/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.protocol;

import java.util.Map;
import org.tarantool.Key;
import org.tarantool.protocol.ProtoUtils;

public class TarantoolPacket {
    private final Map<Integer, Object> headers;
    private final Map<Integer, Object> body;

    public TarantoolPacket(Map<Integer, Object> headers, Map<Integer, Object> body) {
        this.headers = headers;
        this.body = body;
    }

    public TarantoolPacket(Map<Integer, Object> headers) {
        this.headers = headers;
        this.body = null;
    }

    public Long getCode() {
        Object potenticalCode = this.headers.get(Key.CODE.getId());
        if (!(potenticalCode instanceof Long)) {
            throw new IllegalStateException("A value contained in the header by key '" + Key.CODE.name() + "' is not instance of Long class: " + potenticalCode != null ? potenticalCode.getClass().toString() : "null");
        }
        Long code = (Long)potenticalCode;
        return code == 0L ? code : ProtoUtils.extractErrorCode(code);
    }

    public Long getSync() {
        return (Long)this.getHeaders().get(Key.SYNC.getId());
    }

    public Map<Integer, Object> getHeaders() {
        return this.headers;
    }

    public Map<Integer, Object> getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null && this.body.size() > 0;
    }

    public long getSchemaId() {
        return (Long)this.headers.get(Key.SCHEMA_ID.getId());
    }

    public Object getData() {
        return this.hasBody() ? this.body.get(Key.DATA.getId()) : null;
    }

    public Object getError() {
        return this.hasBody() ? this.body.get(Key.ERROR.getId()) : null;
    }
}

