/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TarantoolIndexMeta {
    public static final int VINDEX_IID_FIELD_NUMBER = 1;
    public static final int VINDEX_NAME_FIELD_NUMBER = 2;
    public static final int VINDEX_TYPE_FIELD_NUMBER = 3;
    public static final int VINDEX_OPTIONS_FIELD_NUMBER = 4;
    public static final int VINDEX_PARTS_FIELD_NUMBER = 5;
    public static final int VINDEX_PART_FIELD = 0;
    public static final int VINDEX_PART_TYPE = 1;
    private final int id;
    private final String name;
    private final String type;
    private final IndexOptions options;
    private final List<IndexPart> parts;

    public TarantoolIndexMeta(int id, String name, String type, IndexOptions options, List<IndexPart> parts) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.options = options;
        this.parts = parts;
    }

    public static TarantoolIndexMeta fromTuple(List<?> tuple) {
        Map optionsMap = (Map)tuple.get(4);
        List<IndexPart> parts = Collections.emptyList();
        List partsTuple = (List)tuple.get(5);
        if (!partsTuple.isEmpty()) {
            if (partsTuple.get(0) instanceof List) {
                parts = partsTuple.stream().map(part -> new IndexPart((Integer)part.get(0), (String)part.get(1))).collect(Collectors.toList());
            } else if (partsTuple.get(0) instanceof Map) {
                parts = partsTuple.stream().map(part -> new IndexPart((Integer)part.get("field"), (String)part.get("type"))).collect(Collectors.toList());
            }
        }
        return new TarantoolIndexMeta((Integer)tuple.get(1), (String)tuple.get(2), (String)tuple.get(3), new IndexOptions((Boolean)optionsMap.get("unique")), parts);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public IndexOptions getOptions() {
        return this.options;
    }

    public List<IndexPart> getParts() {
        return this.parts;
    }

    public static class IndexPart {
        private final int fieldNumber;
        private final String type;

        public IndexPart(int fieldNumber, String type) {
            this.fieldNumber = fieldNumber;
            this.type = type;
        }

        public int getFieldNumber() {
            return this.fieldNumber;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class IndexOptions {
        private final boolean unique;

        public IndexOptions(boolean unique) {
            this.unique = unique;
        }

        public boolean isUnique() {
            return this.unique;
        }
    }
}

