/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.tarantool.Iterator;
import org.tarantool.TarantoolClientImpl;
import org.tarantool.TarantoolClientOps;
import org.tarantool.schema.TarantoolIndexMeta;
import org.tarantool.schema.TarantoolIndexNotFoundException;
import org.tarantool.schema.TarantoolSchemaMeta;
import org.tarantool.schema.TarantoolSpaceMeta;
import org.tarantool.schema.TarantoolSpaceNotFoundException;
import org.tarantool.util.TupleTwo;

public class TarantoolMetaSpacesCache
implements TarantoolSchemaMeta {
    private static final int VSPACE_ID = 281;
    private static final int VSPACE_ID_INDEX_ID = 0;
    private static final int VINDEX_ID = 289;
    private static final int VINDEX_ID_INDEX_ID = 0;
    private static final int MAX_TUPLES = Integer.MAX_VALUE;
    private TarantoolClientImpl client;
    private volatile Map<String, TarantoolSpaceMeta> cachedSpaces = Collections.emptyMap();
    private volatile long schemaVersion;

    public TarantoolMetaSpacesCache(TarantoolClientImpl client) {
        this.client = client;
    }

    @Override
    public TarantoolSpaceMeta getSpace(String spaceName) {
        TarantoolSpaceMeta space = this.cachedSpaces.get(spaceName);
        if (space == null) {
            throw new TarantoolSpaceNotFoundException(spaceName);
        }
        return space;
    }

    @Override
    public TarantoolIndexMeta getSpaceIndex(String spaceName, String indexName) {
        TarantoolIndexMeta index = this.getSpace(spaceName).getIndex(indexName);
        if (index == null) {
            throw new TarantoolIndexNotFoundException(spaceName, indexName);
        }
        return index;
    }

    @Override
    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public synchronized long refresh() {
        TupleTwo<List<TarantoolSpaceMeta>, Long> result = this.fetchSpaces();
        this.cachedSpaces = result.getFirst().stream().collect(Collectors.toConcurrentMap(TarantoolSpaceMeta::getName, Function.identity(), (oldValue, newValue) -> newValue, ConcurrentHashMap::new));
        this.schemaVersion = result.getSecond();
        return this.schemaVersion;
    }

    @Override
    public boolean isInitialized() {
        return this.schemaVersion != 0L;
    }

    private TupleTwo<List<TarantoolSpaceMeta>, Long> fetchSpaces() {
        TarantoolClientOps<Integer, List<?>, Object, TupleTwo<List<?>, Long>> clientOps = this.client.unsafeSchemaOps();
        long firstRequestSchema = -1L;
        long secondRequestSchema = 0L;
        List<?> spaces = null;
        List<?> indexes = null;
        while (firstRequestSchema != secondRequestSchema) {
            TupleTwo<List<?>, Long> spacesResult = clientOps.select((Integer)281, (Integer)0, Collections.emptyList(), 0, Integer.MAX_VALUE, Iterator.ALL);
            TupleTwo<List<?>, Long> indexesResult = clientOps.select((Integer)289, (Integer)0, Collections.emptyList(), 0, Integer.MAX_VALUE, Iterator.ALL);
            spaces = spacesResult.getFirst();
            indexes = indexesResult.getFirst();
            firstRequestSchema = spacesResult.getSecond();
            secondRequestSchema = indexesResult.getSecond();
        }
        Map<Integer, List<List>> indexesBySpace = indexes.stream().map(tuple -> (List)tuple).collect(Collectors.groupingBy(tuple -> (Integer)tuple.get(0)));
        List cachedMeta = spaces.stream().map(tuple -> (List)tuple).map(tuple -> TarantoolSpaceMeta.fromTuple(tuple, indexesBySpace.getOrDefault((Integer)tuple.get(0), Collections.emptyList()))).collect(Collectors.toList());
        return TupleTwo.of(cachedMeta, firstRequestSchema);
    }
}

