/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class KafkaContainer
extends GenericContainer<KafkaContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"confluentinc/cp-kafka");
    private static final String DEFAULT_TAG = "5.4.3";
    public static final int KAFKA_PORT = 9093;
    public static final int ZOOKEEPER_PORT = 2181;
    private static final String DEFAULT_INTERNAL_TOPIC_RF = "1";
    protected String externalZookeeperConnect = null;

    @Deprecated
    public KafkaContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    @Deprecated
    public KafkaContainer(String confluentPlatformVersion) {
        this(DEFAULT_IMAGE_NAME.withTag(confluentPlatformVersion));
    }

    public KafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9093});
        this.withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092");
        this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        this.withEnv("KAFKA_BROKER_ID", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_OFFSETS_TOPIC_NUM_PARTITIONS", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_LOG_FLUSH_INTERVAL_MESSAGES", "9223372036854775807");
        this.withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0");
    }

    public KafkaContainer withEmbeddedZookeeper() {
        this.externalZookeeperConnect = null;
        return (KafkaContainer)this.self();
    }

    public KafkaContainer withExternalZookeeper(String connectString) {
        this.externalZookeeperConnect = connectString;
        return (KafkaContainer)this.self();
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9093));
    }

    protected void configure() {
        this.withEnv("KAFKA_ADVERTISED_LISTENERS", String.format("BROKER://%s:9092", this.getNetwork() != null ? this.getNetworkAliases().get(0) : "localhost"));
        String command = "#!/bin/bash\n";
        if (this.externalZookeeperConnect != null) {
            this.withEnv("KAFKA_ZOOKEEPER_CONNECT", this.externalZookeeperConnect);
        } else {
            this.addExposedPort(2181);
            this.withEnv("KAFKA_ZOOKEEPER_CONNECT", "localhost:2181");
            command = command + "echo 'clientPort=2181' > zookeeper.properties\n";
            command = command + "echo 'dataDir=/var/lib/zookeeper/data' >> zookeeper.properties\n";
            command = command + "echo 'dataLogDir=/var/lib/zookeeper/log' >> zookeeper.properties\n";
            command = command + "zookeeper-server-start zookeeper.properties &\n";
        }
        command = command + "echo '' > /etc/confluent/docker/ensure \n";
        command = command + "/etc/confluent/docker/run \n";
        this.withCommand(new String[]{"sh", "-c", command});
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        String brokerAdvertisedListener = this.brokerAdvertisedListener(containerInfo);
        Container.ExecResult result = this.execInContainer(new String[]{"kafka-configs", "--alter", "--bootstrap-server", brokerAdvertisedListener, "--entity-type", "brokers", "--entity-name", (String)this.getEnvMap().get("KAFKA_BROKER_ID"), "--add-config", "advertised.listeners=[" + String.join((CharSequence)",", this.getBootstrapServers(), brokerAdvertisedListener) + "]"});
        if (result.getExitCode() != 0) {
            throw new IllegalStateException(result.toString());
        }
    }

    protected String brokerAdvertisedListener(InspectContainerResponse containerInfo) {
        return String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9092");
    }
}

