/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.ext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testcontainers.ext.ScriptUtils;

class ScriptScanner {
    private final String resource;
    private final String script;
    private final String separator;
    private final String commentPrefix;
    private final String blockCommentStartDelimiter;
    private final String blockCommentEndDelimiter;
    private final Pattern eol = Pattern.compile("[\n\r]+");
    private final Pattern whitespace = Pattern.compile("\\s+");
    private final Pattern identifier = Pattern.compile("[a-z][a-z0-9_$]*", 2);
    private final Pattern dollarQuotedStringDelimiter = Pattern.compile("\\$\\w*\\$");
    private int offset;
    private String currentMatch;

    private boolean matches(String substring) {
        if (this.script.startsWith(substring, this.offset)) {
            this.currentMatch = substring;
            this.offset += this.currentMatch.length();
            return true;
        }
        this.currentMatch = "";
        return false;
    }

    private boolean matches(Pattern regexp) {
        Matcher m = regexp.matcher(this.script);
        m.region(this.offset, this.script.length());
        if (m.lookingAt()) {
            this.currentMatch = m.group();
            this.offset = m.end();
            return true;
        }
        this.currentMatch = "";
        return false;
    }

    private boolean matchesSingleLineComment() {
        if (this.matches(this.commentPrefix)) {
            Matcher m = this.eol.matcher(this.script);
            if (m.find(this.offset)) {
                this.currentMatch = this.commentPrefix + this.script.substring(this.offset, m.end());
                this.offset = m.end();
            } else {
                this.currentMatch = this.commentPrefix + this.script.substring(this.offset);
                this.offset = this.script.length();
            }
            return true;
        }
        return false;
    }

    private boolean matchesMultilineComment() {
        if (this.matches(this.blockCommentStartDelimiter)) {
            int end = this.script.indexOf(this.blockCommentEndDelimiter, this.offset);
            if (end < 0) {
                throw new ScriptUtils.ScriptParseException(String.format("Missing block comment end delimiter [%s].", this.blockCommentEndDelimiter), this.resource);
            }
            this.currentMatch = this.blockCommentStartDelimiter + this.script.substring(this.offset, end += this.blockCommentEndDelimiter.length());
            this.offset = end;
            return true;
        }
        return false;
    }

    private boolean matchesQuotedString(char quote) {
        if (this.script.charAt(this.offset) == quote) {
            boolean escaped = false;
            for (int i = this.offset + 1; i < this.script.length(); ++i) {
                char c = this.script.charAt(i);
                if (escaped) {
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c != quote) continue;
                this.currentMatch = this.script.substring(this.offset, i + 1);
                this.offset = i + 1;
                return true;
            }
        }
        return false;
    }

    private boolean matchesDollarQuotedString() {
        if (this.matches(this.dollarQuotedStringDelimiter)) {
            String delimiter = this.currentMatch;
            int end = this.script.indexOf(delimiter, this.offset);
            if (end < 0) {
                throw new ScriptUtils.ScriptParseException(String.format("Unclosed dollar quoted string [%s].", delimiter), this.resource);
            }
            this.currentMatch = delimiter + this.script.substring(this.offset, end += delimiter.length());
            this.offset = end;
            return true;
        }
        return false;
    }

    Lexem next() {
        if (this.offset < this.script.length()) {
            if (this.matches(this.separator)) {
                return Lexem.SEPARATOR;
            }
            if (this.matchesSingleLineComment() || this.matchesMultilineComment()) {
                return Lexem.COMMENT;
            }
            if (this.matchesQuotedString('\'') || this.matchesQuotedString('\"') || this.matchesQuotedString('`') || this.matchesDollarQuotedString()) {
                return Lexem.QUOTED_STRING;
            }
            if (this.matches(this.identifier)) {
                return Lexem.IDENTIFIER;
            }
            if (this.matches(this.whitespace)) {
                return Lexem.WHITESPACE;
            }
            this.currentMatch = String.valueOf(this.script.charAt(this.offset++));
            return Lexem.OTHER;
        }
        return Lexem.EOF;
    }

    public ScriptScanner(String resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter) {
        this.resource = resource;
        this.script = script;
        this.separator = separator;
        this.commentPrefix = commentPrefix;
        this.blockCommentStartDelimiter = blockCommentStartDelimiter;
        this.blockCommentEndDelimiter = blockCommentEndDelimiter;
    }

    public String getCurrentMatch() {
        return this.currentMatch;
    }

    static enum Lexem {
        SEPARATOR,
        COMMENT,
        QUOTED_STRING,
        WHITESPACE,
        IDENTIFIER,
        OTHER,
        EOF;

    }
}

