/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.expression;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring5.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring5.expression.SPELContextPropertyAccessor;
import org.thymeleaf.standard.expression.RestrictedRequestAccessUtils;
import org.thymeleaf.util.Validate;

public final class ThymeleafEvaluationContext
extends StandardEvaluationContext
implements IThymeleafEvaluationContext {
    public static final String THYMELEAF_EVALUATION_CONTEXT_CONTEXT_VARIABLE_NAME = "thymeleaf::EvaluationContext";
    private static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();
    private final ApplicationContext applicationContext;
    private IExpressionObjects expressionObjects = null;
    private boolean variableAccessRestricted = false;

    public ThymeleafEvaluationContext(ApplicationContext applicationContext, ConversionService conversionService) {
        Validate.notNull((Object)applicationContext, (String)"Application Context cannot be null");
        this.applicationContext = applicationContext;
        this.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        if (conversionService != null) {
            this.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        this.addPropertyAccessor(SPELContextPropertyAccessor.INSTANCE);
        this.addPropertyAccessor((PropertyAccessor)MAP_ACCESSOR_INSTANCE);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object lookupVariable(String name) {
        Object result;
        if (this.expressionObjects != null && this.expressionObjects.containsObject(name) && (result = this.expressionObjects.getObject(name)) != null) {
            if (this.variableAccessRestricted && ("request".equals(name) || "httpServletRequest".equals(name))) {
                return RestrictedRequestAccessUtils.wrapRequestObject((Object)result);
            }
            return result;
        }
        return super.lookupVariable(name);
    }

    @Override
    public boolean isVariableAccessRestricted() {
        return this.variableAccessRestricted;
    }

    @Override
    public void setVariableAccessRestricted(boolean restricted) {
        this.variableAccessRestricted = restricted;
    }

    @Override
    public IExpressionObjects getExpressionObjects() {
        return this.expressionObjects;
    }

    @Override
    public void setExpressionObjects(IExpressionObjects expressionObjects) {
        this.expressionObjects = expressionObjects;
    }
}

