/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.activation;

import java.util.regex.Pattern;
import org.togglz.core.activation.Parameter;
import org.togglz.core.util.Validate;

public class ParameterBuilder
implements Parameter {
    private final String name;
    private String label;
    private Pattern pattern;
    private boolean optional;
    private String description;
    private boolean largeText;

    public static ParameterBuilder create(String name) {
        return new ParameterBuilder(name);
    }

    private ParameterBuilder(String name) {
        Validate.notNull(name, "id is required");
        this.name = name;
        this.label = name;
    }

    public ParameterBuilder label(String name) {
        Validate.notNull(name, "name is required");
        this.label = name;
        return this;
    }

    public ParameterBuilder matching(String regex) {
        Validate.notNull(regex, "regex is required");
        this.pattern = Pattern.compile(regex);
        return this;
    }

    public ParameterBuilder optional() {
        this.optional = true;
        return this;
    }

    public ParameterBuilder largeText() {
        this.largeText = true;
        return this;
    }

    public ParameterBuilder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isValid(String value) {
        if (this.pattern != null) {
            return this.pattern.matcher(value).matches();
        }
        return true;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isLargeText() {
        return this.largeText;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

