/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.manager;

import java.util.UUID;
import org.togglz.core.Feature;
import org.togglz.core.activation.ActivationStrategyProvider;
import org.togglz.core.activation.DefaultActivationStrategyProvider;
import org.togglz.core.manager.DefaultFeatureManager;
import org.togglz.core.manager.EnumBasedFeatureProvider;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.TogglzConfig;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.mem.InMemoryStateRepository;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.user.NoOpUserProvider;
import org.togglz.core.user.UserProvider;
import org.togglz.core.util.Validate;

public class FeatureManagerBuilder {
    private String name = UUID.randomUUID().toString();
    private FeatureProvider featureProvider = null;
    private StateRepository stateRepository = new InMemoryStateRepository();
    private UserProvider userProvider = new NoOpUserProvider();
    private ActivationStrategyProvider strategyProvider = new DefaultActivationStrategyProvider();

    public static FeatureManagerBuilder begin() {
        return new FeatureManagerBuilder();
    }

    public FeatureManagerBuilder stateRepository(StateRepository stateRepository) {
        this.stateRepository = stateRepository;
        return this;
    }

    @Deprecated
    public FeatureManagerBuilder featureClass(Class<? extends Feature> featureClass) {
        return this.featureEnum(featureClass);
    }

    public FeatureManagerBuilder featureEnum(Class<? extends Feature> featureEnum) {
        return this.featureEnums(featureEnum);
    }

    public FeatureManagerBuilder featureEnums(Class<? extends Feature> ... featureEnum) {
        this.featureProvider = new EnumBasedFeatureProvider(featureEnum);
        this.name = "FeatureManager[" + featureEnum[0].getSimpleName() + "]";
        return this;
    }

    public FeatureManagerBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FeatureManagerBuilder featureProvider(FeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
        return this;
    }

    public FeatureManagerBuilder userProvider(UserProvider userProvider) {
        this.userProvider = userProvider;
        return this;
    }

    public FeatureManagerBuilder activationStrategyProvider(ActivationStrategyProvider strategyProvider) {
        this.strategyProvider = strategyProvider;
        return this;
    }

    public FeatureManagerBuilder activationStrategy(ActivationStrategy strategy) {
        if (this.strategyProvider instanceof DefaultActivationStrategyProvider) {
            ((DefaultActivationStrategyProvider)this.strategyProvider).addActivationStrategy(strategy);
            return this;
        }
        throw new IllegalStateException("Adding ActivationStrategies is only allowed when using " + DefaultActivationStrategyProvider.class.getSimpleName());
    }

    public FeatureManagerBuilder togglzConfig(TogglzConfig config) {
        this.stateRepository(config.getStateRepository());
        this.featureEnum(config.getFeatureClass());
        this.userProvider(config.getUserProvider());
        return this;
    }

    public FeatureManager build() {
        Validate.notBlank(this.name, "No name specified");
        Validate.notNull(this.featureProvider, "No feature provider specified");
        Validate.notNull(this.stateRepository, "No state repository specified");
        Validate.notNull(this.userProvider, "No user provider specified");
        Validate.notNull(this.strategyProvider, "No activation strategy provider specified");
        return new DefaultFeatureManager(this.name, this.featureProvider, this.stateRepository, this.userProvider, this.strategyProvider);
    }
}

