/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit5;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.togglz.core.Feature;
import org.togglz.junit5.FeatureManagerExtension;
import org.togglz.testing.TestFeatureManager;

class FeatureVariationInvocationContext
implements TestTemplateInvocationContext {
    private final Class<? extends Feature> featureClass;
    private final Set<? extends Feature> enabledFeatures;

    FeatureVariationInvocationContext(Class<? extends Feature> featureClass, Set<? extends Feature> enabledFeatures) {
        this.featureClass = featureClass;
        this.enabledFeatures = enabledFeatures;
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new FeatureVariantExtension());
    }

    private class FeatureVariantExtension
    extends FeatureManagerExtension {
        private FeatureVariantExtension() {
        }

        @Override
        TestFeatureManager createTestFeatureManager(ExtensionContext context) {
            TestFeatureManager featureManager = new TestFeatureManager(FeatureVariationInvocationContext.this.featureClass);
            featureManager.disableAll();
            FeatureVariationInvocationContext.this.enabledFeatures.forEach(arg_0 -> ((TestFeatureManager)featureManager).enable(arg_0));
            return featureManager;
        }

        @Override
        public void beforeEach(ExtensionContext context) {
            String names = FeatureVariationInvocationContext.this.enabledFeatures.stream().map(Feature::name).sorted().collect(Collectors.joining(", ", "[", "]"));
            context.publishReportEntry("enabledFeatures", names);
            super.beforeEach(context);
        }
    }
}

