/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.util.Validate;
import org.togglz.servlet.spi.RequestListener;

class CompositeRequestListener {
    private final Log log = LogFactory.getLog(CompositeRequestListener.class);
    private final List<RequestListener> listeners;

    public CompositeRequestListener(List<RequestListener> listeners) {
        Validate.notNull(listeners, (String)"No listeners");
        this.listeners = new ArrayList<RequestListener>(listeners);
    }

    public void begin(HttpServletRequest request, HttpServletResponse response) {
        for (RequestListener listener : this.listeners) {
            try {
                listener.begin(request, response);
            }
            catch (Exception e) {
                this.log.error("Failed to execute RequestListener", (Throwable)e);
            }
        }
    }

    public void end(HttpServletRequest request, HttpServletResponse response) {
        for (RequestListener listener : this.listeners) {
            try {
                listener.end(request, response);
            }
            catch (Exception e) {
                this.log.error("Failed to execute RequestListener", (Throwable)e);
            }
        }
    }
}

