/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import com.github.heneke.thymeleaf.togglz.TogglzDialect;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.togglz.core.activation.ActivationStrategyProvider;
import org.togglz.core.activation.DefaultActivationStrategyProvider;
import org.togglz.core.manager.CompositeFeatureProvider;
import org.togglz.core.manager.EnumBasedFeatureProvider;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.FeatureManagerBuilder;
import org.togglz.core.manager.PropertyFeatureProvider;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.cache.CachingStateRepository;
import org.togglz.core.repository.composite.CompositeStateRepository;
import org.togglz.core.repository.file.FileBasedStateRepository;
import org.togglz.core.repository.mem.InMemoryStateRepository;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.user.NoOpUserProvider;
import org.togglz.core.user.UserProvider;
import org.togglz.spring.boot.autoconfigure.TogglzConsoleBaseConfiguration;
import org.togglz.spring.boot.autoconfigure.TogglzProperties;
import org.togglz.spring.listener.TogglzApplicationContextBinderApplicationListener;
import org.togglz.spring.security.SpringSecurityUserProvider;
import org.togglz.spring.web.FeatureInterceptor;

@Configuration
@ConditionalOnProperty(prefix="togglz", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TogglzProperties.class})
public class TogglzAutoConfiguration {
    @Bean
    public TogglzApplicationContextBinderApplicationListener togglzApplicationContextBinderApplicationListener() {
        return new TogglzApplicationContextBinderApplicationListener();
    }

    @Configuration
    @ConditionalOnClass(value={TogglzDialect.class})
    protected static class ThymeleafTogglzDialectConfiguration {
        protected ThymeleafTogglzDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TogglzDialect togglzDialect() {
            return new TogglzDialect();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={HandlerInterceptorAdapter.class})
    @ConditionalOnProperty(prefix="togglz.web", name={"register-feature-interceptor"}, havingValue="true")
    protected static class TogglzFeatureInterceptorConfiguration
    extends WebMvcConfigurerAdapter {
        protected TogglzFeatureInterceptorConfiguration() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new FeatureInterceptor());
        }
    }

    @Configuration
    @Conditional(value={TogglzConsoleBaseConfiguration.OnConsoleAndNotUseManagementPort.class})
    protected static class TogglzConsoleConfiguration
    extends TogglzConsoleBaseConfiguration {
        public TogglzConsoleConfiguration(TogglzProperties properties) {
            super(properties);
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, AuthenticationEntryPoint.class, SpringSecurityUserProvider.class})
    @ConditionalOnMissingBean(value={UserProvider.class})
    protected static class SpringSecurityUserProviderConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected SpringSecurityUserProviderConfiguration() {
        }

        @Bean
        public UserProvider userProvider() {
            return new SpringSecurityUserProvider(this.properties.getConsole().getFeatureAdminAuthority());
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.security.config.annotation.web.configuration.EnableWebSecurity"})
    @ConditionalOnMissingBean(value={UserProvider.class})
    protected static class UserProviderConfiguration {
        protected UserProviderConfiguration() {
        }

        @Bean
        public UserProvider userProvider() {
            return new NoOpUserProvider();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={StateRepository.class})
    protected static class StateRepositoryConfiguration {
        @Autowired
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        @Autowired
        private TogglzProperties properties;

        protected StateRepositoryConfiguration() {
        }

        @Bean
        public StateRepository stateRepository() throws IOException {
            InMemoryStateRepository stateRepository;
            String featuresFile = this.properties.getFeaturesFile();
            if (featuresFile != null) {
                Resource resource = this.resourceLoader.getResource(featuresFile);
                Integer minCheckInterval = this.properties.getFeaturesFileMinCheckInterval();
                stateRepository = minCheckInterval != null ? new FileBasedStateRepository(resource.getFile(), minCheckInterval.intValue()) : new FileBasedStateRepository(resource.getFile());
            } else {
                Map<String, TogglzProperties.FeatureSpec> features = this.properties.getFeatures();
                stateRepository = new InMemoryStateRepository();
                for (String name : features.keySet()) {
                    stateRepository.setFeatureState(features.get(name).state(name));
                }
            }
            if (this.properties.getCache().isEnabled()) {
                stateRepository = new CachingStateRepository((StateRepository)stateRepository, this.properties.getCache().getTimeToLive(), this.properties.getCache().getTimeUnit());
            }
            return stateRepository;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ActivationStrategyProvider.class})
    protected static class ActivationStrategyProviderConfiguration {
        @Autowired(required=false)
        private List<ActivationStrategy> activationStrategies;

        protected ActivationStrategyProviderConfiguration() {
        }

        @Bean
        public ActivationStrategyProvider activationStrategyProvider() {
            DefaultActivationStrategyProvider provider = new DefaultActivationStrategyProvider();
            if (this.activationStrategies != null && this.activationStrategies.size() > 0) {
                provider.addActivationStrategies(this.activationStrategies);
            }
            return provider;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FeatureManager.class})
    protected static class FeatureManagerConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected FeatureManagerConfiguration() {
        }

        @Bean
        public FeatureManager featureManager(FeatureProvider featureProvider, List<StateRepository> stateRepositories, UserProvider userProvider, ActivationStrategyProvider activationStrategyProvider) {
            StateRepository stateRepository = null;
            if (stateRepositories.size() == 1) {
                stateRepository = stateRepositories.get(0);
            } else if (stateRepositories.size() > 1) {
                stateRepository = new CompositeStateRepository(stateRepositories.toArray(new StateRepository[stateRepositories.size()]));
            }
            if (this.properties.getCache().isEnabled() && !(stateRepository instanceof CachingStateRepository)) {
                stateRepository = new CachingStateRepository(stateRepository, this.properties.getCache().getTimeToLive(), this.properties.getCache().getTimeUnit());
            }
            FeatureManagerBuilder featureManagerBuilder = new FeatureManagerBuilder();
            String name = this.properties.getFeatureManagerName();
            if (name != null && name.length() > 0) {
                featureManagerBuilder.name(name);
            }
            featureManagerBuilder.featureProvider(featureProvider).stateRepository(stateRepository).userProvider(userProvider).activationStrategyProvider(activationStrategyProvider).build();
            FeatureManager manager = featureManagerBuilder.build();
            return manager;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FeatureProvider.class})
    protected static class FeatureProviderConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected FeatureProviderConfiguration() {
        }

        @Bean
        public FeatureProvider featureProvider() {
            PropertyFeatureProvider provider = new PropertyFeatureProvider(this.properties.getFeatureProperties());
            Class[] featureEnums = this.properties.getFeatureEnums();
            if (featureEnums != null && featureEnums.length > 0) {
                return new CompositeFeatureProvider(new FeatureProvider[]{new EnumBasedFeatureProvider(featureEnums), provider});
            }
            return provider;
        }
    }
}

