/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.security.spec.AlgorithmParameterSpec;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.AuthenticationException;
import org.tomitribe.auth.signatures.InvalidCreatedFieldException;
import org.tomitribe.auth.signatures.InvalidExpiresFieldException;
import org.tomitribe.auth.signatures.Join;
import org.tomitribe.auth.signatures.MissingAlgorithmException;
import org.tomitribe.auth.signatures.MissingKeyIdException;
import org.tomitribe.auth.signatures.MissingSignatureException;
import org.tomitribe.auth.signatures.SigningAlgorithm;
import org.tomitribe.auth.signatures.UnparsableSignatureException;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class Signature {
    private final String keyId;
    private final SigningAlgorithm signingAlgorithm;
    private final Algorithm algorithm;
    private final String signature;
    private final List<String> headers;
    private final AlgorithmParameterSpec parameterSpec;
    private final Long maxSignatureValidityDuration;
    private Long signatureCreatedTime;
    private Long signatureExpiresTime;
    private static final Pattern RFC_2617_PARAM = Pattern.compile("(?<key>\\w+)=((\"(?<stringValue>[^\"]*)\")|(?<numberValue>\\d+\\.?\\d*))");
    public static long maxTimeSkewInMilliseconds = 30000L;

    public Signature(String keyId, String signingAlgorithm, String algorithm, AlgorithmParameterSpec parameterSpec, List<String> headers) {
        this(keyId, Signature.getSigningAlgorithm(signingAlgorithm), Signature.getAlgorithm(algorithm), parameterSpec, null, headers);
    }

    private static Algorithm getAlgorithm(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null");
        }
        return Algorithm.get(algorithm);
    }

    private static SigningAlgorithm getSigningAlgorithm(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Signing scheme cannot be null");
        }
        return SigningAlgorithm.get(scheme);
    }

    public Signature(String keyId, String signingAlgorithm, String algorithm, AlgorithmParameterSpec parameterSpec, String signature, List<String> headers) {
        this(keyId, Signature.getSigningAlgorithm(signingAlgorithm), Signature.getAlgorithm(algorithm), parameterSpec, signature, headers);
    }

    public Signature(String keyId, SigningAlgorithm signingAlgorithm, Algorithm algorithm, AlgorithmParameterSpec parameterSpec, String signature, List<String> headers) {
        this(keyId, signingAlgorithm, algorithm, parameterSpec, signature, headers, null);
    }

    public Signature(String keyId, SigningAlgorithm signingAlgorithm, Algorithm algorithm, AlgorithmParameterSpec parameterSpec, String signature, List<String> headers, Long maxSignatureValidityDuration) {
        this(keyId, signingAlgorithm, algorithm, parameterSpec, signature, headers, maxSignatureValidityDuration, null, null);
    }

    public Signature(String keyId, SigningAlgorithm signingAlgorithm, Algorithm algorithm, AlgorithmParameterSpec parameterSpec, String signature, List<String> headers, Long maxSignatureValidityDuration, Long signatureCreatedTime, Long signatureExpiresTime) {
        if (keyId == null || keyId.trim().isEmpty()) {
            throw new IllegalArgumentException("keyId is required.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is required.");
        }
        if (signingAlgorithm != null && signingAlgorithm.getSupportedAlgorithms() != null && !signingAlgorithm.getSupportedAlgorithms().contains((Object)algorithm)) {
            throw new IllegalArgumentException("Signing algorithm " + signingAlgorithm.getAlgorithmName() + " is not compatible with " + algorithm.getPortableName());
        }
        this.keyId = keyId;
        this.signingAlgorithm = signingAlgorithm;
        this.algorithm = algorithm;
        if (maxSignatureValidityDuration != null && maxSignatureValidityDuration <= 0L) {
            throw new IllegalArgumentException("Signature max validity must be a positive number");
        }
        this.maxSignatureValidityDuration = maxSignatureValidityDuration;
        this.signatureCreatedTime = signatureCreatedTime;
        this.signatureExpiresTime = signatureExpiresTime;
        this.signature = signature;
        this.parameterSpec = parameterSpec;
        if (headers == null || headers.size() == 0) {
            List<String> list = Arrays.asList("date");
            this.headers = Collections.unmodifiableList(list);
        } else {
            this.headers = Collections.unmodifiableList(this.lowercase(headers));
        }
    }

    public Date getSignatureCreation() {
        if (this.signatureCreatedTime == null) {
            return null;
        }
        return new Date(this.signatureCreatedTime);
    }

    public Long getSignatureCreationTimeMilliseconds() {
        return this.signatureCreatedTime;
    }

    public Long getSignatureMaxValidityMilliseconds() {
        return this.maxSignatureValidityDuration;
    }

    public Date getSignatureExpiration() {
        if (this.signatureExpiresTime == null) {
            return null;
        }
        return new Date(this.signatureExpiresTime);
    }

    public Long getSignatureExpirationTimeMilliseconds() {
        return this.signatureExpiresTime;
    }

    private List<String> lowercase(List<String> headers) {
        ArrayList<String> list = new ArrayList<String>(headers.size());
        for (String header : headers) {
            list.add(header.toLowerCase());
        }
        return list;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getSignature() {
        return this.signature;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public void verifySignatureValidityDates() {
        if (this.signatureCreatedTime != null && this.signatureCreatedTime > System.currentTimeMillis() + maxTimeSkewInMilliseconds) {
            throw new InvalidCreatedFieldException("Signature is not valid yet");
        }
        if (this.signatureExpiresTime != null && this.signatureExpiresTime < System.currentTimeMillis()) {
            throw new InvalidExpiresFieldException("Signature has expired");
        }
    }

    public static Signature fromString(String authorization, Algorithm algorithm) {
        try {
            authorization = Signature.normalize(authorization);
            class FieldValue {
                private Object value;
                private boolean isNumber;

                FieldValue(String value, boolean isNumber) throws ParseException {
                    this.isNumber = isNumber;
                    this.value = isNumber ? NumberFormat.getInstance().parse(value) : value;
                }

                boolean isString() {
                    return !this.isNumber;
                }

                boolean isNumber() {
                    return this.isNumber;
                }

                boolean isInteger() {
                    return this.value instanceof Long;
                }

                String getValueAsString() {
                    if (!this.isString()) {
                        return null;
                    }
                    return (String)this.value;
                }

                Long getValueAsLong() {
                    if (!this.isInteger()) {
                        return null;
                    }
                    return ((Number)this.value).longValue();
                }

                Double getValueAsDouble() {
                    if (!this.isNumber()) {
                        return null;
                    }
                    return ((Number)this.value).doubleValue();
                }
            }
            HashMap<String, FieldValue> map = new HashMap<String, FieldValue>();
            Matcher matcher = RFC_2617_PARAM.matcher(authorization);
            while (matcher.find()) {
                String key = matcher.group("key").toLowerCase();
                boolean isNumber = false;
                String value = matcher.group("stringValue");
                if (value == null) {
                    value = matcher.group("numberValue");
                    isNumber = true;
                }
                map.put(key, new FieldValue(value, isNumber));
            }
            ArrayList<String> headers = new ArrayList<String>();
            FieldValue fieldValue = (FieldValue)map.get("headers");
            if (fieldValue != null) {
                if (!fieldValue.isString()) {
                    throw new IllegalArgumentException("headers field must be a double-quoted string");
                }
                Collections.addAll(headers, fieldValue.getValueAsString().toLowerCase().split(" +"));
            }
            String keyid = null;
            fieldValue = (FieldValue)map.get("keyid");
            if (fieldValue != null && fieldValue.isString()) {
                keyid = fieldValue.getValueAsString();
            }
            if (keyid == null) {
                throw new MissingKeyIdException();
            }
            String algorithmField = null;
            fieldValue = (FieldValue)map.get("algorithm");
            if (fieldValue != null && fieldValue.isString()) {
                algorithmField = fieldValue.getValueAsString();
            }
            if (algorithmField == null) {
                throw new MissingAlgorithmException();
            }
            String signature = null;
            fieldValue = (FieldValue)map.get("signature");
            if (fieldValue != null && fieldValue.isString()) {
                signature = fieldValue.getValueAsString();
            }
            if (signature == null) {
                throw new MissingSignatureException();
            }
            Long created = null;
            fieldValue = (FieldValue)map.get("created");
            if (fieldValue != null) {
                if (!fieldValue.isInteger()) {
                    throw new InvalidCreatedFieldException("Field must be an integer value");
                }
                created = fieldValue.getValueAsLong() * 1000L;
            }
            Long expires = null;
            fieldValue = (FieldValue)map.get("expires");
            if (fieldValue != null) {
                if (!fieldValue.isNumber()) {
                    throw new InvalidExpiresFieldException("Field must be a number");
                }
                expires = (long)(fieldValue.getValueAsDouble() * 1000.0);
            }
            SigningAlgorithm parsedSigningAlgorithm = null;
            try {
                parsedSigningAlgorithm = SigningAlgorithm.get(algorithmField);
            }
            catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
                // empty catch block
            }
            Algorithm parsedAlgorithm = null;
            try {
                parsedAlgorithm = Algorithm.get(algorithmField);
                if (algorithm != null && parsedAlgorithm.getPortableName() != algorithm.getPortableName()) {
                    throw new IllegalArgumentException("The algorithm does not match the value of the 'Authorization' header.");
                }
            }
            catch (UnsupportedAlgorithmException ex) {
                if (algorithm == null) {
                    throw new IllegalArgumentException("The algorithm is required.");
                }
                parsedAlgorithm = algorithm;
            }
            Signature s = new Signature(keyid, parsedSigningAlgorithm, parsedAlgorithm, null, signature, headers, null, created, expires);
            s.verifySignatureValidityDates();
            return s;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnparsableSignatureException(authorization, e);
        }
    }

    private static String normalize(String authorization) {
        String start = "signature ";
        String prefix = authorization.substring(0, "signature ".length()).toLowerCase();
        if (prefix.equals("signature ")) {
            authorization = authorization.substring("signature ".length());
        }
        return authorization.trim();
    }

    public String toString() {
        Enum alg = SigningAlgorithm.HS2019.equals((Object)this.signingAlgorithm) ? this.signingAlgorithm : this.algorithm;
        return "Signature keyId=\"" + this.keyId + '\"' + (this.signatureCreatedTime != null ? String.format(",created=%d", this.signatureCreatedTime / 1000L) : "") + (this.signatureExpiresTime != null ? String.format(",expires=%.3f", (double)this.signatureExpiresTime.longValue() / 1000.0) : "") + ",algorithm=\"" + alg + '\"' + ",headers=\"" + Join.join(" ", this.headers) + '\"' + ",signature=\"" + this.signature + '\"';
    }
}

