/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.tomitribe.auth.signatures.InvalidCreatedFieldException;
import org.tomitribe.auth.signatures.InvalidExpiresFieldException;
import org.tomitribe.auth.signatures.Join;
import org.tomitribe.auth.signatures.MissingRequiredHeaderException;

public enum Signatures {


    public static String createSigningString(List<String> required, String method, String uri, Map<String, String> headers) {
        return Signatures.createSigningString(required, method, uri, headers);
    }

    public static String createSigningString(List<String> required, String method, String uri, Map<String, String> headers, Long signatureCreationTime, Long signatureExpiryTime) {
        headers = Signatures.lowercase(headers);
        ArrayList<String> list = new ArrayList<String>(required.size());
        for (String key : required) {
            if ("(request-target)".equals(key)) {
                method = Signatures.lowercase(method);
                list.add(Join.join(" ", "(request-target):", method, uri));
                continue;
            }
            if ("(created)".equals(key)) {
                if (signatureCreationTime == null) {
                    throw new InvalidCreatedFieldException("(created) field requested but signature creation time is not set");
                }
                list.add(key + ": " + Long.toString(TimeUnit.MILLISECONDS.toSeconds(signatureCreationTime)));
                continue;
            }
            if ("(expires)".equals(key)) {
                if (signatureExpiryTime == null) {
                    throw new InvalidExpiresFieldException("(expires) field requested but signature expiration time is not set");
                }
                double expires = (double)signatureExpiryTime.longValue() / 1000.0;
                list.add(key + ": " + String.format("%.3f", expires));
                continue;
            }
            String value = headers.get(key);
            if (value == null) {
                throw new MissingRequiredHeaderException(key);
            }
            list.add(key + ": " + value);
        }
        return Join.join("\n", list);
    }

    private static Map<String, String> lowercase(Map<String, String> headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            map.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return map;
    }

    private static String lowercase(String spec) {
        return spec.toLowerCase();
    }
}

