/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.minify;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.listener.AbstractMustacheListener;
import org.trimou.engine.listener.MustacheParsingEvent;
import org.trimou.minify.Minifier;
import org.trimou.util.Checker;

public class MinifyListener
extends AbstractMustacheListener {
    private static final Logger logger = LoggerFactory.getLogger(MinifyListener.class);
    private final Minifier minifier;

    MinifyListener(Minifier minifier) {
        Checker.checkArgumentNotNull((Object)minifier);
        this.minifier = minifier;
    }

    public void init(Configuration configuration) {
        if (this.minifier == null) {
            throw new IllegalStateException("MinifyListener not configured properly");
        }
        this.minifier.init(configuration);
        logger.info("Minify listener initialized [minifier: {}]", (Object)this.minifier.toString());
    }

    public Set<ConfigurationKey> getConfigurationKeys() {
        return this.minifier != null ? this.minifier.getConfigurationKeys() : super.getConfigurationKeys();
    }

    public void parsingStarted(MustacheParsingEvent event) {
        event.setMustacheContents(this.minifier.minify(event.getMustacheName(), event.getMustacheContents()));
    }
}

