/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.util.Map;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;

public class AuthorizationPolicyMarshaller {
    private static final String DEFAULT = "default";
    private static final String ROLE = "role";
    private static final String GROUP = "group";
    private static final String PERMISSION = "permission";
    private static final String PRIORITY = "priority";
    private static final String HOME = "home";
    private static final String DESCRIPTION = "description";

    public void read(AuthorizationPolicyBuilder builder, Map ... input) {
        for (Map m : input) {
            m.forEach((x, y) -> this.read(builder, x.toString(), y.toString(), ReadMode.DEFAULT_ONLY));
        }
        for (Map m : input) {
            m.forEach((x, y) -> this.read(builder, x.toString(), y.toString(), ReadMode.DEFAULT_EXCLUDED));
        }
    }

    public void read(AuthorizationPolicyBuilder builder, String key, String value) {
        this.read(builder, key, value, ReadMode.EVERYTHING);
    }

    public void read(AuthorizationPolicyBuilder builder, String key, String value, ReadMode readMode) {
        Key keyObj = this.parse(key);
        if (this.isReadable(keyObj, readMode)) {
            this.read(builder, keyObj, value);
        }
    }

    private boolean isReadable(Key keyObj, ReadMode readMode) {
        if (keyObj.isDefault() && ReadMode.DEFAULT_EXCLUDED.equals((Object)readMode)) {
            return false;
        }
        return keyObj.isDefault() || !ReadMode.DEFAULT_ONLY.equals((Object)readMode);
    }

    private void read(AuthorizationPolicyBuilder builder, Key keyObj, String value) {
        String attr;
        if (!keyObj.isDefault()) {
            if (keyObj.isRole()) {
                builder.role(keyObj.getRole());
            } else if (keyObj.isGroup()) {
                builder.group(keyObj.getGroup());
            } else {
                throw new IllegalArgumentException("Key must start either with 'role' or 'group': " + keyObj);
            }
        }
        switch (attr = keyObj.getAttributeType()) {
            case "description": {
                builder.description(value);
                break;
            }
            case "home": {
                builder.home(value);
                break;
            }
            case "priority": {
                builder.priority(Integer.parseInt(value));
                break;
            }
            case "permission": {
                String permission = keyObj.getAttributeId();
                if (permission.length() == 0) {
                    throw new IllegalArgumentException("Permission is incomplete: " + keyObj);
                }
                boolean granted = Boolean.parseBoolean(value);
                builder.permission(permission, Boolean.valueOf(granted));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key: " + keyObj);
            }
        }
    }

    public void write(AuthorizationPolicy policy, Map out) {
        this.write(policy.getHomePerspective(), out);
        this.write(policy.getPermissions(), out);
        for (Role subject : policy.getRoles()) {
            this.write(subject, policy.getHomePerspective(subject), out);
            this.write(subject, policy.getPriority(subject), out);
            this.write(subject, policy.getPermissions(subject), out);
        }
        for (Role subject : policy.getGroups()) {
            this.write((Group)subject, policy.getHomePerspective((Group)subject), out);
            this.write((Group)subject, policy.getPriority((Group)subject), out);
            this.write((Group)subject, policy.getPermissions((Group)subject), out);
        }
    }

    public void write(String homePerspectiveId, Map out) {
        String key = "default.home";
        out.remove(key);
        if (homePerspectiveId != null) {
            out.put(key, homePerspectiveId);
        }
    }

    public void write(PermissionCollection permissions, Map out) {
        for (Permission p : permissions.collection()) {
            boolean granted = p.getResult() != null && p.getResult().equals((Object)AuthorizationResult.ACCESS_GRANTED);
            String key = "default.permission." + p.getName();
            out.put(key, Boolean.toString(granted));
        }
    }

    public void write(Role role, String homePerspectiveId, Map out) {
        String key = "role." + role.getName() + "." + HOME;
        out.remove(key);
        if (homePerspectiveId != null) {
            out.put(key, homePerspectiveId);
        }
    }

    public void write(Role role, int priority, Map out) {
        String key = "role." + role.getName() + "." + PRIORITY;
        out.put(key, Integer.toString(priority));
    }

    public void write(Role role, PermissionCollection permissions, Map out) {
        for (Permission p : permissions.collection()) {
            boolean granted = p.getResult() != null && p.getResult().equals((Object)AuthorizationResult.ACCESS_GRANTED);
            String key = "role." + role.getName() + "." + PERMISSION + "." + p.getName();
            out.put(key, Boolean.toString(granted));
        }
    }

    public void write(Group group, String homePerspectiveId, Map out) {
        String key = "group." + group.getName() + "." + HOME;
        out.remove(key);
        if (homePerspectiveId != null) {
            out.put(key, homePerspectiveId);
        }
    }

    public void write(Group group, int priority, Map out) {
        String key = "group." + group.getName() + "." + PRIORITY;
        out.put(key, Integer.toString(priority));
    }

    public void write(Group group, PermissionCollection permissions, Map out) {
        for (Permission p : permissions.collection()) {
            boolean granted = p.getResult() != null && p.getResult().equals((Object)AuthorizationResult.ACCESS_GRANTED);
            String key = "group." + group.getName() + "." + PERMISSION + "." + p.getName();
            out.put(key, Boolean.toString(granted));
        }
    }

    public Key parse(String key) {
        int _idx = 0;
        String _key = key.endsWith(".*") ? key.substring(0, key.length() - 2) : key;
        String[] tokens = _key.split("\\.");
        Key result = new Key(key);
        if (_idx < tokens.length) {
            result.setType(tokens[_idx++]);
        }
        if (_idx < tokens.length) {
            if (result.isRole()) {
                result.setRole(tokens[_idx++]);
            } else if (result.isGroup()) {
                result.setGroup(tokens[_idx++]);
            }
        }
        if (_idx < tokens.length) {
            result.setAttributeType(tokens[_idx++]);
        }
        if (_idx < tokens.length) {
            StringBuilder attrIdStr = new StringBuilder();
            for (int i = _idx; i < tokens.length; ++i) {
                if (i > _idx) {
                    attrIdStr.append(".");
                }
                attrIdStr.append(tokens[i]);
            }
            result.setAttributeId(attrIdStr.toString());
        }
        result.validate();
        return result;
    }

    public class Key {
        String key = null;
        String type = null;
        String roleGroup = null;
        String attributeType = null;
        String attributeId = null;

        public Key(String key) {
            this.key = key;
        }

        public boolean isDefault() {
            return this.type != null && AuthorizationPolicyMarshaller.DEFAULT.equals(this.type);
        }

        public boolean isRole() {
            return this.type != null && AuthorizationPolicyMarshaller.ROLE.equals(this.type);
        }

        public boolean isGroup() {
            return this.type != null && AuthorizationPolicyMarshaller.GROUP.equals(this.type);
        }

        public String getRole() {
            return this.isRole() ? this.roleGroup : null;
        }

        public void setRole(String role) {
            this.roleGroup = role;
        }

        public String getGroup() {
            return this.isGroup() ? this.roleGroup : null;
        }

        public void setGroup(String group) {
            this.roleGroup = group;
        }

        public String getAttributeType() {
            return this.attributeType;
        }

        public void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public String getAttributeId() {
            return this.attributeId;
        }

        public void setAttributeId(String attributeId) {
            this.attributeId = attributeId;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.key;
        }

        public void validate() throws IllegalStateException {
            if (this.type == null || !AuthorizationPolicyMarshaller.DEFAULT.equals(this.type) && !AuthorizationPolicyMarshaller.ROLE.equals(this.type) && !AuthorizationPolicyMarshaller.GROUP.equals(this.type)) {
                throw new IllegalArgumentException("Key must start with [default|role|group]");
            }
            if (this.isRole() && (this.roleGroup == null || this.roleGroup.length() == 0)) {
                throw new IllegalArgumentException("Role value is empty");
            }
            if (this.isGroup() && (this.roleGroup == null || this.roleGroup.length() == 0)) {
                throw new IllegalArgumentException("Group value is empty");
            }
            if (this.attributeType == null || this.attributeType.length() == 0) {
                throw new IllegalArgumentException("Empty attribute type not allowed: " + this.attributeType);
            }
        }
    }

    public static enum ReadMode {
        DEFAULT_ONLY,
        DEFAULT_EXCLUDED,
        EVERYTHING;

    }
}

