/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.WebAppListener;
import org.uberfire.backend.server.WebAppSettings;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class RoleLoader {
    Logger logger = LoggerFactory.getLogger(RoleLoader.class);

    @PostConstruct
    public void init() {
        WebAppListener.registerOnStartupCommand(this::registerRolesFromwWebXml);
    }

    public void registerRolesFromwWebXml() {
        try {
            Set<String> roles = this.loadRolesFromwWebXml();
            for (String role : roles) {
                RoleRegistry.get().registerRole(role);
            }
            if (!roles.isEmpty()) {
                this.logger.info("Roles registered from web.xml \"" + StringUtils.join((Object[])roles.toArray(), (String)",") + "\"");
            }
        }
        catch (Exception e) {
            this.logger.error("Error reading roles from web.xml", (Throwable)e);
        }
    }

    protected Set<String> loadRolesFromwWebXml() throws Exception {
        Path webXml = WebAppSettings.get().getAbsolutePath("WEB-INF", "web.xml");
        HashSet<String> result = new HashSet<String>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(webXml.toFile());
        Element root = doc.getRootElement();
        List bundleNodes = root.getChildren("security-role");
        if (bundleNodes.isEmpty()) {
            bundleNodes = root.getChildren("security-role", null);
        }
        for (Element el_role : bundleNodes) {
            List ch_role = el_role.getChildren();
            for (int i = 0; i < ch_role.size(); ++i) {
                String name;
                Element el_child = (Element)ch_role.get(i);
                if (!el_child.getName().equals("role-name") || StringUtils.isBlank((CharSequence)(name = el_child.getValue().trim()))) continue;
                result.add(name);
            }
        }
        return result;
    }
}

