/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.BaseFilteredServlet;
import org.uberfire.server.util.FileServletUtil;

public class FileDownloadServlet
extends BaseFilteredServlet {
    private static final Logger logger = LoggerFactory.getLogger(FileDownloadServlet.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String encodedPath = FileServletUtil.encodeFileNamePart(request.getParameter("path"));
            URI uri = new URI(encodedPath);
            if (!this.validateAccess(uri, response)) {
                return;
            }
            Path path = this.ioService.get(uri);
            byte[] bytes = this.ioService.readAllBytes(path);
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\";", path.getFileName().toString()));
            response.setContentType("application/octet-stream");
            response.getOutputStream().write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            logger.error("Failed to download a file.", (Throwable)e);
        }
    }
}

