/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.enterprise.context.ApplicationScoped;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class EditorActivityGenerator
extends AbstractGenerator {
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String onStartup2ParameterMethodName;
        String onStartup1ParameterMethodName;
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        TypeElement classElement = (TypeElement)element;
        String annotationName = ClientAPIModule.getWorkbenchEditorClass();
        boolean isDynamic = ClientAPIModule.getWbEditorIsDynamicValueOnClass(classElement);
        String owningPlace = GeneratorUtils.getOwningPerspectivePlaceRequest(classElement, processingEnvironment);
        Integer priority = 0;
        Collection<String> associatedResources = null;
        String identifier = null;
        String lockingStrategy = null;
        Integer preferredHeight = null;
        Integer preferredWidth = null;
        for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                AnnotationValue aval = entry.getValue();
                if ("identifier".equals(entry.getKey().getSimpleName().toString())) {
                    identifier = aval.getValue().toString();
                    continue;
                }
                if ("priority".equals(entry.getKey().getSimpleName().toString())) {
                    priority = (Integer)aval.getValue();
                    continue;
                }
                if ("supportedTypes".equals(entry.getKey().getSimpleName().toString())) {
                    associatedResources = GeneratorUtils.extractValue(aval);
                    continue;
                }
                if ("preferredHeight".equals(entry.getKey().getSimpleName().toString())) {
                    int _preferredHeight = (Integer)aval.getValue();
                    if (_preferredHeight <= 0) continue;
                    preferredHeight = _preferredHeight;
                    continue;
                }
                if ("preferredWidth".equals(entry.getKey().getSimpleName().toString())) {
                    int _preferredWidth = (Integer)aval.getValue();
                    if (_preferredWidth <= 0) continue;
                    preferredWidth = _preferredWidth;
                    continue;
                }
                if (!"lockingStrategy".equals(entry.getKey().getSimpleName().toString())) continue;
                lockingStrategy = aval.getValue().toString();
            }
        }
        if (associatedResources != null && associatedResources.size() > 0) {
            for (String string : associatedResources) {
                TypeElement resourceType = processingEnvironment.getElementUtils().getTypeElement(string);
                if (resourceType.getAnnotation(ApplicationScoped.class) != null) continue;
                messager.printMessage(Diagnostic.Kind.ERROR, "This type is referenced as a resource from " + className + ", so it must be @ApplicationScoped.", resourceType);
            }
        }
        String beanActivatorClass = GeneratorUtils.getBeanActivatorClassName(classElement, processingEnvironment);
        ExecutableElement executableElement = GeneratorUtils.getOnStartupMethodForEditors(classElement, processingEnvironment);
        if (executableElement == null) {
            onStartup1ParameterMethodName = null;
            onStartup2ParameterMethodName = null;
        } else if (executableElement.getParameters().size() == 1) {
            onStartup1ParameterMethodName = executableElement.getSimpleName().toString();
            onStartup2ParameterMethodName = null;
        } else {
            onStartup1ParameterMethodName = null;
            onStartup2ParameterMethodName = executableElement.getSimpleName().toString();
        }
        String onMayCloseMethodName = GeneratorUtils.getOnMayCloseMethodName(classElement, processingEnvironment);
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String onLostFocusMethodName = GeneratorUtils.getOnLostFocusMethodName(classElement, processingEnvironment);
        String onFocusMethodName = GeneratorUtils.getOnFocusMethodName(classElement, processingEnvironment);
        String getDefaultPositionMethodName = GeneratorUtils.getDefaultPositionMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        String getContextIdMethodName = GeneratorUtils.getContextIdMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String isDirtyMethodName = GeneratorUtils.getIsDirtyMethodName(classElement, processingEnvironment);
        String onSaveMethodName = GeneratorUtils.getOnSaveMethodName(classElement, processingEnvironment);
        String getMenuBarMethodName = GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment);
        String getToolBarMethodName = GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment);
        List<String> qualifiers = GeneratorUtils.getAllQualifiersDeclarationFromType(classElement);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Identifier: " + identifier);
            messager.printMessage(Diagnostic.Kind.NOTE, "Locking strategy: " + lockingStrategy);
            messager.printMessage(Diagnostic.Kind.NOTE, "Owning Perspective Identifier: " + owningPlace);
            messager.printMessage(Diagnostic.Kind.NOTE, "getContextIdMethodName: " + getContextIdMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Priority: " + priority);
            messager.printMessage(Diagnostic.Kind.NOTE, "Resource types: " + associatedResources);
            messager.printMessage(Diagnostic.Kind.NOTE, "Preferred Height: " + preferredHeight);
            messager.printMessage(Diagnostic.Kind.NOTE, "Preferred Width: " + preferredWidth);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup2ParameterMethodName: " + onStartup2ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onMayCloseMethodName: " + onMayCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onCloseMethodName: " + onCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onShutdownMethodName: " + onShutdownMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onOpenMethodName: " + onOpenMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onLostFocusMethodName: " + onLostFocusMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onFocusMethodName: " + onFocusMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getDefaultPositionMethodName: " + getDefaultPositionMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleMethodName: " + getTitleMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleWidgetMethodName: " + getTitleWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getWidgetMethodName: " + getWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidget: " + Boolean.toString(isWidget));
            messager.printMessage(Diagnostic.Kind.NOTE, "hasUberView: " + Boolean.toString(hasUberView));
            messager.printMessage(Diagnostic.Kind.NOTE, "isDirtyMethodName: " + isDirtyMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onSaveMethodName: " + onSaveMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getMenuBarMethodName: " + getMenuBarMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getToolBarMethodName: " + getToolBarMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Qualifiers: " + String.join((CharSequence)", ", qualifiers));
        }
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchEditor must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            String msg = "The WorkbenchEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            messager.printMessage(Diagnostic.Kind.WARNING, "The WorkbenchEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.", classElement);
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchEditor must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("lockingStrategy", lockingStrategy);
        root.put("owningPlace", owningPlace);
        root.put("getContextIdMethodName", getContextIdMethodName);
        root.put("priority", priority.toString().replace(",", ""));
        root.put("associatedResources", GeneratorUtils.formatAssociatedResources(associatedResources));
        root.put("preferredHeight", preferredHeight);
        root.put("preferredWidth", preferredWidth);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("beanActivatorClass", beanActivatorClass);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onStartup2ParameterMethodName", onStartup2ParameterMethodName);
        root.put("onMayCloseMethodName", onMayCloseMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("onLostFocusMethodName", onLostFocusMethodName);
        root.put("onFocusMethodName", onFocusMethodName);
        root.put("getDefaultPositionMethodName", getDefaultPositionMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("isDirtyMethodName", isDirtyMethodName);
        root.put("onSaveMethodName", onSaveMethodName);
        root.put("getMenuBarMethodName", getMenuBarMethodName);
        root.put("getToolBarMethodName", getToolBarMethodName);
        root.put("isDynamic", isDynamic);
        root.put("qualifiers", qualifiers);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("activityEditor.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

