/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.datasetfactory.impl;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.datasetfactory.DataSetResolver;
import org.unitils.thirdparty.org.apache.commons.io.FileUtils;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataSetResolver
implements DataSetResolver {
    public static final String PROPKEY_PREFIX_WITH_PACKAGE_NAME = "dbUnit.datasetresolver.prefixWithPackageName";
    public static final String PROPKEY_DATA_SET_PATH_PREFIX = "dbUnit.datasetresolver.pathPrefix";
    protected boolean prefixWithPackageName;
    protected String pathPrefix;

    public void init(Properties configuration) {
        this.prefixWithPackageName = PropertyUtils.getBoolean((String)PROPKEY_PREFIX_WITH_PACKAGE_NAME, (Properties)configuration);
        this.pathPrefix = PropertyUtils.getString((String)PROPKEY_DATA_SET_PATH_PREFIX, null, (Properties)configuration);
    }

    @Override
    public File resolve(Class<?> testClass, String dataSetName) {
        String dataSetFileName = this.getDataSetFileName(testClass, dataSetName);
        if (dataSetFileName.startsWith("/")) {
            File dataSetFile = new File(dataSetFileName);
            if (!dataSetFile.exists()) {
                throw new UnitilsException("DataSet file with name " + dataSetFileName + " cannot be found");
            }
            return dataSetFile;
        }
        URL dataSetUrl = testClass.getResource('/' + dataSetFileName);
        if (dataSetUrl == null) {
            throw new UnitilsException("DataSet file with name " + dataSetFileName + " cannot be found");
        }
        return FileUtils.toFile((URL)dataSetUrl);
    }

    protected String getDataSetFileName(Class<?> testClass, String dataSetName) {
        if (this.prefixWithPackageName && !dataSetName.startsWith("/")) {
            dataSetName = this.prefixPackageNameFilePath(testClass, dataSetName);
        }
        if (dataSetName.startsWith("/")) {
            dataSetName = dataSetName.substring(1);
        }
        if (this.pathPrefix != null) {
            dataSetName = this.pathPrefix + '/' + dataSetName;
        }
        return dataSetName;
    }

    protected String prefixPackageNameFilePath(Class<?> testClass, String dataSetName) {
        String className = testClass.getName();
        int indexOfLastDot = className.lastIndexOf(46);
        if (indexOfLastDot == -1) {
            return dataSetName;
        }
        String packageName = className.substring(0, indexOfLastDot).replace('.', '/');
        return packageName + '/' + dataSetName;
    }
}

