/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.util.ConfigUtils;
import org.unitils.io.annotation.handler.FileContentAnnotationHandler;
import org.unitils.io.annotation.handler.TempDirAnnotationHandler;
import org.unitils.io.annotation.handler.TempFileAnnotationHandler;
import org.unitils.io.filecontent.FileContentReader;
import org.unitils.io.filecontent.FileContentReaderFactory;
import org.unitils.io.temp.TempService;
import org.unitils.io.temp.TempServiceFactory;
import org.unitils.util.PropertyUtils;

public class IOModule
implements Module {
    protected static final String CLEANUP_AFTER_TEST = "IOModule.temp.cleanupAfterTest";
    protected Properties configuration;
    protected FileContentReader fileContentReader;
    protected TempService tempService;

    public void init(Properties configuration) {
        this.configuration = configuration;
        this.fileContentReader = this.createFileContentReader();
        this.tempService = this.createTempService();
    }

    public void afterInit() {
    }

    public TestListener getTestListener() {
        boolean cleanUpAfterTest = PropertyUtils.getBoolean((String)CLEANUP_AFTER_TEST, (Properties)this.configuration);
        FileContentAnnotationHandler fileContentAnnotationHandler = new FileContentAnnotationHandler(this.fileContentReader);
        TempFileAnnotationHandler tempFileAnnotationHandler = new TempFileAnnotationHandler(this.tempService, cleanUpAfterTest);
        TempDirAnnotationHandler tempDirAnnotationHandler = new TempDirAnnotationHandler(this.tempService, cleanUpAfterTest);
        return new IOTestListener(fileContentAnnotationHandler, tempFileAnnotationHandler, tempDirAnnotationHandler);
    }

    public <T> T readFileContent(String fileName, Class<T> targetType, String encoding, Class<?> testClass) {
        return this.fileContentReader.readFileContent(fileName, targetType, encoding, testClass);
    }

    public File createTempFile(String fileName) {
        return this.tempService.createTempFile(fileName);
    }

    public File createTempDir(String dirName) {
        return this.tempService.createTempDir(dirName);
    }

    public void deleteTempFileOrDir(File fileOrDir) {
        this.tempService.deleteTempFileOrDir(fileOrDir);
    }

    protected FileContentReader createFileContentReader() {
        FileContentReaderFactory fileContentReaderFactory = (FileContentReaderFactory)ConfigUtils.getInstanceOf(FileContentReaderFactory.class, (Properties)this.configuration, (String[])new String[0]);
        return fileContentReaderFactory.createFileContentReader(this.configuration);
    }

    protected TempService createTempService() {
        TempServiceFactory tempServiceFactory = (TempServiceFactory)ConfigUtils.getInstanceOf(TempServiceFactory.class, (Properties)this.configuration, (String[])new String[0]);
        return tempServiceFactory.createTempService(this.configuration);
    }

    protected class IOTestListener
    extends TestListener {
        protected FileContentAnnotationHandler fileContentAnnotationHandler;
        protected TempFileAnnotationHandler tempFileAnnotationHandler;
        protected TempDirAnnotationHandler tempDirAnnotationHandler;

        public IOTestListener(FileContentAnnotationHandler fileContentAnnotationHandler, TempFileAnnotationHandler tempFileAnnotationHandler, TempDirAnnotationHandler tempDirAnnotationHandler) {
            this.fileContentAnnotationHandler = fileContentAnnotationHandler;
            this.tempFileAnnotationHandler = tempFileAnnotationHandler;
            this.tempDirAnnotationHandler = tempDirAnnotationHandler;
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            this.tempDirAnnotationHandler.beforeTestSetUp(testObject, testMethod);
            this.tempFileAnnotationHandler.beforeTestSetUp(testObject, testMethod);
            this.fileContentAnnotationHandler.beforeTestSetUp(testObject, testMethod);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            this.tempFileAnnotationHandler.afterTestMethod(testObject, testMethod, testThrowable);
            this.tempDirAnnotationHandler.afterTestMethod(testObject, testMethod, testThrowable);
        }
    }
}

