/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.annotation.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.io.annotation.FileContent;
import org.unitils.io.filecontent.FileContentReader;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class FileContentAnnotationHandler
extends TestListener {
    private FileContentReader fileContentReader;

    public FileContentAnnotationHandler(FileContentReader fileContentReader) {
        this.fileContentReader = fileContentReader;
    }

    public void beforeTestSetUp(Object testObject, Method testMethod) {
        Set fieldsAnnotatedWithFileContent = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), FileContent.class);
        for (Field field : fieldsAnnotatedWithFileContent) {
            this.readFileContentForField(testObject, field);
        }
    }

    protected void readFileContentForField(Object testObject, Field field) {
        FileContent fileContentAnnotation = field.getAnnotation(FileContent.class);
        String encoding = this.determineEncoding(fileContentAnnotation);
        String fileName = this.determineFileName(fileContentAnnotation);
        Class<?> targetType = field.getType();
        Class<?> testClass = testObject.getClass();
        try {
            Object result = this.fileContentReader.readFileContent(fileName, targetType, encoding, testClass);
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, result);
        }
        catch (Exception e) {
            throw new UnitilsException("Error reading file content for field " + field.getName(), (Throwable)e);
        }
    }

    protected String determineEncoding(FileContent fileContentAnnotation) {
        String encoding = fileContentAnnotation.encoding();
        if (StringUtils.isEmpty((String)encoding)) {
            return null;
        }
        return encoding;
    }

    protected String determineFileName(FileContent fileContentAnnotation) {
        String fileName = fileContentAnnotation.value();
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        return fileName;
    }
}

