/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.filecontent.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.unitils.core.util.ConfigUtils;
import org.unitils.io.conversion.ConversionStrategy;
import org.unitils.io.filecontent.FileContentReader;
import org.unitils.io.filecontent.FileContentReaderFactory;
import org.unitils.io.filecontent.impl.DefaultFileContentReader;
import org.unitils.io.reader.ReadingStrategy;
import org.unitils.io.reader.ReadingStrategyFactory;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class DefaultFileContentReaderFactory
implements FileContentReaderFactory {
    public static final String DEFAULT_CONVERSION_STRATEGY_KEY = "IOModule.conversion.default";
    public static final String CUSTOM_CONVERSION_STRATEGY_KEY = "IOModule.conversion.custom";
    public static final String DEFAULT_FILE_ENCODING = "IOModule.encoding.default";

    @Override
    public FileContentReader createFileContentReader(Properties configuration) {
        ReadingStrategy readingStrategy = this.createReadingStrategy(configuration);
        List<ConversionStrategy<?>> conversionStrategies = this.createConversionStrategies(configuration);
        String defaultEncoding = PropertyUtils.getString((String)DEFAULT_FILE_ENCODING, (Properties)configuration);
        return new DefaultFileContentReader(readingStrategy, conversionStrategies, defaultEncoding);
    }

    protected ReadingStrategy createReadingStrategy(Properties configuration) {
        ReadingStrategyFactory readingStrategyFactory = (ReadingStrategyFactory)ConfigUtils.getInstanceOf(ReadingStrategyFactory.class, (Properties)configuration, (String[])new String[0]);
        return readingStrategyFactory.createReadingStrategy(configuration);
    }

    protected List<ConversionStrategy<?>> createConversionStrategies(Properties configuration) {
        LinkedList conversionStrategies = new LinkedList();
        conversionStrategies.addAll(this.createConversionStrategies(configuration, CUSTOM_CONVERSION_STRATEGY_KEY));
        conversionStrategies.addAll(this.createConversionStrategies(configuration, DEFAULT_CONVERSION_STRATEGY_KEY));
        return conversionStrategies;
    }

    protected List<ConversionStrategy<?>> createConversionStrategies(Properties configuration, String propertyName) {
        List conversionStrategyClassNames = PropertyUtils.getStringList((String)propertyName, (Properties)configuration);
        ArrayList conversionStrategies = new ArrayList(conversionStrategyClassNames.size());
        for (String conversionStrategyClassName : conversionStrategyClassNames) {
            ConversionStrategy conversionStrategy = (ConversionStrategy)ReflectionUtils.createInstanceOfType((String)conversionStrategyClassName, (boolean)false);
            conversionStrategies.add(conversionStrategy);
        }
        return conversionStrategies;
    }
}

