/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.temp.impl;

import java.io.File;
import java.util.Properties;
import org.unitils.core.UnitilsException;
import org.unitils.io.temp.TempService;
import org.unitils.io.temp.TempServiceFactory;
import org.unitils.io.temp.impl.DefaultTempService;
import org.unitils.util.PropertyUtils;

public class DefaultTempServiceFactory
implements TempServiceFactory {
    public static final String ROOT_TEMP_DIR = "IOModule.temp.rootTempDir";

    @Override
    public TempService createTempService(Properties configuration) {
        File rootTempDir = this.getRootTempDir(configuration);
        return new DefaultTempService(rootTempDir);
    }

    protected File getRootTempDir(Properties configuration) {
        String systemTempDirName = System.getProperty("java.io.tmpdir");
        String rootTempDirName = PropertyUtils.getString((String)ROOT_TEMP_DIR, (String)systemTempDirName, (Properties)configuration);
        File rootTempDir = new File(rootTempDirName);
        if (rootTempDir.isFile()) {
            throw new UnitilsException("Root temp dir " + rootTempDirName + " is not a directory. Please fill in a directory for property " + ROOT_TEMP_DIR);
        }
        rootTempDir.mkdirs();
        return rootTempDir;
    }
}

