/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.argumentmatcher;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.mock.annotation.ArgumentMatcher;
import org.unitils.mock.annotation.MatchStatement;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.unitils.util.ReflectionUtils;
import thirdparty.org.objectweb.asm.ClassReader;
import thirdparty.org.objectweb.asm.Type;
import thirdparty.org.objectweb.asm.tree.AbstractInsnNode;
import thirdparty.org.objectweb.asm.tree.ClassNode;
import thirdparty.org.objectweb.asm.tree.LineNumberNode;
import thirdparty.org.objectweb.asm.tree.MethodInsnNode;
import thirdparty.org.objectweb.asm.tree.MethodNode;
import thirdparty.org.objectweb.asm.tree.analysis.Analyzer;
import thirdparty.org.objectweb.asm.tree.analysis.AnalyzerException;
import thirdparty.org.objectweb.asm.tree.analysis.BasicInterpreter;
import thirdparty.org.objectweb.asm.tree.analysis.BasicValue;
import thirdparty.org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentMatcherPositionFinder {
    public static List<Integer> getArgumentMatcherIndexes(ProxyInvocation proxyInvocation, int fromLineNr, int toLineNr, int index) {
        Class testClass = ReflectionUtils.getClassWithName((String)proxyInvocation.getInvokedAt().getClassName());
        String testMethodName = proxyInvocation.getInvokedAt().getMethodName();
        Method method = proxyInvocation.getMethod();
        return ArgumentMatcherPositionFinder.getArgumentMatcherIndexes(testClass, testMethodName, method, fromLineNr, toLineNr, index);
    }

    public static List<Integer> getArgumentMatcherIndexes(Class<?> clazz, String methodName, Method invokedMethod, int fromLineNr, int toLineNr, int index) {
        ClassNode restClassNode = ArgumentMatcherPositionFinder.readClass(clazz);
        List testMethodNodes = restClassNode.methods;
        for (MethodNode testMethodNode : testMethodNodes) {
            List<Integer> result;
            if (!methodName.equals(testMethodNode.name) || (result = ArgumentMatcherPositionFinder.findArgumentMatcherIndexes(restClassNode, testMethodNode, clazz, methodName, invokedMethod, fromLineNr, toLineNr, index)) == null) continue;
            return result;
        }
        throw new UnitilsException("Unable to find indexes of argument matcher. Method not found: " + methodName);
    }

    protected static ClassNode readClass(Class<?> clazz) {
        ClassNode classNode;
        InputStream inputStream = null;
        try {
            inputStream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(inputStream);
            ClassNode classNode2 = new ClassNode();
            classReader.accept(classNode2, 0);
            classNode = classNode2;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Unable to read class file for " + clazz, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return classNode;
    }

    protected static List<Integer> findArgumentMatcherIndexes(ClassNode classNode, MethodNode methodNode, Class<?> interpretedClass, String interpretedMethodName, Method invokedMethod, int fromLineNr, int toLineNr, int index) {
        String invokedMethodName = invokedMethod.getName();
        String invokedMethodDescriptor = Type.getMethodDescriptor(invokedMethod);
        try {
            MethodInterpreter methodInterpreter = new MethodInterpreter(interpretedClass, interpretedMethodName, invokedMethodName, invokedMethodDescriptor, fromLineNr, toLineNr, index);
            MethodAnalyzer analyzer = new MethodAnalyzer(methodNode, methodInterpreter);
            analyzer.analyze(classNode.name, methodNode);
            return methodInterpreter.getResultArgumentMatcherIndexes();
        }
        catch (AnalyzerException e) {
            if (e.getCause() instanceof UnitilsException) {
                throw (UnitilsException)e.getCause();
            }
            throw new UnitilsException("Unable to find argument matchers for method invocation. Method name: " + invokedMethodName + ", method description; " + invokedMethodDescriptor + ", line nr; " + fromLineNr, (Throwable)e);
        }
    }

    protected static class ArgumentMatcherValue
    extends BasicValue {
        public ArgumentMatcherValue(Type type) {
            super(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodInterpreter
    extends BasicInterpreter {
        protected Class<?> interpretedClass;
        protected String interpretedMethodName;
        protected String invokedMethodName;
        protected String invokedMethodDescriptor;
        protected int fromLineNr;
        protected int toLineNr;
        protected int index;
        protected int currentLineNr = 0;
        protected int currentIndex = 1;
        protected Method currentMatcherMethod;
        protected Set<MethodInsnNode> handledMethodInsnNodes = new HashSet<MethodInsnNode>();
        protected List<Integer> resultArgumentMatcherIndexes;

        public MethodInterpreter(Class<?> interpretedClass, String interpretedMethodName, String invokedMethodName, String invokedMethodDescriptor, int fromLineNr, int toLineNr, int index) {
            this.interpretedClass = interpretedClass;
            this.interpretedMethodName = interpretedMethodName;
            this.invokedMethodName = invokedMethodName;
            this.invokedMethodDescriptor = invokedMethodDescriptor;
            this.fromLineNr = fromLineNr;
            this.toLineNr = toLineNr;
            this.index = index;
        }

        public List<Integer> getResultArgumentMatcherIndexes() {
            return this.resultArgumentMatcherIndexes;
        }

        public void setCurrentLineNr(int currentLineNr) {
            this.currentLineNr = currentLineNr;
        }

        @Override
        public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
            Value resultValue = super.copyOperation(insn, value);
            return this.getValue(resultValue, value);
        }

        @Override
        public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
            Value resultValue = super.unaryOperation(insn, value);
            return this.getValue(resultValue, value);
        }

        @Override
        public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
            Value resultValue = super.binaryOperation(insn, value1, value2);
            return this.getValue(resultValue, value1, value2);
        }

        @Override
        public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
            Value resultValue = super.ternaryOperation(insn, value1, value2, value3);
            return this.getValue(resultValue, value1, value2, value3);
        }

        @Override
        public Value naryOperation(AbstractInsnNode instructionNode, List values) throws AnalyzerException {
            Value resultValue = super.naryOperation(instructionNode, values);
            if (!(instructionNode instanceof MethodInsnNode)) {
                return this.getValue(resultValue, values);
            }
            MethodInsnNode methodInsnNode = (MethodInsnNode)instructionNode;
            if (this.instructionOutOfRange() || this.instructionAlreadyHandled(methodInsnNode)) {
                return this.getValue(resultValue, values);
            }
            if (this.isInvokedMethod(methodInsnNode)) {
                if (this.currentIndex++ != this.index) {
                    return this.getValue(resultValue, values);
                }
                if (this.resultArgumentMatcherIndexes != null) {
                    this.throwUnitilsException("Method invocation occurs more than once within the same clause. Method name: " + this.invokedMethodName);
                }
                this.resultArgumentMatcherIndexes = this.getArgumentMatcherIndexes(methodInsnNode, values);
                this.currentMatcherMethod = null;
                return this.createArgumentMatcherValue(resultValue);
            }
            Method method = this.getMethod(methodInsnNode);
            if (method != null) {
                if (this.isMatcherMethod(method)) {
                    this.currentMatcherMethod = method;
                }
                if (this.isArgumentMatcherMethod(method)) {
                    if (this.currentMatcherMethod == null) {
                        this.throwUnitilsException("An argument matcher cannot be used outside the context of a match statement.");
                    }
                    return this.createArgumentMatcherValue(resultValue);
                }
            }
            return this.getValue(resultValue, values);
        }

        protected boolean instructionOutOfRange() {
            return this.currentLineNr < this.fromLineNr || this.toLineNr < this.currentLineNr;
        }

        protected boolean instructionAlreadyHandled(MethodInsnNode methodInsnNode) {
            return !this.handledMethodInsnNodes.add(methodInsnNode);
        }

        protected boolean isInvokedMethod(MethodInsnNode methodInsnNode) {
            return this.invokedMethodName.equals(methodInsnNode.name) && this.invokedMethodDescriptor.equals(methodInsnNode.desc);
        }

        protected List<Integer> getArgumentMatcherIndexes(MethodInsnNode methodInsnNode, List values) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            boolean isStatic = methodInsnNode.getOpcode() == 184;
            for (int i = 0; i < values.size(); ++i) {
                if (!(values.get(i) instanceof ArgumentMatcherValue)) continue;
                result.add(isStatic ? i : i - 1);
            }
            return result;
        }

        protected boolean isMatcherMethod(Method method) {
            return method.getAnnotation(MatchStatement.class) != null;
        }

        protected boolean isArgumentMatcherMethod(Method method) {
            return method.getAnnotation(ArgumentMatcher.class) != null;
        }

        protected void throwUnitilsException(String errorMessage) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(errorMessage);
            stringBuilder.append("\n at ");
            stringBuilder.append(new StackTraceElement(this.interpretedClass.getName(), this.interpretedMethodName, this.interpretedClass.getName(), this.currentLineNr).toString());
            stringBuilder.append("\n");
            throw new UnitilsException(stringBuilder.toString());
        }

        @Override
        public Value merge(Value value1, Value value2) {
            Value resultValue = super.merge(value1, value2);
            if (value1 instanceof ArgumentMatcherValue || value2 instanceof ArgumentMatcherValue) {
                return this.createArgumentMatcherValue(resultValue);
            }
            return resultValue;
        }

        protected Method getMethod(MethodInsnNode methodNode) {
            Method[] methods;
            String internalClassName = methodNode.owner;
            String className = internalClassName.replace('/', '.');
            String methodName = methodNode.name;
            String methodDescriptor = methodNode.desc;
            Class clazz = ReflectionUtils.getClassWithName((String)className);
            for (Method method : methods = clazz.getMethods()) {
                if (!methodName.equals(method.getName()) || !methodDescriptor.equals(Type.getMethodDescriptor(method))) continue;
                return method;
            }
            return null;
        }

        protected Value getValue(Value resultValue, Value ... values) {
            if (values != null) {
                for (Value value : values) {
                    if (!(value instanceof ArgumentMatcherValue)) continue;
                    return this.createArgumentMatcherValue(resultValue);
                }
            }
            return resultValue;
        }

        protected Value getValue(Value resultValue, List<Value> values) {
            int nrOfArgumentMatcherValues = this.getNrOfArgumentMacherValues(values);
            if (nrOfArgumentMatcherValues > 1) {
                this.throwUnitilsException("An argument matcher cannot be used in an expression.");
            }
            if (nrOfArgumentMatcherValues == 1) {
                return this.createArgumentMatcherValue(resultValue);
            }
            return resultValue;
        }

        protected int getNrOfArgumentMacherValues(List<Value> values) {
            if (values == null) {
                return 0;
            }
            int count = 0;
            for (Value value : values) {
                if (!(value instanceof ArgumentMatcherValue)) continue;
                ++count;
            }
            return count;
        }

        protected ArgumentMatcherValue createArgumentMatcherValue(Value resultValue) {
            if (resultValue == null || !(resultValue instanceof BasicValue)) {
                return new ArgumentMatcherValue(null);
            }
            Type type = ((BasicValue)resultValue).getType();
            return new ArgumentMatcherValue(type);
        }
    }

    protected static class MethodAnalyzer
    extends Analyzer {
        protected MethodNode methodNode;
        protected MethodInterpreter methodInterpreter;

        public MethodAnalyzer(MethodNode methodNode, MethodInterpreter methodInterpreter) {
            super(methodInterpreter);
            this.methodNode = methodNode;
            this.methodInterpreter = methodInterpreter;
        }

        protected void newControlFlowEdge(int instructionIndex, int nextInstructionIndex) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(instructionIndex);
            if (insnNode instanceof LineNumberNode) {
                LineNumberNode lineNumberNode = (LineNumberNode)insnNode;
                this.methodInterpreter.setCurrentLineNr(lineNumberNode.line);
            }
        }
    }
}

