/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.proxy;

import org.unitils.core.UnitilsException;
import org.unitils.mock.core.proxy.ProxyUtils;
import org.unitils.util.ReflectionUtils;

public class StackTraceUtils {
    public static int getInvocationLineNr(Class<?> invokedClass) {
        StackTraceElement[] invocationStackTrace = StackTraceUtils.getInvocationStackTrace(invokedClass, false);
        if (invocationStackTrace == null) {
            return -1;
        }
        return invocationStackTrace[0].getLineNumber();
    }

    public static StackTraceElement[] getInvocationStackTrace(Class<?> invokedInterface) {
        return StackTraceUtils.getInvocationStackTrace(invokedInterface, true);
    }

    public static StackTraceElement[] getInvocationStackTrace(Class<?> invokedInterface, boolean included) {
        StackTraceElement[] currentStackTrace = Thread.currentThread().getStackTrace();
        for (int i = currentStackTrace.length - 1; i >= 0; --i) {
            Class clazz;
            String className = currentStackTrace[i].getClassName();
            try {
                clazz = ReflectionUtils.getClassWithName((String)className);
            }
            catch (UnitilsException e) {
                continue;
            }
            if (!invokedInterface.isAssignableFrom(clazz) && !ProxyUtils.isProxyClassName(className)) continue;
            int index = included ? i : i + 1;
            return StackTraceUtils.getStackTraceStartingFrom(currentStackTrace, index);
        }
        return null;
    }

    public static StackTraceElement[] getStackTraceStartingFrom(StackTraceElement[] stackTraceElements, int index) {
        StackTraceElement[] result = new StackTraceElement[stackTraceElements.length - index];
        System.arraycopy(stackTraceElements, index, result, 0, stackTraceElements.length - index);
        return result;
    }
}

