/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import org.verapdf.cos.COSDirect;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSBoolean
extends COSDirect {
    public static final COSBoolean TRUE = new COSBoolean(true);
    public static final COSBoolean FALSE = new COSBoolean(false);
    private boolean value;

    protected COSBoolean() {
    }

    protected COSBoolean(boolean initValue) {
        this.value = initValue;
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_BOOLEAN;
    }

    public static COSObject construct(boolean initValue) {
        return new COSObject(new COSBoolean(initValue));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromBoolean(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromBoolean(this);
    }

    @Override
    public Boolean getBoolean() {
        return this.get();
    }

    @Override
    public boolean setBoolean(boolean value) {
        this.set(value);
        return true;
    }

    public boolean get() {
        return this.value;
    }

    public void set(boolean value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSBoolean)) {
            return false;
        }
        COSBoolean that = (COSBoolean)o;
        return this.value == that.value;
    }
}

