/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASOutputStream;
import org.verapdf.exceptions.VeraPDFParserException;

public class InternalOutputStream
implements ASOutputStream,
Closeable {
    private static final String READ_WRITE_MODE = "rw";
    private RandomAccessFile os;
    private File file;

    public static InternalOutputStream getInternalOutputStream() throws IOException {
        File tempFile = File.createTempFile("tmp_pdf_file", ".pdf");
        return new InternalOutputStream(tempFile);
    }

    public InternalOutputStream(String fileName) throws FileNotFoundException {
        this(InternalOutputStream.getFileFromString(fileName));
    }

    public InternalOutputStream(File file) throws FileNotFoundException {
        this.os = new RandomAccessFile(file, READ_WRITE_MODE);
        this.file = file;
    }

    @Override
    public long write(byte[] buffer) throws IOException {
        long oldPos = this.os.getFilePointer();
        this.os.write(buffer);
        return this.getOffset() - oldPos;
    }

    public long write(byte[] buffer, int size) throws IOException {
        long oldPos = this.os.getFilePointer();
        this.os.write(buffer, 0, size);
        return this.getOffset() - oldPos;
    }

    @Override
    public long write(byte[] buffer, int offset, int size) throws IOException {
        long oldPos = this.os.getFilePointer();
        this.os.write(buffer, offset, size);
        return this.getOffset() - oldPos;
    }

    @Override
    public long write(ASInputStream stream) throws IOException {
        byte[] buf = new byte[2048];
        int read = stream.read(buf, buf.length);
        int res = 0;
        while (read != -1) {
            this.write(buf, 0, read);
            res += read;
            read = stream.read(buf, buf.length);
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public void seekEnd() throws IOException {
        this.os.seek(this.os.length());
    }

    public long getOffset() throws IOException {
        return this.os.getFilePointer();
    }

    public InternalOutputStream seek(long offset) throws IOException {
        this.os.seek(offset);
        return this;
    }

    public InternalOutputStream write(char value) throws IOException {
        this.os.writeChar(value);
        return this;
    }

    public InternalOutputStream write(byte value) throws IOException {
        this.os.writeByte(value);
        return this;
    }

    public InternalOutputStream write(boolean value) throws IOException {
        this.os.writeBoolean(value);
        return this;
    }

    public InternalOutputStream write(int value) throws IOException {
        this.os.writeInt(value);
        return this;
    }

    public InternalOutputStream write(long value) throws IOException {
        this.os.writeLong(value);
        return this;
    }

    public InternalOutputStream write(double value) throws IOException {
        this.os.writeDouble(value);
        return this;
    }

    public InternalOutputStream write(String value) throws IOException {
        this.os.writeBytes(value);
        return this;
    }

    public File getFile() {
        return this.file;
    }

    private static File getFileFromString(String fileName) {
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            throw new VeraPDFParserException("Cannot create file : " + fileName);
        }
        return file;
    }
}

