/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFFileBaseParser;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.cff.CharStringsWidths;
import org.verapdf.tools.resource.ASFileStreamCloser;

abstract class CFFFontBaseParser
extends CFFFileBaseParser {
    private static final Logger LOGGER = Logger.getLogger(CFFFontBaseParser.class.getCanonicalName());
    protected boolean attemptedParsing = false;
    protected boolean successfullyParsed = false;
    protected static final float[] DEFAULT_FONT_MATRIX = new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f};
    protected ArrayList<CFFNumber> stack;
    protected CFFIndex globalSubrs;
    protected boolean isSubset;
    protected long privateDictOffset;
    protected long privateDictSize;
    protected long topDictBeginOffset;
    protected long topDictEndOffset;
    protected float[] fontMatrix = new float[6];
    boolean fontMatrixRead = false;
    protected long charStringsOffset;
    protected long charSetOffset;
    protected int charStringType;
    protected int nGlyphs;
    protected CFFIndex charStrings;
    protected CharStringsWidths widths;
    protected int defaultWidthX;
    protected int nominalWidthX;
    protected long subrsOffset = -1L;

    public CFFFontBaseParser(SeekableInputStream source) {
        super(source);
        this.stack = new ArrayList(48);
        System.arraycopy(DEFAULT_FONT_MATRIX, 0, this.fontMatrix, 0, DEFAULT_FONT_MATRIX.length);
        this.charStringType = 2;
        this.charSetOffset = 0L;
    }

    protected void readTopDictUnit() throws IOException {
        try {
            int next = this.source.peek() & 0xFF;
            if (next > 27 && next < 31 || next > 31 && next < 255) {
                this.stack.add(this.readNumber());
            } else {
                this.source.readByte();
                if (next < 22) {
                    block1 : switch (next) {
                        case 15: {
                            this.charSetOffset = this.stack.get(this.stack.size() - 1).getInteger();
                            this.stack.clear();
                            break;
                        }
                        case 17: {
                            this.charStringsOffset = this.stack.get(this.stack.size() - 1).getInteger();
                            this.stack.clear();
                            break;
                        }
                        case 18: {
                            this.privateDictSize = this.stack.get(this.stack.size() - 2).getInteger();
                            this.privateDictOffset = this.stack.get(this.stack.size() - 1).getInteger();
                            this.stack.clear();
                            break;
                        }
                        case 12: {
                            next = this.source.readByte() & 0xFF;
                            switch (next) {
                                case 7: {
                                    if (!this.fontMatrixRead) {
                                        this.fontMatrixRead = true;
                                        for (int i = 0; i < 6; ++i) {
                                            this.fontMatrix[i] = this.stack.get(i).getReal();
                                        }
                                    }
                                    this.stack.clear();
                                    break block1;
                                }
                                case 6: {
                                    this.charStringType = (int)this.stack.get(this.stack.size() - 1).getInteger();
                                    this.stack.clear();
                                    break block1;
                                }
                            }
                            this.readTopDictTwoByteOps(next);
                            break;
                        }
                        default: {
                            this.readTopDictOneByteOps(next);
                        }
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Error with stack in processing Top DICT in CFF file", e);
        }
    }

    protected void readTopDictTwoByteOps(int lastRead) throws IOException {
        this.stack.clear();
    }

    protected void readTopDictOneByteOps(int lastRead) {
        this.stack.clear();
    }

    protected void readCharStrings() throws IOException {
        this.charStrings = this.readIndex();
        this.nGlyphs = this.charStrings.size();
    }

    protected void readPrivateDictUnit() throws IOException {
        int next = this.source.peek() & 0xFF;
        if (next > 27 && next < 31 || next > 31 && next < 255) {
            this.stack.add(this.readNumber());
        } else {
            this.source.readByte();
            if (next < 22) {
                switch (next) {
                    case 20: {
                        if (!this.stack.isEmpty()) {
                            this.defaultWidthX = (int)this.stack.get(this.stack.size() - 1).getInteger();
                            this.stack.clear();
                            break;
                        }
                        LOGGER.log(Level.FINE, "Empty arguments stack for defaultWidthX operator");
                        break;
                    }
                    case 21: {
                        if (!this.stack.isEmpty()) {
                            this.nominalWidthX = (int)this.stack.get(this.stack.size() - 1).getInteger();
                            this.stack.clear();
                            break;
                        }
                        LOGGER.log(Level.FINE, "Empty arguments stack for nominalWidthX operator");
                        break;
                    }
                    case 19: {
                        if (!this.stack.isEmpty()) {
                            this.subrsOffset = this.stack.get(this.stack.size() - 1).getInteger() + this.privateDictOffset;
                            this.stack.clear();
                            break;
                        }
                        LOGGER.log(Level.FINE, "Empty arguments stack for Subrs operator");
                        break;
                    }
                    default: {
                        this.stack.clear();
                    }
                }
            }
        }
    }

    public int getNGlyphs() {
        return this.nGlyphs;
    }

    public ASFileStreamCloser getFontProgramResource() {
        if (this.source instanceof ASMemoryInStream) {
            return null;
        }
        return new ASFileStreamCloser(this.source);
    }
}

