/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.pd.font.truetype.PlatformEncodingPair;

public class TrueTypeCmapSubtable {
    private int platformID;
    private int encodingID;
    private long offset;
    private Map<Integer, Integer> mapping;
    private int sampleCode;
    private static List<PlatformEncodingPair> standardEncodingCMaps = new ArrayList<PlatformEncodingPair>();

    public TrueTypeCmapSubtable(int platformID, int encodingID, long offset) {
        this.platformID = platformID;
        this.encodingID = encodingID;
        this.offset = offset;
        this.mapping = new HashMap<Integer, Integer>();
        this.sampleCode = -1;
    }

    int getPlatformID() {
        return this.platformID;
    }

    int getEncodingID() {
        return this.encodingID;
    }

    public long getOffset() {
        return this.offset;
    }

    public void put(Integer key, Integer value) {
        if (this.sampleCode == -1) {
            this.sampleCode = key;
        }
        this.mapping.put(key, value);
    }

    public int getGlyph(int code) {
        if (!this.mapping.containsKey(code)) {
            return 0;
        }
        return this.mapping.get(code);
    }

    int getSampleCharCode() {
        return this.sampleCode;
    }

    public boolean containsGlyph(int glyphCode) {
        return this.mapping.containsValue(glyphCode);
    }

    public boolean containsCID(int cid) {
        return this.mapping.containsKey(cid);
    }

    public boolean isStandardEncodingCMap() {
        for (PlatformEncodingPair pair : standardEncodingCMaps) {
            if (this.platformID != pair.getPlatformID() || this.encodingID != pair.getEncodingID()) continue;
            return true;
        }
        return false;
    }

    static {
        standardEncodingCMaps.add(new PlatformEncodingPair(3, 1));
        standardEncodingCMaps.add(new PlatformEncodingPair(1, 0));
    }
}

