/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.external.JPEG2000;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.images.PDXObject;

public class PDXImage
extends PDXObject {
    private static final Logger LOGGER = Logger.getLogger(PDXImage.class.getCanonicalName());
    private ASAtom colorSpaceName;
    private PDColorSpace imageCS;
    private PDResources resources;
    private JPEG2000 jpxStream;

    public PDXImage(COSObject obj, PDResources resources) {
        super(obj);
        this.resources = resources;
        this.parseJPXAndColorSpace();
    }

    @Override
    public ASAtom getType() {
        return ASAtom.IMAGE;
    }

    private void parseJPXAndColorSpace() {
        COSObject rawColorSpace;
        List<ASAtom> filters = this.getFilters();
        if (filters.contains(ASAtom.JPX_DECODE)) {
            try (ASInputStream stream = this.getObject().getData();){
                this.jpxStream = JPEG2000.fromStream(stream);
                this.imageCS = this.imageCS == null ? this.jpxStream.getImageColorSpace() : this.imageCS;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "IO Exception reading JP2K stream", e);
            }
        }
        if ((rawColorSpace = this.getKey(ASAtom.COLORSPACE)) != null && !rawColorSpace.empty() && rawColorSpace.getType() != COSObjType.COS_NULL) {
            if (rawColorSpace.getType() == COSObjType.COS_NAME) {
                this.colorSpaceName = rawColorSpace.getName();
            }
            if (rawColorSpace.getType() == COSObjType.COS_ARRAY) {
                COSArray array = (COSArray)rawColorSpace.getDirectBase();
                if (array.size() == 1 && array.at(0).getType() == COSObjType.COS_NAME) {
                    this.colorSpaceName = array.at(0).getName();
                } else {
                    this.imageCS = ColorSpaceFactory.getColorSpace(rawColorSpace, this.resources);
                }
            }
        }
    }

    public PDColorSpace getImageCS() {
        return this.imageCS;
    }

    public ASAtom getImageCSName() {
        return this.colorSpaceName;
    }

    public JPEG2000 getJPXStream() {
        return this.jpxStream;
    }

    public boolean isInterpolate() {
        Boolean value = this.getObject().getBooleanKey(ASAtom.INTERPOLATE);
        return value != null ? value : false;
    }

    public List<PDXImage> getAlternates() {
        COSObject alternates = this.getKey(ASAtom.ALTERNATES);
        if (alternates != null && alternates.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDXImage> res = new ArrayList<PDXImage>();
            for (COSObject alternate : (COSArray)alternates.getDirectBase()) {
                if (alternate != null && alternate.getType() == COSObjType.COS_DICT) {
                    COSObject image = alternate.getKey(ASAtom.IMAGE);
                    if (image != null && image.getType() == COSObjType.COS_STREAM) {
                        res.add(new PDXImage(image, this.resources));
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Image key in alternate dictionary contains non stream value");
                    return null;
                }
                LOGGER.log(Level.FINE, "Alternates array contains non dictionary value");
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public COSName getIntent() {
        COSObject object = this.getKey(ASAtom.INTENT);
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return (COSName)object.getDirectBase();
        }
        return null;
    }

    public Long getWidth() {
        return this.getObject().getIntegerKey(ASAtom.WIDTH);
    }

    public Long getHeight() {
        return this.getObject().getIntegerKey(ASAtom.HEIGHT);
    }

    public Long getBitsPerComponent() {
        return this.getObject().getIntegerKey(ASAtom.BITS_PER_COMPONENT);
    }

    public boolean getImageMask() {
        Boolean value = this.getObject().getBooleanKey(ASAtom.IMAGE_MASK);
        return value != null ? value : false;
    }

    public PDXImage getMask() {
        COSObject object = this.getKey(ASAtom.MASK);
        if (object != null && object.getType() == COSObjType.COS_STREAM) {
            return new PDXImage(object, this.resources);
        }
        return null;
    }

    public Long getStructParent() {
        return this.getObject().getIntegerKey(ASAtom.STRUCT_PARENT);
    }

    public List<ASAtom> getFilters() {
        COSObject filters = this.getObject().getKey(ASAtom.FILTER);
        if (filters != null) {
            ArrayList<ASAtom> res = new ArrayList<ASAtom>();
            if (filters.getType() == COSObjType.COS_NAME) {
                res.add(filters.getName());
            } else if (filters.getType() == COSObjType.COS_ARRAY) {
                for (COSObject filter : (COSArray)filters.getDirectBase()) {
                    if (filter == null || filter.getType() != COSObjType.COS_NAME) {
                        LOGGER.log(Level.FINE, "Filter array contains non name value");
                        return Collections.emptyList();
                    }
                    res.add(filter.getName());
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public PDMetadata getMetadata() {
        COSObject object = this.getKey(ASAtom.METADATA);
        if (object != null && object.getType() == COSObjType.COS_STREAM) {
            return new PDMetadata(object);
        }
        return null;
    }

    public int getSMaskInData() {
        Long value = this.getObject().getIntegerKey(ASAtom.SMASK_IN_DATA);
        return value != null ? value.intValue() : 0;
    }
}

