/*
 Highstock JS v10.3.3 (2023-01-20)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(C){a(C);a.Highcharts=C;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function C(a,q,B,r){a.hasOwnProperty(q)||(a[q]=r.apply(null,B),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:q,module:a[q]}})))}a=a?a._modules:{};C(a,"Core/Axis/BrokenAxis.js",
[a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,q){var E=q.addEvent,r=q.find,v=q.fireEvent,y=q.isArray,h=q.isNumber,z=q.pick,u;(function(p){function e(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function g(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function w(){var f=this.brokenAxis;if(f&&f.hasBreaks){for(var c=this.tickPositions,t=this.tickPositions.info,n=[],d=0;d<c.length;d++)f.isInAnyBreak(c[d])||
n.push(c[d]);this.tickPositions=n;this.tickPositions.info=t}}function c(){this.brokenAxis||(this.brokenAxis=new H(this))}function u(){var f=this.options.connectNulls,c=this.points,t=this.xAxis,n=this.yAxis;if(this.isDirty)for(var d=c.length;d--;){var k=c[d],b=!(null===k.y&&!1===f)&&(t&&t.brokenAxis&&t.brokenAxis.isInAnyBreak(k.x,!0)||n&&n.brokenAxis&&n.brokenAxis.isInAnyBreak(k.y,!0));k.visible=b?!1:!1!==k.options.visible}}function f(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,
z(this.pointArrayMap,["y"]))}function D(f,c){var t=this,n=t.points,d,k,b,l;if(f&&f.brokenAxis&&f.brokenAxis.hasBreaks){var m=f.brokenAxis;c.forEach(function(A){d=m&&m.breakArray||[];k=f.isXAxis?f.min:z(t.options.threshold,f.min);n.forEach(function(m){l=z(m["stack"+A.toUpperCase()],m[A]);d.forEach(function(d){if(h(k)&&h(l)){b=!1;if(k<d.from&&l>d.to||k>d.from&&l<d.from)b="pointBreak";else if(k<d.from&&l>d.from&&l<d.to||k>d.from&&l>d.to&&l<d.from)b="pointInBreak";b&&v(f,b,{point:m,brk:d})}})})})}}function L(){var f=
this.currentDataGrouping,c=f&&f.gapSize;f=this.points.slice();var t=this.yAxis,n=this.options.gapSize,d=f.length-1,k;if(n&&0<d)for("value"!==this.options.gapUnit&&(n*=this.basePointRange),c&&c>n&&c>=this.basePointRange&&(n=c),k=void 0;d--;)k&&!1!==k.visible||(k=f[d+1]),c=f[d],!1!==k.visible&&!1!==c.visible&&(k.x-c.x>n&&(k=(c.x+k.x)/2,f.splice(d+1,0,{isNull:!0,x:k}),t.stacking&&this.options.stacking&&(k=t.stacking.stacks[this.stackKey][k]=new a(t,t.options.stackLabels,!1,k,this.stack),k.total=0)),
k=c);return this.getGraphPath(f)}var q=[];p.compose=function(a,p){-1===q.indexOf(a)&&(q.push(a),a.keepProps.push("brokenAxis"),E(a,"init",c),E(a,"afterInit",e),E(a,"afterSetTickPositions",w),E(a,"afterSetOptions",g));if(-1===q.indexOf(p)){q.push(p);var t=p.prototype;t.drawBreaks=D;t.gappedPath=L;E(p,"afterGeneratePoints",u);E(p,"afterRender",f)}return a};var H=function(){function f(f){this.hasBreaks=!1;this.axis=f}f.isInBreak=function(f,c){var n=f.repeat||Infinity,d=f.from,k=f.to-f.from;c=c>=d?(c-
d)%n:n-(d-c)%n;return f.inclusive?c<=k:c<k&&0!==c};f.lin2Val=function(c){var t=this.brokenAxis;t=t&&t.breakArray;if(!t||!h(c))return c;var n;for(n=0;n<t.length;n++){var d=t[n];if(d.from>=c)break;else d.to<c?c+=d.len:f.isInBreak(d,c)&&(c+=d.len)}return c};f.val2Lin=function(c){var t=this.brokenAxis;t=t&&t.breakArray;if(!t||!h(c))return c;var n=c,d;for(d=0;d<t.length;d++){var k=t[d];if(k.to<=c)n-=k.len;else if(k.from>=c)break;else if(f.isInBreak(k,c)){n-=c-k.from;break}}return n};f.prototype.findBreakAt=
function(f,c){return r(c,function(n){return n.from<f&&f<n.to})};f.prototype.isInAnyBreak=function(c,t){var n=this.axis,d=n.options.breaks||[],k=d.length,b;if(k&&h(c)){for(;k--;)if(f.isInBreak(d[k],c)){var l=!0;b||(b=z(d[k].showPoints,!n.isXAxis))}var m=l&&t?l&&!b:l}return m};f.prototype.setBreaks=function(c,t){var n=this,d=n.axis,k=y(c)&&!!c.length;d.isDirty=n.hasBreaks!==k;n.hasBreaks=k;d.options.breaks=d.userOptions.breaks=c;d.forceRedraw=!0;d.series.forEach(function(b){b.isDirty=!0});k||d.val2lin!==
f.val2Lin||(delete d.val2lin,delete d.lin2val);k&&(d.userOptions.ordinal=!1,d.lin2val=f.lin2Val,d.val2lin=f.val2Lin,d.setExtremes=function(b,l,m,A,k){if(n.hasBreaks){for(var M=this.options.breaks||[],f;f=n.findBreakAt(b,M);)b=f.to;for(;f=n.findBreakAt(l,M);)l=f.from;l<b&&(l=b)}d.constructor.prototype.setExtremes.call(this,b,l,m,A,k)},d.setAxisTranslation=function(){d.constructor.prototype.setAxisTranslation.call(this);n.unitLength=void 0;if(n.hasBreaks){var b=d.options.breaks||[],l=[],m=[],A=z(d.pointRangePadding,
0),k=0,c,K=d.userMin||d.min,G=d.userMax||d.max,t;b.forEach(function(b){c=b.repeat||Infinity;h(K)&&h(G)&&(f.isInBreak(b,K)&&(K+=b.to%c-K%c),f.isInBreak(b,G)&&(G-=G%c-b.from%c))});b.forEach(function(b){I=b.from;c=b.repeat||Infinity;if(h(K)&&h(G)){for(;I-c>K;)I-=c;for(;I<K;)I+=c;for(t=I;t<G;t+=c)l.push({value:t,move:"in"}),l.push({value:t+b.to-b.from,move:"out",size:b.breakSize})}});l.sort(function(b,l){return b.value===l.value?("in"===b.move?0:1)-("in"===l.move?0:1):b.value-l.value});var e=0;var I=
K;l.forEach(function(b){e+="in"===b.move?1:-1;1===e&&"in"===b.move&&(I=b.value);0===e&&h(I)&&(m.push({from:I,to:b.value,len:b.value-I-(b.size||0)}),k+=b.value-I-(b.size||0))});n.breakArray=m;h(K)&&h(G)&&h(d.min)&&(n.unitLength=G-K-k+A,v(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:n.unitLength&&(d.transA*=(G-d.min+A)/n.unitLength),A&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=K,d.max=G)}});z(t,!0)&&d.chart.redraw()};return f}();p.Additions=H})(u||(u={}));return u});C(a,"masters/modules/broken-axis.src.js",
[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,q){q.compose(a.Axis,a.Series)});C(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});C(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var e=a.length;a=r(a);u(a)&&e&&(a=h(a/e));return a}function r(a){var e=a.length;if(!e&&a.hasNulls)var p=null;else if(e)for(p=0;e--;)p+=a[e];return p}var v=q.arrayMax,
y=q.arrayMin,h=q.correctFloat,z=q.extend,u=q.isNumber;q={average:E,averages:function(){var a=[];[].forEach.call(arguments,function(e){a.push(E(e))});return"undefined"===typeof a[0]?void 0:a},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},high:function(a){return a.length?v(a):a.hasNulls?null:void 0},hlc:function(p,e,g){p=a.high(p);e=a.low(e);g=a.close(g);if(u(p)||u(e)||u(g))return[p,e,g]},low:function(a){return a.length?y(a):a.hasNulls?null:void 0},ohlc:function(p,e,g,w){p=
a.open(p);e=a.high(e);g=a.low(g);w=a.close(w);if(u(p)||u(e)||u(g)||u(w))return[p,e,g,w]},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},range:function(p,e){p=a.low(p);e=a.high(e);if(u(p)||u(e))return[p,e];if(null===p&&null===e)return null},sum:r};z(a,q);return q});C(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S",
"%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},
hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});C(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var c=this,e=c.series;e.forEach(function(f){f.groupPixelWidth=void 0});e.forEach(function(f){f.groupPixelWidth=
c.getGroupPixelWidth&&c.getGroupPixelWidth();f.groupPixelWidth&&(f.hasProcessed=!0);f.applyGrouping(!!a.hasExtremesChanged)})}function r(){for(var e=this.series,c=e.length,u=0,f=!1,D,g;c--;)if(g=e[c].options.dataGrouping)if(u=Math.max(u,p(g.groupPixelWidth,a.common.groupPixelWidth)),D=(e[c].processedXData||e[c].data).length,e[c].groupPixelWidth||D>this.chart.plotSizeX/u||D&&g.forced)f=!0;return f?u:0}function v(){this.series.forEach(function(a){a.hasProcessed=!1})}function y(a,c){var e;c=p(c,!0);
a||(a={forced:!1,units:null});if(this instanceof g)for(e=this.series.length;e--;)this.series[e].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(f){f.dataGrouping="boolean"===typeof a?a:u(a,f.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()}var h=q.addEvent,z=q.extend,u=q.merge,p=q.pick,e=[],g;return{compose:function(a){g=a;-1===e.indexOf(a)&&(e.push(a),h(a,"afterSetScale",v),h(a,"postProcessData",E),z(a.prototype,{applyGrouping:E,getGroupPixelWidth:r,
setDataGrouping:y}))}}});C(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,B,r,v,y){function h(a){var c=this.chart,d=this.options.dataGrouping,k=!1!==this.allowDG&&d&&H(d.enabled,c.options.isStock),b=this.visible||!c.options.chart.ignoreHiddenSeries,l=this.currentDataGrouping,
m=!1;k&&!this.requireSorting&&(this.requireSorting=m=!0);a=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!a)||!k;m&&(this.requireSorting=!1);if(!a){this.destroyGroupedData();var A=d.groupAll?this.xData:this.processedXData,M=d.groupAll?this.yData:this.processedYData;k=c.plotSizeX;a=this.xAxis;var N=a.options.ordinal,K=this.groupPixelWidth;m=void 0;if(K&&A&&A.length&&k){this.isDirty=m=!0;this.points=null;var G=a.getExtremes();var e=G.min;G=G.max;N=N&&a.ordinal&&a.ordinal.getGroupIntervalFactor(e,
G,this)||1;k=a.getTimeTicks(B.Additions.prototype.normalizeTimeTickInterval(K*(G-e)/k*N,d.units||q.units),Math.min(e,A[0]),Math.max(G,A[A.length-1]),a.options.startOfWeek,A,this.closestPointRange);K=w.groupData.apply(this,[A,M,k,d.approximation]);A=K.groupedXData;M=K.groupedYData;N=0;d&&d.smoothed&&A.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",f(32,!1,c,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));c=A;var D=this.options.dataGrouping;e=this.currentDataGrouping&&
this.currentDataGrouping.gapSize;if(D&&this.xData&&e&&this.groupMap){var I=c.length-1;var u=D.anchor;var g=H(D.firstAnchor,u);D=H(D.lastAnchor,u);if(u&&"start"!==u){var t=e*{middle:.5,end:1}[u];for(u=c.length-1;u--&&0<u;)c[u]+=t}if(g&&"start"!==g&&this.xData[0]>=c[0]){u=this.groupMap[0].start;t=this.groupMap[0].length;var p=void 0;L(u)&&L(t)&&(p=u+(t-1));c[0]={middle:c[0]+.5*e,end:c[0]+e,firstPoint:this.xData[0],lastPoint:p&&this.xData[p]}[g]}D&&"start"!==D&&e&&c[I]>=G-e&&(G=this.groupMap[this.groupMap.length-
1].start,c[I]={middle:c[I]+.5*e,end:c[I]+e,firstPoint:G&&this.xData[G],lastPoint:this.xData[this.xData.length-1]}[D])}for(G=1;G<k.length;G++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(G)||(N=Math.max(k[G]-k[G-1],N));G=k.info;G.gapSize=N;this.closestPointRange=k.info.totalRange;this.groupMap=K.groupMap;if(b){b=A;if(J(b[0])&&L(a.min)&&L(a.dataMin)&&b[0]<a.min){if(!J(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(b[0],a.min);a.dataMin=Math.min(b[0],a.dataMin)}if(J(b[b.length-
1])&&L(a.max)&&L(a.dataMax)&&b[b.length-1]>a.max){if(!J(a.options.max)&&L(a.dataMax)&&a.max>=a.dataMax||a.max===a.dataMax)a.max=Math.max(b[b.length-1],a.max);a.dataMax=Math.max(b[b.length-1],a.dataMax)}}d.groupAll&&(this.allGroupedData=M,d=this.cropData(A,M,a.min,a.max,1),A=d.xData,M=d.yData,this.cropStart=d.start);this.processedXData=A;this.processedYData=M}else this.groupMap=null;this.hasGroupedData=m;this.currentDataGrouping=G;this.preventGraphAnimation=(l&&l.totalRange)!==(G&&G.totalRange)}}function z(){this.groupedData&&
(this.groupedData.forEach(function(a,f){a&&(this.groupedData[f]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)}function u(){x.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function p(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function e(f,c,d,k){var b=this,l=b.data,m=b.options&&b.options.data,A=[],M=[],N=[],K=f.length,G=!!c,n=[],e=b.pointArrayMap,I=e&&e.length,u=["x"].concat(e||
["y"]),D=this.options.dataGrouping&&this.options.dataGrouping.groupAll,g=0,t=0;k="function"===typeof k?k:k&&a[k]?a[k]:a[b.getDGApproximation&&b.getDGApproximation()||"average"];if(I)for(var p=e.length;p--;)n.push([]);else n.push([]);p=I||1;for(var w=0;w<=K;w++)if(!(f[w]<d[0])){for(;"undefined"!==typeof d[g+1]&&f[w]>=d[g+1]||w===K;){var x=d[g];b.dataGroupInfo={start:D?t:b.cropStart+t,length:n[0].length};var h=k.apply(b,n);b.pointClass&&!J(b.dataGroupInfo.options)&&(b.dataGroupInfo.options=E(b.pointClass.prototype.optionsToObject.call({series:b},
b.options.data[b.cropStart+t])),u.forEach(function(l){delete b.dataGroupInfo.options[l]}));"undefined"!==typeof h&&(A.push(x),M.push(h),N.push(b.dataGroupInfo));t=w;for(x=0;x<p;x++)n[x].length=0,n[x].hasNulls=!1;g+=1;if(w===K)break}if(w===K)break;if(e){x=b.options.dataGrouping&&b.options.dataGrouping.groupAll?w:b.cropStart+w;h=l&&l[x]||b.pointClass.prototype.applyOptions.apply({series:b},[m[x]]);var v=void 0;for(x=0;x<I;x++)v=h[e[x]],L(v)?n[x].push(v):null===v&&(n[x].hasNulls=!0)}else x=G?c[w]:null,
L(x)?n[0].push(x):null===x&&(n[0].hasNulls=!0)}return{groupedXData:A,groupedYData:M,groupMap:N}}function g(a){a=a.options;var f=this.type,d=this.chart.options.plotOptions,k=this.useCommonDataGrouping&&q.common,b=q.seriesSpecific,l=r.defaultOptions.plotOptions[f].dataGrouping;if(d&&(b[f]||k)){var m=this.chart.rangeSelector;l||(l=E(q.common,b[f]));a.dataGrouping=E(k,l,d.series&&d.series.dataGrouping,d[f].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&m&&L(m.selected)&&m.buttonOptions[m.selected].dataGrouping)}}
var w=v.series.prototype,c=y.addEvent,J=y.defined,f=y.error,D=y.extend,L=y.isNumber,E=y.merge,H=y.pick,x=w.generatePoints,F=[];return{compose:function(a){var n=a.prototype.pointClass;-1===F.indexOf(n)&&(F.push(n),c(n,"update",function(){if(this.dataGroup)return f(24,!1,this.series.chart),!1}));-1===F.indexOf(a)&&(F.push(a),c(a,"afterSetOptions",g),c(a,"destroy",z),D(a.prototype,{applyGrouping:h,destroyGroupedData:z,generatePoints:u,getDGApproximation:p,groupData:e}))},groupData:e}});C(a,"Extensions/DataGrouping/DataGrouping.js",
[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,q,B,r,v){function y(a){var e=this.chart,c=e.time,g=a.labelConfig,f=g.series,D=f.tooltipOptions,L=f.options.dataGrouping,v=f.xAxis,r=D.xDateFormat,x=D[a.isFooter?"footerFormat":"headerFormat"];if(v&&"datetime"===v.options.type&&L&&p(g.key)){var z=f.currentDataGrouping;
L=L.dateTimeLabelFormats||q.common.dateTimeLabelFormats;if(z)if(D=L[z.unitName],1===z.count)r=D[0];else{r=D[1];var t=D[2]}else!r&&L&&v.dateTime&&(r=v.dateTime.getXDateFormat(g.x,D.dateTimeLabelFormats));r=c.dateFormat(r,g.key);t&&(r+=c.dateFormat(t,g.key+z.totalRange-1));f.chart.styledMode&&(x=this.styledModeFormat(x));a.text=h(x,{point:u(g.point,{key:r}),series:f},e);a.preventDefault()}}var h=r.format,z=v.addEvent,u=v.extend,p=v.isNumber,e=[];r={compose:function(u,p,c){a.compose(u);B.compose(p);
-1===e.indexOf(c)&&(e.push(c),z(c,"headerFormatter",y))},groupData:B.groupData};"";"";return r});C(a,"masters/modules/datagrouping.src.js",[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(a,q,B,r){a.dataGrouping={approximationDefaults:q,approximations:B};r.compose(a.Axis,a.Series,a.Tooltip)});C(a,"Series/DataModifyComposition.js",[a["Core/Axis/Axis.js"],a["Core/Series/Point.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,B,r){var v=q.prototype.tooltipFormatter,y=r.addEvent,h=r.arrayMax,z=r.arrayMin,u=r.correctFloat,p=r.defined,e=r.isArray,g=r.isNumber,w=r.isString,c=r.pick,J;(function(a){function f(b,m,d){this.isXAxis||(this.series.forEach(function(l){"compare"===b&&"boolean"!==typeof m?l.setCompare(m,!1):"cumulative"!==b||w(m)||l.setCumulative(m,!1)}),c(d,!0)&&this.chart.redraw())}function L(b){var l=this,d=l.series.chart.numberFormatter,k=function(m){b=
b.replace("{point."+m+"}",(0<l[m]&&"change"===m?"+":"")+d(l[m],c(l.series.tooltipOptions.changeDecimals,2)))};p(l.change)&&k("change");p(l.cumulativeSum)&&k("cumulativeSum");return v.apply(this,[b])}function J(){var l=this.options.compare;if("percent"===l||"value"===l||this.options.cumulative){var m=new b(this);"percent"===l||"value"===l?m.initCompare(l):m.initCumulative()}this.dataModify=m}function r(l){l=l.dataExtremes;var m=l.activeYData;if(this.dataModify&&l){var d=void 0;this.options.compare?
d=[this.dataModify.modifyValue(l.dataMin),this.dataModify.modifyValue(l.dataMax)]:this.options.cumulative&&e(m)&&2<=m.length&&(d=b.getCumulativeExtremes(m));d&&(l.dataMin=z(d),l.dataMax=h(d))}}function x(b,m){this.options.compare=this.userOptions.compare=b;this.update({},c(m,!0));!this.dataModify||"value"!==b&&"percent"!==b?this.points.forEach(function(b){delete b.change}):this.dataModify.initCompare(b)}function q(){if(this.xAxis&&this.processedYData&&this.dataModify){var b=this.processedXData,m=
this.processedYData,d=m.length,k=!0===this.options.compareStart?0:1,a=-1,f;this.pointArrayMap&&(a=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(f=0;f<d-k;f++){var c=m[f]&&-1<a?m[f][a]:m[f];if(g(c)&&0!==c&&b[f+k]>=(this.xAxis.min||0)){this.dataModify.compareValue=c;break}}}}function t(b,m){this.setModifier("compare",b,m)}function n(b,m){b=c(b,!1);this.options.cumulative=this.userOptions.cumulative=b;this.update({},c(m,!0));this.dataModify?this.dataModify.initCumulative():
this.points.forEach(function(b){delete b.cumulativeSum})}function d(b,m){this.setModifier("cumulative",b,m)}var k=[];a.compose=function(b,m,A){if(-1===k.indexOf(b)){k.push(b);var l=b.prototype;l.setCompare=x;l.setCumulative=n;y(b,"afterInit",J);y(b,"afterGetExtremes",r);y(b,"afterProcessData",q)}-1===k.indexOf(m)&&(k.push(m),m=m.prototype,m.setCompare=t,m.setModifier=f,m.setCumulative=d);-1===k.indexOf(A)&&(k.push(A),A.prototype.tooltipFormatter=L);return b};var b=function(){function b(b){this.series=
b}b.prototype.modifyValue=function(){return 0};b.getCumulativeExtremes=function(b){var l=Infinity,m=-Infinity;b.reduce(function(b,d){d=b+d;l=Math.min(l,d,b);m=Math.max(m,d,b);return d});return[l,m]};b.prototype.initCompare=function(b){this.modifyValue=function(l,m){null===l&&(l=0);var d=this.compareValue;return"undefined"!==typeof l&&"undefined"!==typeof d?(l="value"===b?l-d:l/d*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof m&&(m=this.series.points[m])&&(m.change=l),l):0}};
b.prototype.initCumulative=function(){this.modifyValue=function(b,l){null===b&&(b=0);if(void 0!==b&&void 0!==l){var m=0<l?this.series.points[l-1]:null;m&&m.cumulativeSum&&(b=u(m.cumulativeSum+b));if(l=this.series.points[l])l.cumulativeSum=b;return b}return 0}};return b}();a.Additions=b})(J||(J={}));"";return J});C(a,"Core/Axis/NavigatorAxisComposition.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,q){function E(){this.navigatorAxis||(this.navigatorAxis=new g(this))}function r(a){var c=
this.chart.options,e=c.navigator,f=this.navigatorAxis,u=c.chart.zooming.pinchType,g=c.rangeSelector;c=c.chart.zooming.type;this.isXAxis&&(e&&e.enabled||g&&g.enabled)&&("y"===c?a.zoomed=!1:(!v&&"xy"===c||v&&"xy"===u)&&this.options.range&&(e=f.previousZoom,z(a.newMin)?f.previousZoom=[this.min,this.max]:e&&(a.newMin=e[0],a.newMax=e[1],f.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()}var v=a.isTouchDevice,y=q.addEvent,h=q.correctFloat,z=q.defined,u=q.isNumber,p=q.pick,e=[],g=
function(){function a(a){this.axis=a}a.compose=function(a){-1===e.indexOf(a)&&(e.push(a),a.keepProps.push("navigatorAxis"),y(a,"init",E),y(a,"zoom",r))};a.prototype.destroy=function(){this.axis=void 0};a.prototype.toFixedRange=function(a,e,f,D){var c=this.axis,g=c.chart;a=p(f,c.translate(a,!0,!c.horiz));e=p(D,c.translate(e,!0,!c.horiz));g=g&&g.fixedRange;c=(c.pointRange||0)/2;var w=g&&(e-a)/g;z(f)||(a=h(a+c));z(D)||(e=h(e-c));.7<w&&1.3>w&&(D?a=e-g:e=a+g);u(a)&&u(e)||(a=e=void 0);return{min:a,max:e}};
return a}();return g});C(a,"Stock/Navigator/NavigatorDefaults.js",[a["Core/Color/Color.js"],a["Core/Series/SeriesRegistry.js"]],function(a,q){a=a.parse;q=q.seriesTypes;q={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:a("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:"undefined"===typeof q.areaspline?"line":"areaspline",fillOpacity:.05,
lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},
threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};"";return q});C(a,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(a,
q,B,r,v){void 0===v&&(v={});a=v.width?v.width/2:B;q=Math.round(a/3)+.5;r=v.height||r;return[["M",-a-1,.5],["L",a,.5],["L",a,r+.5],["L",-a-1,r+.5],["L",-a-1,.5],["M",-q,4],["L",-q,r-3],["M",q-1,4],["L",q-1,r-3]]}}});C(a,"Stock/Navigator/NavigatorComposition.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/Navigator/NavigatorSymbols.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Utilities.js"]],function(a,
q,B,r,v,y,h){function z(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function u(){var d=this.legend,b=this.navigator;if(b){var l=d&&d.options;var m=b.xAxis;var a=b.yAxis;var f=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-f-b.height:this.spacing[3]+f,b.top=this.plotTop+f):(b.left=t(m.left,this.plotLeft+f),b.top=b.navigatorOptions.top||this.chartHeight-b.height-f-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(l&&"bottom"===
l.verticalAlign&&"proximate"!==l.layout&&l.enabled&&!l.floating?d.legendHeight+t(l.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));m&&a&&(this.inverted?m.options.left=a.options.left=b.left:m.options.top=a.options.top=b.top,m.setAxisSize(),a.setAxisSize())}}function p(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new d(this),t(a.redraw,!0)&&this.redraw(a.animation))}function e(){var a=this.options;if(a.navigator.enabled||
a.scrollbar.enabled)this.scroller=this.navigator=new d(this)}function g(){var d=this.options,b=d.navigator,l=d.rangeSelector;if((b&&b.enabled||l&&l.enabled)&&(!L&&"x"===d.chart.zooming.type||L&&"x"===d.chart.zooming.pinchType))return!1}function w(d){var b=d.navigator;b&&d.xAxis[0]&&(d=d.xAxis[0].getExtremes(),b.render(d.min,d.max))}function c(d){var b=d.options.navigator||{},l=d.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!l.enabled||(F(!0,this.options.navigator,b),F(!0,this.options.scrollbar,
l),delete d.options.navigator,delete d.options.scrollbar)}function J(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}var f=a.defaultOptions,D=a.setOptions,L=q.isTouchDevice,E=y.getRendererType,H=h.addEvent,x=h.extend,F=h.merge,t=h.pick,n=[],d;return{compose:function(a,b,l,m){B.compose(a);d=l;-1===n.indexOf(b)&&(n.push(b),b.prototype.callbacks.push(w),H(b,"afterAddSeries",z),H(b,"afterSetChartSize",u),H(b,"afterUpdate",p),H(b,"beforeRender",e),H(b,"beforeShowResetZoom",
g),H(b,"update",c));-1===n.indexOf(m)&&(n.push(m),H(m,"afterUpdate",J));-1===n.indexOf(E)&&(n.push(E),x(E().prototype.symbols,v));-1===n.indexOf(D)&&(n.push(D),x(f,{navigator:r}))}}});C(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var q=a.addEvent,B=a.defined,r=a.pick;return function(){function a(){}a.compose=function(v,h){if(-1===a.composed.indexOf(v))a.composed.push(v);else return v;var z=function(a){var u=r(a.options&&a.options.min,a.min),e=r(a.options&&a.options.max,a.max);
return{axisMin:u,axisMax:e,scrollMin:B(a.dataMin)?Math.min(u,a.min,a.dataMin,r(a.threshold,Infinity)):u,scrollMax:B(a.dataMax)?Math.max(e,a.max,a.dataMax,r(a.threshold,-Infinity)):e}};q(v,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new h(a.chart.renderer,a.options.scrollbar,a.chart),q(a.scrollbar,"changed",function(u){var e=z(a),g=e.axisMax,p=e.scrollMin,
c=e.scrollMax-p;B(e.axisMin)&&B(g)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(e=p+c*this.to,p+=c*this.from):(e=p+c*(1-this.from),p+=c*(1-this.to)),this.shouldUpdateExtremes(u.DOMType)?a.setExtremes(p,e,!0,"mousemove"!==u.DOMType&&"touchmove"!==u.DOMType,u):this.setRange(this.from,this.to))}))});q(v,"afterRender",function(){var a=z(this),p=a.scrollMin,e=a.scrollMax;a=this.scrollbar;var g=this.axisTitleMargin+(this.titleOffset||0),w=this.chart.scrollbarsOffsets,c=this.options.margin||0;a&&(this.horiz?
(this.opposite||(w[1]+=g),a.position(this.left,this.top+this.height+2+w[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(w[1]+=c),g=1):(this.opposite&&(w[0]+=g),a.position(a.options.opposite?this.left+this.width+2+w[0]-(this.opposite?0:c):this.opposite?0:c,this.top,this.width,this.height),this.opposite&&(w[0]+=c),g=0),w[g]+=a.size+a.options.margin,isNaN(p)||isNaN(e)||!B(this.min)||!B(this.max)||this.min===this.max?a.setRange(0,1):(w=(this.min-p)/(e-p),p=(this.max-p)/(e-p),this.horiz&&
!this.reversed||!this.horiz&&this.reversed?a.setRange(w,p):a.setRange(1-p,1-w)))});q(v,"afterGetOffset",function(){var a=this.scrollbar&&!this.scrollbar.options.opposite;a=this.horiz?2:a?3:1;var p=this.scrollbar;p&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=p.size+p.options.margin)});return v};a.composed=[];return a}()});C(a,"Stock/Scrollbar/ScrollbarDefaults.js",[a["Core/Globals.js"]],function(a){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,
margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1}});C(a,"Stock/Scrollbar/Scrollbar.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Utilities.js"]],
function(a,q,B,r,v){var y=a.defaultOptions,h=v.addEvent,z=v.correctFloat,u=v.defined,p=v.destroyObjectProperties,e=v.fireEvent,g=v.merge,w=v.pick,c=v.removeEvent;a=function(){function a(a,c,e){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=
void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,c,e)}a.compose=function(f){B.compose(f,a)};a.swapXY=function(a,c){c&&a.forEach(function(a){for(var f=a.length,c,e=0;e<f;e+=2)c=a[e+1],"number"===typeof c&&(a[e+1]=a[e+2],a[e+2]=c)});return a};a.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],c=this.scrollbarButtons,e=this.scrollbarGroup.element,g=this.track.element,p=this.mouseDownHandler.bind(this),x=this.mouseMoveHandler.bind(this),u=this.mouseUpHandler.bind(this);
a=[[c[a[0]].element,"click",this.buttonToMinClick.bind(this)],[c[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[g,"click",this.trackClick.bind(this)],[e,"mousedown",p],[e.ownerDocument,"mousemove",x],[e.ownerDocument,"mouseup",u]];q.hasTouch&&a.push([e,"touchstart",p],[e.ownerDocument,"touchmove",x],[e.ownerDocument,"touchend",u]);a.forEach(function(a){h.apply(null,a)});this._events=a};a.prototype.buttonToMaxClick=function(a){var f=(this.to-this.from)*w(this.options.step,.2);this.updatePosition(this.from+
f,this.to+f);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.buttonToMinClick=function(a){var f=z(this.to-this.from)*w(this.options.step,.2);this.updatePosition(z(this.from-f),z(this.to-f));e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.cursorToScrollbarPosition=function(a){var f=this.options;f=f.minWidth>this.calculatedWidth?f.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-f),chartY:(a.chartY-
this.y-this.yOffset)/(this.barWidth-f)}};a.prototype.destroy=function(){var a=this,c=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(f){a[f]&&a[f].destroy&&(a[f]=a[f].destroy())});c&&a===c.scrollbar&&(c.scrollbar=null,p(c.scrollbarButtons))};a.prototype.drawScrollbarButton=function(f){var c=this.renderer,e=this.scrollbarButtons,g=this.options,p=this.size,x=c.g().add(this.group);e.push(x);x=c.rect().addClass("highcharts-scrollbar-button").add(x);
this.chart.styledMode||x.attr({stroke:g.buttonBorderColor,"stroke-width":g.buttonBorderWidth,fill:g.buttonBackgroundColor});x.attr(x.crisp({x:-.5,y:-.5,width:p+1,height:p+1,r:g.buttonBorderRadius},x.strokeWidth()));x=c.path(a.swapXY([["M",p/2+(f?-1:1),p/2-3],["L",p/2+(f?-1:1),p/2+3],["L",p/2+(f?2:-2),p/2]],g.vertical)).addClass("highcharts-scrollbar-arrow").add(e[f]);this.chart.styledMode||x.attr({fill:g.buttonArrowColor})};a.prototype.init=function(a,c,e){this.scrollbarButtons=[];this.renderer=a;
this.userOptions=c;this.options=g(r,y.scrollbar,c);this.chart=e;this.size=w(this.options.size,this.options.height);c.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};a.prototype.mouseMoveHandler=function(a){var c=this.chart.pointer.normalize(a),f=this.options.vertical?"chartY":"chartX",g=this.initPositions||
[];!this.grabbedCenter||a.touches&&0===a.touches[0][f]||(c=this.cursorToScrollbarPosition(c)[f],f=this[f],f=c-f,this.hasDragged=!0,this.updatePosition(g[0]+f,g[1]+f),this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=
function(a,c,e,g){var f=this.options.vertical,p=this.rendered?"animate":"attr",u=g,t=0;this.group.show();this.x=a;this.y=c+this.trackBorderWidth;this.width=e;this.height=g;this.xOffset=u;this.yOffset=t;f?(this.width=this.yOffset=e=t=this.size,this.xOffset=u=0,this.barWidth=g-2*e,this.x=a+=this.options.margin):(this.height=this.xOffset=g=u=this.size,this.barWidth=e-2*g,this.y+=this.options.margin);this.group[p]({translateX:a,translateY:this.y});this.track[p]({width:e,height:g});this.scrollbarButtons[1][p]({translateX:f?
0:e-u,translateY:f?g-t:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){c.apply(null,a)});this._events.length=0};a.prototype.render=function(){var c=this.renderer,e=this.options,g=this.size,p=this.chart.styledMode,u=c.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=u;this.track=c.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:e.trackBorderRadius||0,height:g,width:g}).add(u);p||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,
"stroke-width":e.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=c.g().add(u);this.scrollbar=c.rect().addClass("highcharts-scrollbar-thumb").attr({height:g,width:g,r:e.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=c.path(a.swapXY([["M",-3,g/4],["L",-3,2*g/3],["M",0,g/4],["L",0,2*g/3],["M",3,g/4],["L",3,2*g/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);p||(this.scrollbar.attr({fill:e.barBackgroundColor,
stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=function(a,c){var e=this.options,f=e.vertical,g=e.minWidth,p=this.barWidth,w=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?
"attr":"animate";if(u(p)){var t=p*Math.min(c,1);a=Math.max(a,0);var n=Math.ceil(p*a);this.calculatedWidth=t=z(t-n);t<g&&(n=(p-g+t)*a,t=g);g=Math.floor(n+this.xOffset+this.yOffset);p=t/2-.5;this.from=a;this.to=c;f?(this.scrollbarGroup[w]({translateY:g}),this.scrollbar[w]({height:t}),this.scrollbarRifles[w]({translateY:p}),this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[w]({translateX:g}),this.scrollbar[w]({width:t}),this.scrollbarRifles[w]({translateX:p}),this.scrollbarLeft=g,this.scrollbarTop=
0);12>=t?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===e.showFull&&(0>=a&&1<=c?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return w(this.options.liveRedraw,q.svg&&!q.isTouchDevice&&!this.chart.boosted)||"mouseup"===a||"touchend"===a||!u(a)};a.prototype.trackClick=function(a){var c=this.chart.pointer.normalize(a),f=this.to-this.from,g=this.y+this.scrollbarTop,p=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>g||!this.options.vertical&&
c.chartX>p?this.updatePosition(this.from+f,this.to+f):this.updatePosition(this.from-f,this.to-f);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,g(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,c){1<c&&(a=z(1-z(c-a)),c=1);0>a&&(c=z(c-a),a=0);this.from=a;this.to=c};a.defaultOptions=r;return a}();y.scrollbar=g(!0,a.defaultOptions,y.scrollbar);return a});C(a,"Stock/Navigator/Navigator.js",
[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorComposition.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Utilities.js"]],function(a,q,B,r,v,y,h){function z(a){for(var b=[],l=1;l<arguments.length;l++)b[l-1]=arguments[l];b=[].filter.call(b,x);if(b.length)return Math[a].apply(0,b)}var u=q.defaultOptions,p=B.hasTouch,e=B.isTouchDevice,g=h.addEvent,w=h.clamp,c=h.correctFloat,J=h.defined,f=h.destroyObjectProperties,
D=h.erase,E=h.extend,C=h.find,H=h.isArray,x=h.isNumber,F=h.merge,t=h.pick,n=h.removeEvent,d=h.splat;return function(){function k(b){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(b)}k.compose=function(b,a,m){v.compose(b,
a,k,m)};k.prototype.drawHandle=function(b,a,m,d){var l=this.navigatorOptions.handles.height;this.handles[a][d](m?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(b,10)+.5-l)}:{translateX:Math.round(this.left+parseInt(b,10)),translateY:Math.round(this.top+this.height/2-l/2-1)})};k.prototype.drawOutline=function(b,a,m,d){var l=this.navigatorOptions.maskInside,k=this.outline.strokeWidth(),A=k/2,c=k%2/2;k=this.outlineHeight;var e=this.scrollbarHeight||0,f=this.size,
g=this.left-e,n=this.top;m?(g-=A,m=n+a+c,a=n+b+c,c=[["M",g+k,n-e-c],["L",g+k,m],["L",g,m],["L",g,a],["L",g+k,a],["L",g+k,n+f+e]],l&&c.push(["M",g+k,m-A],["L",g+k,a+A])):(b+=g+e-c,a+=g+e-c,n+=A,c=[["M",g,n],["L",b,n],["L",b,n+k],["L",a,n+k],["L",a,n],["L",g+f+2*e,n]],l&&c.push(["M",b-A,n],["L",a+A,n]));this.outline[d]({d:c})};k.prototype.drawMasks=function(b,a,m,d){var l=this.left,k=this.top,A=this.height;if(m){var c=[l,l,l];var e=[k,k+b,k+a];var f=[A,A,A];var g=[b,a-b,this.size-a]}else c=[l,l+b,l+
a],e=[k,k,k],f=[b,a-b,this.size-a],g=[A,A,A];this.shades.forEach(function(b,a){b[d]({x:c[a],y:e[a],width:f[a],height:g[a]})})};k.prototype.renderElements=function(){var b=this,a=b.navigatorOptions,d=a.maskInside,k=b.chart,c=k.renderer,e={cursor:k.inverted?"ns-resize":"ew-resize"},f=b.navigatorGroup=c.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!d,d,!d].forEach(function(l,d){var m=c.rect().addClass("highcharts-navigator-mask"+(1===d?"-inside":"-outside")).add(f);k.styledMode||(m.attr({fill:l?
a.maskFill:"rgba(0,0,0,0)"}),1===d&&m.css(e));b.shades[d]=m});b.outline=c.path().addClass("highcharts-navigator-outline").add(f);k.styledMode||b.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor});if(a.handles&&a.handles.enabled){var g=a.handles,n=g.height,p=g.width;[0,1].forEach(function(a){b.handles[a]=c.symbol(g.symbols[a],-p/2-1,0,p,n,g);k.inverted&&b.handles[a].attr({rotation:90,rotationOriginX:Math.floor(-p/2),rotationOriginY:(n+p)/2});b.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+
["left","right"][a]).add(f);k.styledMode||b.handles[a].attr({fill:g.backgroundColor,stroke:g.borderColor,"stroke-width":g.lineWidth}).css(e)})}};k.prototype.update=function(b){(this.series||[]).forEach(function(b){b.baseSeries&&delete b.baseSeries.navigatorSeries});this.destroy();F(!0,this.chart.options.navigator,b);this.init(this.chart)};k.prototype.render=function(b,a,d,k){var l=this.chart,m=this.xAxis,A=m.pointRange||0,e=m.navigatorAxis.fake?l.xAxis[0]:m,f=this.navigatorEnabled,g=this.rendered,
n=l.inverted,p=l.xAxis[0].minRange,u=l.xAxis[0].options.maxRange,h=this.scrollbarHeight,v;if(!this.hasDragged||J(d)){b=c(b-A/2);a=c(a+A/2);if(!x(b)||!x(a))if(g)d=0,k=t(m.width,e.width);else return;this.left=t(m.left,l.plotLeft+h+(n?l.plotWidth:0));var r=this.size=v=t(m.len,(n?l.plotHeight:l.plotWidth)-2*h);l=n?h:v+2*h;d=t(d,m.toPixels(b,!0));k=t(k,m.toPixels(a,!0));x(d)&&Infinity!==Math.abs(d)||(d=0,k=l);b=m.toValue(d,!0);a=m.toValue(k,!0);var q=Math.abs(c(a-b));q<p?this.grabbedLeft?d=m.toPixels(a-
p-A,!0):this.grabbedRight&&(k=m.toPixels(b+p+A,!0)):J(u)&&c(q-A)>u&&(this.grabbedLeft?d=m.toPixels(a-u-A,!0):this.grabbedRight&&(k=m.toPixels(b+u+A,!0)));this.zoomedMax=w(Math.max(d,k),0,r);this.zoomedMin=w(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(d,k),0,r);this.range=this.zoomedMax-this.zoomedMin;r=Math.round(this.zoomedMax);d=Math.round(this.zoomedMin);f&&(this.navigatorGroup.attr({visibility:"inherit"}),g=g&&!this.hasDragged?"animate":"attr",this.drawMasks(d,r,n,g),this.drawOutline(d,
r,n,g),this.navigatorOptions.handles.enabled&&(this.drawHandle(d,0,n,g),this.drawHandle(r,1,n,g)));this.scrollbar&&(n?(n=this.top-h,e=this.left-h+(f||!e.opposite?0:(e.titleOffset||0)+e.axisTitleMargin),h=v+2*h):(n=this.top+(f?this.height:-h),e=this.left-h),this.scrollbar.position(e,n,l,h),this.scrollbar.setRange(this.zoomedMin/(v||1),this.zoomedMax/(v||1)));this.rendered=!0}};k.prototype.addMouseEvents=function(){var b=this,a=b.chart,d=a.container,k=[],c,e;b.mouseMoveHandler=c=function(a){b.onMouseMove(a)};
b.mouseUpHandler=e=function(a){b.onMouseUp(a)};k=b.getPartsEvents("mousedown");k.push(g(a.renderTo,"mousemove",c),g(d.ownerDocument,"mouseup",e));p&&(k.push(g(a.renderTo,"touchmove",c),g(d.ownerDocument,"touchend",e)),k.concat(b.getPartsEvents("touchstart")));b.eventsToUnbind=k;b.series&&b.series[0]&&k.push(g(b.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))};k.prototype.getPartsEvents=function(b){var a=this,d=[];["shades","handles"].forEach(function(l){a[l].forEach(function(m,
k){d.push(g(m.element,b,function(b){a[l+"Mousedown"](b,k)}))})});return d};k.prototype.shadesMousedown=function(b,a){b=this.chart.pointer.normalize(b);var l=this.chart,d=this.xAxis,k=this.zoomedMin,c=this.size,e=this.range,f=this.left,g=b.chartX;l.inverted&&(g=b.chartY,f=this.top);if(1===a)this.grabbedCenter=g,this.fixedWidth=e,this.dragOffset=g-k;else{b=g-f-e/2;if(0===a)b=Math.max(0,b);else if(2===a&&b+e>=c)if(b=c-e,this.reversedExtremes){b-=e;var n=this.getUnionExtremes().dataMin}else var p=this.getUnionExtremes().dataMax;
b!==k&&(this.fixedWidth=e,a=d.navigatorAxis.toFixedRange(b,b+e,n,p),J(a.min)&&l.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}};k.prototype.handlesMousedown=function(b,a){this.chart.pointer.normalize(b);b=this.chart;var l=b.xAxis[0],d=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?l.min:l.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?l.max:l.min);b.fixedRange=
null};k.prototype.onMouseMove=function(b){var a=this,d=a.chart,k=a.navigatorSize,c=a.range,f=a.dragOffset,g=d.inverted,n=a.left;b.touches&&0===b.touches[0].pageX||(b=d.pointer.normalize(b),d=b.chartX,g&&(n=a.top,d=b.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,d-n,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,d-n)):a.grabbedCenter&&(a.hasDragged=!0,d<f?d=f:d>k+f-c&&(d=k+f-c),a.render(0,0,d-f,d-f+c)),a.hasDragged&&a.scrollbar&&t(a.scrollbar.options.liveRedraw,
B.svg&&!e&&!this.chart.boosted)&&(b.DOMType=b.type,setTimeout(function(){a.onMouseUp(b)},0)))};k.prototype.onMouseUp=function(b){var a=this.chart,d=this.xAxis,k=this.scrollbar,c=b.DOMEvent||b,e=a.inverted,f=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!k||!k.hasDragged)||"scrollbar"===b.trigger){k=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var g=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var n=this.fixedExtreme;this.zoomedMax===this.size&&
(n=this.reversedExtremes?k.dataMin:k.dataMax);0===this.zoomedMin&&(g=this.reversedExtremes?k.dataMax:k.dataMin);d=d.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,g,n);J(d.min)&&a.xAxis[0].setExtremes(Math.min(d.min,d.max),Math.max(d.min,d.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:c})}"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=
this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&x(this.zoomedMin)&&x(this.zoomedMax)&&(a=Math.round(this.zoomedMin),b=Math.round(this.zoomedMax),this.shades&&this.drawMasks(a,b,e,f),this.outline&&this.drawOutline(a,b,e,f),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(a,0,e,f),this.drawHandle(b,1,e,f)))};k.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(b){b()}),this.eventsToUnbind=
void 0);this.removeBaseSeriesEvents()};k.prototype.removeBaseSeriesEvents=function(){var b=this.baseSeries||[];this.navigatorEnabled&&b[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&b.forEach(function(b){n(b,"updatedData",this.updatedDataHandler)},this),b[0].xAxis&&n(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};k.prototype.init=function(b){var d=b.options,m=d.navigator||{},k=m.enabled,c=d.scrollbar||{},e=c.enabled;d=k&&m.height||0;var f=e&&c.height||0;this.handles=[];this.shades=
[];this.chart=b;this.setBaseSeries();this.height=d;this.scrollbarHeight=f;this.scrollbarEnabled=e;this.navigatorEnabled=k;this.navigatorOptions=m;this.scrollbarOptions=c;this.outlineHeight=d+f;this.opposite=t(m.opposite,!(k||!b.inverted));var n=this;k=n.baseSeries;c=b.xAxis.length;e=b.yAxis.length;var p=k&&k[0]&&k[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;n.navigatorEnabled?(n.xAxis=new a(b,F({breaks:p.options.breaks,ordinal:p.options.ordinal},m.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",
isX:!0,type:"datetime",index:c,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[f,0,-f,0],width:d}:{offsets:[0,-f,0,f],height:d})),n.yAxis=new a(b,F(m.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,reversed:t(m.yAxis&&m.yAxis.reversed,b.yAxis[0]&&b.yAxis[0].reversed,!1),zoomEnabled:!1},b.inverted?{width:d}:{height:d})),k||m.series.data?n.updateNavigatorSeries(!1):0===b.series.length&&
(n.unbindRedraw=g(b,"beforeRedraw",function(){0<b.series.length&&!n.series&&(n.setBaseSeries(),n.unbindRedraw())})),n.reversedExtremes=b.inverted&&!n.xAxis.reversed||!b.inverted&&n.xAxis.reversed,n.renderElements(),n.addMouseEvents()):(n.xAxis={chart:b,navigatorAxis:{fake:!0},translate:function(a,d){var l=b.xAxis[0],m=l.getExtremes(),k=l.len-2*f,c=z("min",l.options.min,m.dataMin);l=z("max",l.options.max,m.dataMax)-c;return d?a*l/k+c:k*(a-c)/l},toPixels:function(b){return this.translate(b)},toValue:function(b){return this.translate(b,
!0)}},n.xAxis.navigatorAxis.axis=n.xAxis,n.xAxis.navigatorAxis.toFixedRange=r.prototype.toFixedRange.bind(n.xAxis.navigatorAxis));b.options.scrollbar.enabled&&(b.scrollbar=n.scrollbar=new y(b.renderer,F(b.options.scrollbar,{margin:n.navigatorEnabled?0:10,vertical:b.inverted}),b),g(n.scrollbar,"changed",function(b){var a=n.size,d=a*this.to;a*=this.from;n.hasDragged=n.scrollbar.hasDragged;n.render(0,0,a,d);this.shouldUpdateExtremes(b.DOMType)&&setTimeout(function(){n.onMouseUp(b)})}));n.addBaseSeriesEvents();
n.addChartEvents()};k.prototype.getUnionExtremes=function(b){var a=this.chart.xAxis[0],d=this.xAxis,k=d.options,c=a.options,e;b&&null===a.dataMin||(e={dataMin:t(k&&k.min,z("min",c.min,a.dataMin,d.dataMin,d.min)),dataMax:t(k&&k.max,z("max",c.max,a.dataMax,d.dataMax,d.max))});return e};k.prototype.setBaseSeries=function(b,a){var d=this.chart,l=this.baseSeries=[];b=b||d.options&&d.options.navigator.baseSeries||(d.series.length?C(d.series,function(b){return!b.options.isInternal}).index:0);(d.series||
[]).forEach(function(a,d){a.options.isInternal||!a.options.showInNavigator&&(d!==b&&a.options.id!==b||!1===a.options.showInNavigator)||l.push(a)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)};k.prototype.updateNavigatorSeries=function(b,a){var l=this,k=l.chart,c=l.baseSeries,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},
f=l.series=(l.series||[]).filter(function(b){var a=b.baseSeries;return 0>c.indexOf(a)?(a&&(n(a,"updatedData",l.updatedDataHandler),delete a.navigatorSeries),b.chart&&b.destroy(),!1):!0}),g,p,h=l.navigatorOptions.series,I;c&&c.length&&c.forEach(function(b){var m=b.navigatorSeries,n=E({color:b.color,visible:b.visible},H(h)?u.navigator.series:h);m&&!1===l.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+c.length,g=b.options||{},I=g.navigatorOptions||{},n.dataLabels=d(n.dataLabels),p=F(g,e,n,
I),p.pointRange=t(n.pointRange,I.pointRange,u.plotOptions[p.type||"line"].pointRange),n=I.data||n.data,l.hasNavigatorData=l.hasNavigatorData||!!n,p.data=n||g.data&&g.data.slice(0),m&&m.options?m.update(p,a):(b.navigatorSeries=k.initSeries(p),b.navigatorSeries.baseSeries=b,f.push(b.navigatorSeries)))});if(h.data&&(!c||!c.length)||H(h))l.hasNavigatorData=!1,h=d(h),h.forEach(function(b,a){e.name="Navigator "+(f.length+1);p=F(u.navigator.series,{color:k.series[a]&&!k.series[a].options.isInternal&&k.series[a].color||
k.options.colors[a]||k.options.colors[0]},e,b);p.data=b.data;p.data&&(l.hasNavigatorData=!0,f.push(k.initSeries(p)))});b&&this.addBaseSeriesEvents()};k.prototype.addBaseSeriesEvents=function(){var b=this,a=this,d=a.baseSeries||[];d[0]&&d[0].xAxis&&d[0].eventsToUnbind.push(g(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));d.forEach(function(d){d.eventsToUnbind.push(g(d,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));d.eventsToUnbind.push(g(d,"hide",function(){this.navigatorSeries&&
this.navigatorSeries.setVisible(!1,!1)}));!1!==b.navigatorOptions.adaptToUpdatedData&&d.xAxis&&d.eventsToUnbind.push(g(d,"updatedData",b.updatedDataHandler));d.eventsToUnbind.push(g(d,"remove",function(){this.navigatorSeries&&(D(a.series,this.navigatorSeries),J(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})};k.prototype.getBaseSeriesMin=function(b){return this.baseSeries.reduce(function(b,a){return Math.min(b,a.xData&&a.xData.length?a.xData[0]:b)},
b)};k.prototype.modifyNavigatorAxisExtremes=function(){var b=this.xAxis;if("undefined"!==typeof b.getExtremes){var a=this.getUnionExtremes(!0);!a||a.dataMin===b.min&&a.dataMax===b.max||(b.min=a.dataMin,b.max=a.dataMax)}};k.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,d=this.getExtremes(),k=d.dataMin,c=d.dataMax;d=d.max-d.min;var e=a.stickToMin,f=a.stickToMax,n=t(this.options.overscroll,0),g=a.series&&a.series[0],p=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==
this.eventArgs.trigger){if(e){var u=k;var h=u+d}f&&(h=c+n,e||(u=Math.max(k,h-d,a.getBaseSeriesMin(g&&g.xData?g.xData[0]:-Number.MAX_VALUE))));p&&(e||f)&&x(u)&&(this.min=this.userMin=u,this.max=this.userMax=h)}a.stickToMin=a.stickToMax=null};k.prototype.updatedDataHandler=function(){var a=this.chart.navigator,d=this.navigatorSeries;a.stickToMax=t(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size));
a.stickToMin=a.shouldStickToMin(this,a);d&&!a.hasNavigatorData&&(d.options.pointStart=this.xData[0],d.setData(this.options.data,!1,null,!1))};k.prototype.shouldStickToMin=function(a,d){d=d.getBaseSeriesMin(a.xData[0]);var b=a.xAxis;a=b.max;var l=b.min;b=b.options.range;return x(a)&&x(l)?b&&0<a-d?a-d<b:l<=d:!1};k.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(g(this.chart,"redraw",function(){var a=this.navigator,d=a&&(a.baseSeries&&a.baseSeries[0]&&
a.baseSeries[0].xAxis||this.xAxis[0]);d&&a.render(d.min,d.max)}),g(this.chart,"getMargins",function(){var a=this.navigator,d=a.opposite?"plotTop":"marginBottom";this.inverted&&(d=a.opposite?"marginRight":"plotLeft");this[d]=(this[d]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};k.prototype.destroy=function(){var a=this;this.removeEvents();this.xAxis&&(D(this.chart.xAxis,this.xAxis),D(this.chart.axes,this.xAxis));this.yAxis&&(D(this.chart.yAxis,this.yAxis),
D(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(b){a[b]&&a[b].destroy&&a[b].destroy();a[b]=null});[this.handles].forEach(function(a){f(a)})};return k}()});C(a,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,
buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}}});
C(a,"Stock/RangeSelector/RangeSelectorComposition.js",[a["Core/Defaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Core/Utilities.js"]],function(a,q,B){function r(){var a=this.range,d=a.type,k=this.max,b=this.chart.time,l=function(a,l){var k="year"===d?"FullYear":"Month",m=new b.Date(a),c=b.get(k,m);b.set(k,m,c+l);c===b.get(k,m)&&b.set("Date",m,0);return m.getTime()-a};if(E(a)){var m=k-a;var c=a}else a&&(m=k+l(k,-(a.count||1)),this.chart&&(this.chart.fixedRange=k-m));var e=H(this.dataMin,
Number.MIN_VALUE);E(m)||(m=e);m<=e&&(m=e,"undefined"===typeof c&&(c=l(m,a.count)),this.newMax=Math.min(m+c,H(this.dataMax,Number.MAX_VALUE)));E(k)?!E(a)&&a&&a._offsetMin&&(m+=a._offsetMin):m=void 0;return m}function v(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new t(this))}function y(){var a=this.axes,d=this.rangeSelector;d&&(E(d.deferredYTDClick)&&(d.clickButton(d.deferredYTDClick),delete d.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),d.render(),a=d.options.verticalAlign,d.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}function h(a){var d,k,b,l,m=a.rangeSelector,e=function(){m&&(d=a.xAxis[0].getExtremes(),k=a.legend,l=m&&m.options.verticalAlign,E(d.min)&&m.render(d.min,d.max),k.display&&"top"===l&&l===k.options.verticalAlign&&(b=C(a.spacingBox),b.y="vertical"===k.options.layout?a.plotTop:b.y+m.getHeight(),k.group.placed=!1,k.align(b)))};m&&(D(x,function(b){return b[0]===
a})||x.push([a,[c(a.xAxis[0],"afterSetExtremes",function(a){m&&m.render(a.min,a.max)}),c(a,"redraw",e)]]),e())}function z(){for(var a=0,d=x.length;a<d;++a){var k=x[a];if(k[0]===this){k[1].forEach(function(a){return a()});x.splice(a,1);break}}}function u(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function p(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?
this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function e(a){var d=a.options.rangeSelector;a=this.extraBottomMargin;var k=this.extraTopMargin,b=this.rangeSelector;d&&d.enabled&&!J(b)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=b=new t(this));this.extraTopMargin=this.extraBottomMargin=!1;b&&(h(this),d=d&&d.verticalAlign||b.options&&b.options.verticalAlign,b.options.floating||("bottom"===d?this.extraBottomMargin=!0:"middle"!==d&&(this.extraTopMargin=
!0)),this.extraBottomMargin!==a||this.extraTopMargin!==k)&&(this.isDirtyBox=!0)}var g=a.defaultOptions,w=a.setOptions,c=B.addEvent,J=B.defined,f=B.extend,D=B.find,E=B.isNumber,C=B.merge,H=B.pick,x=[],F=[],t;return{compose:function(a,d,k){t=k;-1===F.indexOf(a)&&(F.push(a),a.prototype.minFromRange=r);-1===F.indexOf(d)&&(F.push(d),c(d,"afterGetContainer",v),c(d,"beforeRender",y),c(d,"destroy",z),c(d,"getMargins",u),c(d,"render",p),c(d,"update",e),d.prototype.callbacks.push(h));-1===F.indexOf(w)&&(f(g,
{rangeSelector:q.rangeSelector}),f(g.lang,q.lang))}}});C(a,"Stock/RangeSelector/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Stock/RangeSelector/RangeSelectorComposition.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,B,r,v,y){function h(a){if(-1!==a.indexOf("%L"))return"text";var d="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),k="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return d&&
k?"datetime-local":d?"date":k?"time":"text"}var z=q.defaultOptions,u=y.addEvent,p=y.createElement,e=y.css,g=y.defined,w=y.destroyObjectProperties,c=y.discardElement,J=y.extend,f=y.fireEvent,D=y.isNumber,E=y.merge,C=y.objectEach,H=y.pad,x=y.pick,F=y.pInt,t=y.splat;q=function(){function n(a){this.buttons=void 0;this.buttonOptions=n.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}n.compose=function(a,k){r.compose(a,k,n)};n.prototype.clickButton=function(d,
k){var b=this.chart,l=this.buttonOptions[d],m=b.xAxis[0],c=b.scroller&&b.scroller.getUnionExtremes()||m||{},e=l.type,n=l.dataGrouping,p=c.dataMin,h=c.dataMax,w=m&&Math.round(Math.min(m.max,x(h,m.max)));c=l._range;var v,I=!0;if(null!==p&&null!==h){b.fixedRange=c;this.setSelected(d);n&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(m||{chart:this.chart},n,!1),this.frozenStates=l.preserveDataGrouping);if("month"===e||"year"===e)if(m){e={range:l,max:w,chart:b,dataMin:p,dataMax:h};var r=
m.minFromRange.call(e);D(e.newMax)&&(w=e.newMax);I=!1}else c=l;else if(c)r=Math.max(w-c,p),w=Math.min(r+c,h),I=!1;else if("ytd"===e)if(m){if("undefined"===typeof h||"undefined"===typeof p)p=Number.MAX_VALUE,h=Number.MIN_VALUE,b.series.forEach(function(a){if(a=a.xData)p=Math.min(a[0],p),h=Math.max(a[a.length-1],h)}),k=!1;e=this.getYTDExtremes(h,p,b.time.useUTC);r=v=e.min;w=e.max}else{this.deferredYTDClick=d;return}else"all"===e&&m&&(b.navigator&&b.navigator.baseSeries[0]&&(b.navigator.baseSeries[0].xAxis.options.range=
void 0),r=p,w=h);I&&l._offsetMin&&g(r)&&(r+=l._offsetMin);l._offsetMax&&g(w)&&(w+=l._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=d+1);if(m)m.setExtremes(r,w,x(k,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:l});else{var q=t(b.options.xAxis)[0];var z=q.range;q.range=c;var y=q.min;q.min=v;u(b,"load",function(){q.range=z;q.min=y})}f(this,"afterBtnClick")}};n.prototype.setSelected=function(a){this.selected=this.options.selected=a};n.prototype.init=function(a){var d=this,b=a.options.rangeSelector,
l=b.buttons||d.defaultButtons.slice(),m=b.selected,c=function(){var a=d.minInput,b=d.maxInput;a&&a.blur&&f(a,"blur");b&&b.blur&&f(b,"blur")};d.chart=a;d.options=b;d.buttons=[];d.buttonOptions=l;this.eventsToUnbind=[];this.eventsToUnbind.push(u(a.container,"mousedown",c));this.eventsToUnbind.push(u(a,"resize",c));l.forEach(d.computeButtonRange);"undefined"!==typeof m&&l[m]&&this.clickButton(m,!1);this.eventsToUnbind.push(u(a,"load",function(){a.xAxis&&a.xAxis[0]&&u(a.xAxis[0],"setExtremes",function(b){this.max-
this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})}))};n.prototype.updateButtonStates=function(){var a=this,k=this.chart,b=this.dropdown,l=k.xAxis[0],m=Math.round(l.max-l.min),c=!l.hasVisibleSeries,e=k.scroller&&k.scroller.getUnionExtremes()||l,f=e.dataMin,g=e.dataMax;k=a.getYTDExtremes(g,f,k.time.useUTC);var n=k.min,p=k.max,h=a.selected,u=a.options.allButtonsEnabled,w=a.buttons,t=D(h);a.buttonOptions.forEach(function(d,
k){var e=d._range,A=d.type,M=d.count||1,K=w[k],r=d._offsetMax-d._offsetMin,v=k===h,I=e>g-f,x=e<l.minRange;d=0;var G=!1,q=!1;e=e===m;("month"===A||"year"===A)&&m+36E5>=864E5*{month:28,year:365}[A]*M-r&&m-36E5<=864E5*{month:31,year:366}[A]*M+r?e=!0:"ytd"===A?(e=p-n+r===m,G=!v):"all"===A&&(e=l.max-l.min>=g-f,q=!v&&t&&e);A=!u&&(I||x||q||c);M=v&&e||e&&!t&&!G||v&&a.frozenStates;A?d=3:M&&(t=!0,d=2);K.state!==d&&(K.setState(d),b&&(b.options[k+1].disabled=A,2===d&&(b.selectedIndex=k+1)),0===d&&h===k&&a.setSelected())})};
n.prototype.computeButtonRange=function(a){var d=a.type,b=a.count||1,l={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(l[d])a._range=l[d]*b;else if("month"===d||"year"===d)a._range=864E5*{month:30,year:365}[d]*b;a._offsetMin=x(a.offsetMin,0);a._offsetMax=x(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};n.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var d=this.chart.options.rangeSelector,b=this.chart.time;return a?("text"===a.type&&d.inputDateParser||
this.defaultInputDateParser)(a.value,b.useUTC,b):0};n.prototype.setInputValue=function(a,k){var b=this.options,d=this.chart.time,m="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(m){var c=m.getAttribute("data-hc-time");c=g(c)?Number(c):void 0;g(k)&&(g(c)&&m.setAttribute("data-hc-time-previous",c),m.setAttribute("data-hc-time",k),c=k);m.value=d.dateFormat(this.inputTypeFormats[m.type]||b.inputEditDateFormat,c);a&&a.attr({text:d.dateFormat(b.inputDateFormat,c)})}};
n.prototype.setInputExtremes=function(a,k,b){if(a="min"===a?this.minInput:this.maxInput){var d=this.inputTypeFormats[a.type],m=this.chart.time;d&&(k=m.dateFormat(d,k),a.min!==k&&(a.min=k),b=m.dateFormat(d,b),a.max!==b&&(a.max=b))}};n.prototype.showInput=function(a){var d="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&d&&this.inputGroup){var b="text"===a.type,l=this.inputGroup,m=l.translateX;l=l.translateY;var c=this.options.inputBoxWidth;e(a,{width:b?d.width+
(c?-2:20)+"px":"auto",height:b?d.height-2+"px":"auto",border:"2px solid silver"});b&&c?e(a,{left:m+d.x+"px",top:l+"px"}):e(a,{left:Math.min(Math.round(d.x+m-(a.offsetWidth-d.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:l-(a.offsetHeight-d.height)/2+"px"})}};n.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&e(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};n.prototype.defaultInputDateParser=function(a,k,b){var d=a.split("/").join("-").split(" ").join("T");
-1===d.indexOf("T")&&(d+="T00:00");if(k)d+="Z";else{var m;if(m=B.isSafari)m=d,m=!(6<m.length&&(m.lastIndexOf("-")===m.length-6||m.lastIndexOf("+")===m.length-6));m&&(m=(new Date(d)).getTimezoneOffset()/60,d+=0>=m?"+".concat(H(-m),":00"):"-".concat(H(m),":00"))}d=Date.parse(d);D(d)||(a=a.split("-"),d=Date.UTC(F(a[0]),F(a[1])-1,F(a[2])));b&&k&&D(d)&&(d+=b.getTimezoneOffset(d));return d};n.prototype.drawInput=function(a){function d(){var d=c.maxInput,l=c.minInput,m=b.xAxis[0],k=b.scroller&&b.scroller.xAxis?
b.scroller.xAxis:m,e=k.dataMin;k=k.dataMax;var f=c.getInputValue(a);f!==Number(t.getAttribute("data-hc-time-previous"))&&D(f)&&(t.setAttribute("data-hc-time-previous",f),u&&d&&D(e)?f>Number(d.getAttribute("data-hc-time"))?f=void 0:f<e&&(f=e):l&&D(k)&&(f<Number(l.getAttribute("data-hc-time"))?f=void 0:f>k&&(f=k)),"undefined"!==typeof f&&m.setExtremes(u?f:m.min,u?m.max:f,void 0,void 0,{trigger:"rangeSelectorInput"}))}var b=this.chart,l=this.div,m=this.inputGroup,c=this,f=b.renderer.style||{},g=b.renderer,
n=b.options.rangeSelector,u="min"===a,w=z.lang[u?"rangeSelectorFrom":"rangeSelectorTo"]||"";w=g.label(w,0).addClass("highcharts-range-label").attr({padding:w?2:0,height:w?n.inputBoxHeight:0}).add(m);g=g.label("",0).addClass("highcharts-range-input").attr({padding:2,width:n.inputBoxWidth,height:n.inputBoxHeight,"text-align":"center"}).on("click",function(){c.showInput(a);c[a+"Input"].focus()});b.styledMode||g.attr({stroke:n.inputBoxBorderColor,"stroke-width":1});g.add(m);var t=p("input",{name:a,className:"highcharts-range-selector"},
void 0,l);t.setAttribute("type",h(n.inputDateFormat||"%b %e, %Y"));b.styledMode||(w.css(E(f,n.labelStyle)),g.css(E({color:"#333333"},f,n.inputStyle)),e(t,J({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:f.fontSize,fontFamily:f.fontFamily,top:"-9999em"},n.inputStyle)));t.onfocus=function(){c.showInput(a)};t.onblur=function(){t===B.doc.activeElement&&d();c.hideInput(a);c.setInputValue(a);t.blur()};var r=!1;t.onchange=
function(){r||(d(),c.hideInput(a),t.blur())};t.onkeypress=function(a){13===a.keyCode&&d()};t.onkeydown=function(a){r=!0;38!==a.keyCode&&40!==a.keyCode||d()};t.onkeyup=function(){r=!1};return{dateBox:g,input:t,label:w}};n.prototype.getPosition=function(){var a=this.chart,c=a.options.rangeSelector;a="top"===c.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+c.buttonPosition.y,inputTop:a+c.inputPosition.y-10}};n.prototype.getYTDExtremes=function(a,c,b){var d=this.chart.time,m=new d.Date(a),
k=d.get("FullYear",m);b=b?d.Date.UTC(k,0,1):+new d.Date(k,0,1);c=Math.max(c,b);m=m.getTime();return{max:Math.min(a||m,m),min:c}};n.prototype.render=function(a,c){var b=this.chart,d=b.renderer,m=b.container,k=b.options,e=k.rangeSelector,f=x(k.chart.style&&k.chart.style.zIndex,0)+1;k=e.inputEnabled;if(!1!==e.enabled){this.rendered||(this.group=d.g("range-selector-group").attr({zIndex:7}).add(),this.div=p("div",void 0,{position:"relative",height:0,zIndex:f}),this.buttonOptions.length&&this.renderButtons(),
m.parentNode&&m.parentNode.insertBefore(this.div,m),k&&(this.inputGroup=d.g("input-group").add(this.group),d=this.drawInput("min"),this.minDateBox=d.dateBox,this.minLabel=d.label,this.minInput=d.input,d=this.drawInput("max"),this.maxDateBox=d.dateBox,this.maxLabel=d.label,this.maxInput=d.input));if(k&&(this.setInputValue("min",a),this.setInputValue("max",c),a=b.scroller&&b.scroller.getUnionExtremes()||b.xAxis[0]||{},g(a.dataMin)&&g(a.dataMax)&&(b=b.xAxis[0].minRange||0,this.setInputExtremes("min",
a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-b),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+b,a.dataMax)),this.inputGroup)){var n=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:n}),n+=b+e.inputSpacing)}})}this.alignElements();this.rendered=!0}};n.prototype.renderButtons=function(){var a=this,c=this.buttons,b=this.options,l=z.lang,m=this.chart.renderer,e=E(b.buttonTheme),g=e&&e.states,
n=e.width||28;delete e.width;delete e.states;this.buttonGroup=m.g("range-selector-buttons").add(this.group);var h=this.dropdown=p("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);u(h,"touchstart",function(){h.style.fontSize="16px"});[[B.isMS?"mouseover":"mouseenter"],[B.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(b){var d=b[0],l=b[1];u(h,d,function(){var b=c[a.currentButtonIndex()];b&&f(b.element,
l||d)})});this.zoomText=m.label(l&&l.rangeSelectorZoom||"",0).attr({padding:b.buttonTheme.padding,height:b.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(b.labelStyle),e["stroke-width"]=x(e["stroke-width"],0));p("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,h);this.buttonOptions.forEach(function(b,d){p("option",{textContent:b.title||b.text},void 0,h);c[d]=m.button(b.text,0,0,function(l){var c=b.events&&b.events.click,
m;c&&(m=c.call(b,l));!1!==m&&a.clickButton(d);a.isActive=!0},e,g&&g.hover,g&&g.select,g&&g.disabled).attr({"text-align":"center",width:n}).add(a.buttonGroup);b.title&&c[d].attr("title",b.title)})};n.prototype.alignElements=function(){var a=this,c=this.buttonGroup,b=this.buttons,l=this.chart,m=this.group,e=this.inputGroup,f=this.options,g=this.zoomText,n=l.options,p=n.exporting&&!1!==n.exporting.enabled&&n.navigation&&n.navigation.buttonOptions;n=f.buttonPosition;var h=f.inputPosition,u=f.verticalAlign,
t=function(b,d){return p&&a.titleCollision(l)&&"top"===u&&"right"===d.align&&d.y-b.getBBox().height-12<(p.y||0)+(p.height||0)+l.spacing[0]?-40:0},w=l.plotLeft;if(m&&n&&h){var r=n.x-l.spacing[3];if(c){this.positionButtons();if(!this.initialButtonGroupWidth){var v=0;g&&(v+=g.getBBox().width+5);b.forEach(function(a,d){v+=a.width;d!==b.length-1&&(v+=f.buttonSpacing)});this.initialButtonGroupWidth=v}w-=l.spacing[3];this.updateButtonStates();g=t(c,n);this.alignButtonGroup(g);m.placed=c.placed=l.hasLoaded}c=
0;e&&(c=t(e,h),"left"===h.align?r=w:"right"===h.align&&(r=-Math.max(l.axisOffset[1],-c)),e.align({y:h.y,width:e.getBBox().width,align:h.align,x:h.x+r-2},!0,l.spacingBox),e.placed=l.hasLoaded);this.handleCollision(c);m.align({verticalAlign:u},!0,l.spacingBox);e=m.alignAttr.translateY;c=m.getBBox().height+20;t=0;"bottom"===u&&(t=(t=l.legend&&l.legend.options)&&"bottom"===t.verticalAlign&&t.enabled&&!t.floating?l.legend.legendHeight+x(t.margin,10):0,c=c+t-20,t=e-c-(f.floating?0:f.y)-(l.titleOffset?l.titleOffset[2]:
0)-10);if("top"===u)f.floating&&(t=0),l.titleOffset&&l.titleOffset[0]&&(t=l.titleOffset[0]),t+=l.margin[0]-l.spacing[0]||0;else if("middle"===u)if(h.y===n.y)t=e;else if(h.y||n.y)t=0>h.y||0>n.y?t-Math.min(h.y,n.y):e-c;m.translate(f.x,f.y+Math.floor(t));n=this.minInput;h=this.maxInput;e=this.dropdown;f.inputEnabled&&n&&h&&(n.style.marginTop=m.translateY+"px",h.style.marginTop=m.translateY+"px");e&&(e.style.marginTop=m.translateY+"px")}};n.prototype.alignButtonGroup=function(a,c){var b=this.chart,d=
this.buttonGroup,m=this.options.buttonPosition,e=b.plotLeft-b.spacing[3],k=m.x-b.spacing[3];"right"===m.align?k+=a-e:"center"===m.align&&(k-=e/2);d&&d.align({y:m.y,width:x(c,this.initialButtonGroupWidth),align:m.align,x:k},!0,b.spacingBox)};n.prototype.positionButtons=function(){var a=this.buttons,c=this.chart,b=this.options,l=this.zoomText,m=c.hasLoaded?"animate":"attr",e=b.buttonPosition,f=c=c.plotLeft;l&&"hidden"!==l.visibility&&(l[m]({x:x(c+e.x,c)}),f+=e.x+l.getBBox().width+5);l=0;for(e=this.buttonOptions.length;l<
e;++l)if("hidden"!==a[l].visibility)a[l][m]({x:f}),f+=a[l].width+b.buttonSpacing;else a[l][m]({x:c})};n.prototype.handleCollision=function(a){var d=this,b=this.chart,c=this.buttonGroup,m=this.inputGroup,e=this.options,f=e.buttonPosition,g=e.dropdown,n=e.inputPosition;e=function(){var a=0;d.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var p=function(b){if(m&&c){var d=m.alignAttr.translateX+m.alignOptions.x-a+m.getBBox().x+2,l=m.alignOptions.width,e=c.alignAttr.translateX+
c.getBBox().x;return e+b>d&&d+l>e&&f.y<n.y+m.getBBox().height}return!1},h=function(){m&&c&&m.attr({translateX:m.alignAttr.translateX+(b.axisOffset[1]>=-a?0:-a),translateY:m.alignAttr.translateY+c.getBBox().height+10})};if(c){if("always"===g){this.collapseButtons(a);p(e())&&h();return}"never"===g&&this.expandButtons()}m&&c?n.align===f.align||p(this.initialButtonGroupWidth+20)?"responsive"===g?(this.collapseButtons(a),p(e())&&h()):h():"responsive"===g&&this.expandButtons():c&&"responsive"===g&&(this.initialButtonGroupWidth>
b.plotWidth?this.collapseButtons(a):this.expandButtons())};n.prototype.collapseButtons=function(a){var d=this.buttons,b=this.buttonOptions,c=this.chart,m=this.dropdown,e=this.options,f=this.zoomText,g=c.userOptions.rangeSelector&&c.userOptions.rangeSelector.buttonTheme||{},n=function(a){return{text:a?"".concat(a," \u25be"):"\u25be",width:"auto",paddingLeft:x(e.buttonTheme.paddingLeft,g.padding,8),paddingRight:x(e.buttonTheme.paddingRight,g.padding,8)}};f&&f.hide();var p=!1;b.forEach(function(a,b){b=
d[b];2!==b.state?b.hide():(b.show(),b.attr(n(a.text)),p=!0)});p||(m&&(m.selectedIndex=0),d[0].show(),d[0].attr(n(this.zoomText&&this.zoomText.textStr)));b=e.buttonPosition.align;this.positionButtons();"right"!==b&&"center"!==b||this.alignButtonGroup(a,d[this.currentButtonIndex()].getBBox().width);this.showDropdown()};n.prototype.expandButtons=function(){var a=this.buttons,c=this.buttonOptions,b=this.options,l=this.zoomText;this.hideDropdown();l&&l.show();c.forEach(function(d,c){c=a[c];c.show();c.attr({text:d.text,
width:b.buttonTheme.width||28,paddingLeft:x(b.buttonTheme.paddingLeft,"unset"),paddingRight:x(b.buttonTheme.paddingRight,"unset")});2>c.state&&c.setState(0)});this.positionButtons()};n.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};n.prototype.showDropdown=function(){var a=this.buttonGroup,c=this.buttons,b=this.chart,l=this.dropdown;if(a&&l){var m=a.translateX;a=a.translateY;c=c[this.currentButtonIndex()].getBBox();e(l,{left:b.plotLeft+
m+"px",top:a+.5+"px",width:c.width+"px",height:c.height+"px"});this.hasVisibleDropdown=!0}};n.prototype.hideDropdown=function(){var a=this.dropdown;a&&(e(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};n.prototype.getHeight=function(){var a=this.options,c=this.group,b=a.y,l=a.buttonPosition.y,m=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=c?c.getBBox(!0).height+13+b:0;c=Math.min(m,l);if(0>m&&0>l||0<m&&0<l)a+=Math.abs(c);return a};n.prototype.titleCollision=
function(a){return!(a.options.title.text||a.options.subtitle.text)};n.prototype.update=function(a){var d=this.chart;E(!0,d.options.rangeSelector,a);this.destroy();this.init(d);this.render()};n.prototype.destroy=function(){var a=this,e=a.minInput,b=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);w(a.buttons);e&&(e.onfocus=e.onblur=e.onchange=null);b&&(b.onfocus=b.onblur=b.onchange=null);C(a,function(b,d){b&&"chart"!==d&&(b instanceof v?b.destroy():
b instanceof window.HTMLElement&&c(b));b!==n.prototype[d]&&(a[d]=null)},this)};return n}();J(q.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",
time:"%H:%M:%S"}});"";return q});C(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,B,r){var v=r.addEvent,y=r.correctFloat,h=r.css,z=r.defined,u=r.error,p=r.pick,e=r.timeUnits,g=[],w;(function(a){function c(a,d,c,k,f,g,n){void 0===f&&(f=[]);void 0===g&&(g=0);var b={},m=this.options.tickPixelInterval,l=this.chart.time,p=[],h,t,A=0,w=[],r=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!f||3>f.length||
"undefined"===typeof d)return l.getTimeTicks.apply(l,arguments);var v=f.length;for(h=0;h<v;h++){var x=h&&f[h-1]>c;f[h]<d&&(A=h);if(h===v-1||f[h+1]-f[h]>5*g||x){if(f[h]>r){for(t=l.getTimeTicks(a,f[A],f[h],k);t.length&&t[0]<=r;)t.shift();t.length&&(r=t[t.length-1]);p.push(w.length);w=w.concat(t)}A=h+1}if(x)break}if(t){t=t.info;if(n&&t.unitRange<=e.hour){h=w.length-1;for(A=1;A<h;A++)if(l.dateFormat("%d",w[A])!==l.dateFormat("%d",w[A-1])){b[w[A]]="day";var q=!0}q&&(b[w[0]]="day");t.higherRanks=b}t.segmentStarts=
p;w.info=t}else u(12,!1,this.chart);if(n&&z(m)){t=w.length;l=[];A=[];h=void 0;for(q=t;q--;)p=this.translate(w[q]),h&&(A[q]=h-p),l[q]=h=p;A.sort();A=A[Math.floor(A.length/2)];A<.6*m&&(A=null);q=w[t-1]>c?t-1:t;for(h=void 0;q--;)p=l[q],t=Math.abs(h-p),h&&t<.8*m&&(null===A||t<.8*A)?(b[w[q]]&&!b[w[q+1]]?(t=q+1,h=p):t=q,w.splice(t,1)):h=p}return w}function f(a){var b=this.ordinal.positions;if(!b)return a;var d=b.length-1;if(0>a)a=b[0];else if(a>d)a=b[d];else{d=Math.floor(a);var c=a-d}return"undefined"!==
typeof c&&"undefined"!==typeof b[d]?b[d]+(c?c*(b[d+1]-b[d]):0):a}function w(a){var b=this.ordinal,d=b.positions;if(!d)return a;var c=(a-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<c&&c<this.left+this.len||(b.extendedOrdinalPositions||(b.extendedOrdinalPositions=b.getExtendedPositions()),d=b.extendedOrdinalPositions);if(d&&d.length){a=b.getIndexOfPoint(c,d);b=y(a%1);if(0<=a&&a<d.length-1)return d[Math.floor(a)]+b*(d[Math.ceil(a)]-d[Math.floor(a)]);
b=d.length;c=d[0];d=d[b-1];var e=(d-c)/(b-1);return 0>a?c+e*a:d+e*(a-b)}return a}function r(b,d){var c=a.Additions.findIndexOf(b,d,!0);return b[c]===d?c:c+(d-b[c])/(b[c+1]-b[c])}function E(){this.ordinal||(this.ordinal=new a.Additions(this))}function H(){this.isXAxis&&z(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&z(this.userMin)&&
(this.min+=this.options.overscroll))}function x(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function F(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function t(a){var b=this.xAxis[0],d=b.options.overscroll,c=a.originalEvent.chartX,e=this.options.chart.panning,f=!1;if(e&&"y"!==e.type&&b.options.ordinal&&b.series.length){var k=this.mouseDownX,
g=b.getExtremes(),n=g.dataMax,p=g.min,t=g.max,w=this.hoverPoints,u=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;k=(k-c)/(b.translationSlope*(b.ordinal.slope||u));u=b.ordinal.getExtendedPositions();u={ordinal:{positions:u,extendedOrdinalPositions:u}};var r=b.index2val,v=b.val2lin,q=void 0,x=q=void 0,z=void 0;u.ordinal.positions?1<Math.abs(k)&&(w&&w.forEach(function(a){a.setState()}),0>k?(x=u,z=b.ordinal.positions?b:u):(x=b.ordinal.positions?b:u,z=u),q=z.ordinal.positions,n>q[q.length-
1]&&q.push(n),this.fixedRange=t-p,q=b.navigatorAxis.toFixedRange(void 0,void 0,r.apply(x,[v.apply(x,[p,!0])+k]),r.apply(z,[v.apply(z,[t,!0])+k])),q.min>=Math.min(g.dataMin,p)&&q.max<=Math.max(n,t)+d&&b.setExtremes(q.min,q.max,!0,!1,{trigger:"pan"}),this.mouseDownX=c,h(this.container,{cursor:"move"})):f=!0}else f=!0;f||e&&/y/.test(e.type)?d&&(b.max=b.dataMax+d):a.preventDefault()}function n(){var a=this.xAxis;a&&a.options.ordinal&&(delete a.ordinal.index,delete a.ordinal.extendedOrdinalPositions)}
function d(a,d){var b=this.ordinal,c=b.positions,e=b.slope,l=b.extendedOrdinalPositions;if(!c)return a;var f=c.length;if(c[0]<=a&&c[f-1]>=a)a=r(c,a);else{l||(l=b.getExtendedPositions&&b.getExtendedPositions(),b.extendedOrdinalPositions=l);if(!l||!l.length)return a;f=l.length;e||(e=(l[f-1]-l[0])/f);c=r(l,c[0]);a>=l[0]&&a<=l[f-1]?a=r(l,a)-c:a<l[0]?(a=l[0]-a,a=-c-a/e):(a-=l[f-1],a=a/e+f-c)}return d?a:e*(a||0)+b.offset}a.compose=function(a,e,m){if(-1===g.indexOf(a)){g.push(a);var b=a.prototype;b.getTimeTicks=
c;b.index2val=f;b.lin2val=w;b.val2lin=d;b.ordinal2lin=b.val2lin;v(a,"afterInit",E);v(a,"foundExtremes",H);v(a,"afterSetScale",x);v(a,"initialAxisTranslation",F)}-1===g.indexOf(m)&&(g.push(m),v(m,"pan",t));-1===g.indexOf(e)&&(g.push(e),v(e,"updatedData",n));return a};var k=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,b=a.ordinal,d=a.getExtremes(),c=d.min,e=d.max,f=a.isXAxis&&!!a.options.breaks;d=a.options.ordinal;var k=a.chart.options.chart.ignoreHiddenSeries,
g,n,h=[],t=Number.MAX_VALUE,u=!1,w=!1,r=!1;if(d||f){var q=0;a.series.forEach(function(a,b){g=[];0<b&&"highcharts-navigator-series"!==a.options.id&&1<a.processedXData.length&&(w=q!==a.processedXData[1]-a.processedXData[0]);q=a.processedXData[1]-a.processedXData[0];a.boosted&&(r=a.boosted);if(!(k&&!1===a.visible||!1===a.takeOrdinalPosition&&!f)&&(h=h.concat(a.processedXData),v=h.length,h.sort(function(a,b){return a-b}),t=Math.min(t,p(a.closestPointRange,t)),v)){for(b=0;b<v-1;)h[b]!==h[b+1]&&g.push(h[b+
1]),b++;g[0]!==h[0]&&g.unshift(h[0]);h=g}});w&&r&&(h.pop(),h.shift());var v=h.length;if(2<v){var x=h[1]-h[0];for(n=v-1;n--&&!u;)h[n+1]-h[n]!==x&&(u=!0);!a.options.keepOrdinalPadding&&(h[0]-c>x||e-h[h.length-1]>x)&&(u=!0)}else a.options.overscroll&&(2===v?t=h[1]-h[0]:1===v?(t=a.options.overscroll,h=[h[0],h[0]+t]):t=b.overscrollPointsRange);u||a.forceOrdinal?(a.options.overscroll&&(b.overscrollPointsRange=t,h=h.concat(b.getOverscrollPositions())),b.positions=h,x=a.ordinal2lin(Math.max(c,h[0]),!0),n=
Math.max(a.ordinal2lin(Math.min(e,h[h.length-1]),!0),1),b.slope=e=(e-c)/(n-x),b.offset=c-x*e):(b.overscrollPointsRange=p(a.closestPointRange,b.overscrollPointsRange),b.positions=a.ordinal.slope=b.offset=void 0)}a.isOrdinal=d&&u;b.groupIntervalFactor=null};a.findIndexOf=function(a,b,d){for(var c=0,e=a.length-1,f;c<e;)f=Math.ceil((c+e)/2),a[f]<=b?c=f:e=f-1;return a[c]===b?c:d?c:-1};a.prototype.getExtendedPositions=function(){var a=this,b=a.axis,d=b.constructor.prototype,c=b.chart,e=b.series[0].currentDataGrouping,
f=e?e.count+e.unitName:"raw",k=b.options.overscroll,g=b.getExtremes(),n=void 0,h=a.index;h||(h=a.index={});if(!h[f]){var p={series:[],chart:c,forceOrdinal:!1,getExtremes:function(){return{min:g.dataMin,max:g.dataMax+k}},getGroupPixelWidth:d.getGroupPixelWidth,getTimeTicks:d.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:d.ordinal2lin,getIndexOfPoint:d.getIndexOfPoint,val2lin:d.val2lin};p.ordinal.axis=p;b.series.forEach(function(b){n={xAxis:p,
xData:b.xData.slice(),chart:c,destroyGroupedData:q.noop,getProcessedData:B.prototype.getProcessedData,applyGrouping:B.prototype.applyGrouping};n.xData=n.xData.concat(a.getOverscrollPositions());n.options={dataGrouping:e?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[e.unitName,[e.count]]]}:{enabled:!1}};p.series.push(n);b.processData.apply(n)});n.closestPointRange!==n.basePointRange&&n.currentDataGrouping&&(p.forceOrdinal=!0);b.ordinal.beforeSetTickPositions.apply({axis:p});
h[f]=p.ordinal.positions}return h[f]};a.prototype.getGroupIntervalFactor=function(a,b,d){d=d.processedXData;var c=d.length,e=[];var f=this.groupIntervalFactor;if(!f){for(f=0;f<c-1;f++)e[f]=d[f+1]-d[f];e.sort(function(a,b){return a-b});e=e[Math.floor(c/2)];a=Math.max(a,d[0]);b=Math.min(b,d[c-1]);this.groupIntervalFactor=f=c*e/(b-a)}return f};a.prototype.getIndexOfPoint=function(b,d){var c=this.axis,e=this.positions?this.positions[0]:0,f=c.series[0].points&&c.series[0].points[0]&&c.series[0].points[0].plotX||
c.minPixelPadding;1<c.series.length&&c.series.forEach(function(a){a.points&&z(a.points[0])&&z(a.points[0].plotX)&&a.points[0].plotX<f&&a.points[0].plotX>=p(c.min,-Infinity)&&(f=a.points[0].plotX)});b=(b-f)/(c.translationSlope*(this.slope||c.closestPointRange||this.overscrollPointsRange));return a.findIndexOf(d,e)+b};a.prototype.getOverscrollPositions=function(){var a=this.axis,b=a.options.overscroll,d=this.overscrollPointsRange,c=[],e=a.dataMax;if(z(d))for(;e<=a.dataMax+b;)e+=d,c.push(e);return c};
a.prototype.postProcessTickInterval=function(a){var b=this.axis,d=this.slope;return d?b.options.breaks?b.closestPointRange||a:a/(d/b.closestPointRange):a};return a}();a.Additions=k})(w||(w={}));return w});C(a,"Series/HLC/HLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(r,v){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,h){a.__proto__=h}||function(a,h){for(var r in h)Object.prototype.hasOwnProperty.call(h,r)&&
(a[r]=h[r])};return a(r,v)};return function(r,v){function q(){this.constructor=r}if("function"!==typeof v&&null!==v)throw new TypeError("Class extends value "+String(v)+" is not a constructor or null");a(r,v);r.prototype=null===v?Object.create(v):(q.prototype=v.prototype,new q)}}();return function(a){function r(){var r=null!==a&&a.apply(this,arguments)||this;r.close=void 0;r.high=void 0;r.low=void 0;r.options=void 0;r.plotClose=void 0;r.series=void 0;return r}q(r,a);return r}(a.seriesTypes.column.prototype.pointClass)});
C(a,"Series/HLC/HLCSeriesDefaults.js",[],function(){"";return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}});C(a,"Series/HLC/HLCSeries.js",[a["Series/HLC/HLCPoint.js"],a["Series/HLC/HLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,B,r){var v=this&&this.__extends||
function(){var a=function(h,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var c in e)Object.prototype.hasOwnProperty.call(e,c)&&(a[c]=e[c])};return a(h,e)};return function(h,e){function g(){this.constructor=h}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(h,e);h.prototype=null===e?Object.create(e):(g.prototype=e.prototype,new g)}}(),y=B.seriesTypes.column,h=r.extend,
z=r.merge;r=function(a){function h(){var e=null!==a&&a.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;e.yData=void 0;return e}v(h,a);h.prototype.extendStem=function(a,g,h){var c=a[0];a=a[1];"number"===typeof c[2]&&(c[2]=Math.max(h+g,c[2]));"number"===typeof a[2]&&(a[2]=Math.min(h-g,a[2]))};h.prototype.getPointPath=function(a,g){g=g.strokeWidth();var e=a.series,c=g%2/2,h=Math.round(a.plotX)-c,f=Math.round(a.shapeArgs.width/2),p=[["M",h,Math.round(a.yBottom)],["L",h,Math.round(a.plotHigh)]];
null!==a.close&&(a=Math.round(a.plotClose)+c,p.push(["M",h,a],["L",h+f,a]),e.extendStem(p,g/2,a));return p};h.prototype.drawSinglePoint=function(a){var e=a.series,h=e.chart,c=a.graphic;"undefined"!==typeof a.plotY&&(c||(a.graphic=c=h.renderer.path().add(e.group)),h.styledMode||c.attr(e.pointAttribs(a,a.selected&&"select")),e=e.getPointPath(a,c),c[c?"animate":"attr"]({d:e}).addClass(a.getClassName(),!0))};h.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)};h.prototype.init=
function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};h.prototype.pointAttribs=function(e,g){e=a.prototype.pointAttribs.call(this,e,g);delete e.fill;return e};h.prototype.toYData=function(a){return[a.high,a.low,a.close]};h.prototype.translate=function(){var e=this,g=e.yAxis,h=this.pointArrayMap&&this.pointArrayMap.slice()||[],c=h.map(function(a){return"plot".concat(a.charAt(0).toUpperCase()+a.slice(1))});c.push("yBottom");h.push("low");a.prototype.translate.apply(e);e.points.forEach(function(a){h.forEach(function(f,
h){f=a[f];null!==f&&(e.dataModify&&(f=e.dataModify.modifyValue(f)),a[c[h]]=g.toPixels(f,!0))});a.tooltipPos[1]=a.plotHigh+g.pos-e.chart.plotTop})};h.defaultOptions=z(y.defaultOptions,q);return h}(y);h(r.prototype,{pointClass:a,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});B.registerSeriesType("hlc",r);return r});C(a,"Series/OHLC/OHLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=
this&&this.__extends||function(){var a=function(r,q){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,h){a.__proto__=h}||function(a,h){for(var r in h)Object.prototype.hasOwnProperty.call(h,r)&&(a[r]=h[r])};return a(r,q)};return function(r,q){function v(){this.constructor=r}if("function"!==typeof q&&null!==q)throw new TypeError("Class extends value "+String(q)+" is not a constructor or null");a(r,q);r.prototype=null===q?Object.create(q):(v.prototype=q.prototype,new v)}}();return function(a){function r(){var r=
null!==a&&a.apply(this,arguments)||this;r.open=void 0;r.options=void 0;r.plotOpen=void 0;r.series=void 0;return r}q(r,a);r.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};r.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};r.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};
r.prototype.getZone=function(){var r=a.prototype.getZone.call(this);this.resolveUpColor();return r};r.prototype.applyOptions=function(){a.prototype.applyOptions.apply(this,arguments);this.resolveColor&&this.resolveColor();return this};return r}(a.seriesTypes.hlc.prototype.pointClass)});C(a,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){"";return{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}});
C(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Series/OHLC/OHLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,B,r){function v(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")}function y(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&p(this,{pointValKey:w.prototype.pointValKey,pointArrayMap:w.prototype.pointArrayMap,toYData:w.prototype.toYData})}var h=
this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)Object.prototype.hasOwnProperty.call(c,e)&&(a[e]=c[e])};return a(c,e)};return function(c,e){function f(){this.constructor=c}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}(),z=B.seriesTypes.hlc,
u=r.addEvent,p=r.extend,e=r.merge,g=[],w=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(c,a);c.compose=function(a){for(var c=1;c<arguments.length;c++);-1===g.indexOf(a)&&(g.push(a),u(a,"afterSetOptions",v),u(a,"init",y))};c.prototype.getPointPath=function(c,e){var f=a.prototype.getPointPath.call(this,c,e);e=e.strokeWidth();var g=e%2/2,h=Math.round(c.plotX)-g,p=Math.round(c.shapeArgs.width/2);null!==c.open&&(c=Math.round(c.plotOpen)+
g,f.push(["M",h,c],["L",h-p,c]),a.prototype.extendStem.call(this,f,e/2,c));return f};c.prototype.pointAttribs=function(c,e){e=a.prototype.pointAttribs.call(this,c,e);var f=this.options;delete e.fill;!c.options.color&&f.upColor&&c.open<c.close&&(e.stroke=f.upColor);return e};c.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};c.defaultOptions=e(z.defaultOptions,q);return c}(z);p(w.prototype,{pointClass:a,pointArrayMap:["open","high","low","close"]});B.registerSeriesType("ohlc",w);
return w});C(a,"Series/Candlestick/CandlestickSeriesDefaults.js",[a["Core/Defaults.js"],a["Core/Utilities.js"]],function(a,q){"";return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}});C(a,"Series/Candlestick/CandlestickSeries.js",[a["Series/Candlestick/CandlestickSeriesDefaults.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,B,r){var v=this&&this.__extends||function(){var a=function(e,
g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)Object.prototype.hasOwnProperty.call(c,e)&&(a[e]=c[e])};return a(e,g)};return function(e,g){function h(){this.constructor=e}if("function"!==typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");a(e,g);e.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}(),y=q.defaultOptions;q=B.seriesTypes;var h=q.column,z=q.ohlc,
u=r.merge;r=function(p){function e(){var a=null!==p&&p.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}v(e,p);e.prototype.pointAttribs=function(a,e){var c=h.prototype.pointAttribs.call(this,a,e),g=this.options,f=a.open<a.close,p=g.lineColor||this.color,r=a.color||this.color;c["stroke-width"]=g.lineWidth;c.fill=a.options.color||(f?g.upColor||r:r);c.stroke=a.options.lineColor||(f?g.upLineColor||p:p);e&&(a=g.states[e],c.fill=a.color||c.fill,c.stroke=a.lineColor||c.stroke,
c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c};e.prototype.drawPoints=function(){for(var a=this.chart,e=this.yAxis.reversed,c=0,h=this.points;c<h.length;c++){var f=h[c],p=f.graphic,r=!p;if("undefined"!==typeof f.plotY){p||(f.graphic=p=a.renderer.path().add(this.group));this.chart.styledMode||p.attr(this.pointAttribs(f,f.selected&&"select")).shadow(this.options.shadow);var u=p.strokeWidth()%2/2;var q=Math.round(f.plotX)-u;var x=f.plotOpen;var v=f.plotClose;var t=Math.min(x,v);x=Math.max(x,
v);var n=Math.round(f.shapeArgs.width/2);v=e?x!==f.yBottom:Math.round(t)!==Math.round(f.plotHigh);var d=e?Math.round(t)!==Math.round(f.plotHigh):x!==f.yBottom;t=Math.round(t)+u;x=Math.round(x)+u;u=[];u.push(["M",q-n,x],["L",q-n,t],["L",q+n,t],["L",q+n,x],["Z"],["M",q,t],["L",q,v?Math.round(e?f.yBottom:f.plotHigh):t],["M",q,x],["L",q,d?Math.round(e?f.plotHigh:f.yBottom):x]);p[r?"attr":"animate"]({d:u}).addClass(f.getClassName(),!0)}}};e.defaultOptions=u(z.defaultOptions,y.plotOptions,{tooltip:z.defaultOptions.tooltip},
a);return e}(z);B.registerSeriesType("candlestick",r);return r});C(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q){var B=this&&this.__extends||function(){var a=function(r,h){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,h){a.__proto__=h}||function(a,h){for(var p in h)Object.prototype.hasOwnProperty.call(h,p)&&(a[p]=h[p])};return a(r,h)};return function(r,h){function q(){this.constructor=r}if("function"!==typeof h&&null!==
h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");a(r,h);r.prototype=null===h?Object.create(h):(q.prototype=h.prototype,new q)}}(),r=q.isNumber;return function(a){function q(){var h=null!==a&&a.apply(this,arguments)||this;h.options=void 0;h.series=void 0;h.ttBelow=!1;return h}B(q,a);q.prototype.isValid=function(){return r(this.y)||"undefined"===typeof this.y};q.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&
a&&a!==this.graphic.symbolKey};return q}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/Flags/FlagsSeriesDefaults.js",[],function(){"";return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}}});C(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"]],function(a){var q;
(function(q){function r(a,r,q,p,e){var g=e&&e.anchorX||a;e=e&&e.anchorY||r;var h=this.circle(g-1,e-1,2,2);h.push(["M",g,e],["L",a,r+p],["L",a,r],["L",a+q,r],["L",a+q,r+p],["L",a,r+p],["Z"]);return h}function v(a,r){a[r+"pin"]=function(h,p,e,g,q){var c=q&&q.anchorX;q=q&&q.anchorY;"circle"===r&&g>e&&(h-=Math.round((g-e)/2),e=g);var u=a[r](h,p,e,g);if(c&&q){var f=c;"circle"===r?f=h+e/2:(h=u[0],e=u[1],"M"===h[0]&&"L"===e[0]&&(f=(h[1]+e[1])/2));u.push(["M",f,p>q?p:p+g],["L",c,q]);u=u.concat(a.circle(c-
1,q-1,2,2))}return u}}var y=[];q.compose=function(h){if(-1===y.indexOf(h)){y.push(h);var q=h.prototype.symbols;q.flag=r;v(q,"circle");v(q,"square")}var u=a.getRendererType();y.indexOf(u)&&(y.push(u),q=h.prototype.symbols,h=u.prototype.symbols,h.circlepin=q.circlepin,h.flag=q.flag.bind(q),h.squarepin=q.squarepin)}})(q||(q={}));return q});C(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,B){var r=a.prototype,v=q.prototype,
y=B.defined,h=B.stableSort,z;(function(a){function p(a){return v.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,a)}function e(){r.translate.apply(this);var a=this,c=a.options,e=a.chart,f=a.points,g=c.onSeries,p=(g=g&&e.get(g))&&g.options.step,q=g&&g.points,u=e.inverted,x=a.xAxis,v=a.yAxis;e=f.length-1;var t;c=c.onKey||"y";var n=q&&q.length,d=0,k;if(g&&g.visible&&n){d=(g.pointXOffset||0)+(g.barW||0)/2;var b=g.currentDataGrouping;var l=q[n-1].x+(b?b.totalRange:0);
h(f,function(a,b){return a.x-b.x});for(c="plot"+c[0].toUpperCase()+c.substr(1);n--&&f[e];){var m=q[n];b=f[e];b.y=m.y;if(m.x<=b.x&&"undefined"!==typeof m[c]){if(b.x<=l&&(b.plotY=m[c],m.x<b.x&&!p&&(k=q[n+1])&&"undefined"!==typeof k[c])){var A=(b.x-m.x)/(k.x-m.x);b.plotY+=A*(k[c]-m[c]);b.y+=A*(k.y-m.y)}e--;n++;if(0>e)break}}}f.forEach(function(b,c){b.plotX+=d;if("undefined"===typeof b.plotY||u)0<=b.plotX&&b.plotX<=x.len?u?(b.plotY=x.translate(b.x,0,1,0,1),b.plotX=y(b.y)?v.translate(b.y,0,0,0,1):0):b.plotY=
(x.opposite?0:a.yAxis.len)+x.offset:b.shapeArgs={};if((t=f[c-1])&&t.plotX===b.plotX){"undefined"===typeof t.stackIndex&&(t.stackIndex=0);var e=t.stackIndex+1}b.stackIndex=e});this.onSeries=g}var g=[];a.compose=function(a){if(-1===g.indexOf(a)){g.push(a);var c=a.prototype;c.getPlotBox=p;c.translate=e}return a};a.getPlotBox=p;a.translate=e})(z||(z={}));return z});C(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],a["Series/Flags/FlagsSeriesDefaults.js"],a["Series/Flags/FlagsSymbols.js"],
a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Renderer/RendererUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,B,r,v,y,h,z,u){var p=this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)Object.prototype.hasOwnProperty.call(c,e)&&(a[e]=c[e])};return a(c,e)};return function(c,e){function f(){this.constructor=
c}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}();r=r.noop;var e=y.distribute,g=h.series,w=h.seriesTypes.column,c=u.addEvent,E=u.defined;y=u.extend;var f=u.merge,D=u.objectEach,C=u.wrap;u=function(a){function h(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}p(h,a);h.prototype.animate=function(a){a&&
this.setClip()};h.prototype.drawPoints=function(){var a=this.points,c=this.chart,g=c.renderer,h=c.inverted,d=this.options,k=d.y,b=this.yAxis,l={},m=[],p;for(p=a.length;p--;){var q=a[p];var r=(h?q.plotY:q.plotX)>this.xAxis.len;var u=q.plotX;var v=q.stackIndex;var w=q.options.shape||d.shape;var y=q.plotY;"undefined"!==typeof y&&(y=q.plotY+k-("undefined"!==typeof v&&v*d.stackDistance));q.anchorX=v?void 0:q.plotX;var B=v?void 0:q.plotY;var H="flag"!==w;v=q.graphic;"undefined"!==typeof y&&0<=u&&!r?(v&&
q.hasNewShapeType()&&(v=v.destroy()),v||(v=q.graphic=g.label("",null,null,w,null,null,d.useHTML).addClass("highcharts-point").add(this.markerGroup),q.graphic.div&&(q.graphic.div.point=q),v.isNew=!0),v.attr({align:H?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),c.styledMode||v.attr(this.pointAttribs(q)).css(f(d.style,q.style)).shadow(d.shadow),0<u&&(u-=v.strokeWidth()%2),w={y:y,anchorY:B},d.allowOverlapX&&(w.x=u,w.anchorX=q.anchorX),v.attr({text:q.options.title||d.title||
"A"})[v.isNew?"attr":"animate"](w),d.allowOverlapX||(l[q.plotX]?l[q.plotX].size=Math.max(l[q.plotX].size,v.width):l[q.plotX]={align:H?.5:0,size:v.width,target:u,anchorX:u}),q.tooltipPos=[u,y+b.pos-c.plotTop]):v&&(q.graphic=v.destroy())}if(!d.allowOverlapX){var J=100;D(l,function(a){a.plotX=a.anchorX;m.push(a);J=Math.max(a.size,J)});e(m,h?b.len:this.xAxis.len,J);for(c=0;c<a.length;c++)g=a[c],k=g.plotX,(k=(h=g.graphic)&&l[k])&&h&&(E(k.pos)?h[h.isNew?"attr":"animate"]({x:k.pos+(k.align||0)*k.size,anchorX:g.anchorX}).show().isNew=
!1:h.hide().isNew=!0)}d.useHTML&&this.markerGroup&&C(this.markerGroup,"on",function(a){return z.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};h.prototype.drawTracker=function(){var e=this.points;a.prototype.drawTracker.call(this);for(var f=function(a){var d=a.graphic;d&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=c(d.element,"mouseover",function(){0<a.stackIndex&&!a.raised&&(a._y=d.y,d.attr({y:a._y-8}),a.raised=!0);for(var c=0;c<e.length;c++){var b=
e[c];b!==a&&b.raised&&b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)}}))},g=0;g<e.length;g++)f(e[g])};h.prototype.pointAttribs=function(a,c){var e=this.options,f=a&&a.color||this.color,d=e.lineColor,k=a&&a.lineWidth;a=a&&a.fillColor||e.fillColor;c&&(a=e.states[c].fillColor,d=e.states[c].lineColor,k=e.states[c].lineWidth);return{fill:a||f,stroke:d||f,"stroke-width":k||e.lineWidth||0}};h.prototype.setClip=function(){g.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&
this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};h.compose=B.compose;h.defaultOptions=f(w.defaultOptions,q);return h}(w);v.compose(u);y(u.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:r,init:g.prototype.init});h.registerSeriesType("flags",u);"";return u});C(a,"Core/Chart/StockChart.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],
a["Core/Defaults.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Series/Series.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,q,B,r,v,y,h,z,u,p){function e(a,c){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:t(c.opposite,!0),showLastLabel:!(!c.categories&&
"category"!==c.type),title:{text:null}}:{}}function g(a,c){return"xAxis"===a?(a={type:"datetime",categories:void 0},t(c.navigator&&c.navigator.enabled,v.enabled,!0)&&(a.startOnTick=!1,a.endOnTick=!1),a):{}}var w=this&&this.__extends||function(){var a=function(d,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(a[d]=b[d])};return a(d,b)};return function(d,b){function c(){this.constructor=
d}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");a(d,b);d.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),c=B.format,E=r.getOptions;B=p.addEvent;var f=p.clamp,D=p.defined,C=p.extend,O=p.find,H=p.isNumber,x=p.isString,F=p.merge,t=p.pick,n=p.splat;p=function(a){function d(){return null!==a&&a.apply(this,arguments)||this}w(d,a);d.prototype.init=function(b,d){var c=E(),f=b.xAxis,k=b.yAxis,l=t(b.navigator&&
b.navigator.enabled,v.enabled,!0);b.xAxis=b.yAxis=void 0;l=F({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x"}},navigator:{enabled:l},scrollbar:{enabled:t(h.enabled,!0)},rangeSelector:{enabled:t(y.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:t(c.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},b,{isStock:!0});b.xAxis=f;b.yAxis=k;l.xAxis=n(b.xAxis||{}).map(function(a,d){return F(e("xAxis",a),c.xAxis,c.xAxis&&c.xAxis[d],a,g("xAxis",b))});l.yAxis=n(b.yAxis||{}).map(function(a,
b){return F(e("yAxis",a),c.yAxis,c.yAxis&&c.yAxis[b],a)});a.prototype.init.call(this,l,d)};d.prototype.createAxis=function(b,d){d.axis=F(e(b,d.axis),d.axis,g(b,this.userOptions));return a.prototype.createAxis.call(this,b,d)};return d}(q);(function(a){a.stockChart=function(d,b,c){return new a(d,b,c)}})(p||(p={}));B(z,"setOptions",function(a){var d;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?d={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(d={marker:{enabled:!1,
radius:2}}),d&&(a.plotOptions[this.type]=F(a.plotOptions[this.type],d)))});B(a,"autoLabelAlign",function(a){var d=this.chart,b=this.options;d=d._labelPanes=d._labelPanes||{};var c=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(b=b.top+","+b.height,!d[b]&&c.enabled&&(15===c.x&&(c.x=0),"undefined"===typeof c.align&&(c.align="right"),d[b]=this,a.align="right",a.preventDefault()))});B(a,"destroy",function(){var a=this.chart,c=this.options&&this.options.top+","+this.options.height;
c&&a._labelPanes&&a._labelPanes[c]===this&&delete a._labelPanes[c]});B(a,"getPlotLinePath",function(a){function c(a){var c="xAxis"===a?"yAxis":"xAxis";a=b.options[c];return H(a)?[e[c][a]]:x(a)?[e.get(a)]:d.map(function(a){return a[c]})}var b=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,e=b.chart,g=e.renderer,h=b.left,n=b.top,p,q,r,u,v=[],w=[],z=a.translatedValue,y=a.value,B=a.force;if(e.options.isStock&&!1!==a.acrossPanes&&"xAxis"===b.coll||"yAxis"===b.coll){a.preventDefault();
w=c(b.coll);var E=b.isXAxis?e.yAxis:e.xAxis;E.forEach(function(a){if(D(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var c=a.isXAxis?"yAxis":"xAxis";c=D(a.options[c])?e[c][a.options[c]]:e[c][0];b===c&&w.push(a)}});var C=w.length?[]:[b.isXAxis?e.yAxis[0]:e.xAxis[0]];w.forEach(function(a){-1!==C.indexOf(a)||O(C,function(b){return b.pos===a.pos&&b.len===a.len})||C.push(a)});var F=t(z,b.translate(y,void 0,void 0,a.old));H(F)&&(b.horiz?C.forEach(function(a){var c;q=a.pos;u=q+a.len;p=r=Math.round(F+
b.transB);"pass"!==B&&(p<h||p>h+b.width)&&(B?p=r=f(p,h,h+b.width):c=!0);c||v.push(["M",p,q],["L",r,u])}):C.forEach(function(a){var c;p=a.pos;r=p+a.len;q=u=Math.round(n+b.height-F);"pass"!==B&&(q<n||q>n+b.height)&&(B?q=u=f(q,n,n+b.height):c=!0);c||v.push(["M",p,q],["L",r,u])}));a.path=0<v.length?g.crispPolyLine(v,a.lineWidth||1):null}});u.prototype.crispPolyLine=function(a,c){for(var b=0;b<a.length;b+=2){var d=a[b],e=a[b+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-c%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+
c%2/2)}return a};B(a,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});B(a,"afterDrawCrosshair",function(a){var d,b;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&H(this.min)&&H(this.max)){var e=this.chart,f=this.logarithmic,g=this.crosshair.label,h=this.horiz,n=this.opposite,p=this.left,q=this.top,r=this.crossLabel,u=g.format,v="",w="inside"===this.options.tickPosition,x=!1!==this.crosshair.snap,z=0,y=a.e||this.cross&&
this.cross.e;a=a.point;var B=this.min,E=this.max;f&&(B=f.lin2log(B),E=f.lin2log(E));f=h?"center":n?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";r||(r=this.crossLabel=e.renderer.label("",0,void 0,g.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a&&a.series?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:g.align||f,padding:t(g.padding,8),r:t(g.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||r.attr({fill:g.backgroundColor||
a&&a.series&&a.series.color||"#666666",stroke:g.borderColor||"","stroke-width":g.borderWidth||0}).css(C({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},g.style||{})));h?(f=x?(a.plotX||0)+p:y.chartX,q+=n?0:this.height):(f=n?this.width+p:0,q=x?(a.plotY||0)+q:y.chartY);u||g.formatter||(this.dateTime&&(v="%b %d, %Y"),u="{value"+(v?":"+v:"")+"}");v=x?this.isXAxis?a.x:a.y:this.toValue(h?y.chartX:y.chartY);x=a&&a.series?a.series.isPointInside(a):H(v)&&v>B&&v<E;y="";u?y=c(u,{value:v},
e):g.formatter&&H(v)&&(y=g.formatter.call(this,v));r.attr({text:y,x:f,y:q,visibility:x?"inherit":"hidden"});g=r.getBBox();if(H(r.y))if(h){if(w&&!n||!w&&n)q=r.y-g.height}else q=r.y-g.height/2;h?(d=p-g.x,b=p+this.width-g.x):(d="left"===this.labelAlign?p:0,b="right"===this.labelAlign?p+this.width:e.chartWidth);r.translateX<d&&(z=d-r.translateX);r.translateX+g.width>=b&&(z=-(r.translateX+g.width-b));r.attr({x:f+z,y:q,anchorX:h?f:this.opposite?0:e.chartWidth,anchorY:h?this.opposite?e.chartHeight:0:q+g.height/
2})}});z.prototype.forceCropping=function(){var a=this.chart,c=this.options.dataGrouping;return!1!==this.allowDG&&c&&t(c.enabled,a.options.isStock)};B(q,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(F(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({}),delete a.scrollbar)});return p});C(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Series/DataModifyComposition.js"],a["Stock/Navigator/Navigator.js"],a["Stock/RangeSelector/RangeSelector.js"],a["Stock/Scrollbar/Scrollbar.js"],
a["Core/Axis/OrdinalAxis.js"],a["Series/OHLC/OHLCSeries.js"],a["Series/Flags/FlagsSeries.js"],a["Core/Chart/StockChart.js"]],function(a,q,B,r,v,y,h,z,u){a.Navigator=B;a.RangeSelector=r;a.Scrollbar=v;a.StockChart=a.stockChart=u.stockChart;q.compose(a.Series,a.Axis,a.Point);z.compose(a.Renderer);B.compose(a.Axis,a.Chart,a.Series);h.compose(a.Series);y.compose(a.Axis,a.Series,a.Chart);r.compose(a.Axis,a.Chart);v.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map