/*
 Highcharts JS v10.3.3 (2023-01-20)

 (c) 2014-2021 Highsoft AS
 Authors: Jon Arild Nygard / Oystein Moseng

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/treemap",["highcharts"],function(u){a(u);a.Highcharts=u;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function u(a,e,b,m){a.hasOwnProperty(e)||(a[e]=m.apply(null,b),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:a[e]}})))}a=a?a._modules:{};u(a,
"Series/ColorMapComposition.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,e){var b=a.seriesTypes.column.prototype,m=e.addEvent,l=e.defined,n;(function(a){function e(c){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:c&&"hover"===c.state?1:0})}var g=[];a.pointMembers={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value&&(void 0===this.value||!isNaN(this.value))}};a.seriesMembers=
{colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],colorAttribs:function(c){var f={};!l(c.color)||c.state&&"normal"!==c.state||(f[this.colorProp||"fill"]=c.color);return f},pointAttribs:b.pointAttribs};a.compose=function(c){var f=c.prototype.pointClass;-1===g.indexOf(f)&&(g.push(f),m(f,"afterSetState",e));return c}})(n||(n={}));return n});u(a,"Series/Treemap/TreemapAlgorithmGroup.js",
[],function(){return function(){function a(a,b,m,l){this.height=a;this.width=b;this.plot=l;this.startDirection=this.direction=m;this.lH=this.nH=this.lW=this.nW=this.total=0;this.elArr=[];this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(a,e){return Math.max(a/e,e/a)}}}a.prototype.addElement=function(a){this.lP.total=this.elArr[this.elArr.length-1];this.total+=a;0===this.direction?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),
this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH));this.elArr.push(a)};a.prototype.reset=function(){this.lW=this.nW=0;this.elArr=[];this.total=0};return a}()});u(a,"Series/DrawPointUtilities.js",[a["Core/Utilities.js"]],
function(a){return{draw:function(a,b){var e=b.animatableAttribs,l=b.onComplete,n=b.css,p=b.renderer,k=a.series&&a.series.chart.hasRendered?void 0:a.series&&a.series.options.animation,g=a.graphic;b.attribs=b.attribs||{};b.attribs["class"]=a.getClassName();if(a.shouldDraw())g||(a.graphic=g="text"===b.shapeType?p.text():p[b.shapeType](b.shapeArgs||{}),g.add(b.group)),n&&g.css(n),g.attr(b.attribs).animate(e,b.isNew?!1:k,l);else if(g){var c=function(){a.graphic=g=g&&g.destroy();"function"===typeof l&&
l()};Object.keys(e).length?g.animate(e,void 0,function(){return c()}):c()}}}});u(a,"Series/Treemap/TreemapPoint.js",[a["Series/DrawPointUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,e,b){var m=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var h in c)Object.prototype.hasOwnProperty.call(c,h)&&(a[h]=c[h])};return a(c,b)};return function(c,b){function f(){this.constructor=
c}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");a(c,b);c.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),l=e.series.prototype.pointClass,n=e.seriesTypes;e=n.pie.prototype.pointClass;var p=b.extend,k=b.isNumber,g=b.pick;b=function(c){function f(){var a=null!==c&&c.apply(this,arguments)||this;a.name=void 0;a.node=void 0;a.options=void 0;a.series=void 0;a.shapeType="rect";a.value=void 0;return a}m(f,c);
f.prototype.draw=function(c){a.draw(this,c)};f.prototype.getClassName=function(){var a=l.prototype.getClassName.call(this),c=this.series,f=c.options;this.node.level<=c.nodeMap[c.rootNode].level?a+=" highcharts-above-level":this.node.isLeaf||g(f.interactByLeaf,!f.allowTraversingTree)?this.node.isLeaf||(a+=" highcharts-internal-node"):a+=" highcharts-internal-node-interactive";return a};f.prototype.isValid=function(){return!(!this.id&&!k(this.value))};f.prototype.setState=function(a){l.prototype.setState.call(this,
a);this.graphic&&this.graphic.attr({zIndex:"hover"===a?1:0})};f.prototype.shouldDraw=function(){return k(this.plotY)&&null!==this.y};return f}(n.scatter.prototype.pointClass);p(b.prototype,{setVisible:e.prototype.setVisible});return b});u(a,"Series/Treemap/TreemapUtilities.js",[a["Core/Utilities.js"]],function(a){var e=a.objectEach,b;(function(a){function b(a,e,k){void 0===k&&(k=this);a=e.call(k,a);!1!==a&&b(a,e,k)}a.AXIS_MAX=100;a.isBoolean=function(a){return"boolean"===typeof a};a.eachObject=function(a,
b,k){k=k||this;e(a,function(e,c){b.call(k,e,c,a)})};a.recursive=b})(b||(b={}));return b});u(a,"Series/TreeUtilities.js",[a["Core/Color/Color.js"],a["Core/Utilities.js"]],function(a,e){function b(a,f){var c=f.before,e=f.idRoot,v=f.mapIdToNode[e],h=f.points[a.i],q=h&&h.options||{},w=[],x=0;a.levelDynamic=a.level-(!1!==f.levelIsConstant?0:v.level);a.name=g(h&&h.name,"");a.visible=e===a.id||!0===f.visible;"function"===typeof c&&(a=c(a,f));a.children.forEach(function(h,c){var q=m({},f);m(q,{index:c,siblings:a.children.length,
visible:a.visible});h=b(h,q);w.push(h);h.visible&&(x+=h.val)});c=g(q.value,x);a.visible=0<=c&&(0<x||a.visible);a.children=w;a.childrenTotal=x;a.isLeaf=a.visible&&!x;a.val=c;return a}var m=e.extend,l=e.isArray,n=e.isNumber,p=e.isObject,k=e.merge,g=e.pick;return{getColor:function(c,f){var b=f.index,e=f.mapOptionsToLevel,v=f.parentColor,h=f.parentColorIndex,q=f.series,w=f.colors,x=f.siblings,k=q.points,l=q.chart.options.chart,m;if(c){k=k[c.i];c=e[c.level]||{};if(e=k&&c.colorByPoint){var p=k.index%(w?
w.length:l.colorCount);var n=w&&w[p]}if(!q.chart.styledMode){w=k&&k.options.color;l=c&&c.color;if(m=v)m=(m=c&&c.colorVariation)&&"brightness"===m.key&&b&&x?a.parse(v).brighten(b/x*m.to).get():v;m=g(w,l,n,m,q.color)}var A=g(k&&k.options.colorIndex,c&&c.colorIndex,p,h,f.colorIndex)}return{color:m,colorIndex:A}},getLevelOptions:function(a){var c={};if(p(a)){var b=n(a.from)?a.from:1;var e=a.levels;var v={};var h=p(a.defaults)?a.defaults:{};l(e)&&(v=e.reduce(function(a,c){if(p(c)&&n(c.level)){var q=k({},
c);var f=g(q.levelIsConstant,h.levelIsConstant);delete q.levelIsConstant;delete q.level;c=c.level+(f?0:b-1);p(a[c])?k(!0,a[c],q):a[c]=q}return a},{}));e=n(a.to)?a.to:1;for(a=0;a<=e;a++)c[a]=k({},h,p(v[a])?v[a]:{})}return c},setTreeValues:b,updateRootId:function(a){if(p(a)){var c=p(a.options)?a.options:{};c=g(a.rootNode,c.rootId,"");p(a.userOptions)&&(a.userOptions.rootId=c);a.rootNode=c}return c}}});u(a,"Extensions/Breadcrumbs.js",[a["Core/Chart/Chart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],
a["Core/Utilities.js"],a["Core/FormatUtilities.js"]],function(a,e,b,m,l){var n=l.format;l=m.addEvent;var p=m.objectEach,k=m.extend,g=m.fireEvent,c=m.merge,f=m.pick,u=m.defined,E=m.isString;k(e.defaultOptions.lang,{mainBreadcrumb:"Main"});e=function(){function a(h,q){this.group=void 0;this.list=[];this.elementList={};this.isDirty=!0;this.level=0;this.options=void 0;q=c(h.options.drilldown&&h.options.drilldown.drillUpButton,a.defaultBreadcrumbsOptions,h.options.navigation&&h.options.navigation.breadcrumbs,
q);this.chart=h;this.options=q||{}}a.prototype.updateProperties=function(a){this.setList(a);this.setLevel();this.isDirty=!0};a.prototype.setList=function(a){this.list=a};a.prototype.setLevel=function(){this.level=this.list.length&&this.list.length-1};a.prototype.getLevel=function(){return this.level};a.prototype.getButtonText=function(a){var c=this.chart,h=this.options,b=c.options.lang,e=f(h.format,h.showFullPath?"{level.name}":"\u2190 {level.name}");b=b&&f(b.drillUpText,b.mainBreadcrumb);a=h.formatter&&
h.formatter(a)||n(e,{level:a.levelOptions},c)||"";(E(a)&&!a.length||"\u2190 "===a)&&u(b)&&(a=h.showFullPath?b:"\u2190 "+b);return a};a.prototype.redraw=function(){this.isDirty&&this.render();this.group&&this.group.align();this.isDirty=!1};a.prototype.render=function(){var a=this.chart,c=this.options;!this.group&&c&&(this.group=a.renderer.g("breadcrumbs-group").addClass("highcharts-no-tooltip highcharts-breadcrumbs").attr({zIndex:c.zIndex}).add());c.showFullPath?this.renderFullPathButtons():this.renderSingleButton();
this.alignBreadcrumbsGroup()};a.prototype.renderFullPathButtons=function(){this.destroySingleButton();this.resetElementListState();this.updateListElements();this.destroyListElements()};a.prototype.renderSingleButton=function(){var a=this.chart,c=this.list,b=this.options.buttonSpacing;this.destroyListElements();var e=this.group?this.group.getBBox().width:b;c=c[c.length-2];!a.drillUpButton&&0<this.level?a.drillUpButton=this.renderButton(c,e,b):a.drillUpButton&&(0<this.level?this.updateSingleButton():
this.destroySingleButton())};a.prototype.alignBreadcrumbsGroup=function(a){if(this.group){var b=this.options,h=b.buttonTheme,e=b.position,k="chart"===b.relativeTo||"spacingBox"===b.relativeTo?void 0:"scrollablePlotBox",g=this.group.getBBox();b=2*(h.padding||0)+b.buttonSpacing;e.width=g.width+b;e.height=g.height+b;g=c(e);a&&(g.x+=a);this.options.rtl&&(g.x+=e.width);g.y=f(g.y,this.yOffset,0);this.group.align(g,!0,k)}};a.prototype.renderButton=function(a,b,e){var h=this,f=this.chart,k=h.options,q=c(k.buttonTheme);
b=f.renderer.button(h.getButtonText(a),b,e,function(c){var b=k.events&&k.events.click,e;b&&(e=b.call(h,c,a));!1!==e&&(c.newLevel=k.showFullPath?a.level:h.level-1,g(h,"up",c))},q).addClass("highcharts-breadcrumbs-button").add(h.group);f.styledMode||b.attr(k.style);return b};a.prototype.renderSeparator=function(a,c){var b=this.chart,h=this.options.separator;a=b.renderer.label(h.text,a,c,void 0,void 0,void 0,!1).addClass("highcharts-breadcrumbs-separator").add(this.group);b.styledMode||a.css(h.style);
return a};a.prototype.update=function(a){c(!0,this.options,a);this.destroy();this.isDirty=!0};a.prototype.updateSingleButton=function(){var a=this.chart,c=this.list[this.level-1];a.drillUpButton&&a.drillUpButton.attr({text:this.getButtonText(c)})};a.prototype.destroy=function(){this.destroySingleButton();this.destroyListElements(!0);this.group&&this.group.destroy();this.group=void 0};a.prototype.destroyListElements=function(a){var c=this.elementList;p(c,function(b,e){if(a||!c[e].updated)b=c[e],b.button&&
b.button.destroy(),b.separator&&b.separator.destroy(),delete b.button,delete b.separator,delete c[e]});a&&(this.elementList={})};a.prototype.destroySingleButton=function(){this.chart.drillUpButton&&(this.chart.drillUpButton.destroy(),this.chart.drillUpButton=void 0)};a.prototype.resetElementListState=function(){p(this.elementList,function(a){a.updated=!1})};a.prototype.updateListElements=function(){var a=this,c=a.elementList,b=a.options.buttonSpacing,e=a.list,f=a.options.rtl,k=f?-1:1,g=function(a,
b){return k*a.getBBox().width+k*b},m=a.group?g(a.group,b):b,l;e.forEach(function(h,q){q=q===e.length-1;if(c[h.level]){l=c[h.level];var p=l.button;if(l.separator||q)l.separator&&q&&(l.separator.destroy(),delete l.separator);else{m+=k*b;l.separator=a.renderSeparator(m,b);if(f){var n=l.separator;n.translate(m-n.getBBox().width,b)}m+=g(l.separator,b)}c[h.level].updated=!0}else p=a.renderButton(h,m,b),f&&p.translate(m-p.getBBox().width,b),m+=g(p,b),q||(n=a.renderSeparator(m,b),f&&n.translate(m-n.getBBox().width,
b),m+=g(n,b)),c[h.level]={button:p,separator:n,updated:!0};p&&p.setState(q?2:0)})};a.defaultBreadcrumbsOptions={buttonTheme:{fill:"none",height:18,padding:2,"stroke-width":0,zIndex:7,states:{select:{fill:"none"}},style:{color:"#335cad"}},buttonSpacing:5,floating:!1,format:void 0,relativeTo:"plotBox",rtl:!1,position:{align:"left",verticalAlign:"top",x:0,y:void 0},separator:{text:"/",style:{color:"#666666"}},showFullPath:!0,style:{},useHTML:!1,zIndex:7};return a}();b.Breadcrumbs||(b.Breadcrumbs=e,l(a,
"getMargins",function(){var a=this.breadcrumbs;if(a&&!a.options.floating&&a.level){var b=a.options,c=b.buttonTheme;c=(c.height||0)+2*(c.padding||0)+b.buttonSpacing;b=b.position.verticalAlign;"bottom"===b?(this.marginBottom=(this.marginBottom||0)+c,a.yOffset=c):"middle"!==b?(this.plotTop+=c,a.yOffset=-c):a.yOffset=void 0}}),l(a,"redraw",function(){this.breadcrumbs&&this.breadcrumbs.redraw()}),l(a,"destroy",function(){this.breadcrumbs&&(this.breadcrumbs.destroy(),this.breadcrumbs=void 0)}),l(a,"afterShowResetZoom",
function(){if(this.breadcrumbs){var a=this.resetZoomButton&&this.resetZoomButton.getBBox(),b=this.breadcrumbs.options;a&&"right"===b.position.align&&"plotBox"===b.relativeTo&&this.breadcrumbs.alignBreadcrumbsGroup(-a.width-b.buttonSpacing)}}),l(a,"selection",function(a){!0===a.resetSelection&&this.breadcrumbs&&this.breadcrumbs.alignBreadcrumbsGroup()}));"";return e});u(a,"Series/Treemap/TreemapComposition.js",[a["Core/Series/SeriesRegistry.js"],a["Series/Treemap/TreemapUtilities.js"],a["Core/Utilities.js"]],
function(a,e,b){var m=b.addEvent,l=b.extend,n=!1;m(a.series,"afterBindAxes",function(){var a=this.xAxis,b=this.yAxis;if(a&&b)if(this.is("treemap")){var g={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:e.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]};l(b.options,g);l(a.options,g);n=!0}else n&&(b.setOptions(b.userOptions),a.setOptions(a.userOptions),n=!1)})});u(a,"Series/Treemap/TreemapNode.js",[],function(){return function(){function a(){this.childrenTotal=0;
this.visible=!1}a.prototype.init=function(a,b,m,l,n,p,k){this.id=a;this.i=b;this.children=m;this.height=l;this.level=n;this.series=p;this.parent=k;return this};return a}()});u(a,"Series/Treemap/TreemapSeries.js",[a["Core/Color/Color.js"],a["Series/ColorMapComposition.js"],a["Core/Globals.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Treemap/TreemapAlgorithmGroup.js"],a["Series/Treemap/TreemapPoint.js"],a["Series/Treemap/TreemapUtilities.js"],a["Series/TreeUtilities.js"],
a["Extensions/Breadcrumbs.js"],a["Core/Utilities.js"],a["Series/Treemap/TreemapNode.js"]],function(a,e,b,m,l,n,p,k,g,c,f,u){var E=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var b in d)Object.prototype.hasOwnProperty.call(d,b)&&(a[b]=d[b])};return a(b,d)};return function(b,d){function r(){this.constructor=b}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+
String(d)+" is not a constructor or null");a(b,d);b.prototype=null===d?Object.create(d):(r.prototype=d.prototype,new r)}}(),v=a.parse;a=b.noop;var h=l.series;b=l.seriesTypes;var q=b.column,w=b.heatmap,x=b.scatter,J=g.getColor,K=g.getLevelOptions,L=g.updateRootId,B=f.addEvent,M=f.correctFloat,A=f.defined,N=f.error,D=f.extend,O=f.fireEvent,I=f.isArray,P=f.isObject,G=f.isString,z=f.merge,y=f.pick,Q=f.stableSort;g=function(a){function b(){var d=null!==a&&a.apply(this,arguments)||this;d.axisRatio=void 0;
d.data=void 0;d.mapOptionsToLevel=void 0;d.nodeMap=void 0;d.nodeList=void 0;d.options=void 0;d.points=void 0;d.rootNode=void 0;d.tree=void 0;d.level=void 0;return d}E(b,a);b.prototype.algorithmCalcPoints=function(a,b,c,e){var d,r,t,f,F=c.lW,h=c.lH,g=c.plot,k=0,m=c.elArr.length-1;if(b)F=c.nW,h=c.nH;else var l=c.elArr[c.elArr.length-1];c.elArr.forEach(function(a){if(b||k<m)0===c.direction?(d=g.x,r=g.y,t=F,f=a/t):(d=g.x,r=g.y,f=h,t=a/f),e.push({x:d,y:r,width:t,height:M(f)}),0===c.direction?g.y+=f:g.x+=
t;k+=1});c.reset();0===c.direction?c.width-=F:c.height-=h;g.y=g.parent.y+(g.parent.height-c.height);g.x=g.parent.x+(g.parent.width-c.width);a&&(c.direction=1-c.direction);b||c.addElement(l)};b.prototype.algorithmFill=function(a,b,c){var d=[],r,t=b.direction,e=b.x,f=b.y,g=b.width,h=b.height,k,m,l,n;c.forEach(function(c){r=c.val/b.val*b.height*b.width;k=e;m=f;0===t?(n=h,l=r/n,g-=l,e+=l):(l=g,n=r/l,h-=n,f+=n);d.push({x:k,y:m,width:l,height:n});a&&(t=1-t)});return d};b.prototype.algorithmLowAspectRatio=
function(a,b,c){var d=[],r=this,t,e={x:b.x,y:b.y,parent:b},f=0,g=c.length-1,h=new n(b.height,b.width,b.direction,e);c.forEach(function(c){t=c.val/b.val*b.height*b.width;h.addElement(t);h.lP.nR>h.lP.lR&&r.algorithmCalcPoints(a,!1,h,d,e);f===g&&r.algorithmCalcPoints(a,!0,h,d,e);f+=1});return d};b.prototype.alignDataLabel=function(a,b,c){var d=c.style;d&&!A(d.textOverflow)&&b.text&&b.getBBox().width>b.text.textWidth&&b.css({textOverflow:"ellipsis",width:d.width+="px"});q.prototype.alignDataLabel.apply(this,
arguments);a.dataLabel&&a.dataLabel.attr({zIndex:(a.node.zIndex||0)+1})};b.prototype.calculateChildrenAreas=function(a,b){var d=this,c=d.options,r=d.mapOptionsToLevel[a.level+1],e=y(d[r&&r.layoutAlgorithm]&&r.layoutAlgorithm,c.layoutAlgorithm),f=c.alternateStartingDirection,g=[];a=a.children.filter(function(a){return!a.ignore});r&&r.layoutStartingDirection&&(b.direction="vertical"===r.layoutStartingDirection?0:1);g=d[e](b,a);a.forEach(function(a,c){c=g[c];a.values=z(c,{val:a.childrenTotal,direction:f?
1-b.direction:b.direction});a.pointValues=z(c,{x:c.x/d.axisRatio,y:k.AXIS_MAX-c.y-c.height,width:c.width/d.axisRatio});a.children.length&&d.calculateChildrenAreas(a,a.values)})};b.prototype.createList=function(a){var b=this.chart,d=[];if(b.breadcrumbs){var c=0;d.push({level:c,levelOptions:b.series[0]});b=a.target.nodeMap[a.newRootId];for(var e=[];b.parent||""===b.parent;)e.push(b),b=a.target.nodeMap[b.parent];e.reverse().forEach(function(a){d.push({level:++c,levelOptions:a})});1>=d.length&&(d.length=
0)}return d};b.prototype.drawDataLabels=function(){var a=this,b=a.mapOptionsToLevel,c,e;a.points.filter(function(a){return a.node.visible}).forEach(function(d){e=b[d.node.level];c={style:{}};d.node.isLeaf||(c.enabled=!1);e&&e.dataLabels&&(c=z(c,e.dataLabels),a._hasPointLabels=!0);d.shapeArgs&&(c.style.width=d.shapeArgs.width,d.dataLabel&&d.dataLabel.css({width:d.shapeArgs.width+"px"}));d.dlOptions=z(c,d.options.dataLabels)});h.prototype.drawDataLabels.call(this)};b.prototype.drawPoints=function(a){void 0===
a&&(a=this.points);var b=this,d=b.chart,c=d.renderer,e=d.styledMode,f=b.options,g=e?{}:f.shadow,h=f.borderRadius,k=d.pointCount<f.animationLimit,l=f.allowTraversingTree;a.forEach(function(a){var d=a.node.levelDynamic,r={},H={},t={},C="level-group-"+a.node.level,m=!!a.graphic,R=k&&m,n=a.shapeArgs;a.shouldDraw()&&(a.isInside=!0,h&&(H.r=h),z(!0,R?r:H,m?n:{},e?{}:b.pointAttribs(a,a.selected?"select":void 0)),b.colorAttribs&&e&&D(t,b.colorAttribs(a)),b[C]||(b[C]=c.g(C).attr({zIndex:1E3-(d||0)}).add(b.group),
b[C].survive=!0));a.draw({animatableAttribs:r,attribs:H,css:t,group:b[C],renderer:c,shadow:g,shapeArgs:n,shapeType:a.shapeType});l&&a.graphic&&(a.drillId=f.interactByLeaf?b.drillToByLeaf(a):b.drillToByGroup(a))})};b.prototype.drillToByGroup=function(a){var b=!1;1!==a.node.level-this.nodeMap[this.rootNode].level||a.node.isLeaf||(b=a.id);return b};b.prototype.drillToByLeaf=function(a){var b=!1;if(a.node.parent!==this.rootNode&&a.node.isLeaf)for(a=a.node;!b;)a=this.nodeMap[a.parent],a.parent===this.rootNode&&
(b=a.id);return b};b.prototype.drillToNode=function(a,b){N(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"});this.setRootNode(a,b)};b.prototype.drillUp=function(){var a=this.nodeMap[this.rootNode];a&&G(a.parent)&&this.setRootNode(a.parent,!0,{trigger:"traverseUpButton"})};b.prototype.getExtremes=function(){var a=h.prototype.getExtremes.call(this,this.colorValueData),b=a.dataMax;this.valueMin=a.dataMin;this.valueMax=b;return h.prototype.getExtremes.call(this)};b.prototype.getListOfParents=
function(a,b){a=I(a)?a:[];var d=I(b)?b:[];b=a.reduce(function(a,b,d){b=y(b.parent,"");"undefined"===typeof a[b]&&(a[b]=[]);a[b].push(d);return a},{"":[]});k.eachObject(b,function(a,b,c){""!==b&&-1===d.indexOf(b)&&(a.forEach(function(a){c[""].push(a)}),delete c[b])});return b};b.prototype.getTree=function(){var a=this.data.map(function(a){return a.id});a=this.getListOfParents(this.data,a);this.nodeMap={};this.nodeList=[];return this.buildTree("",-1,0,a)};b.prototype.buildTree=function(a,b,c,e,f){var d=
this,g=[],r=d.points[b],h=0,t;(e[a]||[]).forEach(function(b){t=d.buildTree(d.points[b].id,b,c+1,e,a);h=Math.max(t.height+1,h);g.push(t)});var k=(new d.NodeClass).init(a,b,g,h,c,d,f);g.forEach(function(a){a.parentNode=k});d.nodeMap[k.id]=k;d.nodeList.push(k);r&&(r.node=k,k.point=r);return k};b.prototype.hasData=function(){return!!this.processedXData.length};b.prototype.init=function(a,b){var d=this,e=z(b.drillUpButton,b.breadcrumbs);var f=B(d,"setOptions",function(a){a=a.userOptions;A(a.allowDrillToNode)&&
!A(a.allowTraversingTree)&&(a.allowTraversingTree=a.allowDrillToNode,delete a.allowDrillToNode);A(a.drillUpButton)&&!A(a.traverseUpButton)&&(a.traverseUpButton=a.drillUpButton,delete a.drillUpButton)});h.prototype.init.call(d,a,b);delete d.opacity;d.eventsToUnbind.push(f);d.options.allowTraversingTree&&(d.eventsToUnbind.push(B(d,"click",d.onClickDrillToNode)),d.eventsToUnbind.push(B(d,"setRootNode",function(a){var b=d.chart;b.breadcrumbs&&b.breadcrumbs.updateProperties(d.createList(a))})),d.eventsToUnbind.push(B(d,
"update",function(a,b){(b=this.chart.breadcrumbs)&&a.options.breadcrumbs&&b.update(a.options.breadcrumbs)})),d.eventsToUnbind.push(B(d,"destroy",function(a){var b=this.chart;b.breadcrumbs&&(b.breadcrumbs.destroy(),a.keepEventsForUpdate||(b.breadcrumbs=void 0))})));a.breadcrumbs||(a.breadcrumbs=new c(a,e));d.eventsToUnbind.push(B(a.breadcrumbs,"up",function(a){a=this.level-a.newLevel;for(var b=0;b<a;b++)d.drillUp()}))};b.prototype.onClickDrillToNode=function(a){var b=(a=a.point)&&a.drillId;G(b)&&(a.setState(""),
this.setRootNode(b,!0,{trigger:"click"}))};b.prototype.pointAttribs=function(a,b){var c=P(this.mapOptionsToLevel)?this.mapOptionsToLevel:{},d=a&&c[a.node.level]||{};c=this.options;var e=b&&c.states&&c.states[b]||{},f=a&&a.getClassName()||"";a={stroke:a&&a.borderColor||d.borderColor||e.borderColor||c.borderColor,"stroke-width":y(a&&a.borderWidth,d.borderWidth,e.borderWidth,c.borderWidth),dashstyle:a&&a.borderDashStyle||d.borderDashStyle||e.borderDashStyle||c.borderDashStyle,fill:a&&a.color||this.color};
-1!==f.indexOf("highcharts-above-level")?(a.fill="none",a["stroke-width"]=0):-1!==f.indexOf("highcharts-internal-node-interactive")?(b=y(e.opacity,c.opacity),a.fill=v(a.fill).setOpacity(b).get(),a.cursor="pointer"):-1!==f.indexOf("highcharts-internal-node")?a.fill="none":b&&(a.fill=v(a.fill).brighten(e.brightness).get());return a};b.prototype.setColorRecursive=function(a,b,c,e,f){var d=this,g=d&&d.chart;g=g&&g.options&&g.options.colors;if(a){var h=J(a,{colors:g,index:e,mapOptionsToLevel:d.mapOptionsToLevel,
parentColor:b,parentColorIndex:c,series:d,siblings:f});if(b=d.points[a.i])b.color=h.color,b.colorIndex=h.colorIndex;(a.children||[]).forEach(function(b,c){d.setColorRecursive(b,h.color,h.colorIndex,c,a.children.length)})}};b.prototype.setPointValues=function(){var a=this,b=a.xAxis,c=a.yAxis,e=a.chart.styledMode;a.points.forEach(function(d){var f=d.node,g=f.pointValues;f=f.visible;if(g&&f){f=g.height;var h=g.width,k=g.x,r=g.y,l=e?0:(a.pointAttribs(d)["stroke-width"]||0)%2/2;g=Math.round(b.toPixels(k,
!0))-l;h=Math.round(b.toPixels(k+h,!0))-l;k=Math.round(c.toPixels(r,!0))-l;f=Math.round(c.toPixels(r+f,!0))-l;f={x:Math.min(g,h),y:Math.min(k,f),width:Math.abs(h-g),height:Math.abs(f-k)};d.plotX=f.x+f.width/2;d.plotY=f.y+f.height/2;d.shapeArgs=f}else delete d.plotX,delete d.plotY})};b.prototype.setRootNode=function(a,b,c){a=D({newRootId:a,previousRootId:this.rootNode,redraw:y(b,!0),series:this},c);O(this,"setRootNode",a,function(a){var b=a.series;b.idPreviousRoot=a.previousRootId;b.rootNode=a.newRootId;
b.isDirty=!0;a.redraw&&b.chart.redraw()})};b.prototype.setState=function(a){this.options.inactiveOtherPoints=!0;h.prototype.setState.call(this,a,!1);this.options.inactiveOtherPoints=!1};b.prototype.setTreeValues=function(a){var b=this,c=b.options,d=b.nodeMap[b.rootNode];c=k.isBoolean(c.levelIsConstant)?c.levelIsConstant:!0;var e=0,f=[],g=b.points[a.i];a.children.forEach(function(a){a=b.setTreeValues(a);f.push(a);a.ignore||(e+=a.val)});Q(f,function(a,b){return(a.sortIndex||0)-(b.sortIndex||0)});var h=
y(g&&g.options.value,e);g&&(g.value=h);D(a,{children:f,childrenTotal:e,ignore:!(y(g&&g.visible,!0)&&0<h),isLeaf:a.visible&&!e,levelDynamic:a.level-(c?0:d.level),name:y(g&&g.name,""),sortIndex:y(g&&g.sortIndex,-h),val:h});return a};b.prototype.sliceAndDice=function(a,b){return this.algorithmFill(!0,a,b)};b.prototype.squarified=function(a,b){return this.algorithmLowAspectRatio(!0,a,b)};b.prototype.strip=function(a,b){return this.algorithmLowAspectRatio(!1,a,b)};b.prototype.stripes=function(a,b){return this.algorithmFill(!1,
a,b)};b.prototype.translate=function(){var a=this,b=a.options,c=L(a);h.prototype.translate.call(a);var e=a.tree=a.getTree();var f=a.nodeMap[c];""===c||f&&f.children.length||(a.setRootNode("",!1),c=a.rootNode,f=a.nodeMap[c]);a.mapOptionsToLevel=K({from:f.level+1,levels:b.levels,to:e.height,defaults:{levelIsConstant:a.options.levelIsConstant,colorByPoint:b.colorByPoint}});k.recursive(a.nodeMap[a.rootNode],function(b){var c=!1,d=b.parent;b.visible=!0;if(d||""===d)c=a.nodeMap[d];return c});k.recursive(a.nodeMap[a.rootNode].children,
function(a){var b=!1;a.forEach(function(a){a.visible=!0;a.children.length&&(b=(b||[]).concat(a.children))});return b});a.setTreeValues(e);a.axisRatio=a.xAxis.len/a.yAxis.len;a.nodeMap[""].pointValues=c={x:0,y:0,width:k.AXIS_MAX,height:k.AXIS_MAX};a.nodeMap[""].values=c=z(c,{width:c.width*a.axisRatio,direction:"vertical"===b.layoutStartingDirection?0:1,val:e.val});a.calculateChildrenAreas(e,c);a.colorAxis||b.colorByPoint||a.setColorRecursive(a.tree);b.allowTraversingTree&&(b=f.pointValues,a.xAxis.setExtremes(b.x,
b.x+b.width,!1),a.yAxis.setExtremes(b.y,b.y+b.height,!1),a.xAxis.setScale(),a.yAxis.setScale());a.setPointValues()};b.defaultOptions=z(x.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var a=this&&this.point?this.point:{};return G(a.name)?a.name:""},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,
layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:"#e6e6e6",borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:"#999999",brightness:w?0:.1,halo:!1,opacity:.75,shadow:!1}}});return b}(x);D(g.prototype,{buildKDTree:a,colorAttribs:e.seriesMembers.colorAttribs,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:m.drawRectangle,getExtremesFromAll:!0,
getSymbol:a,optionalAxis:"colorAxis",parallelArrays:["x","y","value","colorValue"],pointArrayMap:["value"],pointClass:p,NodeClass:u,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:k.recursive}});e.compose(g);l.registerSeriesType("treemap",g);"";return g});u(a,"masters/modules/treemap.src.js",[a["Core/Globals.js"],a["Extensions/Breadcrumbs.js"]],function(a,e){a.Breadcrumbs=e})});
//# sourceMappingURL=treemap.js.map