/*
 Highmaps JS v7.2.1 (2019-10-31)

 Highmaps as a plugin for Highcharts or Highstock.

 (c) 2011-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(h){"object"===typeof module&&module.exports?(h["default"]=h,module.exports=h):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(y){h(y);h.Highcharts=y;return h}):h("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(h){function y(a,b,h,n){a.hasOwnProperty(b)||(a[b]=n.apply(null,h))}h=h?h._modules:{};y(h,"parts-map/MapAxis.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.pick;b=a.addEvent;a=a.Axis;b(a,"getSeriesExtremes",
function(){var a=[];this.isXAxis&&(this.series.forEach(function(t,b){t.useMapGeometry&&(a[b]=t.xData,t.xData=[])}),this.seriesXData=a)});b(a,"afterGetSeriesExtremes",function(){var a=this.seriesXData,t;if(this.isXAxis){var b=h(this.dataMin,Number.MAX_VALUE);var p=h(this.dataMax,-Number.MAX_VALUE);this.series.forEach(function(n,w){n.useMapGeometry&&(b=Math.min(b,h(n.minX,b)),p=Math.max(p,h(n.maxX,p)),n.xData=a[w],t=!0)});t&&(this.dataMin=b,this.dataMax=p);delete this.seriesXData}});b(a,"afterSetAxisTranslation",
function(){var a=this.chart;var b=a.plotWidth/a.plotHeight;a=a.xAxis[0];var w;"yAxis"===this.coll&&void 0!==a.transA&&this.series.forEach(function(a){a.preserveAspectRatio&&(w=!0)});if(w&&(this.transA=a.transA=Math.min(this.transA,a.transA),b/=(a.max-a.min)/(this.max-this.min),b=1>b?this:a,a=(b.max-b.min)*b.transA,b.pixelPadding=b.len-a,b.minPixelPadding=b.pixelPadding/2,a=b.fixTo)){a=a[1]-b.toValue(a[0],!0);a*=b.transA;if(Math.abs(a)>b.minPixelPadding||b.min===b.dataMin&&b.max===b.dataMax)a=0;b.minPixelPadding-=
a}});b(a,"render",function(){this.fixTo=null})});y(h,"parts-map/ColorSeriesMixin.js",[h["parts/Globals.js"]],function(a){a.colorPointMixin={setVisible:function(a){var b=this,h=a?"show":"hide";b.visible=!!a;["graphic","dataLabel"].forEach(function(a){if(b[a])b[a][h]()})}};a.colorSeriesMixin={optionalAxis:"colorAxis",colorAxis:0,translateColors:function(){var a=this,h=this.options.nullColor,n=this.colorAxis,t=this.colorKey;(this.data.length?this.data:this.points).forEach(function(b){var w=b[t];if(w=
b.options.color||(b.isNull?h:n&&void 0!==w?n.toColor(w,b):b.color||a.color))b.color=w})}}});y(h,"parts-map/ColorAxis.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.erase,n=b.extend,t=b.isNumber,w=b.pick,p=b.splat;b=a.addEvent;var u=a.Axis,r=a.Chart,g=a.Series,d=a.Point,m=a.color,x=a.Legend,q=a.LegendSymbolMixin,l=a.colorPointMixin,e=a.noop,k=a.merge;n(g.prototype,a.colorSeriesMixin);n(d.prototype,l);var c=a.ColorAxis=function(){this.init.apply(this,arguments)};n(c.prototype,
u.prototype);n(c.prototype,{defaultColorAxisOptions:{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0},keepProps:["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"].concat(u.prototype.keepProps),init:function(f,c){this.coll="colorAxis";var v=this.buildOptions.call(f,
this.defaultColorAxisOptions,c);u.prototype.init.call(this,f,v);c.dataClasses&&this.initDataClasses(c);this.initStops();this.horiz=!v.opposite;this.zoomEnabled=!1;this.defaultLegendLength=200},initDataClasses:function(f){var c=this.chart,z,e=0,a=c.options.chart.colorCount,d=this.options,b=f.dataClasses.length;this.dataClasses=z=[];this.legendItems=[];f.dataClasses.forEach(function(f,v){f=k(f);z.push(f);if(c.styledMode||!f.color)"category"===d.dataClassColor?(c.styledMode||(v=c.options.colors,a=v.length,
f.color=v[e]),f.colorIndex=e,e++,e===a&&(e=0)):f.color=m(d.minColor).tweenTo(m(d.maxColor),2>b?.5:v/(b-1))})},hasData:function(){return!(!this.tickPositions||!this.tickPositions.length)},setTickPositions:function(){if(!this.dataClasses)return u.prototype.setTickPositions.call(this)},initStops:function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(f){f.color=m(f[1])})},buildOptions:function(f,c){var v=this.options.legend,e=c.layout?
"vertical"!==c.layout:"vertical"!==v.layout;return k(f,{side:e?2:1,reversed:!e},c,{opposite:!e,showEmpty:!1,title:null,visible:v.enabled&&(c?!1!==c.visible:!0)})},setOptions:function(f){u.prototype.setOptions.call(this,f);this.options.crosshair=this.options.marker},setAxisSize:function(){var f=this.legendSymbol,c=this.chart,e=c.options.legend||{},a,k;f?(this.left=e=f.attr("x"),this.top=a=f.attr("y"),this.width=k=f.attr("width"),this.height=f=f.attr("height"),this.right=c.chartWidth-e-k,this.bottom=
c.chartHeight-a-f,this.len=this.horiz?k:f,this.pos=this.horiz?e:a):this.len=(this.horiz?e.symbolWidth:e.symbolHeight)||this.defaultLegendLength},normalizedValue:function(f){this.isLog&&(f=this.val2lin(f));return 1-(this.max-f)/(this.max-this.min||1)},toColor:function(f,c){var e=this.stops,v=this.dataClasses,a;if(v)for(a=v.length;a--;){var k=v[a];var d=k.from;e=k.to;if((void 0===d||f>=d)&&(void 0===e||f<=e)){var b=k.color;c&&(c.dataClass=a,c.colorIndex=k.colorIndex);break}}else{f=this.normalizedValue(f);
for(a=e.length;a--&&!(f>e[a][0]););d=e[a]||e[a+1];e=e[a+1]||d;f=1-(e[0]-f)/(e[0]-d[0]||1);b=d.color.tweenTo(e.color,f)}return b},getOffset:function(){var f=this.legendGroup,c=this.chart.axisOffset[this.side];f&&(this.axisParent=f,u.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=c)},setLegendColor:function(){var f=this.reversed;var c=f?1:0;f=f?0:1;c=this.horiz?[c,0,f,0]:[0,f,0,c];this.legendColor={linearGradient:{x1:c[0],
y1:c[1],x2:c[2],y2:c[3]},stops:this.stops}},drawLegendSymbol:function(f,c){var e=f.padding,a=f.options,v=this.horiz,k=w(a.symbolWidth,v?this.defaultLegendLength:12),d=w(a.symbolHeight,v?12:this.defaultLegendLength),b=w(a.labelPadding,v?16:30);a=w(a.itemDistance,10);this.setLegendColor();c.legendSymbol=this.chart.renderer.rect(0,f.baseline-11,k,d).attr({zIndex:1}).add(c.legendGroup);this.legendItemWidth=k+e+(v?a:b);this.legendItemHeight=d+e+(v?b:0)},setState:function(f){this.series.forEach(function(c){c.setState(f)})},
visible:!0,setVisible:e,getSeriesExtremes:function(){var f=this.series,c=f.length,e;this.dataMin=Infinity;for(this.dataMax=-Infinity;c--;){var a=f[c];var k=a.colorKey=w(a.options.colorKey,a.colorKey,a.pointValKey,a.zoneAxis,"y");var d=a.pointArrayMap;var b=a[k+"Min"]&&a[k+"Max"];if(a[k+"Data"])var m=a[k+"Data"];else if(d){m=[];d=d.indexOf(k);var l=a.yData;if(0<=d&&l)for(e=0;e<l.length;e++)m.push(w(l[e][d],l[e]))}else m=a.yData;b?(a.minColorValue=a[k+"Min"],a.maxColorValue=a[k+"Max"]):(g.prototype.getExtremes.call(a,
m),a.minColorValue=a.dataMin,a.maxColorValue=a.dataMax);void 0!==a.minColorValue&&(this.dataMin=Math.min(this.dataMin,a.minColorValue),this.dataMax=Math.max(this.dataMax,a.maxColorValue));b||g.prototype.getExtremes.call(a)}},drawCrosshair:function(f,c){var a=c&&c.plotX,e=c&&c.plotY,k=this.pos,v=this.len;if(c){var d=this.toPixels(c[c.series.colorKey]);d<k?d=k-2:d>k+v&&(d=k+v+2);c.plotX=d;c.plotY=this.len-d;u.prototype.drawCrosshair.call(this,f,c);c.plotX=a;c.plotY=e;this.cross&&!this.cross.addedToColorAxis&&
this.legendGroup&&(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,this.chart.styledMode||this.cross.attr({fill:this.crosshair.color}))}},getPlotLinePath:function(f){var c=f.translatedValue;return t(c)?this.horiz?["M",c-4,this.top-6,"L",c+4,this.top-6,c,this.top,"Z"]:["M",this.left,c,"L",this.left-6,c+6,this.left-6,c-6,"Z"]:u.prototype.getPlotLinePath.apply(this,arguments)},update:function(f,c){var a=this.chart,e=a.legend,d=this.buildOptions.call(a,
{},f);this.series.forEach(function(f){f.isDirtyData=!0});(f.dataClasses&&e.allItems||this.dataClasses)&&this.destroyItems();a.options[this.coll]=k(this.userOptions,d);u.prototype.update.call(this,d,c);this.legendItem&&(this.setLegendColor(),e.colorizeItem(this,!0))},destroyItems:function(){var f=this.chart;this.legendItem?f.legend.destroyItem(this):this.legendItems&&this.legendItems.forEach(function(c){f.legend.destroyItem(c)});f.isDirtyLegend=!0},remove:function(f){this.destroyItems();u.prototype.remove.call(this,
f)},getDataClassLegendSymbols:function(){var f=this,c=this.chart,d=this.legendItems,k=c.options.legend,b=k.valueDecimals,m=k.valueSuffix||"",g;d.length||this.dataClasses.forEach(function(k,v){var z=!0,l=k.from,A=k.to;g="";void 0===l?g="< ":void 0===A&&(g="> ");void 0!==l&&(g+=a.numberFormat(l,b)+m);void 0!==l&&void 0!==A&&(g+=" - ");void 0!==A&&(g+=a.numberFormat(A,b)+m);d.push(n({chart:c,name:g,options:{},drawLegendSymbol:q.drawRectangle,visible:!0,setState:e,isDataClass:!0,setVisible:function(){z=
this.visible=!z;f.series.forEach(function(f){f.points.forEach(function(f){f.dataClass===v&&f.setVisible(z)})});c.legend.colorizeItem(this,z)}},k))});return d},beforePadding:!1,name:""});["fill","stroke"].forEach(function(f){a.Fx.prototype[f+"Setter"]=function(){this.elem.attr(f,m(this.start).tweenTo(m(this.end),this.pos),null,!0)}});b(r,"afterGetAxes",function(){var f=this,a=f.options;this.colorAxis=[];a.colorAxis&&(a.colorAxis=p(a.colorAxis),a.colorAxis.forEach(function(a,e){a.index=e;new c(f,a)}))});
b(g,"bindAxes",function(){var f=this.axisTypes;f?-1===f.indexOf("colorAxis")&&f.push("colorAxis"):this.axisTypes=["colorAxis"]});b(x,"afterGetAllItems",function(f){var c=[],a,e;(this.chart.colorAxis||[]).forEach(function(e){(a=e.options)&&a.showInLegend&&(a.dataClasses&&a.visible?c=c.concat(e.getDataClassLegendSymbols()):a.visible&&c.push(e),e.series.forEach(function(c){if(!c.options.showInLegend||a.dataClasses)"point"===c.options.legendType?c.points.forEach(function(c){h(f.allItems,c)}):h(f.allItems,
c)}))});for(e=c.length;e--;)f.allItems.unshift(c[e])});b(x,"afterColorizeItem",function(c){c.visible&&c.item.legendColor&&c.item.legendSymbol.attr({fill:c.item.legendColor})});b(x,"afterUpdate",function(){var c=this.chart.colorAxis;c&&c.forEach(function(c,f,a){c.update({},a)})});b(g,"afterTranslate",function(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()})});y(h,"parts-map/ColorMapSeriesMixin.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,
b){var h=b.defined;b=a.noop;var n=a.seriesTypes;a.colorMapPointMixin={dataLabelOnNull:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value},setState:function(b){a.Point.prototype.setState.call(this,b);this.graphic&&this.graphic.attr({zIndex:"hover"===b?1:0})}};a.colorMapSeriesMixin={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:b,parallelArrays:["x","y","value"],colorKey:"value",
pointAttribs:n.column.prototype.pointAttribs,colorAttribs:function(a){var b={};h(a.color)&&(b[this.colorProp||"fill"]=a.color);return b}}});y(h,"parts-map/MapNavigation.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){function h(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function n(a){this.init(a)}var t=b.extend,w=b.objectEach,p=b.pick,u=a.addEvent;b=a.Chart;var r=a.doc,g=a.merge;n.prototype.init=function(a){this.chart=a;
a.mapNavButtons=[]};n.prototype.update=function(a){var d=this.chart,b=d.options.mapNavigation,q,l,e,k,c,f=function(c){this.handler.call(d,c);h(c)},v=d.mapNavButtons;a&&(b=d.options.mapNavigation=g(d.options.mapNavigation,a));for(;v.length;)v.pop().destroy();p(b.enableButtons,b.enabled)&&!d.renderer.forExport&&w(b.buttons,function(a,m){q=g(b.buttonOptions,a);d.styledMode||(l=q.theme,l.style=g(q.theme.style,q.style),k=(e=l.states)&&e.hover,c=e&&e.select);a=d.renderer.button(q.text,0,0,f,l,k,c,0,"zoomIn"===
m?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[m]).attr({width:q.width,height:q.height,title:d.options.lang[m],padding:q.padding,zIndex:5}).add();a.handler=q.onclick;a.align(t(q,{width:a.width,height:2*a.height}),null,q.alignTo);u(a.element,"dblclick",h);v.push(a)});this.updateEvents(b)};n.prototype.updateEvents=function(a){var d=this.chart;p(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||
u(d.container,"dblclick",function(a){d.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());p(a.enableMouseWheelZoom,a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||u(d.container,void 0===r.onmousewheel?"DOMMouseScroll":"mousewheel",function(a){d.pointer.onContainerMouseWheel(a);h(a);return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};t(b.prototype,{fitToBox:function(a,b){[["x","width"],["y","height"]].forEach(function(d){var g=
d[0];d=d[1];a[g]+a[d]>b[g]+b[d]&&(a[d]>b[d]?(a[d]=b[d],a[g]=b[g]):a[g]=b[g]+b[d]-a[d]);a[d]>b[d]&&(a[d]=b[d]);a[g]<b[g]&&(a[g]=b[g])});return a},mapZoom:function(a,b,g,h,l){var e=this.xAxis[0],k=e.max-e.min,c=p(b,e.min+k/2),f=k*a;k=this.yAxis[0];var d=k.max-k.min,z=p(g,k.min+d/2);d*=a;c=this.fitToBox({x:c-f*(h?(h-e.pos)/e.len:.5),y:z-d*(l?(l-k.pos)/k.len:.5),width:f,height:d},{x:e.dataMin,y:k.dataMin,width:e.dataMax-e.dataMin,height:k.dataMax-k.dataMin});f=c.x<=e.dataMin&&c.width>=e.dataMax-e.dataMin&&
c.y<=k.dataMin&&c.height>=k.dataMax-k.dataMin;h&&(e.fixTo=[h-e.pos,b]);l&&(k.fixTo=[l-k.pos,g]);void 0===a||f?(e.setExtremes(void 0,void 0,!1),k.setExtremes(void 0,void 0,!1)):(e.setExtremes(c.x,c.x+c.width,!1),k.setExtremes(c.y,c.y+c.height,!1));this.redraw()}});u(b,"beforeRender",function(){this.mapNavigation=new n(this);this.mapNavigation.update()});a.MapNavigation=n});y(h,"parts-map/MapPointer.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.extend,n=b.pick;b=a.Pointer;
a=a.wrap;h(b.prototype,{onContainerDblClick:function(a){var b=this.chart;a=this.normalize(a);b.options.mapNavigation.enableDoubleClickZoomTo?b.pointer.inClass(a.target,"highcharts-tracker")&&b.hoverPoint&&b.hoverPoint.zoomTo():b.isInsidePlot(a.chartX-b.plotLeft,a.chartY-b.plotTop)&&b.mapZoom(.5,b.xAxis[0].toValue(a.chartX),b.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)},onContainerMouseWheel:function(a){var b=this.chart;a=this.normalize(a);var h=a.detail||-(a.wheelDelta/120);b.isInsidePlot(a.chartX-
b.plotLeft,a.chartY-b.plotTop)&&b.mapZoom(Math.pow(b.options.mapNavigation.mouseWheelSensitivity,h),b.xAxis[0].toValue(a.chartX),b.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)}});a(b.prototype,"zoomOption",function(a){var b=this.chart.options.mapNavigation;n(b.enableTouchZoom,b.enabled)&&(this.chart.options.chart.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});a(b.prototype,"pinchTranslate",function(a,b,h,n,r,g,d){a.call(this,b,h,n,r,g,d);"map"===this.chart.options.chart.type&&this.hasZoom&&
(a=n.scaleX>n.scaleY,this.pinchTranslateDirection(!a,b,h,n,r,g,d,a?n.scaleX:n.scaleY))})});y(h,"parts-map/MapSeries.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.extend,n=b.isArray,t=b.isNumber,w=b.objectEach,p=b.pick,u=b.splat;b=a.colorMapPointMixin;var r=a.merge,g=a.noop,d=a.fireEvent,m=a.Point,x=a.Series,q=a.seriesType,l=a.seriesTypes;q("map","scatter",{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},
marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#cccccc",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"},inactive:{opacity:1}}},r(a.colorMapSeriesMixin,{type:"map",getExtremesFromAll:!0,useMapGeometry:!0,forceDL:!0,searchPoint:g,directTouch:!0,preserveAspectRatio:!0,pointArrayMap:["value"],setOptions:function(a){a=
x.prototype.setOptions.call(this,a);var e=a.joinBy;null===e&&(e="_i");e=this.joinBy=u(e);e[1]||(e[1]=e[0]);return a},getBox:function(e){var b=Number.MAX_VALUE,c=-b,f=b,d=-b,g=b,m=b,l=this.xAxis,h=this.yAxis,r;(e||[]).forEach(function(e){if(e.path){"string"===typeof e.path&&(e.path=a.splitPath(e.path));var k=e.path||[],v=k.length,z=!1,l=-b,h=b,A=-b,B=b,C=e.properties;if(!e._foundBox){for(;v--;)t(k[v])&&(z?(l=Math.max(l,k[v]),h=Math.min(h,k[v])):(A=Math.max(A,k[v]),B=Math.min(B,k[v])),z=!z);e._midX=
h+(l-h)*p(e.middleX,C&&C["hc-middle-x"],.5);e._midY=B+(A-B)*p(e.middleY,C&&C["hc-middle-y"],.5);e._maxX=l;e._minX=h;e._maxY=A;e._minY=B;e.labelrank=p(e.labelrank,(l-h)*(A-B));e._foundBox=!0}c=Math.max(c,e._maxX);f=Math.min(f,e._minX);d=Math.max(d,e._maxY);g=Math.min(g,e._minY);m=Math.min(e._maxX-e._minX,e._maxY-e._minY,m);r=!0}});r&&(this.minY=Math.min(g,p(this.minY,b)),this.maxY=Math.max(d,p(this.maxY,-b)),this.minX=Math.min(f,p(this.minX,b)),this.maxX=Math.max(c,p(this.maxX,-b)),l&&void 0===l.options.minRange&&
(l.minRange=Math.min(5*m,(this.maxX-this.minX)/5,l.minRange||b)),h&&void 0===h.options.minRange&&(h.minRange=Math.min(5*m,(this.maxY-this.minY)/5,h.minRange||b)))},hasData:function(){return!!this.processedXData.length},getExtremes:function(){x.prototype.getExtremes.call(this,this.valueData);this.chart.hasRendered&&this.isDirtyData&&this.getBox(this.options.data);this.valueMin=this.dataMin;this.valueMax=this.dataMax;this.dataMin=this.minY;this.dataMax=this.maxY},translatePath:function(a){var e=!1,
c=this.xAxis,f=this.yAxis,b=c.min,d=c.transA;c=c.minPixelPadding;var g=f.min,l=f.transA;f=f.minPixelPadding;var m,h=[];if(a)for(m=a.length;m--;)t(a[m])?(h[m]=e?(a[m]-b)*d+c:(a[m]-g)*l+f,e=!e):h[m]=a[m];return h},setData:function(e,b,c,f){var d=this.options,k=this.chart.options.chart,g=k&&k.map,m=d.mapData,l=this.joinBy,h=d.keys||this.pointArrayMap,q=[],p={},u=this.chart.mapTransforms;!m&&g&&(m="string"===typeof g?a.maps[g]:g);e&&e.forEach(function(c,f){var b=0;if(t(c))e[f]={value:c};else if(n(c)){e[f]=
{};!d.keys&&c.length>h.length&&"string"===typeof c[0]&&(e[f]["hc-key"]=c[0],++b);for(var k=0;k<h.length;++k,++b)h[k]&&void 0!==c[b]&&(0<h[k].indexOf(".")?a.Point.prototype.setNestedProperty(e[f],c[b],h[k]):e[f][h[k]]=c[b])}l&&"_i"===l[0]&&(e[f]._i=f)});this.getBox(e);(this.chart.mapTransforms=u=k&&k.mapTransforms||m&&m["hc-transform"]||u)&&w(u,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(m){"FeatureCollection"===m.type&&(this.mapTitle=m.title,m=a.geojson(m,
this.type,this));this.mapData=m;this.mapMap={};for(u=0;u<m.length;u++)k=m[u],g=k.properties,k._i=u,l[0]&&g&&g[l[0]]&&(k[l[0]]=g[l[0]]),p[k[l[0]]]=k;this.mapMap=p;e&&l[1]&&e.forEach(function(a){p[a[l[1]]]&&q.push(p[a[l[1]]])});d.allAreas?(this.getBox(m),e=e||[],l[1]&&e.forEach(function(a){q.push(a[l[1]])}),q="|"+q.map(function(a){return a&&a[l[0]]}).join("|")+"|",m.forEach(function(a){l[0]&&-1!==q.indexOf("|"+a[l[0]]+"|")||(e.push(r(a,{value:null})),f=!1)})):this.getBox(q)}x.prototype.setData.call(this,
e,b,c,f)},drawGraph:g,drawDataLabels:g,doFullTranslate:function(){return this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML||!this.baseTrans},translate:function(){var a=this,b=a.xAxis,c=a.yAxis,f=a.doFullTranslate();a.generatePoints();a.data.forEach(function(e){t(e._midX)&&t(e._midY)&&(e.plotX=b.toPixels(e._midX,!0),e.plotY=c.toPixels(e._midY,!0));f&&(e.shapeType="path",e.shapeArgs={d:a.translatePath(e.path)})});d(a,"afterTranslate")},pointAttribs:function(a,b){b=a.series.chart.styledMode?
this.colorAttribs(a):l.column.prototype.pointAttribs.call(this,a,b);b["stroke-width"]=p(a.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||"borderWidth"],"inherit");return b},drawPoints:function(){var a=this,b=a.xAxis,c=a.yAxis,f=a.group,d=a.chart,g=d.renderer,m=this.baseTrans;a.transformGroup||(a.transformGroup=g.g().attr({scaleX:1,scaleY:1}).add(f),a.transformGroup.survive=!0);if(a.doFullTranslate())d.hasRendered&&!d.styledMode&&a.points.forEach(function(c){c.shapeArgs&&
(c.shapeArgs.fill=a.pointAttribs(c,c.state).fill)}),a.group=a.transformGroup,l.column.prototype.drawPoints.apply(a),a.group=f,a.points.forEach(function(c){if(c.graphic){var f="";c.name&&(f+="highcharts-name-"+c.name.replace(/ /g,"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(f+=" highcharts-key-"+c.properties["hc-key"].toLowerCase());f&&c.graphic.addClass(f);d.styledMode&&c.graphic.css(a.pointAttribs(c,c.selected&&"select"))}}),this.baseTrans={originX:b.min-b.minPixelPadding/b.transA,
originY:c.min-c.minPixelPadding/c.transA+(c.reversed?0:c.len/c.transA),transAX:b.transA,transAY:c.transA},this.transformGroup.animate({translateX:0,translateY:0,scaleX:1,scaleY:1});else{var h=b.transA/m.transAX;var r=c.transA/m.transAY;var n=b.toPixels(m.originX,!0);var q=c.toPixels(m.originY,!0);.99<h&&1.01>h&&.99<r&&1.01>r&&(r=h=1,n=Math.round(n),q=Math.round(q));var x=this.transformGroup;if(d.renderer.globalAnimation){var t=x.attr("translateX");var w=x.attr("translateY");var u=x.attr("scaleX");
var G=x.attr("scaleY");x.attr({animator:0}).animate({animator:1},{step:function(a,c){x.attr({translateX:t+(n-t)*c.pos,translateY:w+(q-w)*c.pos,scaleX:u+(h-u)*c.pos,scaleY:G+(r-G)*c.pos})}})}else x.attr({translateX:n,translateY:q,scaleX:h,scaleY:r})}d.styledMode||f.element.setAttribute("stroke-width",p(a.options[a.pointAttrToOptions&&a.pointAttrToOptions["stroke-width"]||"borderWidth"],1)/(h||1));this.drawMapDataLabels()},drawMapDataLabels:function(){x.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&
this.dataLabelsGroup.clip(this.chart.clipRect)},render:function(){var a=this,b=x.prototype.render;a.chart.renderer.isVML&&3E3<a.data.length?setTimeout(function(){b.call(a)}):b.call(a)},animate:function(a){var b=this.options.animation,c=this.group,f=this.xAxis,e=this.yAxis,d=f.pos,g=e.pos;this.chart.renderer.isSVG&&(!0===b&&(b={duration:1E3}),a?c.attr({translateX:d+f.len/2,translateY:g+e.len/2,scaleX:.001,scaleY:.001}):(c.animate({translateX:d,translateY:g,scaleX:1,scaleY:1},b),this.animate=null))},
animateDrilldown:function(a){var b=this.chart.plotBox,c=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],f=c.bBox,e=this.chart.options.drilldown.animation;a||(a=Math.min(f.width/b.width,f.height/b.height),c.shapeArgs={scaleX:a,scaleY:a,translateX:f.x,translateY:f.y},this.points.forEach(function(a){a.graphic&&a.graphic.attr(c.shapeArgs).animate({scaleX:1,scaleY:1,translateX:0,translateY:0},e)}),this.animate=null)},drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,animateDrillupFrom:function(a){l.column.prototype.animateDrillupFrom.call(this,
a)},animateDrillupTo:function(a){l.column.prototype.animateDrillupTo.call(this,a)}}),h({applyOptions:function(a,b){var c=this.series;a=m.prototype.applyOptions.call(this,a,b);b=c.joinBy;c.mapData&&((b=void 0!==a[b[1]]&&c.mapMap[a[b[1]]])?(c.xyFromShape&&(a.x=b._midX,a.y=b._midY),h(a,b)):a.value=a.value||null);return a},onMouseOver:function(b){a.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)m.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)},
zoomTo:function(){var a=this.series;a.xAxis.setExtremes(this._minX,this._maxX,!1);a.yAxis.setExtremes(this._minY,this._maxY,!1);a.chart.redraw()}},b));""});y(h,"parts-map/MapLineSeries.js",[h["parts/Globals.js"]],function(a){var b=a.seriesType,h=a.seriesTypes;b("mapline","map",{lineWidth:1,fillColor:"none"},{type:"mapline",colorProp:"stroke",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointAttribs:function(a,b){a=h.map.prototype.pointAttribs.call(this,a,b);a.fill=this.options.fillColor;
return a},drawLegendSymbol:h.line.prototype.drawLegendSymbol});""});y(h,"parts-map/MapPointSeries.js",[h["parts/Globals.js"]],function(a){var b=a.merge,h=a.Point;a=a.seriesType;a("mappoint","scatter",{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}},{type:"mappoint",forceDL:!0},{applyOptions:function(a,t){a=void 0!==a.lat&&void 0!==a.lon?b(a,this.series.chart.fromLatLonToPoint(a)):a;return h.prototype.applyOptions.call(this,
a,t)}});""});y(h,"parts-more/BubbleLegend.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.arrayMax,n=b.arrayMin,t=b.isNumber,w=b.objectEach,p=b.pick;b=a.Series;var u=a.Legend,r=a.Chart,g=a.addEvent,d=a.wrap,m=a.color,x=a.numberFormat,q=a.merge,l=a.noop,e=a.stableSort,k=a.setOptions;k({legend:{bubbleLegend:{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,
allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:10,color:void 0},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}});a.BubbleLegend=function(a,f){this.init(a,f)};a.BubbleLegend.prototype={init:function(a,f){this.options=a;this.visible=!0;this.chart=f.chart;this.legend=f},setState:l,addToLegend:function(a){a.splice(this.options.legendIndex,0,this)},
drawLegendSymbol:function(a){var c=this.chart,b=this.options,d=p(a.options.itemDistance,20),g=b.ranges;var k=b.connectorDistance;this.fontMetrics=c.renderer.fontMetrics(b.labels.style.fontSize.toString()+"px");g&&g.length&&t(g[0].value)?(e(g,function(a,c){return c.value-a.value}),this.ranges=g,this.setOptions(),this.render(),c=this.getMaxLabelSize(),g=this.ranges[0].radius,a=2*g,k=k-g+c.width,k=0<k?k:0,this.maxLabel=c,this.movementX="left"===b.labels.align?k:0,this.legendItemWidth=a+k+d,this.legendItemHeight=
a+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=!0},setOptions:function(){var a=this.ranges,f=this.options,b=this.chart.series[f.seriesIndex],e=this.legend.baseline,d={"z-index":f.zIndex,"stroke-width":f.borderWidth},g={"z-index":f.zIndex,"stroke-width":f.connectorWidth},k=this.getLabelStyles(),l=b.options.marker.fillOpacity,h=this.chart.styledMode;a.forEach(function(c,v){h||(d.stroke=p(c.borderColor,f.borderColor,b.color),d.fill=p(c.color,f.color,1!==l?m(b.color).setOpacity(l).get("rgba"):
b.color),g.stroke=p(c.connectorColor,f.connectorColor,b.color));a[v].radius=this.getRangeRadius(c.value);a[v]=q(a[v],{center:a[0].radius-a[v].radius+e});h||q(!0,a[v],{bubbleStyle:q(!1,d),connectorStyle:q(!1,g),labelStyle:k})},this)},getLabelStyles:function(){var a=this.options,f={},b="left"===a.labels.align,e=this.legend.options.rtl;w(a.labels.style,function(a,c){"color"!==c&&"fontSize"!==c&&"z-index"!==c&&(f[c]=a)});return q(!1,f,{"font-size":a.labels.style.fontSize,fill:p(a.labels.style.color,"#000000"),
"z-index":a.zIndex,align:e||b?"right":"left"})},getRangeRadius:function(a){var c=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,c.ranges[c.ranges.length-1].value,c.ranges[0].value,c.minSize,c.maxSize,a)},render:function(){var a=this.chart.renderer,f=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=a.g("bubble-legend");this.legendItem=a.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=
0;this.ranges.forEach(function(a){a.value>=f&&this.renderRange(a)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);this.hideOverlappingLabels()},renderRange:function(a){var c=this.options,b=c.labels,e=this.chart.renderer,d=this.symbols,g=d.labels,k=a.center,m=Math.abs(a.radius),l=c.connectorDistance,h=b.align,r=b.style.fontSize;l=this.legend.options.rtl||"left"===h?-l:l;b=c.connectorWidth;var q=this.ranges[0].radius,x=k-m-c.borderWidth/2+b/2;r=r/2-(this.fontMetrics.h-
r)/2;var n=e.styledMode;"center"===h&&(l=0,c.connectorDistance=0,a.labelStyle.align="center");h=x+c.labels.y;var p=q+l+c.labels.x;d.bubbleItems.push(e.circle(q,k+((x%1?1:.5)-(b%2?0:.5)),m).attr(n?{}:a.bubbleStyle).addClass((n?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-symbol "+(c.className||"")).add(this.legendSymbol));d.connectors.push(e.path(e.crispLine(["M",q,x,"L",q+l,x],c.connectorWidth)).attr(n?{}:a.connectorStyle).addClass((n?"highcharts-color-"+this.options.seriesIndex+
" ":"")+"highcharts-bubble-legend-connectors "+(c.connectorClassName||"")).add(this.legendSymbol));a=e.text(this.formatLabel(a),p,h+r).attr(n?{}:a.labelStyle).addClass("highcharts-bubble-legend-labels "+(c.labels.className||"")).add(this.legendSymbol);g.push(a);a.placed=!0;a.alignAttr={x:p,y:h+r}},getMaxLabelSize:function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}},formatLabel:function(c){var b=this.options,e=b.labels.formatter;return(b=
b.labels.format)?a.format(b,c):e?e.call(c):x(c.value,1)},hideOverlappingLabels:function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))},getRanges:function(){var a=this.legend.bubbleLegend,b=a.options.ranges,e,d=Number.MAX_VALUE,g=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(e=a.zData.filter(t),
e.length&&(d=p(a.options.zMin,Math.min(d,Math.max(n(e),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),g=p(a.options.zMax,Math.max(g,h(e)))))});var k=d===g?[{value:g}]:[{value:d},{value:(d+g)/2},{value:g,autoRanges:!0}];b.length&&b[0].radius&&k.reverse();k.forEach(function(a,c){b&&b[c]&&(k[c]=q(!1,b[c],a))});return k},predictBubbleSizes:function(){var a=this.chart,b=this.fontMetrics,e=a.legend.options,d="horizontal"===e.layout,g=d?a.legend.lastLineHeight:0,k=a.plotSizeX,l=
a.plotSizeY,m=a.series[this.options.seriesIndex];a=Math.ceil(m.minPxSize);var h=Math.ceil(m.maxPxSize);m=m.options.maxSize;var r=Math.min(l,k);if(e.floating||!/%$/.test(m))b=h;else if(m=parseFloat(m),b=(r+g-b.h/2)*m/100/(m/100+1),d&&l-b>=k||!d&&k-b>=l)b=h;return[a,Math.ceil(b)]},updateRanges:function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()},correctSizes:function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex];1<Math.abs(Math.ceil(b.maxPxSize)-
this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())}};g(a.Legend,"afterGetAllItems",function(b){var c=this.bubbleLegend,e=this.options,d=e.bubbleLegend,g=this.chart.getVisibleBubbleSeriesIndex();c&&c.ranges&&c.ranges.length&&(d.ranges.length&&(d.autoRanges=!!d.ranges[0].autoRanges),this.destroyItem(c));0<=g&&e.enabled&&d.enabled&&(d.seriesIndex=g,this.bubbleLegend=new a.BubbleLegend(d,this),this.bubbleLegend.addToLegend(b.allItems))});r.prototype.getVisibleBubbleSeriesIndex=
function(){for(var a=this.series,b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1};u.prototype.getLinesHeights=function(){var a=this.allItems,b=[],e=a.length,d,g=0;for(d=0;d<e;d++)if(a[d].legendItemHeight&&(a[d].itemHeight=a[d].legendItemHeight),a[d]===a[e-1]||a[d+1]&&a[d]._legendItemPos[1]!==a[d+1]._legendItemPos[1]){b.push({height:0});var k=b[b.length-1];for(g;g<=d;g++)a[g].itemHeight>k.height&&(k.height=a[g].itemHeight);k.step=d}return b};u.prototype.retranslateItems=
function(a){var b,c,d,e=this.options.rtl,g=0;this.allItems.forEach(function(f,k){b=f.legendGroup.translateX;c=f._legendItemPos[1];if((d=f.movementX)||e&&f.ranges)d=e?b-f.options.maxSize/2:b+d,f.legendGroup.attr({translateX:d});k>a[g].step&&g++;f.legendGroup.attr({translateY:Math.round(c+a[g].height/2)});f._legendItemPos[1]=c+a[g].height/2})};g(b,"legendItemClick",function(){var a=this.chart,b=this.visible,d=this.chart.legend;d&&d.bubbleLegend&&(this.visible=!b,this.ignoreSeries=b,a=0<=a.getVisibleBubbleSeriesIndex(),
d.bubbleLegend.visible!==a&&(d.update({bubbleLegend:{enabled:a}}),d.bubbleLegend.visible=a),this.visible=b)});d(r.prototype,"drawChartBox",function(a,b,d){var c=this.legend,e=0<=this.getVisibleBubbleSeriesIndex();if(c&&c.options.enabled&&c.bubbleLegend&&c.options.bubbleLegend.autoRanges&&e){var f=c.bubbleLegend.options;e=c.bubbleLegend.predictBubbleSizes();c.bubbleLegend.updateRanges(e[0],e[1]);f.placed||(c.group.placed=!1,c.allItems.forEach(function(a){a.legendGroup.translateY=null}));c.render();
this.getMargins();this.axes.forEach(function(a){a.visible&&a.render();f.placed||(a.setScale(),a.updateNames(),w(a.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});f.placed=!0;this.getMargins();a.call(this,b,d);c.bubbleLegend.correctSizes();c.retranslateItems(c.getLinesHeights())}else a.call(this,b,d),c&&c.options.enabled&&c.bubbleLegend&&(c.render(),c.retranslateItems(c.getLinesHeights()))})});y(h,"parts-more/BubbleSeries.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.arrayMax,
n=b.arrayMin,t=b.extend,w=b.isNumber,p=b.pick,u=b.pInt;b=a.Axis;var r=a.color,g=a.noop,d=a.Point,m=a.Series,x=a.seriesType,q=a.seriesTypes;x("bubble","scatter",{dataLabels:{formatter:function(){return this.point.z},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},
turboThreshold:0,zThreshold:0,zoneAxis:"z"},{pointArrayMap:["y","z"],parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",bubblePadding:!0,zoneAxis:"z",directTouch:!0,isBubble:!0,pointAttribs:function(a,b){var d=this.options.marker.fillOpacity;a=m.prototype.pointAttribs.call(this,a,b);1!==d&&(a.fill=r(a.fill).setOpacity(d).get("rgba"));return a},getRadii:function(a,b,d){var c=this.zData,e=this.yData,g=d.minPxSize,k=d.maxPxSize,m=[];var h=0;for(d=c.length;h<d;h++){var l=
c[h];m.push(this.getRadius(a,b,g,k,l,e[h]))}this.radii=m},getRadius:function(a,b,d,c,f,g){var e=this.options,k="width"!==e.sizeBy,m=e.zThreshold,h=b-a,l=.5;if(null===g||null===f)return null;if(w(f)){e.sizeByAbsoluteValue&&(f=Math.abs(f-m),h=Math.max(b-m,Math.abs(a-m)),a=0);if(f<a)return d/2-1;0<h&&(l=(f-a)/h)}k&&0<=l&&(l=Math.sqrt(l));return Math.ceil(d+l*(c-d))/2},animate:function(a){!a&&this.points.length<this.options.animationLimit&&(this.points.forEach(function(a){var b=a.graphic;if(b&&b.width){var c=
{x:b.x,y:b.y,width:b.width,height:b.height};b.attr({x:a.plotX,y:a.plotY,width:1,height:1});b.animate(c,this.options.animation)}},this),this.animate=null)},hasData:function(){return!!this.processedXData.length},translate:function(){var a,b=this.data,d=this.radii;q.scatter.prototype.translate.call(this);for(a=b.length;a--;){var c=b[a];var f=d?d[a]:0;w(f)&&f>=this.minPxSize/2?(c.marker=t(c.marker,{radius:f,width:2*f,height:2*f}),c.dlBox={x:c.plotX-f,y:c.plotY-f,width:2*f,height:2*f}):c.shapeArgs=c.plotY=
c.dlBox=void 0}},alignDataLabel:q.column.prototype.alignDataLabel,buildKDTree:g,applyZones:g},{haloPath:function(a){return d.prototype.haloPath.call(this,0===a?0:(this.marker?this.marker.radius||0:0)+a)},ttBelow:!1});b.prototype.beforePadding=function(){var a=this,b=this.len,d=this.chart,c=0,f=b,g=this.isXAxis,m=g?"xData":"yData",r=this.min,q={},x=Math.min(d.plotWidth,d.plotHeight),t=Number.MAX_VALUE,y=-Number.MAX_VALUE,E=this.max-r,D=b/E,F=[];this.series.forEach(function(b){var c=b.options;!b.bubblePadding||
!b.visible&&d.options.chart.ignoreHiddenSeries||(a.allowZoomOutside=!0,F.push(b),g&&(["minSize","maxSize"].forEach(function(a){var b=c[a],d=/%$/.test(b);b=u(b);q[a]=d?x*b/100:b}),b.minPxSize=q.minSize,b.maxPxSize=Math.max(q.maxSize,q.minSize),b=b.zData.filter(w),b.length&&(t=p(c.zMin,Math.min(t,Math.max(n(b),!1===c.displayNegative?c.zThreshold:-Number.MAX_VALUE))),y=p(c.zMax,Math.max(y,h(b))))))});F.forEach(function(b){var d=b[m],e=d.length;g&&b.getRadii(t,y,b);if(0<E)for(;e--;)if(w(d[e])&&a.dataMin<=
d[e]&&d[e]<=a.dataMax){var h=b.radii?b.radii[e]:0;c=Math.min((d[e]-r)*D-h,c);f=Math.max((d[e]-r)*D+h,f)}});F.length&&0<E&&!this.isLog&&(f-=b,D*=(b+Math.max(0,c)-Math.min(f,b))/b,[["min","userMin",c],["max","userMax",f]].forEach(function(b){void 0===p(a.options[b[0]],a[b[1]])&&(a[b[0]]+=b[2]/D)}))};""});y(h,"parts-map/MapBubbleSeries.js",[h["parts/Globals.js"]],function(a){var b=a.merge,h=a.Point,n=a.seriesType,t=a.seriesTypes;t.bubble&&n("mapbubble","bubble",{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}},
{xyFromShape:!0,type:"mapbubble",pointArrayMap:["z"],getMapData:t.map.prototype.getMapData,getBox:t.map.prototype.getBox,setData:t.map.prototype.setData,setOptions:t.map.prototype.setOptions},{applyOptions:function(a,n){return a&&void 0!==a.lat&&void 0!==a.lon?h.prototype.applyOptions.call(this,b(a,this.series.chart.fromLatLonToPoint(a)),n):t.map.prototype.pointClass.prototype.applyOptions.call(this,a,n)},isValid:function(){return"number"===typeof this.z},ttBelow:!1});""});y(h,"parts-map/HeatmapSeries.js",
[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){var h=b.extend,n=b.pick;b=a.colorMapPointMixin;var t=a.merge,w=a.noop,p=a.fireEvent,u=a.Series,r=a.seriesType,g=a.seriesTypes;r("heatmap","scatter",{animation:!1,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){return this.point.value},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:null,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}},
t(a.colorMapSeriesMixin,{pointArrayMap:["y","value"],hasPointSpecificOptions:!0,getExtremesFromAll:!0,directTouch:!0,init:function(){g.scatter.prototype.init.apply(this,arguments);var a=this.options;a.pointRange=n(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1},translate:function(){var a=this.options,b=this.xAxis,g=this.yAxis,h=a.pointPadding||0,l=function(a,b,d){return Math.min(Math.max(b,a),d)},e=this.pointPlacementToXValue();this.generatePoints();this.points.forEach(function(d){var c=
(a.colsize||1)/2,f=(a.rowsize||1)/2,m=l(Math.round(b.len-b.translate(d.x-c,0,1,0,1,-e)),-b.len,2*b.len);c=l(Math.round(b.len-b.translate(d.x+c,0,1,0,1,-e)),-b.len,2*b.len);var k=l(Math.round(g.translate(d.y-f,0,1,0,1)),-g.len,2*g.len);f=l(Math.round(g.translate(d.y+f,0,1,0,1)),-g.len,2*g.len);var r=n(d.pointPadding,h);d.plotX=d.clientX=(m+c)/2;d.plotY=(k+f)/2;d.shapeType="rect";d.shapeArgs={x:Math.min(m,c)+r,y:Math.min(k,f)+r,width:Math.max(Math.abs(c-m)-2*r,0),height:Math.max(Math.abs(f-k)-2*r,0)}});
p(this,"afterTranslate")},drawPoints:function(){var a=this.chart.styledMode?"css":"animate";g.column.prototype.drawPoints.call(this);this.points.forEach(function(b){b.graphic[a](this.colorAttribs(b))},this)},hasData:function(){return!!this.processedXData.length},getValidPoints:function(a,b){return u.prototype.getValidPoints.call(this,a,b,!0)},animate:w,getBox:w,drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,alignDataLabel:g.column.prototype.alignDataLabel,getExtremes:function(){u.prototype.getExtremes.call(this,
this.valueData);this.valueMin=this.dataMin;this.valueMax=this.dataMax;u.prototype.getExtremes.call(this)}}),h({haloPath:function(a){if(!a)return[];var b=this.shapeArgs;return["M",b.x-a,b.y-a,"L",b.x-a,b.y+b.height+a,b.x+b.width+a,b.y+b.height+a,b.x+b.width+a,b.y-a,"Z"]}},b));""});y(h,"parts-map/GeoJSON.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){function h(a,b){var d,g=!1,h=a.x,r=a.y;a=0;for(d=b.length-1;a<b.length;d=a++){var l=b[a][1]>r;var e=b[d][1]>r;l!==e&&h<(b[d][0]-b[a][0])*
(r-b[a][1])/(b[d][1]-b[a][1])+b[a][0]&&(g=!g)}return g}var n=b.extend;b=a.Chart;var t=a.format,w=a.merge,p=a.win,u=a.wrap;b.prototype.transformFromLatLon=function(b,g){if(void 0===p.proj4)return a.error(21,!1,this),{x:0,y:null};b=p.proj4(g.crs,[b.lon,b.lat]);var d=g.cosAngle||g.rotation&&Math.cos(g.rotation),h=g.sinAngle||g.rotation&&Math.sin(g.rotation);b=g.rotation?[b[0]*d+b[1]*h,-b[0]*h+b[1]*d]:b;return{x:((b[0]-(g.xoffset||0))*(g.scale||1)+(g.xpan||0))*(g.jsonres||1)+(g.jsonmarginX||0),y:(((g.yoffset||
0)-b[1])*(g.scale||1)+(g.ypan||0))*(g.jsonres||1)-(g.jsonmarginY||0)}};b.prototype.transformToLatLon=function(b,g){if(void 0===p.proj4)a.error(21,!1,this);else{b={x:((b.x-(g.jsonmarginX||0))/(g.jsonres||1)-(g.xpan||0))/(g.scale||1)+(g.xoffset||0),y:((-b.y-(g.jsonmarginY||0))/(g.jsonres||1)+(g.ypan||0))/(g.scale||1)+(g.yoffset||0)};var d=g.cosAngle||g.rotation&&Math.cos(g.rotation),h=g.sinAngle||g.rotation&&Math.sin(g.rotation);g=p.proj4(g.crs,"WGS84",g.rotation?{x:b.x*d+b.y*-h,y:b.x*h+b.y*d}:b);return{lat:g.y,
lon:g.x}}};b.prototype.fromPointToLatLon=function(b){var g=this.mapTransforms,d;if(g){for(d in g)if(Object.hasOwnProperty.call(g,d)&&g[d].hitZone&&h({x:b.x,y:-b.y},g[d].hitZone.coordinates[0]))return this.transformToLatLon(b,g[d]);return this.transformToLatLon(b,g["default"])}a.error(22,!1,this)};b.prototype.fromLatLonToPoint=function(b){var g=this.mapTransforms,d;if(!g)return a.error(22,!1,this),{x:0,y:null};for(d in g)if(Object.hasOwnProperty.call(g,d)&&g[d].hitZone){var m=this.transformFromLatLon(b,
g[d]);if(h({x:m.x,y:-m.y},g[d].hitZone.coordinates[0]))return m}return this.transformFromLatLon(b,g["default"])};a.geojson=function(a,b,d){var g=[],h=[],q=function(a){var b,d=a.length;h.push("M");for(b=0;b<d;b++)1===b&&h.push("L"),h.push(a[b][0],-a[b][1])};b=b||"map";a.features.forEach(function(a){var d=a.geometry,k=d.type;d=d.coordinates;a=a.properties;var c;h=[];"map"===b||"mapbubble"===b?("Polygon"===k?(d.forEach(q),h.push("Z")):"MultiPolygon"===k&&(d.forEach(function(a){a.forEach(q)}),h.push("Z")),
h.length&&(c={path:h})):"mapline"===b?("LineString"===k?q(d):"MultiLineString"===k&&d.forEach(q),h.length&&(c={path:h})):"mappoint"===b&&"Point"===k&&(c={x:d[0],y:-d[1]});c&&g.push(n(c,{name:a.name||a.NAME,properties:a}))});d&&a.copyrightShort&&(d.chart.mapCredits=t(d.chart.options.credits.mapText,{geojson:a}),d.chart.mapCreditsFull=t(d.chart.options.credits.mapTextFull,{geojson:a}));return g};u(b.prototype,"addCredits",function(a,b){b=w(!0,this.options.credits,b);this.mapCredits&&(b.href=null);a.call(this,
b);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});y(h,"parts-map/Map.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(a,b){function h(a,b,g,h,l,e,k,c){return["M",a+l,b,"L",a+g-e,b,"C",a+g-e/2,b,a+g,b+e/2,a+g,b+e,"L",a+g,b+h-k,"C",a+g,b+h-k/2,a+g-k/2,b+h,a+g-k,b+h,"L",a+c,b+h,"C",a+c/2,b+h,a,b+h-c/2,a,b+h-c,"L",a,b+l,"C",a,b+l/2,a+l/2,b,a+l,b,"Z"]}var n=b.extend,t=b.pick,w=a.Chart;b=a.defaultOptions;var p=a.merge,u=a.Renderer,r=a.SVGRenderer,g=a.VMLRenderer;
n(b.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});b.mapNavigation={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};a.splitPath=function(a){var b;a=a.replace(/([A-Za-z])/g," $1 ");a=a.replace(/^\s*/,"").replace(/\s*$/,
"");a=a.split(/[ ,]+/);for(b=0;b<a.length;b++)/[a-zA-Z]/.test(a[b])||(a[b]=parseFloat(a[b]));return a};a.maps={};r.prototype.symbols.topbutton=function(a,b,g,n,l){return h(a-1,b-1,g,n,l.r,l.r,0,0)};r.prototype.symbols.bottombutton=function(a,b,g,n,l){return h(a-1,b-1,g,n,0,0,l.r,l.r)};u===g&&["topbutton","bottombutton"].forEach(function(a){g.prototype.symbols[a]=r.prototype.symbols[a]});a.Map=a.mapChart=function(b,g,h){var d="string"===typeof b||b.nodeName,l=arguments[d?1:0],e=l,k={endOnTick:!1,visible:!1,
minPadding:0,maxPadding:0,startOnTick:!1},c=a.getOptions().credits;var f=l.series;l.series=null;l=p({chart:{panning:"xy",type:"map"},credits:{mapText:t(c.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:t(c.mapTextFull,"{geojson.copyright}")},tooltip:{followTouchMove:!1},xAxis:k,yAxis:p(k,{reversed:!0})},l,{chart:{inverted:!1,alignTicks:!1}});l.series=e.series=f;return d?new w(b,l,h):new w(l,g)}});y(h,"masters/modules/map.src.js",[],function(){})});
//# sourceMappingURL=map.js.map