/*
 Highcharts JS v7.2.1 (2019-10-31)

 Force directed graph module

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(h){"object"===typeof module&&module.exports?(h["default"]=h,module.exports=h):"function"===typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(m){h(m);h.Highcharts=m;return h}):h("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(h){function m(e,a,c,f){e.hasOwnProperty(a)||(e[a]=f.apply(null,c))}h=h?h._modules:{};m(h,"mixins/nodes.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,a){var c=a.defined,f=a.extend,g=a.pick,n=e.Point;
e.NodesMixin={createNode:function(a){function b(b,d){return e.find(b,function(b){return b.id===d})}var d=b(this.nodes,a),k=this.pointClass;if(!d){var p=this.options.nodes&&b(this.options.nodes,a);d=(new k).init(this,f({className:"highcharts-node",isNode:!0,id:a,y:1},p));d.linksTo=[];d.linksFrom=[];d.formatPrefix="node";d.name=d.name||d.options.id;d.mass=g(d.options.mass,d.options.marker&&d.options.marker.radius,this.options.marker&&this.options.marker.radius,4);d.getSum=function(){var b=0,k=0;d.linksTo.forEach(function(d){b+=
d.weight});d.linksFrom.forEach(function(b){k+=b.weight});return Math.max(b,k)};d.offset=function(b,k){for(var f=0,a=0;a<d[k].length;a++){if(d[k][a]===b)return f;f+=d[k][a].weight}};d.hasShape=function(){var b=0;d.linksTo.forEach(function(d){d.outgoing&&b++});return!d.linksTo.length||b!==d.linksTo.length};this.nodes.push(d)}return d},generatePoints:function(){var f=this.chart,b={};e.Series.prototype.generatePoints.call(this);this.nodes||(this.nodes=[]);this.colorCounter=0;this.nodes.forEach(function(b){b.linksFrom.length=
0;b.linksTo.length=0;b.level=void 0});this.points.forEach(function(d){c(d.from)&&(b[d.from]||(b[d.from]=this.createNode(d.from)),b[d.from].linksFrom.push(d),d.fromNode=b[d.from],f.styledMode?d.colorIndex=g(d.options.colorIndex,b[d.from].colorIndex):d.color=d.options.color||b[d.from].color);c(d.to)&&(b[d.to]||(b[d.to]=this.createNode(d.to)),b[d.to].linksTo.push(d),d.toNode=b[d.to]);d.name=d.name||d.id},this);this.nodeLookup=b},setData:function(){this.nodes&&(this.nodes.forEach(function(f){f.destroy()}),
this.nodes.length=0);e.Series.prototype.setData.apply(this,arguments)},destroy:function(){this.data=[].concat(this.points||[],this.nodes);return e.Series.prototype.destroy.apply(this,arguments)},setNodeState:function(f){var b=arguments,d=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==f&&d.forEach(function(d){d.series&&(n.prototype.setState.apply(d,b),d.isNode||(d.fromNode.graphic&&n.prototype.setState.apply(d.fromNode,b),d.toNode.graphic&&n.prototype.setState.apply(d.toNode,
b)))});n.prototype.setState.apply(this,b)}}});m(h,"modules/networkgraph/integrations.js",[h["parts/Globals.js"]],function(e){e.networkgraphIntegrations={verlet:{attractiveForceFunction:function(a,c){return(c-a)/a},repulsiveForceFunction:function(a,c){return(c-a)/a*(c>a?1:0)},barycenter:function(){var a=this.options.gravitationalConstant,c=this.barycenter.xFactor,f=this.barycenter.yFactor;c=(c-(this.box.left+this.box.width)/2)*a;f=(f-(this.box.top+this.box.height)/2)*a;this.nodes.forEach(function(a){a.fixedPosition||
(a.plotX-=c/a.mass/a.degree,a.plotY-=f/a.mass/a.degree)})},repulsive:function(a,c,f){c=c*this.diffTemperature/a.mass/a.degree;a.fixedPosition||(a.plotX+=f.x*c,a.plotY+=f.y*c)},attractive:function(a,c,f){var g=a.getMass(),e=-f.x*c*this.diffTemperature;c=-f.y*c*this.diffTemperature;a.fromNode.fixedPosition||(a.fromNode.plotX-=e*g.fromNode/a.fromNode.degree,a.fromNode.plotY-=c*g.fromNode/a.fromNode.degree);a.toNode.fixedPosition||(a.toNode.plotX+=e*g.toNode/a.toNode.degree,a.toNode.plotY+=c*g.toNode/
a.toNode.degree)},integrate:function(a,c){var f=-a.options.friction,g=a.options.maxSpeed,e=(c.plotX+c.dispX-c.prevX)*f;f*=c.plotY+c.dispY-c.prevY;var l=Math.abs,b=l(e)/(e||1);l=l(f)/(f||1);e=b*Math.min(g,Math.abs(e));f=l*Math.min(g,Math.abs(f));c.prevX=c.plotX+c.dispX;c.prevY=c.plotY+c.dispY;c.plotX+=e;c.plotY+=f;c.temperature=a.vectorLength({x:e,y:f})},getK:function(a){return Math.pow(a.box.width*a.box.height/a.nodes.length,.5)}},euler:{attractiveForceFunction:function(a,c){return a*a/c},repulsiveForceFunction:function(a,
c){return c*c/a},barycenter:function(){var a=this.options.gravitationalConstant,c=this.barycenter.xFactor,f=this.barycenter.yFactor;this.nodes.forEach(function(g){if(!g.fixedPosition){var e=g.getDegree();e*=1+e/2;g.dispX+=(c-g.plotX)*a*e/g.degree;g.dispY+=(f-g.plotY)*a*e/g.degree}})},repulsive:function(a,c,f,g){a.dispX+=f.x/g*c/a.degree;a.dispY+=f.y/g*c/a.degree},attractive:function(a,c,f,g){var e=a.getMass(),l=f.x/g*c;c*=f.y/g;a.fromNode.fixedPosition||(a.fromNode.dispX-=l*e.fromNode/a.fromNode.degree,
a.fromNode.dispY-=c*e.fromNode/a.fromNode.degree);a.toNode.fixedPosition||(a.toNode.dispX+=l*e.toNode/a.toNode.degree,a.toNode.dispY+=c*e.toNode/a.toNode.degree)},integrate:function(a,c){c.dispX+=c.dispX*a.options.friction;c.dispY+=c.dispY*a.options.friction;var f=c.temperature=a.vectorLength({x:c.dispX,y:c.dispY});0!==f&&(c.plotX+=c.dispX/f*Math.min(Math.abs(c.dispX),a.temperature),c.plotY+=c.dispY/f*Math.min(Math.abs(c.dispY),a.temperature))},getK:function(a){return Math.pow(a.box.width*a.box.height/
a.nodes.length,.3)}}}});m(h,"modules/networkgraph/QuadTree.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,a){a=a.extend;var c=e.QuadTreeNode=function(a){this.box=a;this.boxSize=Math.min(a.width,a.height);this.nodes=[];this.body=this.isInternal=!1;this.isEmpty=!0};a(c.prototype,{insert:function(a,g){this.isInternal?this.nodes[this.getBoxPosition(a)].insert(a,g-1):(this.isEmpty=!1,this.body?g?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,
g-1),this.body=!0),this.nodes[this.getBoxPosition(a)].insert(a,g-1)):(g=new c({top:a.plotX,left:a.plotY,width:.1,height:.1}),g.body=a,g.isInternal=!1,this.nodes.push(g)):(this.isInternal=!1,this.body=a))},updateMassAndCenter:function(){var a=0,c=0,e=0;this.isInternal?(this.nodes.forEach(function(f){f.isEmpty||(a+=f.mass,c+=f.plotX*f.mass,e+=f.plotY*f.mass)}),c/=a,e/=a):this.body&&(a=this.body.mass,c=this.body.plotX,e=this.body.plotY);this.mass=a;this.plotX=c;this.plotY=e},divideBox:function(){var a=
this.box.width/2,g=this.box.height/2;this.nodes[0]=new c({left:this.box.left,top:this.box.top,width:a,height:g});this.nodes[1]=new c({left:this.box.left+a,top:this.box.top,width:a,height:g});this.nodes[2]=new c({left:this.box.left+a,top:this.box.top+g,width:a,height:g});this.nodes[3]=new c({left:this.box.left,top:this.box.top+g,width:a,height:g})},getBoxPosition:function(a){var f=a.plotY<this.box.top+this.box.height/2;return a.plotX<this.box.left+this.box.width/2?f?0:3:f?1:2}});e=e.QuadTree=function(a,
g,e,l){this.box={left:a,top:g,width:e,height:l};this.maxDepth=25;this.root=new c(this.box,"0");this.root.isInternal=!0;this.root.isRoot=!0;this.root.divideBox()};a(e.prototype,{insertNodes:function(a){a.forEach(function(a){this.root.insert(a,this.maxDepth)},this)},visitNodeRecursive:function(a,c,e){var f;a||(a=this.root);a===this.root&&c&&(f=c(a));!1!==f&&(a.nodes.forEach(function(b){if(b.isInternal){c&&(f=c(b));if(!1===f)return;this.visitNodeRecursive(b,c,e)}else b.body&&c&&c(b.body);e&&e(b)},this),
a===this.root&&e&&e(a))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(a){a.updateMassAndCenter()})}})});m(h,"modules/networkgraph/layouts.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,a){var c=a.defined,f=a.extend,g=a.pick,h=a.setAnimation;a=e.addEvent;var l=e.Chart;e.layouts={"reingold-fruchterman":function(){}};f(e.layouts["reingold-fruchterman"].prototype,{init:function(b){this.options=b;this.nodes=[];this.links=[];this.series=[];this.box={x:0,y:0,
width:0,height:0};this.setInitialRendering(!0);this.integration=e.networkgraphIntegrations[b.integration];this.attractiveForce=g(b.attractiveForce,this.integration.attractiveForceFunction);this.repulsiveForce=g(b.repulsiveForce,this.integration.repulsiveForceFunction);this.approximation=b.approximation},start:function(){var b=this.series,a=this.options;this.currentStep=0;this.forces=b[0]&&b[0].forces||[];this.initialRendering&&(this.initPositions(),b.forEach(function(b){b.render()}));this.setK();
this.resetSimulation(a);a.enableSimulation&&this.step()},step:function(){var b=this,a=this.series,k=this.options;b.currentStep++;"barnes-hut"===b.approximation&&(b.createQuadTree(),b.quadTree.calculateMassAndCenter());b.forces.forEach(function(a){b[a+"Forces"](b.temperature)});b.applyLimits(b.temperature);b.temperature=b.coolDown(b.startTemperature,b.diffTemperature,b.currentStep);b.prevSystemTemperature=b.systemTemperature;b.systemTemperature=b.getSystemTemperature();k.enableSimulation&&(a.forEach(function(b){b.chart&&
b.render()}),b.maxIterations--&&isFinite(b.temperature)&&!b.isStable()?(b.simulation&&e.win.cancelAnimationFrame(b.simulation),b.simulation=e.win.requestAnimationFrame(function(){b.step()})):b.simulation=!1)},stop:function(){this.simulation&&e.win.cancelAnimationFrame(this.simulation)},setArea:function(b,a,k,c){this.box={left:b,top:a,width:k,height:c}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(b,a){b.forEach(function(b){-1===a.indexOf(b)&&
a.push(b)})},removeElementFromCollection:function(b,a){b=a.indexOf(b);-1!==b&&a.splice(b,1)},clear:function(){this.nodes.length=0;this.links.length=0;this.series.length=0;this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1;this.systemTemperature=0;this.setMaxIterations();this.setTemperature();this.setDiffTemperature()},setMaxIterations:function(b){this.maxIterations=g(b,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},
setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(b){this.initialRendering=b},createQuadTree:function(){this.quadTree=new e.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height);this.quadTree.insertNodes(this.nodes)},initPositions:function(){var b=this.options.initialPositions;e.isFunction(b)?(b.call(this),this.nodes.forEach(function(b){c(b.prevX)||(b.prevX=b.plotX);c(b.prevY)||(b.prevY=b.plotY);b.dispX=
0;b.dispY=0})):"circle"===b?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){function b(a){a.linksFrom.forEach(function(a){h[a.toNode.id]||(h[a.toNode.id]=!0,e.push(a.toNode),b(a.toNode))})}var a=this.box,k=this.nodes,c=2*Math.PI/(k.length+1),f=k.filter(function(b){return 0===b.linksTo.length}),e=[],h={},l=this.options.initialPositionRadius;f.forEach(function(a){e.push(a);b(a)});e.length?k.forEach(function(a){-1===e.indexOf(a)&&e.push(a)}):e=k;e.forEach(function(b,
d){b.plotX=b.prevX=g(b.plotX,a.width/2+l*Math.cos(d*c));b.plotY=b.prevY=g(b.plotY,a.height/2+l*Math.sin(d*c));b.dispX=0;b.dispY=0})},setRandomPositions:function(){function b(b){b=b*b/Math.PI;return b-=Math.floor(b)}var a=this.box,k=this.nodes,c=k.length+1;k.forEach(function(d,k){d.plotX=d.prevX=g(d.plotX,a.width*b(k));d.plotY=d.prevY=g(d.plotY,a.height*b(c+k));d.dispX=0;d.dispY=0})},force:function(b){this.integration[b].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter();
this.force("barycenter")},getBarycenter:function(){var b=0,a=0,k=0;this.nodes.forEach(function(d){a+=d.plotX*d.mass;k+=d.plotY*d.mass;b+=d.mass});return this.barycenter={x:a,y:k,xFactor:a/b,yFactor:k/b}},barnesHutApproximation:function(b,a){var d=this.getDistXY(b,a),c=this.vectorLength(d);if(b!==a&&0!==c)if(a.isInternal)if(a.boxSize/c<this.options.theta&&0!==c){var f=this.repulsiveForce(c,this.k);this.force("repulsive",b,f*a.mass,d,c);var e=!1}else e=!0;else f=this.repulsiveForce(c,this.k),this.force("repulsive",
b,f*a.mass,d,c);return e},repulsiveForces:function(){var a=this;"barnes-hut"===a.approximation?a.nodes.forEach(function(b){a.quadTree.visitNodeRecursive(null,function(d){return a.barnesHutApproximation(b,d)})}):a.nodes.forEach(function(b){a.nodes.forEach(function(d){if(b!==d&&!b.fixedPosition){var c=a.getDistXY(b,d);var k=a.vectorLength(c);if(0!==k){var f=a.repulsiveForce(k,a.k);a.force("repulsive",b,f*d.mass,c,k)}}})})},attractiveForces:function(){var a=this,d,c,f;a.links.forEach(function(b){b.fromNode&&
b.toNode&&(d=a.getDistXY(b.fromNode,b.toNode),c=a.vectorLength(d),0!==c&&(f=a.attractiveForce(c,a.k),a.force("attractive",b,f,d,c)))})},applyLimits:function(){var a=this;a.nodes.forEach(function(b){b.fixedPosition||(a.integration.integrate(a,b),a.applyLimitBox(b,a.box),b.dispX=0,b.dispY=0)})},applyLimitBox:function(a,d){var b=a.radius;a.plotX=Math.max(Math.min(a.plotX,d.width-b),d.left+b);a.plotY=Math.max(Math.min(a.plotY,d.height-b),d.top+b)},coolDown:function(a,d,c){return a-d*c},isStable:function(){return.00001>
Math.abs(this.systemTemperature-this.prevSystemTemperature)||0>=this.temperature},getSystemTemperature:function(){return this.nodes.reduce(function(a,d){return a+d.temperature},0)},vectorLength:function(a){return Math.sqrt(a.x*a.x+a.y*a.y)},getDistR:function(a,d){a=this.getDistXY(a,d);return this.vectorLength(a)},getDistXY:function(a,d){var b=a.plotX-d.plotX;a=a.plotY-d.plotY;return{x:b,y:a,absX:Math.abs(b),absY:Math.abs(a)}}});a(l,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(a){a.stop()})});
a(l,"render",function(){function a(a){a.maxIterations--&&isFinite(a.temperature)&&!a.isStable()&&!a.options.enableSimulation&&(a.beforeStep&&a.beforeStep(),a.step(),c=!1,d=!0)}var d=!1;if(this.graphLayoutsLookup){h(!1,this);for(this.graphLayoutsLookup.forEach(function(a){a.start()});!c;){var c=!0;this.graphLayoutsLookup.forEach(a)}d&&this.series.forEach(function(a){a&&a.layout&&a.render()})}})});m(h,"modules/networkgraph/draggable-nodes.js",[h["parts/Globals.js"]],function(e){var a=e.Chart,c=e.addEvent;
e.dragNodesMixin={onMouseDown:function(a,c){c=this.chart.pointer.normalize(c);a.fixedPosition={chartX:c.chartX,chartY:c.chartY,plotX:a.plotX,plotY:a.plotY};a.inDragMode=!0},onMouseMove:function(a,c){if(a.fixedPosition&&a.inDragMode){var f=this.chart,e=f.pointer.normalize(c);c=a.fixedPosition.chartX-e.chartX;e=a.fixedPosition.chartY-e.chartY;if(5<Math.abs(c)||5<Math.abs(e))c=a.fixedPosition.plotX-c,e=a.fixedPosition.plotY-e,f.isInsidePlot(c,e)&&(a.plotX=c,a.plotY=e,a.hasDragged=!0,this.redrawHalo(a),
this.layout.simulation?this.layout.resetSimulation():(this.layout.setInitialRendering(!1),this.layout.enableSimulation?this.layout.start():this.layout.setMaxIterations(1),this.chart.redraw(),this.layout.setInitialRendering(!0)))}},onMouseUp:function(a,c){a.fixedPosition&&a.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw(),a.inDragMode=a.hasDragged=!1,this.options.fixedDraggable||delete a.fixedPosition)},redrawHalo:function(a){a&&this.halo&&this.halo.attr({d:a.haloPath(this.options.states.hover.halo.size)})}};
c(a,"load",function(){var a=this,e,h,l;a.container&&(e=c(a.container,"mousedown",function(b){var d=a.hoverPoint;d&&d.series&&d.series.hasDraggableNodes&&d.series.options.draggable&&(d.series.onMouseDown(d,b),h=c(a.container,"mousemove",function(a){return d&&d.series&&d.series.onMouseMove(d,a)}),l=c(a.container.ownerDocument,"mouseup",function(a){h();l();return d&&d.series&&d.series.onMouseUp(d,a)}))}));c(a,"destroy",function(){e()})})});m(h,"modules/networkgraph/networkgraph.src.js",[h["parts/Globals.js"],
h["parts/Utilities.js"]],function(e,a){var c=a.defined,f=a.pick,g=e.addEvent;a=e.seriesType;var h=e.seriesTypes,l=e.Point,b=e.Series,d=e.dragNodesMixin;a("networkgraph","line",{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},
textPath:{enabled:!1}},link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1E3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1},{forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,drawGraph:null,isCartesian:!1,requireSorting:!1,directTouch:!0,noSharedTooltip:!0,pointArrayMap:["from",
"to"],trackerGroups:["group","markerGroup","dataLabelsGroup"],drawTracker:e.TrackerMixin.drawTrackerPoint,animate:null,buildKDTree:e.noop,createNode:e.NodesMixin.createNode,destroy:function(){this.layout.removeElementFromCollection(this,this.layout.series);e.NodesMixin.destroy.call(this)},init:function(){b.prototype.init.apply(this,arguments);g(this,"updatedData",function(){this.layout&&this.layout.stop()});return this},generatePoints:function(){var a;e.NodesMixin.generatePoints.apply(this,arguments);
this.options.nodes&&this.options.nodes.forEach(function(a){this.nodeLookup[a.id]||(this.nodeLookup[a.id]=this.createNode(a.id))},this);for(a=this.nodes.length-1;0<=a;a--){var b=this.nodes[a];b.degree=b.getDegree();b.radius=f(b.marker&&b.marker.radius,this.options.marker&&this.options.marker.radius,0);this.nodeLookup[b.id]||b.remove()}this.data.forEach(function(a){a.formatPrefix="link"});this.indexateNodes()},indexateNodes:function(){this.nodes.forEach(function(a,b){a.index=b})},markerAttribs:function(a,
d){d=b.prototype.markerAttribs.call(this,a,d);c(a.plotY)||(d.y=0);d.x=(a.plotX||0)-(d.width/2||0);return d},translate:function(){this.processedXData||this.processData();this.generatePoints();this.deferLayout();this.nodes.forEach(function(a){a.isInside=!0;a.linksFrom.forEach(function(a){a.shapeType="path";a.y=1})})},deferLayout:function(){var a=this.options.layoutAlgorithm,b=this.chart.graphLayoutsStorage,d=this.chart.graphLayoutsLookup,f=this.chart.options.chart;if(this.visible){b||(this.chart.graphLayoutsStorage=
b={},this.chart.graphLayoutsLookup=d=[]);var g=b[a.type];g||(a.enableSimulation=c(f.forExport)?!f.forExport:a.enableSimulation,b[a.type]=g=new e.layouts[a.type],g.init(a),d.splice(g.index,0,g));this.layout=g;g.setArea(0,0,this.chart.plotWidth,this.chart.plotHeight);g.addElementsToCollection([this],g.series);g.addElementsToCollection(this.nodes,g.nodes);g.addElementsToCollection(this.points,g.links)}},render:function(){var a=this.points,b=this.chart.hoverPoint,c=[];this.points=this.nodes;h.line.prototype.render.call(this);
this.points=a;a.forEach(function(a){a.fromNode&&a.toNode&&(a.renderLink(),a.redrawLink())});b&&b.series===this&&this.redrawHalo(b);this.chart.hasRendered&&!this.options.dataLabels.allowOverlap&&(this.nodes.concat(this.points).forEach(function(a){a.dataLabel&&c.push(a.dataLabel)}),this.chart.hideOverlappingLabels(c))},drawDataLabels:function(){var a=this.options.dataLabels.textPath;b.prototype.drawDataLabels.apply(this,arguments);this.points=this.data;this.options.dataLabels.textPath=this.options.dataLabels.linkTextPath;
b.prototype.drawDataLabels.apply(this,arguments);this.points=this.nodes;this.options.dataLabels.textPath=a},pointAttribs:function(a,c){var d=c||a.state||"normal";c=b.prototype.pointAttribs.call(this,a,d);d=this.options.states[d];a.isNode||(c=a.getLinkAttributes(),d&&(c={stroke:d.linkColor||c.stroke,dashstyle:d.linkDashStyle||c.dashstyle,opacity:f(d.linkOpacity,c.opacity),"stroke-width":d.linkColor||c["stroke-width"]}));return c},redrawHalo:d.redrawHalo,onMouseDown:d.onMouseDown,onMouseMove:d.onMouseMove,
onMouseUp:d.onMouseUp,setState:function(a,c){c?(this.points=this.nodes.concat(this.data),b.prototype.setState.apply(this,arguments),this.points=this.data):b.prototype.setState.apply(this,arguments);this.layout.simulation||a||this.render()}},{setState:e.NodesMixin.setNodeState,init:function(){l.prototype.init.apply(this,arguments);this.series.options.draggable&&!this.series.chart.styledMode&&(g(this,"mouseOver",function(){e.css(this.series.chart.container,{cursor:"move"})}),g(this,"mouseOut",function(){e.css(this.series.chart.container,
{cursor:"default"})}));return this},getDegree:function(){var a=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===a?1:a},getLinkAttributes:function(){var a=this.series.options.link,b=this.options;return{"stroke-width":f(b.width,a.width),stroke:b.color||a.color,dashstyle:b.dashStyle||a.dashStyle,opacity:f(b.opacity,a.opacity,1)}},renderLink:function(){if(!this.graphic&&(this.graphic=this.series.chart.renderer.path(this.getLinkPath()).add(this.series.group),!this.series.chart.styledMode)){var a=
this.series.pointAttribs(this);this.graphic.attr(a);(this.dataLabels||[]).forEach(function(b){b&&b.attr({opacity:a.opacity})})}},redrawLink:function(){var a=this.getLinkPath();if(this.graphic){this.shapeArgs={d:a};if(!this.series.chart.styledMode){var b=this.series.pointAttribs(this);this.graphic.attr(b);(this.dataLabels||[]).forEach(function(a){a&&a.attr({opacity:b.opacity})})}this.graphic.animate(this.shapeArgs);this.plotX=(a[1]+a[4])/2;this.plotY=(a[2]+a[5])/2}},getMass:function(){var a=this.fromNode.mass,
b=this.toNode.mass,c=a+b;return{fromNode:1-a/c,toNode:1-b/c}},getLinkPath:function(){var a=this.fromNode,b=this.toNode;a.plotX>b.plotX&&(a=this.toNode,b=this.fromNode);return["M",a.plotX,a.plotY,"L",b.plotX,b.plotY]},isValid:function(){return!this.isNode||c(this.id)},remove:function(a,c){var d=this.series,e=d.options.nodes||[],f,g=e.length;if(this.isNode){d.points=[];[].concat(this.linksFrom).concat(this.linksTo).forEach(function(a){f=a.fromNode.linksFrom.indexOf(a);-1<f&&a.fromNode.linksFrom.splice(f,
1);f=a.toNode.linksTo.indexOf(a);-1<f&&a.toNode.linksTo.splice(f,1);b.prototype.removePoint.call(d,d.data.indexOf(a),!1,!1)});d.points=d.data.slice();for(d.nodes.splice(d.nodes.indexOf(this),1);g--;)if(e[g].id===this.options.id){d.options.nodes.splice(g,1);break}this&&this.destroy();d.isDirty=!0;d.isDirtyData=!0;a&&d.chart.redraw(a)}else d.removePoint(d.data.indexOf(this),a,c)},destroy:function(){this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(a){a.destroyElements&&a.destroyElements()});
this.series.layout.removeElementFromCollection(this,this.series.layout[this.isNode?"nodes":"links"]);return l.prototype.destroy.apply(this,arguments)}});""});m(h,"masters/modules/networkgraph.src.js",[],function(){})});
//# sourceMappingURL=networkgraph.js.map