/*
 Highstock JS v7.2.1 (2019-10-31)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(n){"object"===typeof module&&module.exports?(n["default"]=n,module.exports=n):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(G){n(G);n.Highcharts=G;return n}):n("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(n){function G(e,g,n,A){e.hasOwnProperty(g)||(e[g]=A.apply(null,n))}n=n?n._modules:{};G(n,"parts/Scrollbar.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,g){function n(b,f,p){this.init(b,f,p)}var A=g.defined,
E=g.destroyObjectProperties,z=g.pick,B=e.addEvent;g=e.Axis;var v=e.correctFloat,t=e.defaultOptions,x=e.fireEvent,d=e.hasTouch,k=e.merge,w=e.removeEvent,y,l={height:e.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",
trackBorderColor:"#f2f2f2",trackBorderWidth:1};t.scrollbar=k(!0,l,t.scrollbar);e.swapXY=y=function(b,f){var p=b.length;if(f)for(f=0;f<p;f+=3){var d=b[f+1];b[f+1]=b[f+2];b[f+2]=d}return b};n.prototype={init:function(b,f,p){this.scrollbarButtons=[];this.renderer=b;this.userOptions=f;this.options=k(l,f);this.chart=p;this.size=z(this.options.size,this.options.height);f.enabled&&(this.render(),this.initEvents(),this.addEvents())},render:function(){var b=this.renderer,f=this.options,p=this.size,d=this.chart.styledMode,
a;this.group=a=b.g("scrollbar").attr({zIndex:f.zIndex,translateY:-99999}).add();this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:f.trackBorderRadius||0,height:p,width:p}).add(a);d||this.track.attr({fill:f.trackBackgroundColor,stroke:f.trackBorderColor,"stroke-width":f.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=b.g().add(a);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:p,
width:p,r:f.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(y(["M",-3,p/4,"L",-3,2*p/3,"M",0,p/4,"L",0,2*p/3,"M",3,p/4,"L",3,2*p/3],f.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);d||(this.scrollbar.attr({fill:f.barBackgroundColor,stroke:f.barBorderColor,"stroke-width":f.barBorderWidth}),this.scrollbarRifles.attr({stroke:f.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)},position:function(b,f,p,d){var a=this.options.vertical,m=0,q=this.rendered?"animate":"attr";this.x=b;this.y=f+this.trackBorderWidth;this.width=p;this.xOffset=this.height=d;this.yOffset=m;a?(this.width=this.yOffset=p=m=this.size,this.xOffset=f=0,this.barWidth=d-2*p,this.x=b+=this.options.margin):(this.height=this.xOffset=d=f=this.size,this.barWidth=p-2*d,this.y+=this.options.margin);this.group[q]({translateX:b,
translateY:this.y});this.track[q]({width:p,height:d});this.scrollbarButtons[1][q]({translateX:a?0:p-f,translateY:a?d-m:0})},drawScrollbarButton:function(b){var f=this.renderer,p=this.scrollbarButtons,d=this.options,a=this.size;var m=f.g().add(this.group);p.push(m);m=f.rect().addClass("highcharts-scrollbar-button").add(m);this.chart.styledMode||m.attr({stroke:d.buttonBorderColor,"stroke-width":d.buttonBorderWidth,fill:d.buttonBackgroundColor});m.attr(m.crisp({x:-.5,y:-.5,width:a+1,height:a+1,r:d.buttonBorderRadius},
m.strokeWidth()));m=f.path(y(["M",a/2+(b?-1:1),a/2-3,"L",a/2+(b?-1:1),a/2+3,"L",a/2+(b?2:-2),a/2],d.vertical)).addClass("highcharts-scrollbar-arrow").add(p[b]);this.chart.styledMode||m.attr({fill:d.buttonArrowColor})},setRange:function(b,f){var p=this.options,d=p.vertical,a=p.minWidth,m=this.barWidth,q,u=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(A(m)){b=Math.max(b,0);var c=Math.ceil(m*b);this.calculatedWidth=q=v(m*Math.min(f,1)-c);q<
a&&(c=(m-a+q)*b,q=a);a=Math.floor(c+this.xOffset+this.yOffset);m=q/2-.5;this.from=b;this.to=f;d?(this.scrollbarGroup[u]({translateY:a}),this.scrollbar[u]({height:q}),this.scrollbarRifles[u]({translateY:m}),this.scrollbarTop=a,this.scrollbarLeft=0):(this.scrollbarGroup[u]({translateX:a}),this.scrollbar[u]({width:q}),this.scrollbarRifles[u]({translateX:m}),this.scrollbarLeft=a,this.scrollbarTop=0);12>=q?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===p.showFull&&(0>=b&&1<=f?this.group.hide():
this.group.show());this.rendered=!0}},initEvents:function(){var b=this;b.mouseMoveHandler=function(f){var d=b.chart.pointer.normalize(f),k=b.options.vertical?"chartY":"chartX",a=b.initPositions;!b.grabbedCenter||f.touches&&0===f.touches[0][k]||(d=b.cursorToScrollbarPosition(d)[k],k=b[k],k=d-k,b.hasDragged=!0,b.updatePosition(a[0]+k,a[1]+k),b.hasDragged&&x(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMType:f.type,DOMEvent:f}))};b.mouseUpHandler=function(f){b.hasDragged&&x(b,"changed",{from:b.from,
to:b.to,trigger:"scrollbar",DOMType:f.type,DOMEvent:f});b.grabbedCenter=b.hasDragged=b.chartX=b.chartY=null};b.mouseDownHandler=function(f){f=b.chart.pointer.normalize(f);f=b.cursorToScrollbarPosition(f);b.chartX=f.chartX;b.chartY=f.chartY;b.initPositions=[b.from,b.to];b.grabbedCenter=!0};b.buttonToMinClick=function(f){var d=v(b.to-b.from)*b.options.step;b.updatePosition(v(b.from-d),v(b.to-d));x(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMEvent:f})};b.buttonToMaxClick=function(f){var d=
(b.to-b.from)*b.options.step;b.updatePosition(b.from+d,b.to+d);x(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMEvent:f})};b.trackClick=function(f){var d=b.chart.pointer.normalize(f),k=b.to-b.from,a=b.y+b.scrollbarTop,m=b.x+b.scrollbarLeft;b.options.vertical&&d.chartY>a||!b.options.vertical&&d.chartX>m?b.updatePosition(b.from+k,b.to+k):b.updatePosition(b.from-k,b.to-k);x(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMEvent:f})}},cursorToScrollbarPosition:function(b){var f=this.options;
f=f.minWidth>this.calculatedWidth?f.minWidth:0;return{chartX:(b.chartX-this.x-this.xOffset)/(this.barWidth-f),chartY:(b.chartY-this.y-this.yOffset)/(this.barWidth-f)}},updatePosition:function(b,f){1<f&&(b=v(1-v(f-b)),f=1);0>b&&(f=v(f-b),b=0);this.from=b;this.to=f},update:function(b){this.destroy();this.init(this.chart.renderer,k(!0,this.options,b),this.chart)},addEvents:function(){var b=this.options.inverted?[1,0]:[0,1],f=this.scrollbarButtons,p=this.scrollbarGroup.element,k=this.mouseDownHandler,
a=this.mouseMoveHandler,m=this.mouseUpHandler;b=[[f[b[0]].element,"click",this.buttonToMinClick],[f[b[1]].element,"click",this.buttonToMaxClick],[this.track.element,"click",this.trackClick],[p,"mousedown",k],[p.ownerDocument,"mousemove",a],[p.ownerDocument,"mouseup",m]];d&&b.push([p,"touchstart",k],[p.ownerDocument,"touchmove",a],[p.ownerDocument,"touchend",m]);b.forEach(function(b){B.apply(null,b)});this._events=b},removeEvents:function(){this._events.forEach(function(b){w.apply(null,b)});this._events.length=
0},destroy:function(){var b=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(b){this[b]&&this[b].destroy&&(this[b]=this[b].destroy())},this);b&&this===b.scrollbar&&(b.scrollbar=null,E(b.scrollbarButtons))}};e.Scrollbar||(B(g,"afterInit",function(){var b=this;b.options&&b.options.scrollbar&&b.options.scrollbar.enabled&&(b.options.scrollbar.vertical=!b.horiz,b.options.startOnTick=b.options.endOnTick=!1,b.scrollbar=new n(b.chart.renderer,
b.options.scrollbar,b.chart),B(b.scrollbar,"changed",function(f){var d=Math.min(z(b.options.min,b.min),b.min,b.dataMin),k=Math.max(z(b.options.max,b.max),b.max,b.dataMax)-d;if(b.horiz&&!b.reversed||!b.horiz&&b.reversed){var a=d+k*this.to;d+=k*this.from}else a=d+k*(1-this.from),d+=k*(1-this.to);z(this.options.liveRedraw,e.svg&&!e.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===f.DOMType||!A(f.DOMType)?b.setExtremes(d,a,!0,"mousemove"!==f.DOMType,f):this.setRange(this.from,this.to)}))}),B(g,"afterRender",
function(){var b=Math.min(z(this.options.min,this.min),this.min,z(this.dataMin,this.min)),f=Math.max(z(this.options.max,this.max),this.max,z(this.dataMax,this.max)),d=this.scrollbar,k=this.axisTitleMargin+(this.titleOffset||0),a=this.chart.scrollbarsOffsets,m=this.options.margin||0;d&&(this.horiz?(this.opposite||(a[1]+=k),d.position(this.left,this.top+this.height+2+a[1]-(this.opposite?m:0),this.width,this.height),this.opposite||(a[1]+=m),k=1):(this.opposite&&(a[0]+=k),d.position(this.left+this.width+
2+a[0]-(this.opposite?0:m),this.top,this.width,this.height),this.opposite&&(a[0]+=m),k=0),a[k]+=d.size+d.options.margin,isNaN(b)||isNaN(f)||!A(this.min)||!A(this.max)||this.min===this.max?d.setRange(0,1):(a=(this.min-b)/(f-b),b=(this.max-b)/(f-b),this.horiz&&!this.reversed||!this.horiz&&this.reversed?d.setRange(a,b):d.setRange(1-b,1-a)))}),B(g,"afterGetOffset",function(){var b=this.horiz?2:1,f=this.scrollbar;f&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[b]+=f.size+f.options.margin)}),
e.Scrollbar=n)});G(n,"parts/Navigator.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,g){function n(c){this.init(c)}var A=g.defined,E=g.destroyObjectProperties,z=g.erase,B=g.extend,v=g.isArray,t=g.isNumber,x=g.pick,d=g.splat,k=e.addEvent,w=e.Axis;g=e.Chart;var y=e.color,l=e.defaultOptions,b=e.hasTouch,f=e.isTouchDevice,p=e.merge,F=e.removeEvent,a=e.Scrollbar,m=e.Series,q=function(c){for(var r=[],h=1;h<arguments.length;h++)r[h-1]=arguments[h];r=[].filter.call(r,t);if(r.length)return Math[c].apply(0,
r)};var u=void 0===e.seriesTypes.areaspline?"line":"areaspline";B(l,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:y("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:u,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,smoothed:!0,units:[["millisecond",[1,
2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",
style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});e.Renderer.prototype.symbols["navigator-handle"]=function(c,r,h,b,a){c=a.width/2;r=Math.round(c/3)+.5;a=a.height;return["M",-c-1,.5,"L",c,.5,"L",c,a+.5,"L",-c-1,a+.5,"L",-c-1,.5,"M",-r,4,"L",-r,a-3,"M",r-1,4,"L",r-1,a-3]};w.prototype.toFixedRange=function(c,
r,h,b){var a=this.chart&&this.chart.fixedRange,C=(this.pointRange||0)/2;c=x(h,this.translate(c,!0,!this.horiz));r=x(b,this.translate(r,!0,!this.horiz));var f=a&&(r-c)/a;A(h)||(c=e.correctFloat(c+C));A(b)||(r=e.correctFloat(r-C));.7<f&&1.3>f&&(b?c=r-a:r=c+a);t(c)&&t(r)||(c=r=void 0);return{min:c,max:r}};n.prototype={drawHandle:function(c,r,h,b){var a=this.navigatorOptions.handles.height;this.handles[r][b](h?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(c,10)+
.5-a)}:{translateX:Math.round(this.left+parseInt(c,10)),translateY:Math.round(this.top+this.height/2-a/2-1)})},drawOutline:function(c,r,h,b){var a=this.navigatorOptions.maskInside,f=this.outline.strokeWidth(),C=f/2;f=f%2/2;var d=this.outlineHeight,m=this.scrollbarHeight,q=this.size,k=this.left-m,u=this.top;h?(k-=C,h=u+r+f,r=u+c+f,c=["M",k+d,u-m-f,"L",k+d,h,"L",k,h,"L",k,r,"L",k+d,r,"L",k+d,u+q+m].concat(a?["M",k+d,h-C,"L",k+d,r+C]:[])):(c+=k+m-f,r+=k+m-f,u+=C,c=["M",k,u,"L",c,u,"L",c,u+d,"L",r,u+
d,"L",r,u,"L",k+q+2*m,u].concat(a?["M",c-C,u,"L",r+C,u]:[]));this.outline[b]({d:c})},drawMasks:function(c,r,h,b){var a=this.left,f=this.top,C=this.height;if(h){var d=[a,a,a];var m=[f,f+c,f+r];var q=[C,C,C];var k=[c,r-c,this.size-r]}else d=[a,a+c,a+r],m=[f,f,f],q=[c,r-c,this.size-r],k=[C,C,C];this.shades.forEach(function(c,h){c[b]({x:d[h],y:m[h],width:q[h],height:k[h]})})},renderElements:function(){var c=this,r=c.navigatorOptions,h=r.maskInside,a=c.chart,b=a.renderer,f,d={cursor:a.inverted?"ns-resize":
"ew-resize"};c.navigatorGroup=f=b.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!h,h,!h].forEach(function(h,D){c.shades[D]=b.rect().addClass("highcharts-navigator-mask"+(1===D?"-inside":"-outside")).add(f);a.styledMode||c.shades[D].attr({fill:h?r.maskFill:"rgba(0,0,0,0)"}).css(1===D&&d)});c.outline=b.path().addClass("highcharts-navigator-outline").add(f);a.styledMode||c.outline.attr({"stroke-width":r.outlineWidth,stroke:r.outlineColor});r.handles.enabled&&[0,1].forEach(function(h){r.handles.inverted=
a.inverted;c.handles[h]=b.symbol(r.handles.symbols[h],-r.handles.width/2-1,0,r.handles.width,r.handles.height,r.handles);c.handles[h].attr({zIndex:7-h}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][h]).add(f);if(!a.styledMode){var D=r.handles;c.handles[h].attr({fill:D.backgroundColor,stroke:D.borderColor,"stroke-width":D.lineWidth}).css(d)}})},update:function(c){(this.series||[]).forEach(function(c){c.baseSeries&&delete c.baseSeries.navigatorSeries});this.destroy();
p(!0,this.chart.options.navigator,this.options,c);this.init(this.chart)},render:function(c,r,h,a){var b=this.chart,f=this.scrollbarHeight,d,C=this.xAxis,m=C.pointRange||0;var q=C.fake?b.xAxis[0]:C;var k=this.navigatorEnabled,u,p=this.rendered;var l=b.inverted;var w=b.xAxis[0].minRange,y=b.xAxis[0].options.maxRange;if(!this.hasDragged||A(h)){c=e.correctFloat(c-m/2);r=e.correctFloat(r+m/2);if(!t(c)||!t(r))if(p)h=0,a=x(C.width,q.width);else return;this.left=x(C.left,b.plotLeft+f+(l?b.plotWidth:0));this.size=
u=d=x(C.len,(l?b.plotHeight:b.plotWidth)-2*f);b=l?f:d+2*f;h=x(h,C.toPixels(c,!0));a=x(a,C.toPixels(r,!0));t(h)&&Infinity!==Math.abs(h)||(h=0,a=b);c=C.toValue(h,!0);r=C.toValue(a,!0);var g=Math.abs(e.correctFloat(r-c));e.correctFloat(g-m)<w?this.grabbedLeft?h=C.toPixels(r-w-m,!0):this.grabbedRight&&(a=C.toPixels(c+w+m,!0)):A(y)&&e.correctFloat(g-m)>y&&(this.grabbedLeft?h=C.toPixels(r-y-m,!0):this.grabbedRight&&(a=C.toPixels(c+y+m,!0)));this.zoomedMax=Math.min(Math.max(h,a,0),u);this.zoomedMin=Math.min(Math.max(this.fixedWidth?
this.zoomedMax-this.fixedWidth:Math.min(h,a),0),u);this.range=this.zoomedMax-this.zoomedMin;u=Math.round(this.zoomedMax);h=Math.round(this.zoomedMin);k&&(this.navigatorGroup.attr({visibility:"visible"}),p=p&&!this.hasDragged?"animate":"attr",this.drawMasks(h,u,l,p),this.drawOutline(h,u,l,p),this.navigatorOptions.handles.enabled&&(this.drawHandle(h,0,l,p),this.drawHandle(u,1,l,p)));this.scrollbar&&(l?(l=this.top-f,q=this.left-f+(k||!q.opposite?0:(q.titleOffset||0)+q.axisTitleMargin),f=d+2*f):(l=this.top+
(k?this.height:-f),q=this.left-f),this.scrollbar.position(q,l,b,f),this.scrollbar.setRange(this.zoomedMin/(d||1),this.zoomedMax/(d||1)));this.rendered=!0}},addMouseEvents:function(){var c=this,r=c.chart,h=r.container,a=[],f,d;c.mouseMoveHandler=f=function(h){c.onMouseMove(h)};c.mouseUpHandler=d=function(h){c.onMouseUp(h)};a=c.getPartsEvents("mousedown");a.push(k(r.renderTo,"mousemove",f),k(h.ownerDocument,"mouseup",d));b&&(a.push(k(r.renderTo,"touchmove",f),k(h.ownerDocument,"touchend",d)),a.concat(c.getPartsEvents("touchstart")));
c.eventsToUnbind=a;c.series&&c.series[0]&&a.push(k(c.series[0].xAxis,"foundExtremes",function(){r.navigator.modifyNavigatorAxisExtremes()}))},getPartsEvents:function(c){var a=this,h=[];["shades","handles"].forEach(function(r){a[r].forEach(function(b,f){h.push(k(b.element,c,function(c){a[r+"Mousedown"](c,f)}))})});return h},shadesMousedown:function(c,a){c=this.chart.pointer.normalize(c);var h=this.chart,b=this.xAxis,r=this.zoomedMin,f=this.left,d=this.size,m=this.range,q=c.chartX;h.inverted&&(q=c.chartY,
f=this.top);if(1===a)this.grabbedCenter=q,this.fixedWidth=m,this.dragOffset=q-r;else{c=q-f-m/2;if(0===a)c=Math.max(0,c);else if(2===a&&c+m>=d)if(c=d-m,this.reversedExtremes){c-=m;var k=this.getUnionExtremes().dataMin}else var u=this.getUnionExtremes().dataMax;c!==r&&(this.fixedWidth=m,a=b.toFixedRange(c,c+m,k,u),A(a.min)&&h.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}},handlesMousedown:function(c,a){this.chart.pointer.normalize(c);c=this.chart;
var h=c.xAxis[0],b=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=b?h.min:h.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=b?h.max:h.min);c.fixedRange=null},onMouseMove:function(c){var a=this,h=a.chart,b=a.left,d=a.navigatorSize,m=a.range,q=a.dragOffset,k=h.inverted;c.touches&&0===c.touches[0].pageX||(c=h.pointer.normalize(c),h=c.chartX,k&&(b=a.top,h=c.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,h-b,a.otherHandlePos)):
a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,h-b)):a.grabbedCenter&&(a.hasDragged=!0,h<q?h=q:h>d+q-m&&(h=d+q-m),a.render(0,0,h-q,h-q+m)),a.hasDragged&&a.scrollbar&&x(a.scrollbar.options.liveRedraw,e.svg&&!f&&!this.chart.isBoosting)&&(c.DOMType=c.type,setTimeout(function(){a.onMouseUp(c)},0)))},onMouseUp:function(c){var a=this.chart,h=this.xAxis,b=this.scrollbar,f=c.DOMEvent||c;if(this.hasDragged&&(!b||!b.hasDragged)||"scrollbar"===c.trigger){b=this.getUnionExtremes();if(this.zoomedMin===
this.otherHandlePos)var d=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var m=this.fixedExtreme;this.zoomedMax===this.size&&(m=this.reversedExtremes?b.dataMin:b.dataMax);0===this.zoomedMin&&(d=this.reversedExtremes?b.dataMax:b.dataMin);h=h.toFixedRange(this.zoomedMin,this.zoomedMax,d,m);A(h.min)&&a.xAxis[0].setExtremes(Math.min(h.min,h.max),Math.max(h.min,h.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:f})}"mousemove"!==c.DOMType&&"touchmove"!==
c.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null)},removeEvents:function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(c){c()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()},removeBaseSeriesEvents:function(){var c=this.baseSeries||[];this.navigatorEnabled&&c[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&c.forEach(function(c){F(c,"updatedData",this.updatedDataHandler)},
this),c[0].xAxis&&F(c[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},init:function(c){var b=c.options,h=b.navigator,f=h.enabled,d=b.scrollbar,m=d.enabled;b=f?h.height:0;var u=m?d.height:0;this.handles=[];this.shades=[];this.chart=c;this.setBaseSeries();this.height=b;this.scrollbarHeight=u;this.scrollbarEnabled=m;this.navigatorEnabled=f;this.navigatorOptions=h;this.scrollbarOptions=d;this.outlineHeight=b+u;this.opposite=x(h.opposite,!(f||!c.inverted));var l=this;f=l.baseSeries;d=c.xAxis.length;
m=c.yAxis.length;var e=f&&f[0]&&f[0].xAxis||c.xAxis[0]||{options:{}};c.isDirtyBox=!0;l.navigatorEnabled?(l.xAxis=new w(c,p({breaks:e.options.breaks,ordinal:e.options.ordinal},h.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:d,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},c.inverted?{offsets:[u,0,-u,0],width:b}:{offsets:[0,-u,0,u],height:b})),l.yAxis=new w(c,p(h.yAxis,{id:"navigator-y-axis",alignTicks:!1,
offset:0,index:m,isInternal:!0,zoomEnabled:!1},c.inverted?{width:b}:{height:b})),f||h.series.data?l.updateNavigatorSeries(!1):0===c.series.length&&(l.unbindRedraw=k(c,"beforeRedraw",function(){0<c.series.length&&!l.series&&(l.setBaseSeries(),l.unbindRedraw())})),l.reversedExtremes=c.inverted&&!l.xAxis.reversed||!c.inverted&&l.xAxis.reversed,l.renderElements(),l.addMouseEvents()):l.xAxis={translate:function(h,a){var b=c.xAxis[0],r=b.getExtremes(),f=b.len-2*u,d=q("min",b.options.min,r.dataMin);b=q("max",
b.options.max,r.dataMax)-d;return a?h*b/f+d:f*(h-d)/b},toPixels:function(c){return this.translate(c)},toValue:function(c){return this.translate(c,!0)},toFixedRange:w.prototype.toFixedRange,fake:!0};c.options.scrollbar.enabled&&(c.scrollbar=l.scrollbar=new a(c.renderer,p(c.options.scrollbar,{margin:l.navigatorEnabled?0:10,vertical:c.inverted}),c),k(l.scrollbar,"changed",function(h){var a=l.size,b=a*this.to;a*=this.from;l.hasDragged=l.scrollbar.hasDragged;l.render(0,0,a,b);(c.options.scrollbar.liveRedraw||
"mousemove"!==h.DOMType&&"touchmove"!==h.DOMType)&&setTimeout(function(){l.onMouseUp(h)})}));l.addBaseSeriesEvents();l.addChartEvents()},getUnionExtremes:function(c){var a=this.chart.xAxis[0],h=this.xAxis,b=h.options,f=a.options,d;c&&null===a.dataMin||(d={dataMin:x(b&&b.min,q("min",f.min,a.dataMin,h.dataMin,h.min)),dataMax:x(b&&b.max,q("max",f.max,a.dataMax,h.dataMax,h.max))});return d},setBaseSeries:function(c,a){var h=this.chart,b=this.baseSeries=[];c=c||h.options&&h.options.navigator.baseSeries||
(h.series.length?e.find(h.series,function(c){return!c.options.isInternal}).index:0);(h.series||[]).forEach(function(h,a){h.options.isInternal||!h.options.showInNavigator&&(a!==c&&h.options.id!==c||!1===h.options.showInNavigator)||b.push(h)});this.xAxis&&!this.xAxis.fake&&this.updateNavigatorSeries(!0,a)},updateNavigatorSeries:function(c,a){var h=this,b=h.chart,f=h.baseSeries,r,m,q=h.navigatorOptions.series,k,u={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",
yAxis:"navigator-y-axis",showInLegend:!1,stacking:!1,isInternal:!0,states:{inactive:{opacity:1}}},e=h.series=(h.series||[]).filter(function(c){var a=c.baseSeries;return 0>f.indexOf(a)?(a&&(F(a,"updatedData",h.updatedDataHandler),delete a.navigatorSeries),c.chart&&c.destroy(),!1):!0});f&&f.length&&f.forEach(function(c){var d=c.navigatorSeries,D=B({color:c.color,visible:c.visible},v(q)?l.navigator.series:q);d&&!1===h.navigatorOptions.adaptToUpdatedData||(u.name="Navigator "+f.length,r=c.options||{},
k=r.navigatorOptions||{},m=p(r,u,D,k),m.pointRange=x(D.pointRange,k.pointRange,l.plotOptions[m.type||"line"].pointRange),D=k.data||D.data,h.hasNavigatorData=h.hasNavigatorData||!!D,m.data=D||r.data&&r.data.slice(0),d&&d.options?d.update(m,a):(c.navigatorSeries=b.initSeries(m),c.navigatorSeries.baseSeries=c,e.push(c.navigatorSeries)))});if(q.data&&(!f||!f.length)||v(q))h.hasNavigatorData=!1,q=d(q),q.forEach(function(c,a){u.name="Navigator "+(e.length+1);m=p(l.navigator.series,{color:b.series[a]&&!b.series[a].options.isInternal&&
b.series[a].color||b.options.colors[a]||b.options.colors[0]},u,c);m.data=c.data;m.data&&(h.hasNavigatorData=!0,e.push(b.initSeries(m)))});c&&this.addBaseSeriesEvents()},addBaseSeriesEvents:function(){var c=this,a=c.baseSeries||[];a[0]&&a[0].xAxis&&k(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);a.forEach(function(h){k(h,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});k(h,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)});!1!==
this.navigatorOptions.adaptToUpdatedData&&h.xAxis&&k(h,"updatedData",this.updatedDataHandler);k(h,"remove",function(){this.navigatorSeries&&(z(c.series,this.navigatorSeries),A(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)})},this)},getBaseSeriesMin:function(c){return this.baseSeries.reduce(function(c,h){return Math.min(c,h.xData?h.xData[0]:c)},c)},modifyNavigatorAxisExtremes:function(){var c=this.xAxis,a;"undefined"!==typeof c.getExtremes&&(!(a=this.getUnionExtremes(!0))||
a.dataMin===c.min&&a.dataMax===c.max||(c.min=a.dataMin,c.max=a.dataMax))},modifyBaseAxisExtremes:function(){var c=this.chart.navigator,a=this.getExtremes(),h=a.dataMin,b=a.dataMax;a=a.max-a.min;var f=c.stickToMin,d=c.stickToMax,m=x(this.options.overscroll,0),q=c.series&&c.series[0],k=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(f){var u=h;var l=u+a}d&&(l=b+m,f||(u=Math.max(l-a,c.getBaseSeriesMin(q&&q.xData?q.xData[0]:-Number.MAX_VALUE))));k&&(f||d)&&t(u)&&
(this.min=this.userMin=u,this.max=this.userMax=l)}c.stickToMin=c.stickToMax=null},updatedDataHandler:function(){var c=this.chart.navigator,a=this.navigatorSeries,h=c.getBaseSeriesMin(this.xData[0]);c.stickToMax=c.reversedExtremes?0===Math.round(c.zoomedMin):Math.round(c.zoomedMax)>=Math.round(c.size);c.stickToMin=t(this.xAxis.min)&&this.xAxis.min<=h&&(!this.chart.fixedRange||!c.stickToMax);a&&!c.hasNavigatorData&&(a.options.pointStart=this.xData[0],a.setData(this.options.data,!1,null,!1))},addChartEvents:function(){this.eventsToUnbind||
(this.eventsToUnbind=[]);this.eventsToUnbind.push(k(this.chart,"redraw",function(){var c=this.navigator,a=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||c.scrollbar&&this.xAxis[0]);a&&c.render(a.min,a.max)}),k(this.chart,"getMargins",function(){var c=this.navigator,a=c.opposite?"plotTop":"marginBottom";this.inverted&&(a=c.opposite?"marginRight":"plotLeft");this[a]=(this[a]||0)+(c.navigatorEnabled||!this.inverted?c.outlineHeight:0)+c.navigatorOptions.margin}))},destroy:function(){this.removeEvents();
this.xAxis&&(z(this.chart.xAxis,this.xAxis),z(this.chart.axes,this.xAxis));this.yAxis&&(z(this.chart.yAxis,this.yAxis),z(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(c){this[c]&&this[c].destroy&&this[c].destroy();this[c]=null},this);[this.handles].forEach(function(c){E(c)},this)}};e.Navigator||(e.Navigator=n,
k(w,"zoom",function(c){var a=this.chart.options,h=a.chart.zoomType,b=a.chart.pinchType,d=a.navigator;a=a.rangeSelector;this.isXAxis&&(d&&d.enabled||a&&a.enabled)&&("y"===h?c.zoomed=!1:(!f&&"xy"===h||f&&"xy"===b)&&this.options.range&&(h=this.previousZoom,A(c.newMin)?this.previousZoom=[this.min,this.max]:h&&(c.newMin=h[0],c.newMax=h[1],delete this.previousZoom)));void 0!==c.zoomed&&c.preventDefault()}),k(g,"beforeShowResetZoom",function(){var c=this.options,a=c.navigator,h=c.rangeSelector;if((a&&a.enabled||
h&&h.enabled)&&(!f&&"x"===c.chart.zoomType||f&&"x"===c.chart.pinchType))return!1}),k(g,"beforeRender",function(){var c=this.options;if(c.navigator.enabled||c.scrollbar.enabled)this.scroller=this.navigator=new n(this)}),k(g,"afterSetChartSize",function(){var c=this.legend,a=this.navigator;if(a){var h=c&&c.options;var b=a.xAxis;var f=a.yAxis;var d=a.scrollbarHeight;this.inverted?(a.left=a.opposite?this.chartWidth-d-a.height:this.spacing[3]+d,a.top=this.plotTop+d):(a.left=this.plotLeft+d,a.top=a.navigatorOptions.top||
this.chartHeight-a.height-d-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(h&&"bottom"===h.verticalAlign&&h.enabled&&!h.floating?c.legendHeight+x(h.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));b&&f&&(this.inverted?b.options.left=f.options.left=a.left:b.options.top=f.options.top=a.top,b.setAxisSize(),f.setAxisSize())}}),k(g,"update",function(a){var c=a.options.navigator||{},h=a.options.scrollbar||{};this.navigator||this.scroller||!c.enabled&&
!h.enabled||(p(!0,this.options.navigator,c),p(!0,this.options.scrollbar,h),delete a.options.navigator,delete a.options.scrollbar)}),k(g,"afterUpdate",function(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new n(this),x(a.redraw,!0)&&this.redraw(a.animation))}),k(g,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),k(m,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&
this.chart.navigator.setBaseSeries(null,!1)}),g.prototype.callbacks.push(function(a){var c=a.navigator;c&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),c.render(a.min,a.max))}))});G(n,"parts/OrdinalAxis.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,g){var n=g.defined,A=g.extend,E=g.pick;g=e.addEvent;var z=e.Axis,B=e.Chart,v=e.css,t=e.noop,x=e.timeUnits;g(e.Series,"updatedData",function(){var d=this.xAxis;d&&d.options.ordinal&&delete d.ordinalIndex});z.prototype.getTimeTicks=function(d,
k,e,y,l,b,f){var p=0,w,a,m={},q=[],u=-Number.MAX_VALUE,c=this.options.tickPixelInterval,r=this.chart.time,h=[];if(!this.options.ordinal&&!this.options.breaks||!l||3>l.length||void 0===k)return r.getTimeTicks.apply(r,arguments);var C=l.length;for(w=0;w<C;w++){var D=w&&l[w-1]>e;l[w]<k&&(p=w);if(w===C-1||l[w+1]-l[w]>5*b||D){if(l[w]>u){for(a=r.getTimeTicks(d,l[p],l[w],y);a.length&&a[0]<=u;)a.shift();a.length&&(u=a[a.length-1]);h.push(q.length);q=q.concat(a)}p=w+1}if(D)break}a=a.info;if(f&&a.unitRange<=
x.hour){w=q.length-1;for(p=1;p<w;p++)if(r.dateFormat("%d",q[p])!==r.dateFormat("%d",q[p-1])){m[q[p]]="day";var H=!0}H&&(m[q[0]]="day");a.higherRanks=m}a.segmentStarts=h;q.info=a;if(f&&n(c)){p=h=q.length;H=[];var g;for(r=[];p--;)w=this.translate(q[p]),g&&(r[p]=g-w),H[p]=g=w;r.sort();r=r[Math.floor(r.length/2)];r<.6*c&&(r=null);p=q[h-1]>e?h-1:h;for(g=void 0;p--;)w=H[p],h=Math.abs(g-w),g&&h<.8*c&&(null===r||h<.8*r)?(m[q[p]]&&!m[q[p+1]]?(h=p+1,g=w):h=p,q.splice(h,1)):g=w}return q};A(z.prototype,{beforeSetTickPositions:function(){var d=
[],k,w=!1,e=this.getExtremes(),l=e.min,b=e.max,f,p=this.isXAxis&&!!this.options.breaks;e=this.options.ordinal;var g=Number.MAX_VALUE,a=this.chart.options.chart.ignoreHiddenSeries,m;if(e||p){this.series.forEach(function(c,b){k=[];if(!(a&&!1===c.visible||!1===c.takeOrdinalPosition&&!p)&&(d=d.concat(c.processedXData),q=d.length,d.sort(function(a,c){return a-c}),g=Math.min(g,E(c.closestPointRange,g)),q)){for(b=0;b<q-1;)d[b]!==d[b+1]&&k.push(d[b+1]),b++;k[0]!==d[0]&&k.unshift(d[0]);d=k}c.isSeriesBoosting&&
(m=!0)});m&&(d.length=0);var q=d.length;if(2<q){var u=d[1]-d[0];for(f=q-1;f--&&!w;)d[f+1]-d[f]!==u&&(w=!0);!this.options.keepOrdinalPadding&&(d[0]-l>u||b-d[d.length-1]>u)&&(w=!0)}else this.options.overscroll&&(2===q?g=d[1]-d[0]:1===q?(g=this.options.overscroll,d=[d[0],d[0]+g]):g=this.overscrollPointsRange);w?(this.options.overscroll&&(this.overscrollPointsRange=g,d=d.concat(this.getOverscrollPositions())),this.ordinalPositions=d,u=this.ordinal2lin(Math.max(l,d[0]),!0),f=Math.max(this.ordinal2lin(Math.min(b,
d[d.length-1]),!0),1),this.ordinalSlope=b=(b-l)/(f-u),this.ordinalOffset=l-u*b):(this.overscrollPointsRange=E(this.closestPointRange,this.overscrollPointsRange),this.ordinalPositions=this.ordinalSlope=this.ordinalOffset=void 0)}this.isOrdinal=e&&w;this.groupIntervalFactor=null},val2lin:function(d,k){var e=this.ordinalPositions;if(e){var g=e.length,l;for(l=g;l--;)if(e[l]===d){var b=l;break}for(l=g-1;l--;)if(d>e[l]||0===l){d=(d-e[l])/(e[l+1]-e[l]);b=l+d;break}k=k?b:this.ordinalSlope*(b||0)+this.ordinalOffset}else k=
d;return k},lin2val:function(d,k){var e=this.ordinalPositions;if(e){var g=this.ordinalSlope,l=this.ordinalOffset,b=e.length-1;if(k)if(0>d)d=e[0];else if(d>b)d=e[b];else{b=Math.floor(d);var f=d-b}else for(;b--;)if(k=g*b+l,d>=k){g=g*(b+1)+l;f=(d-k)/(g-k);break}return void 0!==f&&void 0!==e[b]?e[b]+(f?f*(e[b+1]-e[b]):0):d}return d},getExtendedPositions:function(){var d=this,k=d.chart,e=d.series[0].currentDataGrouping,g=d.ordinalIndex,l=e?e.count+e.unitName:"raw",b=d.options.overscroll,f=d.getExtremes(),
p;g||(g=d.ordinalIndex={});if(!g[l]){var v={series:[],chart:k,getExtremes:function(){return{min:f.dataMin,max:f.dataMax+b}},options:{ordinal:!0},val2lin:z.prototype.val2lin,ordinal2lin:z.prototype.ordinal2lin};d.series.forEach(function(a){p={xAxis:v,xData:a.xData.slice(),chart:k,destroyGroupedData:t};p.xData=p.xData.concat(d.getOverscrollPositions());p.options={dataGrouping:e?{enabled:!0,forced:!0,approximation:"open",units:[[e.unitName,[e.count]]]}:{enabled:!1}};a.processData.apply(p);v.series.push(p)});
d.beforeSetTickPositions.apply(v);g[l]=v.ordinalPositions}return g[l]},getOverscrollPositions:function(){var d=this.options.overscroll,k=this.overscrollPointsRange,e=[],g=this.dataMax;if(n(k))for(e.push(g);g<=this.dataMax+d;)g+=k,e.push(g);return e},getGroupIntervalFactor:function(d,k,e){e=e.processedXData;var g=e.length,l=[];var b=this.groupIntervalFactor;if(!b){for(b=0;b<g-1;b++)l[b]=e[b+1]-e[b];l.sort(function(b,d){return b-d});l=l[Math.floor(g/2)];d=Math.max(d,e[0]);k=Math.min(k,e[g-1]);this.groupIntervalFactor=
b=g*l/(k-d)}return b},postProcessTickInterval:function(d){var k=this.ordinalSlope;return k?this.options.breaks?this.closestPointRange||d:d/(k/this.closestPointRange):d}});z.prototype.ordinal2lin=z.prototype.val2lin;g(B,"pan",function(d){var k=this.xAxis[0],e=k.options.overscroll,g=d.originalEvent.chartX,l=!1;if(k.options.ordinal&&k.series.length){var b=this.mouseDownX,f=k.getExtremes(),p=f.dataMax,t=f.min,a=f.max,m=this.hoverPoints,q=k.closestPointRange||k.overscrollPointsRange;b=(b-g)/(k.translationSlope*
(k.ordinalSlope||q));var u={ordinalPositions:k.getExtendedPositions()};q=k.lin2val;var c=k.val2lin;if(!u.ordinalPositions)l=!0;else if(1<Math.abs(b)){m&&m.forEach(function(a){a.setState()});if(0>b){m=u;var r=k.ordinalPositions?k:u}else m=k.ordinalPositions?k:u,r=u;u=r.ordinalPositions;p>u[u.length-1]&&u.push(p);this.fixedRange=a-t;b=k.toFixedRange(null,null,q.apply(m,[c.apply(m,[t,!0])+b,!0]),q.apply(r,[c.apply(r,[a,!0])+b,!0]));b.min>=Math.min(f.dataMin,t)&&b.max<=Math.max(p,a)+e&&k.setExtremes(b.min,
b.max,!0,!1,{trigger:"pan"});this.mouseDownX=g;v(this.container,{cursor:"move"})}}else l=!0;l?e&&(k.max=k.dataMax+e):d.preventDefault()});g(z,"foundExtremes",function(){this.isXAxis&&n(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&n(this.userMin)&&(this.min+=this.options.overscroll))});g(z,"afterSetScale",function(){this.horiz&&
!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)})});G(n,"modules/broken-axis.src.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,g){var n=g.extend,A=g.isArray,E=g.pick;g=e.addEvent;var z=e.find,B=e.fireEvent,v=e.Axis,t=e.Series,x=function(d,k){return z(k,function(k){return k.from<d&&d<k.to})};n(v.prototype,{isInBreak:function(d,k){var e=d.repeat||Infinity,g=d.from,l=d.to-d.from;k=k>=g?(k-g)%e:e-(g-k)%e;return d.inclusive?
k<=l:k<l&&0!==k},isInAnyBreak:function(d,k){var e=this.options.breaks,g=e&&e.length,l;if(g){for(;g--;)if(this.isInBreak(e[g],d)){var b=!0;l||(l=E(e[g].showPoints,!this.isXAxis))}var f=b&&k?b&&!l:b}return f}});g(v,"afterInit",function(){"function"===typeof this.setBreaks&&this.setBreaks(this.options.breaks,!1)});g(v,"afterSetTickPositions",function(){if(this.isBroken){var d=this.tickPositions,k=this.tickPositions.info,e=[],g;for(g=0;g<d.length;g++)this.isInAnyBreak(d[g])||e.push(d[g]);this.tickPositions=
e;this.tickPositions.info=k}});g(v,"afterSetOptions",function(){this.isBroken&&(this.options.ordinal=!1)});v.prototype.setBreaks=function(d,k){function e(b){var f=b,d;for(d=0;d<l.breakArray.length;d++){var a=l.breakArray[d];if(a.to<=b)f-=a.len;else if(a.from>=b)break;else if(l.isInBreak(a,b)){f-=b-a.from;break}}return f}function g(b){var f;for(f=0;f<l.breakArray.length;f++){var d=l.breakArray[f];if(d.from>=b)break;else d.to<b?b+=d.len:l.isInBreak(d,b)&&(b+=d.len)}return b}var l=this,b=A(d)&&!!d.length;
l.isDirty=l.isBroken!==b;l.isBroken=b;l.options.breaks=l.userOptions.breaks=d;l.forceRedraw=!0;b||l.val2lin!==e||(delete l.val2lin,delete l.lin2val);b&&(l.userOptions.ordinal=!1,l.val2lin=e,l.lin2val=g,l.setExtremes=function(b,d,k,a,m){if(this.isBroken){for(var f,e=this.options.breaks;f=x(b,e);)b=f.to;for(;f=x(d,e);)d=f.from;d<b&&(d=b)}v.prototype.setExtremes.call(this,b,d,k,a,m)},l.setAxisTranslation=function(b){v.prototype.setAxisTranslation.call(this,b);this.unitLength=null;if(this.isBroken){b=
l.options.breaks;var d=[],f=[],a=0,m,q=l.userMin||l.min,k=l.userMax||l.max,c=E(l.pointRangePadding,0),r;b.forEach(function(a){m=a.repeat||Infinity;l.isInBreak(a,q)&&(q+=a.to%m-q%m);l.isInBreak(a,k)&&(k-=k%m-a.from%m)});b.forEach(function(a){e=a.from;for(m=a.repeat||Infinity;e-m>q;)e-=m;for(;e<q;)e+=m;for(r=e;r<k;r+=m)d.push({value:r,move:"in"}),d.push({value:r+(a.to-a.from),move:"out",size:a.breakSize})});d.sort(function(a,c){return a.value===c.value?("in"===a.move?0:1)-("in"===c.move?0:1):a.value-
c.value});var h=0;var e=q;d.forEach(function(c){h+="in"===c.move?1:-1;1===h&&"in"===c.move&&(e=c.value);0===h&&(f.push({from:e,to:c.value,len:c.value-e-(c.size||0)}),a+=c.value-e-(c.size||0))});l.breakArray=f;l.unitLength=k-q-a+c;B(l,"afterBreaks");l.staticScale?l.transA=l.staticScale:l.unitLength&&(l.transA*=(k-l.min+c)/l.unitLength);c&&(l.minPixelPadding=l.transA*l.minPointOffset);l.min=q;l.max=k}});E(k,!0)&&this.chart.redraw()};g(t,"afterGeneratePoints",function(){var d=this.xAxis,k=this.yAxis,
e=this.points,g=e.length,l=this.options.connectNulls;if(d&&k&&(d.options.breaks||k.options.breaks))for(;g--;){var b=e[g];var f=null===b.y&&!1===l;f||!d.isInAnyBreak(b.x,!0)&&!k.isInAnyBreak(b.y,!0)||(e.splice(g,1),this.data[g]&&this.data[g].destroyElements())}});g(t,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,E(this.pointArrayMap,["y"]))});e.Series.prototype.drawBreaks=function(d,e){var k=this,g=k.points,l,b,f,p;d&&e.forEach(function(e){l=d.breakArray||[];
b=d.isXAxis?d.min:E(k.options.threshold,d.min);g.forEach(function(a){p=E(a["stack"+e.toUpperCase()],a[e]);l.forEach(function(m){f=!1;if(b<m.from&&p>m.to||b>m.from&&p<m.from)f="pointBreak";else if(b<m.from&&p>m.from&&p<m.to||b>m.from&&p>m.to&&p<m.from)f="pointInBreak";f&&B(d,f,{point:a,brk:m})})})})};e.Series.prototype.gappedPath=function(){var d=this.currentDataGrouping,k=d&&d.gapSize;d=this.options.gapSize;var g=this.points.slice(),v=g.length-1,l=this.yAxis;if(d&&0<v)for("value"!==this.options.gapUnit&&
(d*=this.basePointRange),k&&k>d&&k>=this.basePointRange&&(d=k);v--;)g[v+1].x-g[v].x>d&&(k=(g[v].x+g[v+1].x)/2,g.splice(v+1,0,{isNull:!0,x:k}),this.options.stacking&&(k=l.stacks[this.stackKey][k]=new e.StackItem(l,l.options.stackLabels,!1,k,this.stack),k.total=0));return this.getGraphPath(g)}});G(n,"masters/modules/broken-axis.src.js",[],function(){});G(n,"parts/DataGrouping.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,g){var n=g.arrayMax,A=g.arrayMin,E=g.defined,z=g.extend,B=g.isNumber,
v=g.pick;g=e.addEvent;var t=e.Axis,x=e.correctFloat,d=e.defaultPlotOptions,k=e.format,w=e.merge,y=e.Point,l=e.Series,b=e.Tooltip,f=e.approximations={sum:function(a){var c=a.length;if(!c&&a.hasNulls)var b=null;else if(c)for(b=0;c--;)b+=a[c];return b},average:function(a){var c=a.length;a=f.sum(a);B(a)&&c&&(a=x(a/c));return a},averages:function(){var a=[];[].forEach.call(arguments,function(c){a.push(f.average(c))});return void 0===a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:
void 0},high:function(a){return a.length?n(a):a.hasNulls?null:void 0},low:function(a){return a.length?A(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,c,b,d){a=f.open(a);c=f.high(c);b=f.low(b);d=f.close(d);if(B(a)||B(c)||B(b)||B(d))return[a,c,b,d]},range:function(a,c){a=f.low(a);c=f.high(c);if(B(a)||B(c))return[a,c];if(null===a&&null===c)return null}},p=function(a,c,b,d){var h=this,m=h.data,e=h.options&&h.options.data,k=[],q=[],r=
[],g=a.length,l=!!c,u=[],D=h.pointArrayMap,C=D&&D.length,p=["x"].concat(D||["y"]),H=0,v=0,t;d="function"===typeof d?d:f[d]?f[d]:f[h.getDGApproximation&&h.getDGApproximation()||"average"];C?D.forEach(function(){u.push([])}):u.push([]);var z=C||1;for(t=0;t<=g&&!(a[t]>=b[0]);t++);for(t;t<=g;t++){for(;void 0!==b[H+1]&&a[t]>=b[H+1]||t===g;){var x=b[H];h.dataGroupInfo={start:h.cropStart+v,length:u[0].length};var n=d.apply(h,u);h.pointClass&&!E(h.dataGroupInfo.options)&&(h.dataGroupInfo.options=w(h.pointClass.prototype.optionsToObject.call({series:h},
h.options.data[h.cropStart+v])),p.forEach(function(a){delete h.dataGroupInfo.options[a]}));void 0!==n&&(k.push(x),q.push(n),r.push(h.dataGroupInfo));v=t;for(x=0;x<z;x++)u[x].length=0,u[x].hasNulls=!1;H+=1;if(t===g)break}if(t===g)break;if(D)for(x=h.cropStart+t,n=m&&m[x]||h.pointClass.prototype.applyOptions.apply({series:h},[e[x]]),x=0;x<C;x++){var y=n[D[x]];B(y)?u[x].push(y):null===y&&(u[x].hasNulls=!0)}else x=l?c[t]:null,B(x)?u[0].push(x):null===x&&(u[0].hasNulls=!0)}return{groupedXData:k,groupedYData:q,
groupMap:r}},F={approximations:f,groupData:p},a=l.prototype,m=a.processData,q=a.generatePoints,u={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],
month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},c={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},r=e.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];a.getDGApproximation=function(){return e.seriesTypes.arearange&&
this instanceof e.seriesTypes.arearange?"range":e.seriesTypes.ohlc&&this instanceof e.seriesTypes.ohlc?"ohlc":e.seriesTypes.column&&this instanceof e.seriesTypes.column?"sum":"average"};a.groupData=p;a.processData=function(){var c=this.chart,b=this.options.dataGrouping,d=!1!==this.allowDG&&b&&v(b.enabled,c.options.isStock),f=this.visible||!c.options.chart.ignoreHiddenSeries,e,k=this.currentDataGrouping,q=!1;this.forceCrop=d;this.groupPixelWidth=null;this.hasProcessed=!0;d&&!this.requireSorting&&(this.requireSorting=
q=!0);d=!1===m.apply(this,arguments)||!d;q&&(this.requireSorting=!1);if(!d){this.destroyGroupedData();d=b.groupAll?this.xData:this.processedXData;var g=b.groupAll?this.yData:this.processedYData,u=c.plotSizeX;c=this.xAxis;var l=c.options.ordinal,p=this.groupPixelWidth=c.getGroupPixelWidth&&c.getGroupPixelWidth();if(p){this.isDirty=e=!0;this.points=null;q=c.getExtremes();var t=q.min;q=q.max;l=l&&c.getGroupIntervalFactor(t,q,this)||1;p=p*(q-t)/u*l;u=c.getTimeTicks(c.normalizeTimeTickInterval(p,b.units||
r),Math.min(t,d[0]),Math.max(q,d[d.length-1]),c.options.startOfWeek,d,this.closestPointRange);g=a.groupData.apply(this,[d,g,u,b.approximation]);d=g.groupedXData;l=g.groupedYData;var x=0;if(b.smoothed&&d.length){var w=d.length-1;for(d[w]=Math.min(d[w],q);w--&&0<w;)d[w]+=p/2;d[0]=Math.max(d[0],t)}for(w=1;w<u.length;w++)u.info.segmentStarts&&-1!==u.info.segmentStarts.indexOf(w)||(x=Math.max(u[w]-u[w-1],x));t=u.info;t.gapSize=x;this.closestPointRange=u.info.totalRange;this.groupMap=g.groupMap;if(E(d[0])&&
d[0]<c.min&&f){if(!E(c.options.min)&&c.min<=c.dataMin||c.min===c.dataMin)c.min=Math.min(d[0],c.min);c.dataMin=d[0]}b.groupAll&&(b=this.cropData(d,l,c.min,c.max,1),d=b.xData,l=b.yData);this.processedXData=d;this.processedYData=l}else this.groupMap=null;this.hasGroupedData=e;this.currentDataGrouping=t;this.preventGraphAnimation=(k&&k.totalRange)!==(t&&t.totalRange)}};a.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,c){a&&(this.groupedData[c]=a.destroy?a.destroy():
null)},this),this.groupedData.length=0)};a.generatePoints=function(){q.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};g(y,"update",function(){if(this.dataGroup)return e.error(24,!1,this.series.chart),!1});g(b,"headerFormatter",function(a){var c=this.chart.time,b=a.labelConfig,h=b.series,d=h.tooltipOptions,f=h.options.dataGrouping,m=d.xDateFormat,q=h.xAxis,e=d[(a.isFooter?"footer":"header")+"Format"];if(q&&"datetime"===q.options.type&&f&&B(b.key)){var r=
h.currentDataGrouping;f=f.dateTimeLabelFormats||u.dateTimeLabelFormats;if(r)if(d=f[r.unitName],1===r.count)m=d[0];else{m=d[1];var g=d[2]}else!m&&f&&(m=this.getXDateFormat(b,d,q));m=c.dateFormat(m,b.key);g&&(m+=c.dateFormat(g,b.key+r.totalRange-1));h.chart.styledMode&&(e=this.styledModeFormat(e));a.text=k(e,{point:z(b.point,{key:m}),series:h},c);a.preventDefault()}});g(l,"destroy",a.destroyGroupedData);g(l,"afterSetOptions",function(a){a=a.options;var b=this.type,h=this.chart.options.plotOptions,f=
d[b].dataGrouping,m=this.useCommonDataGrouping&&u;if(c[b]||m)f||(f=w(u,c[b])),a.dataGrouping=w(m,f,h.series&&h.series.dataGrouping,h[b].dataGrouping,this.userOptions.dataGrouping)});g(t,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});t.prototype.getGroupPixelWidth=function(){var a=this.series,c=a.length,b,d=0,f=!1,m;for(b=c;b--;)(m=a[b].options.dataGrouping)&&(d=Math.max(d,v(m.groupPixelWidth,u.groupPixelWidth)));for(b=c;b--;)(m=a[b].options.dataGrouping)&&a[b].hasProcessed&&
(c=(a[b].processedXData||a[b].data).length,a[b].groupPixelWidth||c>this.chart.plotSizeX/d||c&&m.forced)&&(f=!0);return f?d:0};t.prototype.setDataGrouping=function(a,c){var b;c=v(c,!0);a||(a={forced:!1,units:null});if(this instanceof t)for(b=this.series.length;b--;)this.series[b].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(c){c.dataGrouping=a},!1);this.ordinalSlope=null;c&&this.chart.redraw()};e.dataGrouping=F;"";return F});G(n,"parts/OHLCSeries.js",[n["parts/Globals.js"]],
function(e){var g=e.Point,n=e.seriesType,A=e.seriesTypes;n("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open","high","low","close"],toYData:function(e){return[e.open,e.high,e.low,e.close]},pointValKey:"close",pointAttrToOptions:{stroke:"color",
"stroke-width":"lineWidth"},init:function(){A.column.prototype.init.apply(this,arguments);this.options.stacking=!1},pointAttribs:function(e,g){g=A.column.prototype.pointAttribs.call(this,e,g);var n=this.options;delete g.fill;!e.options.color&&n.upColor&&e.open<e.close&&(g.stroke=n.upColor);return g},translate:function(){var e=this,g=e.yAxis,n=!!e.modifyValue,v=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];A.column.prototype.translate.apply(e);e.points.forEach(function(t){[t.open,t.high,
t.low,t.close,t.low].forEach(function(x,d){null!==x&&(n&&(x=e.modifyValue(x)),t[v[d]]=g.toPixels(x,!0))});t.tooltipPos[1]=t.plotHigh+g.pos-e.chart.plotTop})},drawPoints:function(){var e=this,g=e.chart;e.points.forEach(function(n){var v=n.graphic,t=!v;if(void 0!==n.plotY){v||(n.graphic=v=g.renderer.path().add(e.group));g.styledMode||v.attr(e.pointAttribs(n,n.selected&&"select"));var x=v.strokeWidth()%2/2;var d=Math.round(n.plotX)-x;var k=Math.round(n.shapeArgs.width/2);var w=["M",d,Math.round(n.yBottom),
"L",d,Math.round(n.plotHigh)];if(null!==n.open){var z=Math.round(n.plotOpen)+x;w.push("M",d,z,"L",d-k,z)}null!==n.close&&(z=Math.round(n.plotClose)+x,w.push("M",d,z,"L",d+k,z));v[t?"attr":"animate"]({d:w}).addClass(n.getClassName(),!0)}})},animate:null},{getClassName:function(){return g.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}});""});G(n,"parts/CandlestickSeries.js",[n["parts/Globals.js"]],function(e){var g=e.defaultPlotOptions,n=e.merge,
A=e.seriesType,E=e.seriesTypes;A("candlestick","ohlc",n(g.column,{states:{hover:{lineWidth:2}},tooltip:g.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(e,g){var v=E.column.prototype.pointAttribs.call(this,e,g),t=this.options,n=e.open<e.close,d=t.lineColor||this.color;v["stroke-width"]=t.lineWidth;v.fill=e.options.color||(n?t.upColor||this.color:this.color);v.stroke=e.options.lineColor||(n?t.upLineColor||d:d);g&&(e=t.states[g],
v.fill=e.color||v.fill,v.stroke=e.lineColor||v.stroke,v["stroke-width"]=e.lineWidth||v["stroke-width"]);return v},drawPoints:function(){var e=this,g=e.chart,v=e.yAxis.reversed;e.points.forEach(function(t){var n=t.graphic,d=!n;if(void 0!==t.plotY){n||(t.graphic=n=g.renderer.path().add(e.group));e.chart.styledMode||n.attr(e.pointAttribs(t,t.selected&&"select")).shadow(e.options.shadow);var k=n.strokeWidth()%2/2;var w=Math.round(t.plotX)-k;var y=t.plotOpen;var l=t.plotClose;var b=Math.min(y,l);y=Math.max(y,
l);var f=Math.round(t.shapeArgs.width/2);l=v?y!==t.yBottom:Math.round(b)!==Math.round(t.plotHigh);var p=v?Math.round(b)!==Math.round(t.plotHigh):y!==t.yBottom;b=Math.round(b)+k;y=Math.round(y)+k;k=[];k.push("M",w-f,y,"L",w-f,b,"L",w+f,b,"L",w+f,y,"Z","M",w,b,"L",w,l?Math.round(v?t.yBottom:t.plotHigh):b,"M",w,y,"L",w,p?Math.round(v?t.plotHigh:t.yBottom):y);n[d?"attr":"animate"]({d:k}).addClass(t.getClassName(),!0)}})}});""});G(n,"mixins/on-series.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],
function(e,g){var n=g.defined,A=e.seriesTypes,E=e.stableSort;return{getPlotBox:function(){return e.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){A.column.prototype.translate.apply(this);var e=this,g=e.options,v=e.chart,t=e.points,x=t.length-1,d,k=g.onSeries;k=k&&v.get(k);g=g.onKey||"y";var w=k&&k.options.step,y=k&&k.points,l=y&&y.length,b=v.inverted,f=e.xAxis,p=e.yAxis,F=0,a;if(k&&k.visible&&l){F=(k.pointXOffset||0)+(k.barW||
0)/2;v=k.currentDataGrouping;var m=y[l-1].x+(v?v.totalRange:0);E(t,function(a,b){return a.x-b.x});for(g="plot"+g[0].toUpperCase()+g.substr(1);l--&&t[x];){var q=y[l];v=t[x];v.y=q.y;if(q.x<=v.x&&void 0!==q[g]){if(v.x<=m&&(v.plotY=q[g],q.x<v.x&&!w&&(a=y[l+1])&&void 0!==a[g])){var u=(v.x-q.x)/(a.x-q.x);v.plotY+=u*(a[g]-q[g]);v.y+=u*(a.y-q.y)}x--;l++;if(0>x)break}}}t.forEach(function(a,m){a.plotX+=F;if(void 0===a.plotY||b)0<=a.plotX&&a.plotX<=f.len?b?(a.plotY=f.translate(a.x,0,1,0,1),a.plotX=n(a.y)?p.translate(a.y,
0,0,0,1):0):a.plotY=(f.opposite?0:e.yAxis.len)+f.offset:a.shapeArgs={};if((d=t[m-1])&&d.plotX===a.plotX){void 0===d.stackIndex&&(d.stackIndex=0);var c=d.stackIndex+1}a.stackIndex=c});this.onSeries=k}}});G(n,"parts/FlagsSeries.js",[n["parts/Globals.js"],n["parts/Utilities.js"],n["mixins/on-series.js"]],function(e,g,n){function A(b){l[b+"pin"]=function(d,e,g,a,m){var f=m&&m.anchorX;m=m&&m.anchorY;"circle"===b&&a>g&&(d-=Math.round((a-g)/2),g=a);var k=l[b](d,e,g,a);f&&m&&(k.push("M","circle"===b?d+g/
2:k[1]+k[4]/2,e>m?e:e+a,"L",f,m),k=k.concat(l.circle(f-1,m-1,2,2)));return k}}var E=g.defined,z=g.isNumber,B=g.objectEach,v=e.addEvent,t=e.merge;g=e.noop;var x=e.Renderer,d=e.Series,k=e.seriesType,w=e.TrackerMixin,y=e.VMLRenderer,l=e.SVGRenderer.prototype.symbols;k("flags","column",{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}<br/>"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},
style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:d.prototype.init,pointAttribs:function(b,d){var f=this.options,e=b&&b.color||this.color,a=f.lineColor,m=b&&b.lineWidth;b=b&&b.fillColor||f.fillColor;d&&(b=f.states[d].fillColor,a=f.states[d].lineColor,m=f.states[d].lineWidth);return{fill:b||e,stroke:a||e,"stroke-width":m||f.lineWidth||0}},translate:n.translate,getPlotBox:n.getPlotBox,drawPoints:function(){var b=
this.points,d=this.chart,g=d.renderer,k=d.inverted,a=this.options,m=a.y,q,u=this.yAxis,c={},r=[];for(q=b.length;q--;){var h=b[q];var l=(k?h.plotY:h.plotX)>this.xAxis.len;var D=h.plotX;var n=h.stackIndex;var v=h.options.shape||a.shape;var w=h.plotY;void 0!==w&&(w=h.plotY+m-(void 0!==n&&n*a.stackDistance));h.anchorX=n?void 0:h.plotX;var x=n?void 0:h.plotY;var I="flag"!==v;n=h.graphic;void 0!==w&&0<=D&&!l?(n||(n=h.graphic=g.label("",null,null,v,null,null,a.useHTML),d.styledMode||n.attr(this.pointAttribs(h)).css(t(a.style,
h.style)),n.attr({align:I?"center":"left",width:a.width,height:a.height,"text-align":a.textAlign}).addClass("highcharts-point").add(this.markerGroup),h.graphic.div&&(h.graphic.div.point=h),d.styledMode||n.shadow(a.shadow),n.isNew=!0),0<D&&(D-=n.strokeWidth()%2),v={y:w,anchorY:x},a.allowOverlapX&&(v.x=D,v.anchorX=h.anchorX),n.attr({text:h.options.title||a.title||"A"})[n.isNew?"attr":"animate"](v),a.allowOverlapX||(c[h.plotX]?c[h.plotX].size=Math.max(c[h.plotX].size,n.width):c[h.plotX]={align:I?.5:
0,size:n.width,target:D,anchorX:D}),h.tooltipPos=[D,w+u.pos-d.plotTop]):n&&(h.graphic=n.destroy())}a.allowOverlapX||(B(c,function(a){a.plotX=a.anchorX;r.push(a)}),e.distribute(r,k?u.len:this.xAxis.len,100),b.forEach(function(a){var b=a.graphic&&c[a.plotX];b&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:b.pos+b.align*b.size,anchorX:a.anchorX}),E(b.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));a.useHTML&&e.wrap(this.markerGroup,"on",function(a){return e.SVGElement.prototype.on.apply(a.apply(this,
[].slice.call(arguments,1)),[].slice.call(arguments,1))})},drawTracker:function(){var b=this.points;w.drawTrackerPoint.apply(this);b.forEach(function(d){var e=d.graphic;e&&v(e.element,"mouseover",function(){0<d.stackIndex&&!d.raised&&(d._y=e.y,e.attr({y:d._y-8}),d.raised=!0);b.forEach(function(b){b!==d&&b.raised&&b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)})})})},animate:function(b){b?this.setClip():this.animate=null},setClip:function(){d.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&
this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},buildKDTree:g,invertGroups:g},{isValid:function(){return z(this.y)||void 0===this.y}});l.flag=function(b,d,e,g,a){var f=a&&a.anchorX||b;a=a&&a.anchorY||d;return l.circle(f-1,a-1,2,2).concat(["M",f,a,"L",b,d+g,b,d,b+e,d,b+e,d+g,b,d+g,"Z"])};A("circle");A("square");x===y&&["circlepin","flag","squarepin"].forEach(function(b){y.prototype.symbols[b]=l[b]});""});G(n,"parts/RangeSelector.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],
function(e,g){function n(a){this.init(a)}var A=g.defined,E=g.destroyObjectProperties,z=g.discardElement,B=g.extend,v=g.isNumber,t=g.objectEach,x=g.pick,d=g.pInt,k=g.splat,w=e.addEvent,y=e.Axis;g=e.Chart;var l=e.css,b=e.createElement,f=e.defaultOptions,p=e.fireEvent,F=e.merge;B(f,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});
f.lang=F(f.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});n.prototype={clickButton:function(a,b){var d=this.chart,e=this.buttonOptions[a],c=d.xAxis[0],f=d.scroller&&d.scroller.getUnionExtremes()||c||{},h=f.dataMin,m=f.dataMax,g=c&&Math.round(Math.min(c.max,x(m,c.max))),l=e.type;f=e._range;var n,p=e.dataGrouping;if(null!==h&&null!==m){d.fixedRange=f;p&&(this.forcedDataGrouping=!0,y.prototype.setDataGrouping.call(c||{chart:this.chart},p,!1),this.frozenStates=e.preserveDataGrouping);
if("month"===l||"year"===l)if(c){l={range:e,max:g,chart:d,dataMin:h,dataMax:m};var t=c.minFromRange.call(l);v(l.newMax)&&(g=l.newMax)}else f=e;else if(f)t=Math.max(g-f,h),g=Math.min(t+f,m);else if("ytd"===l)if(c)void 0===m&&(h=Number.MAX_VALUE,m=Number.MIN_VALUE,d.series.forEach(function(a){a=a.xData;h=Math.min(a[0],h);m=Math.max(a[a.length-1],m)}),b=!1),g=this.getYTDExtremes(m,h,d.time.useUTC),t=n=g.min,g=g.max;else{this.deferredYTDClick=a;return}else"all"===l&&c&&(t=h,g=m);t+=e._offsetMin;g+=e._offsetMax;
this.setSelected(a);if(c)c.setExtremes(t,g,x(b,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:e});else{var I=k(d.options.xAxis)[0];var U=I.range;I.range=f;var V=I.min;I.min=n;w(d,"load",function(){I.range=U;I.min=V})}}},setSelected:function(a){this.selected=this.options.selected=a},defaultButtons:[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}],init:function(a){var b=
this,d=a.options.rangeSelector,e=d.buttons||[].concat(b.defaultButtons),c=d.selected,f=function(){var a=b.minInput,c=b.maxInput;a&&a.blur&&p(a,"blur");c&&c.blur&&p(c,"blur")};b.chart=a;b.options=d;b.buttons=[];b.buttonOptions=e;this.unMouseDown=w(a.container,"mousedown",f);this.unResize=w(a,"resize",f);e.forEach(b.computeButtonRange);void 0!==c&&e[c]&&this.clickButton(c,!1);w(a,"load",function(){a.xAxis&&a.xAxis[0]&&w(a.xAxis[0],"setExtremes",function(c){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==
c.trigger&&"updatedData"!==c.trigger&&b.forcedDataGrouping&&!b.frozenStates&&this.setDataGrouping(!1,!1)})})},updateButtonStates:function(){var a=this,b=this.chart,d=b.xAxis[0],e=Math.round(d.max-d.min),c=!d.hasVisibleSeries,f=b.scroller&&b.scroller.getUnionExtremes()||d,h=f.dataMin,g=f.dataMax;b=a.getYTDExtremes(g,h,b.time.useUTC);var k=b.min,l=b.max,n=a.selected,p=v(n),t=a.options.allButtonsEnabled,w=a.buttons;a.buttonOptions.forEach(function(b,f){var m=b._range,q=b.type,r=b.count||1,u=w[f],v=0,
D=b._offsetMax-b._offsetMin;b=f===n;var x=m>g-h,C=m<d.minRange,I=!1,H=!1;m=m===e;("month"===q||"year"===q)&&e+36E5>=864E5*{month:28,year:365}[q]*r-D&&e-36E5<=864E5*{month:31,year:366}[q]*r+D?m=!0:"ytd"===q?(m=l-k+D===e,I=!b):"all"===q&&(m=d.max-d.min>=g-h,H=!b&&p&&m);q=!t&&(x||C||H||c);r=b&&m||m&&!p&&!I||b&&a.frozenStates;q?v=3:r&&(p=!0,v=2);u.state!==v&&(u.setState(v),0===v&&n===f&&a.setSelected(null))})},computeButtonRange:function(a){var b=a.type,d=a.count||1,e={millisecond:1,second:1E3,minute:6E4,
hour:36E5,day:864E5,week:6048E5};if(e[b])a._range=e[b]*d;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*d;a._offsetMin=x(a.offsetMin,0);a._offsetMax=x(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin},setInputValue:function(a,b){var d=this.chart.options.rangeSelector,e=this.chart.time,c=this[a+"Input"];A(b)&&(c.previousValue=c.HCTime,c.HCTime=b);c.value=e.dateFormat(d.inputEditDateFormat||"%Y-%m-%d",c.HCTime);this[a+"DateBox"].attr({text:e.dateFormat(d.inputDateFormat||"%b %e, %Y",
c.HCTime)})},showInput:function(a){var b=this.inputGroup,d=this[a+"DateBox"];l(this[a+"Input"],{left:b.translateX+d.x+"px",top:b.translateY+"px",width:d.width-2+"px",height:d.height-2+"px",border:"2px solid silver"})},hideInput:function(a){l(this[a+"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)},drawInput:function(a){function g(){var a=t.value,b=(h.inputDateParser||Date.parse)(a),c=u.xAxis[0],e=u.scroller&&u.scroller.xAxis?u.scroller.xAxis:c,f=e.dataMin;e=e.dataMax;b!==t.previousValue&&
(t.previousValue=b,v(b)||(b=a.split("-"),b=Date.UTC(d(b[0]),d(b[1])-1,d(b[2]))),v(b)&&(u.time.useUTC||(b+=6E4*(new Date).getTimezoneOffset()),p?b>k.maxInput.HCTime?b=void 0:b<f&&(b=f):b<k.minInput.HCTime?b=void 0:b>e&&(b=e),void 0!==b&&c.setExtremes(p?b:c.min,p?c.max:b,void 0,void 0,{trigger:"rangeSelectorInput"})))}var k=this,u=k.chart,c=u.renderer.style||{},r=u.renderer,h=u.options.rangeSelector,n=k.div,p="min"===a,t,w,x=this.inputGroup;this[a+"Label"]=w=r.label(f.lang[p?"rangeSelectorFrom":"rangeSelectorTo"],
this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(x);x.offset+=w.width+5;this[a+"DateBox"]=r=r.label("",x.offset).addClass("highcharts-range-input").attr({padding:2,width:h.inputBoxWidth||90,height:h.inputBoxHeight||17,"text-align":"center"}).on("click",function(){k.showInput(a);k[a+"Input"].focus()});u.styledMode||r.attr({stroke:h.inputBoxBorderColor||"#cccccc","stroke-width":1});r.add(x);x.offset+=r.width+(p?10:0);this[a+"Input"]=t=b("input",{name:a,className:"highcharts-range-selector",
type:"text"},{top:u.plotTop+"px"},n);u.styledMode||(w.css(F(c,h.labelStyle)),r.css(F({color:"#333333"},c,h.inputStyle)),l(t,B({position:"absolute",border:0,width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:c.fontSize,fontFamily:c.fontFamily,top:"-9999em"},h.inputStyle)));t.onfocus=function(){k.showInput(a)};t.onblur=function(){t===e.doc.activeElement&&g();k.hideInput(a);t.blur()};t.onchange=g;t.onkeypress=function(a){13===a.keyCode&&g()}},getPosition:function(){var a=this.chart,b=a.options.rangeSelector;
a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}},getYTDExtremes:function(a,b,d){var e=this.chart.time,c=new e.Date(a),f=e.get("FullYear",c);d=d?e.Date.UTC(f,0,1):+new e.Date(f,0,1);b=Math.max(b||0,d);c=c.getTime();return{max:Math.min(a||c,c),min:b}},render:function(a,d){var e=this,g=e.chart,c=g.renderer,k=g.container,h=g.options,m=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,l=f.lang,n=
e.div,p=h.rangeSelector,t=x(h.chart.style&&h.chart.style.zIndex,0)+1;h=p.floating;var v=e.buttons;n=e.inputGroup;var w=p.buttonTheme,y=p.buttonPosition,z=p.inputPosition,A=p.inputEnabled,B=w&&w.states,E=g.plotLeft,F=e.buttonGroup;var G=e.rendered;var M=e.options.verticalAlign,O=g.legend,P=O&&O.options,Q=y.y,N=z.y,R=G||!1,S=R?"animate":"attr",L=0,J=0,K;if(!1!==p.enabled){G||(e.group=G=c.g("range-selector-group").attr({zIndex:7}).add(),e.buttonGroup=F=c.g("range-selector-buttons").add(G),e.zoomText=
c.text(l.rangeSelectorZoom,0,15).add(F),g.styledMode||(e.zoomText.css(p.labelStyle),w["stroke-width"]=x(w["stroke-width"],0)),e.buttonOptions.forEach(function(a,b){v[b]=c.button(a.text,0,0,function(c){var d=a.events&&a.events.click,h;d&&(h=d.call(a,c));!1!==h&&e.clickButton(b);e.isActive=!0},w,B&&B.hover,B&&B.select,B&&B.disabled).attr({"text-align":"center"}).add(F)}),!1!==A&&(e.div=n=b("div",null,{position:"relative",height:0,zIndex:t}),k.parentNode.insertBefore(n,k),e.inputGroup=n=c.g("input-group").add(G),
n.offset=0,e.drawInput("min"),e.drawInput("max")));e.zoomText[S]({x:x(E+y.x,E)});var T=x(E+y.x,E)+e.zoomText.getBBox().width+5;e.buttonOptions.forEach(function(a,b){v[b][S]({x:T});T+=v[b].width+x(p.buttonSpacing,5)});E=g.plotLeft-g.spacing[3];e.updateButtonStates();m&&this.titleCollision(g)&&"top"===M&&"right"===y.align&&y.y+F.getBBox().height-12<(m.y||0)+m.height&&(L=-40);"left"===y.align?K=y.x-g.spacing[3]:"right"===y.align&&(K=y.x+L-g.spacing[1]);F.align({y:y.y,width:F.getBBox().width,align:y.align,
x:K},!0,g.spacingBox);e.group.placed=R;e.buttonGroup.placed=R;!1!==A&&(L=m&&this.titleCollision(g)&&"top"===M&&"right"===z.align&&z.y-n.getBBox().height-12<(m.y||0)+m.height+g.spacing[0]?-40:0,"left"===z.align?K=E:"right"===z.align&&(K=-Math.max(g.axisOffset[1],-L)),n.align({y:z.y,width:n.getBBox().width,align:z.align,x:z.x+K-2},!0,g.spacingBox),k=n.alignAttr.translateX+n.alignOptions.x-L+n.getBBox().x+2,m=n.alignOptions.width,l=F.alignAttr.translateX+F.getBBox().x,K=F.getBBox().width+20,(z.align===
y.align||l+K>k&&k+m>l&&Q<N+n.getBBox().height)&&n.attr({translateX:n.alignAttr.translateX+(g.axisOffset[1]>=-L?0:-L),translateY:n.alignAttr.translateY+F.getBBox().height+10}),e.setInputValue("min",a),e.setInputValue("max",d),e.inputGroup.placed=R);e.group.align({verticalAlign:M},!0,g.spacingBox);a=e.group.getBBox().height+20;d=e.group.alignAttr.translateY;"bottom"===M&&(O=P&&"bottom"===P.verticalAlign&&P.enabled&&!P.floating?O.legendHeight+x(P.margin,10):0,a=a+O-20,J=d-a-(h?0:p.y)-(g.titleOffset?
g.titleOffset[2]:0)-10);if("top"===M)h&&(J=0),g.titleOffset&&g.titleOffset[0]&&(J=g.titleOffset[0]),J+=g.margin[0]-g.spacing[0]||0;else if("middle"===M)if(N===Q)J=0>N?d+void 0:d;else if(N||Q)J=0>N||0>Q?J-Math.min(N,Q):d-a+NaN;e.group.translate(p.x,p.y+Math.floor(J));!1!==A&&(e.minInput.style.marginTop=e.group.translateY+"px",e.maxInput.style.marginTop=e.group.translateY+"px");e.rendered=!0}},getHeight:function(){var a=this.options,b=this.group,d=a.y,e=a.buttonPosition.y,c=a.inputPosition.y;if(a.height)return a.height;
a=b?b.getBBox(!0).height+13+d:0;b=Math.min(c,e);if(0>c&&0>e||0<c&&0<e)a+=Math.abs(b);return a},titleCollision:function(a){return!(a.options.title.text||a.options.subtitle.text)},update:function(a){var b=this.chart;F(!0,b.options.rangeSelector,a);this.destroy();this.init(b);b.rangeSelector.render()},destroy:function(){var a=this,b=a.minInput,d=a.maxInput;a.unMouseDown();a.unResize();E(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);t(a,function(b,c){b&&"chart"!==
c&&(b.destroy?b.destroy():b.nodeType&&z(this[c]));b!==n.prototype[c]&&(a[c]=null)},this)}};y.prototype.minFromRange=function(){var a=this.range,b={month:"Month",year:"FullYear"}[a.type],d=this.max,e=this.chart.time,c=function(a,c){var d=new e.Date(a),h=e.get(b,d);e.set(b,d,h+c);h===e.get(b,d)&&e.set("Date",d,0);return d.getTime()-a};if(v(a)){var f=d-a;var h=a}else f=d+c(d,-a.count),this.chart&&(this.chart.fixedRange=d-f);var g=x(this.dataMin,Number.MIN_VALUE);v(f)||(f=g);f<=g&&(f=g,void 0===h&&(h=
c(f,a.count)),this.newMax=Math.min(f+h,this.dataMax));v(d)||(f=void 0);return f};e.RangeSelector||(w(g,"afterGetContainer",function(){this.options.rangeSelector.enabled&&(this.rangeSelector=new n(this))}),w(g,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(v(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===
a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),w(g,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var d=this.extraBottomMargin,e=this.extraTopMargin;b&&b.enabled&&!A(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new n(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=
!0)),this.extraBottomMargin!==d||this.extraTopMargin!==e)&&(this.isDirtyBox=!0)}),w(g,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),w(g,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}),g.prototype.callbacks.push(function(a){function b(){d=a.xAxis[0].getExtremes();
v(d.min)&&e.render(d.min,d.max)}var d,e=a.rangeSelector;if(e){var c=w(a.xAxis[0],"afterSetExtremes",function(a){e.render(a.min,a.max)});var f=w(a,"redraw",b);b()}w(a,"destroy",function(){e&&(f(),c())})}),e.RangeSelector=n)});G(n,"parts/StockChart.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,g){var n=g.arrayMax,A=g.arrayMin,E=g.defined,z=g.extend,B=g.isNumber,v=g.isString,t=g.pick,x=g.splat;g=e.addEvent;var d=e.Axis,k=e.Chart,w=e.format,y=e.merge,l=e.Point,b=e.Renderer,f=e.Series,
p=e.SVGRenderer,F=e.VMLRenderer,a=f.prototype,m=a.init,q=a.processData,u=l.prototype.tooltipFormatter;e.StockChart=e.stockChart=function(a,b,d){var c=v(a)||a.nodeName,h=arguments[c?1:0],f=h,g=h.series,l=e.getOptions(),m,r=t(h.navigator&&h.navigator.enabled,l.navigator.enabled,!0),n=r?{startOnTick:!1,endOnTick:!1}:null;h.xAxis=x(h.xAxis||{}).map(function(a,b){return y({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},l.xAxis,l.xAxis&&
l.xAxis[b],a,{type:"datetime",categories:null},n)});h.yAxis=x(h.yAxis||{}).map(function(a,b){m=t(a.opposite,!0);return y({labels:{y:-2},opposite:m,showLastLabel:!(!a.categories&&"category"!==a.type),title:{text:null}},l.yAxis,l.yAxis&&l.yAxis[b],a)});h.series=null;h=y({chart:{panning:!0,pinchType:"x"},navigator:{enabled:r},scrollbar:{enabled:t(l.scrollbar.enabled,!0)},rangeSelector:{enabled:t(l.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:t(l.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},
h,{isStock:!0});h.series=f.series=g;return c?new k(a,h,d):new k(h,b)};g(f,"setOptions",function(a){function b(a){return e.seriesTypes[a]&&c instanceof e.seriesTypes[a]}var c=this,d;this.chart.options.isStock&&(b("column")||b("columnrange")?d={borderWidth:0,shadow:!1}:!b("line")||b("scatter")||b("sma")||(d={marker:{enabled:!1,radius:2}}),d&&(a.plotOptions[this.type]=y(a.plotOptions[this.type],d)))});g(d,"autoLabelAlign",function(a){var b=this.chart,c=this.options;b=b._labelPanes=b._labelPanes||{};
var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(c=c.top+","+c.height,!b[c]&&d.enabled&&(15===d.x&&(d.x=0),void 0===d.align&&(d.align="right"),b[c]=this,a.align="right",a.preventDefault()))});g(d,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});g(d,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=c.options[b];return B(a)?[f[b][a]]:
v(a)?[f.get(a)]:d.map(function(a){return a[b]})}var c=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,f=c.chart,g=f.renderer,k=c.left,l=c.top,m,n,p,q,u=[],w=[],x=a.translatedValue,y=a.value,z=a.force;if(f.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll){a.preventDefault();w=b(c.coll);var A=c.isXAxis?f.yAxis:f.xAxis;A.forEach(function(a){if(E(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=E(a.options[b])?f[b][a.options[b]]:
f[b][0];c===b&&w.push(a)}});var F=w.length?[]:[c.isXAxis?f.yAxis[0]:f.xAxis[0]];w.forEach(function(a){-1!==F.indexOf(a)||e.find(F,function(b){return b.pos===a.pos&&b.len===a.len})||F.push(a)});var G=t(x,c.translate(y,null,null,a.old));B(G)&&(c.horiz?F.forEach(function(a){var b;n=a.pos;q=n+a.len;m=p=Math.round(G+c.transB);"pass"!==z&&(m<k||m>k+c.width)&&(z?m=p=Math.min(Math.max(k,m),k+c.width):b=!0);b||u.push("M",m,n,"L",p,q)}):F.forEach(function(a){var b;m=a.pos;p=m+a.len;n=q=Math.round(l+c.height-
G);"pass"!==z&&(n<l||n>l+c.height)&&(z?n=q=Math.min(Math.max(l,n),c.top+c.height):b=!0);b||u.push("M",m,n,"L",p,q)}));a.path=0<u.length?g.crispPolyLine(u,a.lineWidth||1):null}});p.prototype.crispPolyLine=function(a,b){var c;for(c=0;c<a.length;c+=6)a[c+1]===a[c+4]&&(a[c+1]=a[c+4]=Math.round(a[c+1])-b%2/2),a[c+2]===a[c+5]&&(a[c+2]=a[c+5]=Math.round(a[c+2])+b%2/2);return a};b===F&&(F.prototype.crispPolyLine=p.prototype.crispPolyLine);g(d,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=
this.crossLabel.hide())});g(d,"afterDrawCrosshair",function(a){var b,c;if(E(this.crosshair.label)&&this.crosshair.label.enabled&&this.cross){var d=this.chart,e=this.options.crosshair.label,f=this.horiz,g=this.opposite,k=this.left,l=this.top,m=this.crossLabel,n=e.format,p="",q="inside"===this.options.tickPosition,u=!1!==this.crosshair.snap,v=0,x=a.e||this.cross&&this.cross.e,y=a.point;var A=this.lin2log;if(this.isLog){a=A(this.min);var B=A(this.max)}else a=this.min,B=this.max;A=f?"center":g?"right"===
this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";m||(m=this.crossLabel=d.renderer.label(null,null,null,e.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&" highcharts-color-"+this.series[0].colorIndex)).attr({align:e.align||A,padding:t(e.padding,8),r:t(e.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||m.attr({fill:e.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:e.borderColor||"","stroke-width":e.borderWidth||0}).css(z({color:"#ffffff",
fontWeight:"normal",fontSize:"11px",textAlign:"center"},e.style)));f?(A=u?y.plotX+k:x.chartX,l+=g?0:this.height):(A=g?this.width+k:0,l=u?y.plotY+l:x.chartY);n||e.formatter||(this.isDatetimeAxis&&(p="%b %d, %Y"),n="{value"+(p?":"+p:"")+"}");p=u?y[this.isXAxis?"x":"y"]:this.toValue(f?x.chartX:x.chartY);m.attr({text:n?w(n,{value:p},d.time):e.formatter.call(this,p),x:A,y:l,visibility:p<a||p>B?"hidden":"visible"});e=m.getBBox();if(f){if(q&&!g||!q&&g)l=m.y-e.height}else l=m.y-e.height/2;f?(b=k-e.x,c=k+
this.width-e.x):(b="left"===this.labelAlign?k:0,c="right"===this.labelAlign?k+this.width:d.chartWidth);m.translateX<b&&(v=b-m.translateX);m.translateX+e.width>=c&&(v=-(m.translateX+e.width-c));m.attr({x:A+v,y:l,anchorX:f?A:this.opposite?0:d.chartWidth,anchorY:f?this.opposite?d.chartHeight:0:l+e.height/2})}});a.init=function(){m.apply(this,arguments);this.setCompare(this.options.compare)};a.setCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,c){var d=this.compareValue;return void 0!==
b&&void 0!==d?(b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),c&&(c.change=b),b):0}:null;this.userOptions.compare=a;this.chart.hasRendered&&(this.isDirty=!0)};a.processData=function(a){var b,c=-1,d=!0===this.options.compareStart?0:1;q.apply(this,arguments);if(this.xAxis&&this.processedYData){var e=this.processedXData;var f=this.processedYData;var g=f.length;this.pointArrayMap&&(c=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<g-d;b++){var k=
f[b]&&-1<c?f[b][c]:f[b];if(B(k)&&e[b+d]>=this.xAxis.min&&0!==k){this.compareValue=k;break}}}};g(f,"afterGetExtremes",function(){if(this.modifyValue){var a=[this.modifyValue(this.dataMin),this.modifyValue(this.dataMax)];this.dataMin=A(a);this.dataMax=n(a)}});d.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),t(b,!0)&&this.chart.redraw())};l.prototype.tooltipFormatter=function(a){a=a.replace("{point.change}",(0<this.change?"+":"")+e.numberFormat(this.change,
t(this.series.tooltipOptions.changeDecimals,2)));return u.apply(this,[a])};g(f,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial){var b=this.yAxis.len;if(this.xAxis.axisLine){var d=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,e=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=d&&(b-=Math.max(e-d,0))}!this.clipBox&&this.animate?(this.clipBox=y(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b):a[this.sharedClipKey]&&(a[this.sharedClipKey].animate({width:this.xAxis.len,
height:b}),a[this.sharedClipKey+"m"]&&a[this.sharedClipKey+"m"].animate({width:this.xAxis.len}))}});g(k,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(y(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)})});G(n,"masters/modules/stock.src.js",[],function(){})});
//# sourceMappingURL=stock.js.map