/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DependencyResolutionException;
import org.whitesource.agent.api.dispatch.BaseCheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.maven.AgentMojo;

@Mojo(name="checkPolicies", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, aggregator=true)
public class CheckPoliciesMojo
extends AgentMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException, DependencyResolutionException {
        if (this.reactorProjects == null) {
            this.info("No Projects Found. Skipping Update");
            return;
        }
        this.init();
        Collection<AgentProjectInfo> projectInfos = this.extractProjectInfos();
        if (projectInfos == null || projectInfos.isEmpty()) {
            this.info("No open source information found.");
        } else {
            this.sendCheckPolicies(projectInfos);
        }
    }

    @Override
    protected void init() throws MojoFailureException {
        super.init();
    }

    private void sendCheckPolicies(Collection<AgentProjectInfo> projectInfos) throws MojoFailureException, MojoExecutionException {
        try {
            this.info("Checking Policies");
            CheckPolicyComplianceResult result = this.service.checkPolicyCompliance(this.orgToken, this.product, this.productVersion, projectInfos, this.forceCheckAllDependencies);
            if (this.outputDirectory == null || !this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                this.warn("Output directory doesn't exist. Skipping policies check report.");
            } else {
                this.generateReport((BaseCheckPoliciesResult)result);
            }
            if (result.hasRejections()) {
                String msg = "Some dependencies were rejected by the organization's policies.";
                throw new MojoExecutionException(msg);
            }
            this.info("All dependencies conform with the organization's policies.");
        }
        catch (WssServiceException e) {
            if (this.isConnectionError((Exception)((Object)e))) {
                if (this.connectionRetries-- > 0) {
                    this.info("Attempting to reconnect to WhiteSource");
                    try {
                        Thread.sleep(this.connectionRetryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.sendCheckPolicies(projectInfos);
                }
                throw new MojoExecutionException("Error communicating with service: Connection refused: ", (Exception)((Object)e));
            }
            throw new MojoExecutionException("Error communicating with service: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

