/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.whitesource.agent.client.WhitesourceService;
import org.whitesource.maven.utils.proxy.ProxySettings;
import org.whitesource.maven.utils.proxy.ProxySettingsProvider;
import org.whitesource.maven.utils.proxy.ProxySettingsProviderFactory;

public abstract class WhitesourceMojo
extends AbstractMojo {
    private static final String DEFAULT_CONNECTION_TIMEOUT_MINUTES = "60";
    private static final String DEFAULT_CONNECTION_RETRIES = "1";
    private static final String DEFAULT_CONNECTION_RETRY_INTERVAL = "3000";
    private static final String DEFAULT_CONNECTION_IGNORE_CERTIFICATE_CHECK = "false";
    private static final String DEFAULT_ENABLE_DEBUG = "false";
    private Log log;
    protected DateFormat dateFormat = new SimpleDateFormat("[HH:mm:ss] ");
    @Parameter(alias="failOnError", property="org.whitesource.failOnError", required=false, defaultValue="false")
    protected boolean failOnError;
    @Parameter(alias="skip", property="org.whitesource.skip", required=false, defaultValue="false")
    protected boolean skip;
    @Parameter(alias="autoDetectProxySettings", property="org.whitesource.autoDetectProxySettings", defaultValue="false")
    protected boolean autoDetectProxySettings;
    @Component
    protected MavenSession session;
    @Component
    protected MavenProject mavenProject;
    @Component(hint="default")
    protected ProjectDependenciesResolver projectDependenciesResolver;
    @Parameter(alias="wssUrl", property="wss.url", required=false, defaultValue="https://saas.whitesourcesoftware.com/agent")
    protected String wssUrl;
    @Parameter(alias="failOnConnectionError", property="org.whitesource.failOnConnectionError", required=false, defaultValue="true")
    protected boolean failOnConnectionError;
    @Parameter(alias="connectionRetries", property="org.whitesource.connectionRetries", required=false, defaultValue="1")
    protected int connectionRetries;
    @Parameter(alias="connectionRetryInterval", property="org.whitesource.connectionRetryInterval", required=false, defaultValue="3000")
    protected int connectionRetryInterval;
    @Parameter(alias="ignoreCertificateCheck", property="org.whitesource.ignoreCertificateCheck", required=false, defaultValue="false")
    protected boolean ignoreCertificateCheck;
    @Parameter(alias="connectionTimeoutMinutes", property="wss.connectionTimeoutMinutes", required=false, defaultValue="60")
    protected int connectionTimeoutMinutes;
    @Parameter(alias="enableDebug", property="org.whitesource.enableDebug", required=false, defaultValue="false")
    protected boolean enableDebug;
    protected WhitesourceService service;

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException, DependencyResolutionException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        boolean skip = Boolean.valueOf(this.session.getSystemProperties().getProperty("org.whitesource.skip", String.valueOf(this.skip)));
        if (skip) {
            this.info("Skipping update");
        } else {
            try {
                this.createService();
                this.doExecute();
            }
            catch (DependencyResolutionException e) {
                this.handleError((Exception)((Object)e));
            }
            catch (MojoExecutionException e) {
                this.handleError((Exception)((Object)e));
            }
            catch (RuntimeException e) {
                throw new MojoFailureException("Unexpected error", (Throwable)e);
            }
            finally {
                if (this.service != null) {
                    this.service.shutdown();
                }
            }
        }
        this.debug("Total execution time is " + (System.currentTimeMillis() - startTime) + " [msec]");
    }

    protected void init() throws MojoFailureException {
        Properties systemProperties = this.session.getSystemProperties();
        this.failOnError = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.failOnError", Boolean.toString(this.failOnError)));
        this.autoDetectProxySettings = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.autoDetectProxySettings", Boolean.toString(this.autoDetectProxySettings)));
        this.connectionTimeoutMinutes = Integer.parseInt(systemProperties.getProperty("wss.connectionTimeoutMinutes", String.valueOf(this.connectionTimeoutMinutes)));
        this.failOnConnectionError = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.failOnConnectionError", Boolean.toString(this.failOnConnectionError)));
        this.connectionRetries = Integer.parseInt(systemProperties.getProperty("org.whitesource.connectionRetries", String.valueOf(this.connectionRetries)));
        this.connectionRetryInterval = Integer.parseInt(systemProperties.getProperty("org.whitesource.connectionRetryInterval", String.valueOf(this.connectionRetryInterval)));
        this.ignoreCertificateCheck = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.ignoreCertificateCheck", String.valueOf(this.ignoreCertificateCheck)));
        this.enableDebug = Boolean.parseBoolean(systemProperties.getProperty("org.whitesource.enableDebug", String.valueOf(this.enableDebug)));
        if (this.enableDebug) {
            this.log = new SystemStreamLog(){

                public boolean isDebugEnabled() {
                    return WhitesourceMojo.this.enableDebug;
                }
            };
            this.setLog(this.log);
        } else {
            this.log = this.getLog();
        }
    }

    protected void createService() {
        String serviceUrl = this.session.getSystemProperties().getProperty("wss.url");
        if (StringUtils.isBlank((String)serviceUrl)) {
            serviceUrl = this.session.getSystemProperties().getProperty("org.whitesource.wssUrl", this.wssUrl);
        }
        this.info("Service URL is " + serviceUrl);
        this.service = new WhitesourceService("maven-plugin", "2.5.9", "18.2.2</version>", serviceUrl, this.autoDetectProxySettings, this.connectionTimeoutMinutes, this.ignoreCertificateCheck);
        if (this.service == null) {
            this.info("Failed to initiate WhiteSource Service");
        } else {
            this.info("Initiated WhiteSource Service");
        }
        ProxySettingsProvider proxySettingsProvider = ProxySettingsProviderFactory.getProxySettingsProviderForUrl((String)serviceUrl, (MavenSession)this.session);
        if (proxySettingsProvider.isProxyConfigured()) {
            ProxySettings proxySettings = proxySettingsProvider.getProxySettings();
            this.service.getClient().setProxy(proxySettings.getHostname(), proxySettings.getPort(), proxySettings.getUsername(), proxySettings.getPassword());
            this.info("Proxy hostname: " + proxySettings.getHostname());
            this.info("Proxy port: " + proxySettings.getPort());
            this.debug("Proxy username: " + proxySettings.getUsername());
            this.debug("Proxy password: " + proxySettings.getPassword());
        } else {
            this.info("No Proxy Settings");
        }
    }

    protected void handleError(Exception error) throws MojoFailureException {
        String message = error.getMessage();
        boolean failOnError = Boolean.valueOf(this.session.getSystemProperties().getProperty("org.whitesource.failOnError", String.valueOf(this.failOnError)));
        boolean failOnConnectionError = Boolean.valueOf(this.session.getSystemProperties().getProperty("org.whitesource.failOnConnectionError", String.valueOf(this.failOnConnectionError)));
        boolean connectionError = error.getMessage().contains("Connection refused: ");
        if (connectionError && failOnConnectionError) {
            this.debug(message, error);
            throw new MojoFailureException(message);
        }
        if (!connectionError && failOnError) {
            this.debug(message, error);
            throw new MojoFailureException(message);
        }
        this.error(message, error);
    }

    protected boolean isConnectionError(Exception e) {
        return e.getCause() != null && e.getCause().getClass().getCanonicalName().contains("java.net");
    }

    protected void debug(CharSequence content) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.getFormattedContent(content));
        }
    }

    protected void debug(CharSequence content, Throwable error) {
        if (this.log != null) {
            this.log.debug(this.getFormattedContent(content), error);
        }
    }

    protected CharSequence getFormattedContent(CharSequence content) {
        Date date = new Date();
        return this.dateFormat.format(date) + content;
    }

    protected void info(CharSequence content) {
        if (this.log != null) {
            this.log.info(this.getFormattedContent(content));
        }
    }

    protected void warn(CharSequence content, Throwable error) {
        if (this.log != null) {
            this.log.debug(this.getFormattedContent(content), error);
            this.log.warn(this.getFormattedContent(content));
        }
    }

    protected void warn(CharSequence content) {
        if (this.log != null) {
            this.log.warn(this.getFormattedContent(content));
        }
    }

    protected void error(CharSequence content, Throwable error) {
        if (this.log != null) {
            this.log.debug(this.getFormattedContent(content), error);
            this.log.error(this.getFormattedContent(content));
        }
    }

    protected void error(CharSequence content) {
        if (this.log != null) {
            this.log.error(this.getFormattedContent(content));
        }
    }
}

