/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import wicket.contrib.tinymce.InPlaceEditBehavior;
import wicket.contrib.tinymce.InPlaceSaveBehavior;
import wicket.contrib.tinymce.settings.TinyMCESettings;
import wicket.contrib.tinymce.settings.WicketSavePlugin;

public class InPlaceEditComponent
extends AbstractTextComponent {
    private static final long serialVersionUID = 1L;
    private InPlaceSaveBehavior inPlaceSaveBehavior;
    private InPlaceEditBehavior inPlaceEditBehavior;
    private final Component triggerComponent;
    private final TinyMCESettings settings;

    public InPlaceEditComponent(String id, IModel model) {
        this(id, model, null, null);
    }

    public InPlaceEditComponent(String id, IModel model, Component triggerComponent) {
        this(id, model, triggerComponent, null);
    }

    public InPlaceEditComponent(String id, IModel model, TinyMCESettings settings) {
        this(id, model, null, settings);
    }

    public InPlaceEditComponent(String id, IModel model, Component triggerComponent, TinyMCESettings settings) {
        super(id, model);
        this.settings = settings != null ? settings : new TinyMCESettings(TinyMCESettings.Theme.advanced);
        this.triggerComponent = triggerComponent != null ? triggerComponent : this;
    }

    public InPlaceEditComponent(String id, String text) {
        this(id, (IModel)new Model((Serializable)((Object)text)));
    }

    public InPlaceEditComponent(String id, String text, Component triggerComponent) {
        this(id, (IModel)new Model((Serializable)((Object)text)), triggerComponent, null);
    }

    public InPlaceEditComponent(String id, String text, TinyMCESettings settings) {
        this(id, (IModel)new Model((Serializable)((Object)text)), settings);
    }

    public InPlaceEditComponent(String id, String text, Component triggerComponent, TinyMCESettings settings) {
        this(id, (IModel)new Model((Serializable)((Object)text)), triggerComponent, settings);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setEscapeModelStrings(false);
        this.setOutputMarkupId(true);
        this.inPlaceSaveBehavior = this.createSaveBehavior();
        if (this.inPlaceSaveBehavior != null) {
            this.add(new Behavior[]{this.inPlaceSaveBehavior});
        }
        this.inPlaceEditBehavior = this.createEditBehavior(this.triggerComponent);
        if (this.inPlaceEditBehavior != null) {
            this.add(new Behavior[]{this.inPlaceEditBehavior});
        }
    }

    protected InPlaceEditBehavior createEditBehavior(Component triggerComponent) {
        WicketSavePlugin savePlugin = new WicketSavePlugin(this.inPlaceSaveBehavior);
        return new InPlaceEditBehavior(this.settings, triggerComponent, savePlugin);
    }

    protected InPlaceSaveBehavior createSaveBehavior() {
        return new InPlaceSaveBehavior();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("name");
    }

    public String getInputName() {
        return this.getMarkupId();
    }

    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.getValue());
    }

    public InPlaceSaveBehavior getInPlaceSaveBehavior() {
        return this.inPlaceSaveBehavior;
    }

    public InPlaceEditBehavior getInPlaceEditBehavior() {
        return this.inPlaceEditBehavior;
    }

    public TinyMCESettings getSettings() {
        return this.settings;
    }
}

