/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;

public class InPlaceSaveBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_HTMLCONT = "htmlcont";
    private String saveEditorScriptName;
    private String cancelEditorScriptName;
    private String additionalJavaScript;

    public void setAdditionalJavaScript(String additionalJavaScript) {
        this.additionalJavaScript = additionalJavaScript;
    }

    protected final void respond(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        String newContent = request.getRequestParameters().getParameterValue(PARAM_HTMLCONT).toString();
        newContent = this.onSave(target, newContent);
        Component component = this.getComponent();
        IModel defaultModel = component.getDefaultModel();
        defaultModel.setObject((Object)newContent);
        target.add(new Component[]{component});
    }

    public final String getSaveCallbackName() {
        if (this.saveEditorScriptName == null) {
            String uuid = UUID.randomUUID().toString().replace('-', '_');
            this.saveEditorScriptName = "savemce_" + uuid;
        }
        return this.saveEditorScriptName;
    }

    public final String getCancelCallbackName() {
        if (this.cancelEditorScriptName == null) {
            String uuid = UUID.randomUUID().toString().replace('-', '_');
            this.cancelEditorScriptName = "cancelmce_" + uuid;
        }
        return this.cancelEditorScriptName;
    }

    public Component getTheComponent() {
        Component result = this.getComponent();
        if (result == null) {
            throw new IllegalArgumentException("save behavior not yet bound to a component");
        }
        return result;
    }

    protected String onSave(AjaxRequestTarget target, String newContent) {
        return newContent;
    }

    public String getSaveCallback() {
        CharSequence callback = this.getWicketPostScript();
        String markupId = this.getComponent().getMarkupId();
        return "function " + this.getSaveCallbackName() + "(inst) {\n" + " var content = inst.getContent();\n" + " inst.setContent(inst.settings.wicket_updating_mess);\n" + " tinyMCE.execCommand('mceRemoveControl',false,'" + markupId + "');\n" + " " + callback + "\n" + (this.additionalJavaScript == null ? "" : this.additionalJavaScript + "\n") + "}";
    }

    public String getCancelCallback() {
        return "function " + this.getCancelCallbackName() + "(inst) {\n" + (this.additionalJavaScript == null ? "" : this.additionalJavaScript + "\n") + "}";
    }

    private CharSequence getWicketPostScript() {
        return "var sendContent = " + this.getCallbackFunction(new CallbackParameter[]{CallbackParameter.explicit((String)"content")}) + "sendContent(content);";
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setMethod(AjaxRequestAttributes.Method.POST);
        attributes.getDynamicExtraParameters().add("return {'htmlcont': attrs.ep.content}");
    }
}

