/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.build.AetherArtifactFileResolver;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.featurepack.FeaturePackBuilder;
import org.wildfly.build.featurepack.model.FeaturePackBuild;
import org.wildfly.build.featurepack.model.FeaturePackBuildModelParser;
import org.wildfly.build.plugin.MavenProjectArtifactResolver;
import org.wildfly.build.plugin.Resource;
import org.wildfly.build.util.FileUtils;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.PropertyResolver;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class FeaturePackBuildMojo
extends AbstractMojo {
    private static final boolean OS_WINDOWS = System.getProperty("os.name").contains("indows");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="config-file", defaultValue="feature-pack-build.xml", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="resources-dir", defaultValue="src/main/resources", property="wildfly.feature.pack.resourcesDir", required=true)
    private String resourcesDir;
    @Parameter(alias="server-name", defaultValue="${project.build.finalName}", property="wildfly.feature.pack.serverName")
    private String serverName;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.feature.pack.buildName")
    private String buildName;
    @Parameter
    private List<Resource> resources;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.resourcesDir.isEmpty()) {
            switch (this.resourcesDir.charAt(0)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    this.resourcesDir = "/" + this.resourcesDir;
                }
            }
        }
        this.copyContents();
        try (FileInputStream configStream = new FileInputStream(new File(this.configDir, this.configFile));){
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.project.getProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            properties.put("project.version", this.project.getVersion());
            FeaturePackBuild build = new FeaturePackBuildModelParser((PropertyResolver)new MapPropertyResolver(properties)).parse(configStream);
            File target = new File(this.buildName, this.serverName);
            FeaturePackBuilder.build(build, target, new MavenProjectArtifactResolver(this.project), (ArtifactFileResolver)new AetherArtifactFileResolver(this.repoSystem, this.repoSession, this.remoteRepos));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.resources != null) {
            try {
                this.processResources(this.getOverwriteResources(), true);
                this.processResources(this.getNonOverwriteResources(), false);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Failed to process resources.", (Exception)((Object)e));
            }
        }
    }

    private void copyContents() {
        try {
            File baseDir = new File(this.buildName, this.serverName);
            FileUtils.deleteRecursive((File)baseDir);
            Path path = Paths.get(baseDir.getAbsolutePath(), new String[0]);
            Path baseFile = Paths.get(this.configDir.getAbsolutePath() + this.resourcesDir, new String[0]);
            this.doCopy(path.resolve("content"), baseFile.resolve("content"));
            this.doCopy(path.resolve("modules"), baseFile.resolve("modules"));
            this.doCopy(path.resolve("configuration"), baseFile.resolve("configuration"));
            this.doCopy(path.resolve("subsystem-templates"), baseFile.resolve("subsystem-templates"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doCopy(final Path target, final Path source) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relative = source.relativize(dir).toString();
                boolean include = true;
                if (include) {
                    Path rel = target.resolve(relative);
                    if (!Files.isDirectory(rel, new LinkOption[0]) && !rel.toFile().mkdirs()) {
                        throw new IOException("Could not create directory " + rel.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relative = source.relativize(file).toString();
                Path targetFile = target.resolve(relative);
                FileUtils.copyFile((File)file.toFile(), (File)targetFile.toFile());
                if (!OS_WINDOWS) {
                    Files.setPosixFilePermissions(targetFile, Files.getPosixFilePermissions(file, new LinkOption[0]));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void processResources(List<org.apache.maven.model.Resource> resources, boolean overwrite) throws MavenFilteringException {
        MavenResourcesExecution resourcesExecution = new MavenResourcesExecution(resources, new File(this.buildName, this.serverName), this.project, "UTF-8", Collections.emptyList(), Collections.emptyList(), this.session);
        resourcesExecution.setIncludeEmptyDirs(false);
        resourcesExecution.setEscapeWindowsPaths(true);
        resourcesExecution.setOverwrite(overwrite);
        resourcesExecution.setAddDefaultExcludes(true);
        this.mavenResourcesFiltering.filterResources(resourcesExecution);
    }

    private List<org.apache.maven.model.Resource> getOverwriteResources() {
        ArrayList<org.apache.maven.model.Resource> result = new ArrayList<org.apache.maven.model.Resource>();
        for (Resource resource : this.resources) {
            if (!resource.isOverwrite()) continue;
            result.add(resource);
        }
        return result;
    }

    private List<org.apache.maven.model.Resource> getNonOverwriteResources() {
        ArrayList<org.apache.maven.model.Resource> result = new ArrayList<org.apache.maven.model.Resource>();
        for (Resource resource : this.resources) {
            if (resource.isOverwrite()) continue;
            result.add(resource);
        }
        return result;
    }
}

