/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.CombinationPolicy;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.ApplicationTypeConstraint;
import org.jboss.as.controller.access.constraint.AuditConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.HostEffectConstraint;
import org.jboss.as.controller.access.constraint.NonAuditConstraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.constraint.SensitiveTargetConstraint;
import org.jboss.as.controller.access.constraint.SensitiveVaultExpressionConstraint;
import org.jboss.as.controller.access.constraint.ServerGroupEffectConstraint;
import org.jboss.as.controller.access.constraint.TopRoleConstraint;
import org.jboss.as.controller.access.permission.AllPermissionsCollection;
import org.jboss.as.controller.access.permission.CombinationManagementPermission;
import org.jboss.as.controller.access.permission.JmxPermissionFactory;
import org.jboss.as.controller.access.permission.ManagementPermission;
import org.jboss.as.controller.access.permission.ManagementPermissionCollection;
import org.jboss.as.controller.access.permission.PermissionFactory;
import org.jboss.as.controller.access.permission.SimpleManagementPermission;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.as.controller.logging.ControllerLogger;

public class DefaultPermissionFactory
implements PermissionFactory,
JmxPermissionFactory,
AuthorizerConfiguration.ScopedRoleListener {
    private static final PermissionCollection NO_PERMISSIONS = new NoPermissionsCollection();
    private final RoleMapper roleMapper;
    private final SortedSet<ConstraintFactory> constraintFactories = new TreeSet<ConstraintFactory>();
    private final Map<String, ManagementPermissionCollection> permissionsByRole = new HashMap<String, ManagementPermissionCollection>();
    private final Map<String, ScopedBase> scopedBaseMap = new HashMap<String, ScopedBase>();
    private final AuthorizerConfiguration authorizerConfiguration;
    private PermsHolder permsHolder;
    private boolean rolePermissionsConfigured;

    public DefaultPermissionFactory(RoleMapper roleMapper, AuthorizerConfiguration authorizerConfiguration) {
        this(roleMapper, DefaultPermissionFactory.getStandardConstraintFactories(), authorizerConfiguration);
    }

    DefaultPermissionFactory(RoleMapper roleMapper, Set<ConstraintFactory> constraintFactories, AuthorizerConfiguration authorizerConfiguration) {
        this.roleMapper = roleMapper;
        this.constraintFactories.addAll(constraintFactories);
        this.authorizerConfiguration = authorizerConfiguration;
    }

    @Override
    public PermissionCollection getUserPermissions(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        return this.getUserPermissions(this.roleMapper.mapRoles(caller, callEnvironment, action, target));
    }

    @Override
    public PermissionCollection getUserPermissions(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        return this.getUserPermissions(this.roleMapper.mapRoles(caller, callEnvironment, action, target));
    }

    @Override
    public Set<String> getUserRoles(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        return this.roleMapper.mapRoles(caller, callEnvironment, action, target);
    }

    @Override
    public boolean isNonFacadeMBeansSensitive() {
        return this.authorizerConfiguration.isNonFacadeMBeansSensitive();
    }

    private PermissionCollection getUserPermissions(Set<String> roles) {
        PermissionCollection result = this.checkAllPermissions(roles);
        if (result != null) {
            return result;
        }
        PermsHolder currentPerms = this.configureRolePermissions();
        result = currentPerms.getPermissions(roles);
        if (result != null) {
            return result;
        }
        CombinationPolicy combinationPolicy = this.authorizerConfiguration.getPermissionCombinationPolicy();
        PermissionCollection simple = null;
        HashMap<Action.ActionEffect, CombinationManagementPermission> combined = null;
        for (String roleName : roles) {
            CombinationManagementPermission cmp;
            Action.ActionEffect actionEffect;
            ManagementPermission mperm;
            Enumeration<Permission> permissionEnumeration;
            if (combinationPolicy == CombinationPolicy.REJECTING && simple != null) {
                throw ControllerLogger.ROOT_LOGGER.illegalMultipleRoles();
            }
            ManagementPermissionCollection role = (ManagementPermissionCollection)currentPerms.permsByRole.get(DefaultPermissionFactory.getOfficialForm(roleName));
            if (role == null) {
                throw ControllerLogger.ROOT_LOGGER.unknownRole(roleName);
            }
            if (simple == null) {
                simple = role;
                continue;
            }
            if (combined == null) {
                combined = new HashMap<Action.ActionEffect, CombinationManagementPermission>();
                permissionEnumeration = ((ManagementPermissionCollection)simple).elements();
                String firstName = ((ManagementPermissionCollection)simple).getName();
                while (permissionEnumeration.hasMoreElements()) {
                    mperm = (ManagementPermission)permissionEnumeration.nextElement();
                    actionEffect = mperm.getActionEffect();
                    cmp = new CombinationManagementPermission(combinationPolicy, actionEffect);
                    cmp.addUnderlyingPermission(firstName, mperm);
                    combined.put(actionEffect, cmp);
                }
            }
            permissionEnumeration = role.elements();
            String officialForm = DefaultPermissionFactory.getOfficialForm(roleName);
            while (permissionEnumeration.hasMoreElements()) {
                mperm = (ManagementPermission)permissionEnumeration.nextElement();
                actionEffect = mperm.getActionEffect();
                cmp = (CombinationManagementPermission)combined.get((Object)actionEffect);
                if (cmp == null) {
                    cmp = new CombinationManagementPermission(combinationPolicy, actionEffect);
                    combined.put(actionEffect, cmp);
                }
                cmp.addUnderlyingPermission(officialForm, mperm);
            }
        }
        if (combined == null) {
            result = simple != null ? simple : NO_PERMISSIONS;
        } else {
            result = new ManagementPermissionCollection("MULTIPLE ROLES", CombinationManagementPermission.class);
            for (CombinationManagementPermission cmp : combined.values()) {
                result.add(cmp);
            }
        }
        currentPerms.storePermissions(roles, result);
        return result;
    }

    private PermissionCollection checkAllPermissions(Set<String> roles) {
        if (roles.contains(StandardRole.SUPERUSER.toString()) && (this.authorizerConfiguration.getPermissionCombinationPolicy() == CombinationPolicy.PERMISSIVE || roles.size() == 1)) {
            return AllPermissionsCollection.INSTANCE;
        }
        return null;
    }

    @Override
    public PermissionCollection getRequiredPermissions(Action action, TargetAttribute target) {
        PermsHolder currentPerms = this.configureRolePermissions();
        ConstraintFactory[] currentFactories = currentPerms.constraintFactories;
        ManagementPermissionCollection result = new ManagementPermissionCollection(SimpleManagementPermission.class);
        for (Action.ActionEffect actionEffect : action.getActionEffects()) {
            Constraint[] constraints = new Constraint[currentFactories.length];
            for (int i = 0; i < constraints.length; ++i) {
                constraints[i] = currentFactories[i].getRequiredConstraint(actionEffect, action, target);
            }
            result.add(new SimpleManagementPermission(actionEffect, constraints));
        }
        return result;
    }

    @Override
    public PermissionCollection getRequiredPermissions(Action action, TargetResource target) {
        PermsHolder currentPerms = this.configureRolePermissions();
        ConstraintFactory[] currentFactories = currentPerms.constraintFactories;
        ManagementPermissionCollection result = new ManagementPermissionCollection(SimpleManagementPermission.class);
        for (Action.ActionEffect actionEffect : action.getActionEffects()) {
            Constraint[] constraints = new Constraint[currentFactories.length];
            for (int i = 0; i < constraints.length; ++i) {
                constraints[i] = currentFactories[i].getRequiredConstraint(actionEffect, action, target);
            }
            result.add(new SimpleManagementPermission(actionEffect, constraints));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConstraintFactory(ConstraintFactory factory) {
        DefaultPermissionFactory defaultPermissionFactory = this;
        synchronized (defaultPermissionFactory) {
            if (this.constraintFactories.add(factory)) {
                this.rolePermissionsConfigured = false;
            }
        }
    }

    @Override
    public synchronized void scopedRoleAdded(AuthorizerConfiguration.ScopedRole added) {
        String roleName = added.getName();
        String officialForm = DefaultPermissionFactory.getOfficialForm(roleName);
        if (this.permissionsByRole.containsKey(officialForm)) {
            throw ControllerLogger.ROOT_LOGGER.roleIsAlreadyRegistered(roleName);
        }
        String baseName = added.getBaseRoleName();
        String officialBase = DefaultPermissionFactory.getOfficialForm(baseName);
        if (this.rolePermissionsConfigured && !this.permissionsByRole.containsKey(officialBase)) {
            throw ControllerLogger.ROOT_LOGGER.unknownBaseRole(baseName);
        }
        ScopingConstraint constraint = added.getScopingConstraint();
        this.addConstraintFactory(constraint.getFactory());
        this.scopedBaseMap.put(officialForm, new ScopedBase(StandardRole.valueOf(officialBase), constraint));
        this.rolePermissionsConfigured = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void scopedRoleRemoved(AuthorizerConfiguration.ScopedRole removed) {
        StandardRole standard;
        String officialForm = DefaultPermissionFactory.getOfficialForm(removed.getName());
        try {
            standard = StandardRole.valueOf(officialForm);
        }
        catch (RuntimeException ignored) {
            standard = null;
        }
        if (standard != null) {
            throw ControllerLogger.ROOT_LOGGER.cannotRemoveStandardRole(standard.toString());
        }
        DefaultPermissionFactory defaultPermissionFactory = this;
        synchronized (defaultPermissionFactory) {
            this.scopedBaseMap.remove(officialForm);
            this.rolePermissionsConfigured = false;
        }
    }

    private synchronized PermsHolder configureRolePermissions() {
        if (!this.rolePermissionsConfigured) {
            this.permissionsByRole.clear();
            this.permissionsByRole.putAll(this.configureDefaultPermissions());
            for (Map.Entry<String, ScopedBase> entry : this.scopedBaseMap.entrySet()) {
                this.addScopedRoleInternal(entry.getKey(), entry.getValue().base, entry.getValue().constraint);
            }
            this.permsHolder = new PermsHolder(this.permissionsByRole, this.constraintFactories);
            this.rolePermissionsConfigured = true;
        }
        return this.permsHolder;
    }

    private synchronized Map<String, ManagementPermissionCollection> configureDefaultPermissions() {
        HashMap<String, ManagementPermissionCollection> result = new HashMap<String, ManagementPermissionCollection>();
        for (StandardRole standardRole : StandardRole.values()) {
            String officialForm = DefaultPermissionFactory.getOfficialForm(standardRole);
            ManagementPermissionCollection rolePerms = new ManagementPermissionCollection(officialForm, SimpleManagementPermission.class);
            for (Action.ActionEffect actionEffect : Action.ActionEffect.values()) {
                if (!standardRole.isActionEffectAllowed(actionEffect)) continue;
                Constraint[] constraints = new Constraint[this.constraintFactories.size()];
                int i = 0;
                for (ConstraintFactory factory : this.constraintFactories) {
                    constraints[i] = factory.getStandardUserConstraint(standardRole, actionEffect);
                    ++i;
                }
                rolePerms.add(new SimpleManagementPermission(actionEffect, constraints));
            }
            result.put(officialForm, rolePerms);
        }
        return result;
    }

    private synchronized void addScopedRoleInternal(String officialForm, StandardRole base, ScopingConstraint scopingConstraint) {
        ManagementPermissionCollection baseCollection = this.permissionsByRole.get(DefaultPermissionFactory.getOfficialForm(base));
        int constraintIndex = this.getConstraintIndex(scopingConstraint.getFactory());
        HashMap<Action.ActionEffect, SimpleManagementPermission> monitorPermissions = new HashMap<Action.ActionEffect, SimpleManagementPermission>();
        ManagementPermissionCollection monitorCollection = this.permissionsByRole.get(DefaultPermissionFactory.getOfficialForm(StandardRole.MONITOR));
        Enumeration<Permission> monitorEnumeration = monitorCollection.elements();
        while (monitorEnumeration.hasMoreElements()) {
            SimpleManagementPermission monitorPerm = (SimpleManagementPermission)monitorEnumeration.nextElement();
            monitorPermissions.put(monitorPerm.getActionEffect(), monitorPerm);
        }
        ManagementPermissionCollection scopedPermissions = null;
        Enumeration<Permission> permissionEnumeration = baseCollection.elements();
        String scopedBaseName = officialForm + " (" + DefaultPermissionFactory.getOfficialForm(base) + " permissions)";
        while (permissionEnumeration.hasMoreElements()) {
            SimpleManagementPermission basePerm = (SimpleManagementPermission)permissionEnumeration.nextElement();
            Action.ActionEffect actionEffect = basePerm.getActionEffect();
            CombinationManagementPermission combinedPermission = new CombinationManagementPermission(CombinationPolicy.PERMISSIVE, actionEffect);
            if (scopedPermissions == null) {
                scopedPermissions = new ManagementPermissionCollection(officialForm, CombinationManagementPermission.class);
            }
            ManagementPermission scopedPerm = basePerm.createScopedPermission(scopingConstraint.getStandardConstraint(), constraintIndex);
            combinedPermission.addUnderlyingPermission(scopedBaseName, scopedPerm);
            SimpleManagementPermission monitorPerm = (SimpleManagementPermission)monitorPermissions.get((Object)actionEffect);
            String scopedReadOnlyName = officialForm + " (READ-ONLY permissions)";
            if (monitorPerm != null) {
                combinedPermission.addUnderlyingPermission(scopedReadOnlyName, monitorPerm.createScopedPermission(scopingConstraint.getOutofScopeReadConstraint(), constraintIndex));
            }
            scopedPermissions.add(combinedPermission);
        }
        this.permissionsByRole.put(officialForm, scopedPermissions);
    }

    private int getConstraintIndex(ConstraintFactory factory) {
        int i = 0;
        Iterator iter = this.constraintFactories.iterator();
        while (iter.hasNext()) {
            if (factory.equals(iter.next())) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private static Set<ConstraintFactory> getStandardConstraintFactories() {
        HashSet<ConstraintFactory> result = new HashSet<ConstraintFactory>();
        result.add(ApplicationTypeConstraint.FACTORY);
        result.add(AuditConstraint.FACTORY);
        result.add(NonAuditConstraint.FACTORY);
        result.add(HostEffectConstraint.FACTORY);
        result.add(SensitiveTargetConstraint.FACTORY);
        result.add(SensitiveVaultExpressionConstraint.FACTORY);
        result.add(ServerGroupEffectConstraint.FACTORY);
        result.add(TopRoleConstraint.FACTORY);
        return result;
    }

    private static String getOfficialForm(StandardRole role) {
        return role.getOfficialForm();
    }

    private static String getOfficialForm(String role) {
        return role.toUpperCase(Locale.ENGLISH);
    }

    private static class PermsHolder {
        private final Map<Set<String>, PermissionCollection> permsByRoleSet = Collections.synchronizedMap(new HashMap());
        private final Map<String, ManagementPermissionCollection> permsByRole = new HashMap<String, ManagementPermissionCollection>();
        private final ConstraintFactory[] constraintFactories;

        private PermsHolder(Map<String, ManagementPermissionCollection> permsByRole, SortedSet<ConstraintFactory> constraintFactories) {
            this.permsByRole.putAll(permsByRole);
            this.constraintFactories = constraintFactories.toArray(new ConstraintFactory[constraintFactories.size()]);
        }

        private PermissionCollection getPermissions(Set<String> roleSet) {
            return this.permsByRoleSet.get(roleSet);
        }

        private void storePermissions(Set<String> roleSet, PermissionCollection perms) {
            this.permsByRoleSet.put(roleSet, perms);
        }
    }

    private static class NoPermissionsCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 426277167342589940L;

        private NoPermissionsCollection() {
        }

        @Override
        public void add(Permission permission) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return new Enumeration<Permission>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public Permission nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private class ScopedBase {
        private final StandardRole base;
        private final ScopingConstraint constraint;

        private ScopedBase(StandardRole base, ScopingConstraint constraint) {
            this.base = base;
            this.constraint = constraint;
        }
    }
}

