/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.DelegatingManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

final class ProxyControllerRegistration
extends AbstractResourceRegistration
implements DescriptionProvider {
    private volatile Map<String, OperationEntry> operations;
    private volatile Map<String, AttributeAccess> attributes;
    private final ProxyController proxyController;
    private final OperationEntry operationEntry;
    private static final AtomicMapFieldUpdater<ProxyControllerRegistration, String, OperationEntry> operationsUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ProxyControllerRegistration.class, Map.class, "operations"));
    private static final AtomicMapFieldUpdater<ProxyControllerRegistration, String, AttributeAccess> attributesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ProxyControllerRegistration.class, Map.class, "attributes"));

    ProxyControllerRegistration(String valueString, NodeSubregistry parent, ProxyController proxyController) {
        super(valueString, parent);
        this.operationEntry = new OperationEntry(new ProxyStepHandler(proxyController), this, false, OperationEntry.EntryType.PRIVATE);
        this.proxyController = proxyController;
        operationsUpdater.clear(this);
        attributesUpdater.clear(this);
    }

    @Override
    OperationEntry getOperationEntry(ListIterator<PathElement> iterator, String operationName, OperationEntry inherited) {
        ProxyControllerRegistration.checkPermission();
        if (!iterator.hasNext()) {
            OperationEntry entry = operationsUpdater.get(this, operationName);
            return entry == null ? this.operationEntry : entry;
        }
        return this.operationEntry;
    }

    @Override
    OperationEntry getInheritableOperationEntry(String operationName) {
        ProxyControllerRegistration.checkPermission();
        return null;
    }

    @Override
    public boolean isRuntimeOnly() {
        ProxyControllerRegistration.checkPermission();
        return true;
    }

    @Override
    public void setRuntimeOnly(boolean runtimeOnly) {
        ProxyControllerRegistration.checkPermission();
    }

    @Override
    public boolean isRemote() {
        ProxyControllerRegistration.checkPermission();
        return true;
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        ProxyControllerRegistration.checkPermission();
        return Collections.emptyList();
    }

    @Override
    public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterSubModel(PathElement address) throws IllegalArgumentException {
        throw this.alreadyRegistered();
    }

    @Override
    public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterOverrideModel(String name) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        if (operationsUpdater.putIfAbsent(this, operationName, new OperationEntry(handler, descriptionProvider, inherited, entryType)) != null) {
            throw this.alreadyRegistered("operation handler", operationName);
        }
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        if (operationsUpdater.putIfAbsent(this, operationName, new OperationEntry(handler, descriptionProvider, inherited, entryType, flags, null)) != null) {
            throw this.alreadyRegistered("operation handler", operationName);
        }
    }

    @Override
    public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
        if (operationsUpdater.putIfAbsent(this, definition.getName(), new OperationEntry(handler, definition.getDescriptionProvider(), inherited, definition.getEntryType(), definition.getFlags(), definition.getAccessConstraints())) != null) {
            throw this.alreadyRegistered("operation handler", definition.getName());
        }
    }

    @Override
    public void unregisterOperationHandler(String operationName) {
        if (operationsUpdater.remove(this, operationName) == null) {
            throw this.operationNotRegisteredException(operationName, this.proxyController.getProxyNodeAddress().getLastElement());
        }
    }

    @Override
    public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        AttributeAccess.Storage storage;
        AttributeAccess aa;
        EnumSet<AttributeAccess.Flag> flags = definition.getFlags();
        String attributeName = definition.getName();
        if (attributesUpdater.putIfAbsent(this, attributeName, aa = new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION, readHandler, writeHandler, definition, flags)) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, null, null);
        if (attributesUpdater.putIfAbsent(this, attributeName, aa) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        AttributeAccess.Storage storage;
        AttributeAccess aa;
        EnumSet<AttributeAccess.Flag> flags = definition.getFlags();
        String attributeName = definition.getName();
        if (attributesUpdater.putIfAbsent(this, attributeName, aa = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION, readHandler, null, definition, flags)) != null) {
            throw this.alreadyRegistered("attribute", attributeName);
        }
    }

    @Override
    public void unregisterAttribute(String attributeName) {
        attributesUpdater.remove(this, attributeName);
    }

    @Override
    public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.METRIC, AttributeAccess.Storage.RUNTIME, metricHandler, null, definition, definition.getFlags());
        if (attributesUpdater.putIfAbsent(this, definition.getName(), aa) != null) {
            throw this.alreadyRegistered("attribute", definition.getName());
        }
    }

    @Override
    public void registerProxyController(PathElement address, ProxyController proxyController) throws IllegalArgumentException {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterProxyController(PathElement address) throws IllegalArgumentException {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerAlias(PathElement address, AliasEntry alias) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterAlias(PathElement address) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerNotification(NotificationDefinition notification, boolean inherited) {
        throw this.alreadyRegistered();
    }

    @Override
    public void registerNotification(NotificationDefinition notification) {
        throw this.alreadyRegistered();
    }

    @Override
    public void unregisterNotification(String notificationType) {
        throw this.alreadyRegistered();
    }

    @Override
    void getOperationDescriptions(ListIterator<PathElement> iterator, Map<String, OperationEntry> providers, boolean inherited) {
        ProxyControllerRegistration.checkPermission();
    }

    @Override
    void getInheritedOperationEntries(Map<String, OperationEntry> providers) {
        ProxyControllerRegistration.checkPermission();
    }

    @Override
    void getNotificationDescriptions(ListIterator<PathElement> iterator, Map<String, NotificationEntry> providers, boolean inherited) {
        ProxyControllerRegistration.checkPermission();
    }

    @Override
    void getInheritedNotificationEntries(Map<String, NotificationEntry> providers) {
        ProxyControllerRegistration.checkPermission();
    }

    @Override
    DescriptionProvider getModelDescription(ListIterator<PathElement> iterator) {
        ProxyControllerRegistration.checkPermission();
        return this;
    }

    @Override
    Set<String> getAttributeNames(ListIterator<PathElement> iterator) {
        ProxyControllerRegistration.checkPermission();
        if (iterator.hasNext()) {
            return Collections.emptySet();
        }
        Map<String, AttributeAccess> snapshot = attributesUpdater.get(this);
        return snapshot.keySet();
    }

    @Override
    Set<String> getChildNames(ListIterator<PathElement> iterator) {
        ProxyControllerRegistration.checkPermission();
        return Collections.emptySet();
    }

    @Override
    Set<PathElement> getChildAddresses(ListIterator<PathElement> iterator) {
        ProxyControllerRegistration.checkPermission();
        return Collections.emptySet();
    }

    @Override
    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String attributeName) {
        ProxyControllerRegistration.checkPermission();
        if (iterator.hasNext()) {
            return null;
        }
        Map<String, AttributeAccess> snapshot = attributesUpdater.get(this);
        return snapshot.get(attributeName);
    }

    @Override
    ProxyController getProxyController(ListIterator<PathElement> iterator) {
        ProxyControllerRegistration.checkPermission();
        return this.proxyController;
    }

    @Override
    void getProxyControllers(ListIterator<PathElement> iterator, Set<ProxyController> controllers) {
        ProxyControllerRegistration.checkPermission();
        controllers.add(this.proxyController);
    }

    @Override
    ManagementResourceRegistration getResourceRegistration(ListIterator<PathElement> iterator) {
        PathAddress childAddress = null;
        if (iterator.hasNext()) {
            childAddress = this.getPathAddress();
            while (iterator.hasNext()) {
                childAddress = childAddress.append(iterator.next());
            }
        }
        ProxyControllerRegistration.checkPermission();
        return childAddress == null ? this : new ChildRegistration(childAddress);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ProxyControllerRegistration.checkPermission();
        return new ModelNode();
    }

    private IllegalArgumentException alreadyRegistered() {
        return ControllerLogger.ROOT_LOGGER.proxyHandlerAlreadyRegistered(this.getLocationString());
    }

    private IllegalArgumentException alreadyRegistered(String type, String name) {
        return ControllerLogger.ROOT_LOGGER.alreadyRegistered(type, name, this.getLocationString());
    }

    private IllegalArgumentException operationNotRegisteredException(String op, PathElement address) {
        return ControllerLogger.ROOT_LOGGER.operationNotRegisteredException(op, PathAddress.pathAddress(address));
    }

    @Override
    public AliasEntry getAliasEntry() {
        ProxyControllerRegistration.checkPermission();
        return null;
    }

    @Override
    protected void registerAlias(PathElement address, AliasEntry alias, AbstractResourceRegistration target) {
        throw ControllerLogger.ROOT_LOGGER.proxyHandlerAlreadyRegistered(this.getLocationString());
    }

    private class ChildRegistration
    extends DelegatingManagementResourceRegistration {
        private final PathAddress pathAddress;

        public ChildRegistration(PathAddress pathAddress) {
            super(ProxyControllerRegistration.this);
            this.pathAddress = pathAddress;
        }

        @Override
        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            AbstractResourceRegistration.checkPermission();
            return ProxyControllerRegistration.this.operationEntry;
        }

        @Override
        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return this.getOperationEntry(address, operationName).getOperationHandler();
        }

        @Override
        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return this.getOperationEntry(address, operationName).getDescriptionProvider();
        }

        @Override
        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return this.getOperationEntry(address, operationName).getFlags();
        }

        @Override
        public Set<String> getAttributeNames(PathAddress address) {
            AbstractResourceRegistration.checkPermission();
            return Collections.emptySet();
        }

        @Override
        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            AbstractResourceRegistration.checkPermission();
            return null;
        }

        @Override
        public ManagementResourceRegistration getOverrideModel(String name) {
            AbstractResourceRegistration.checkPermission();
            return null;
        }

        @Override
        public ManagementResourceRegistration getSubModel(PathAddress address) {
            if (address.size() == 0) {
                return this;
            }
            return new ChildRegistration(this.pathAddress.append(address));
        }
    }
}

