/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;

final class ContainerStateVerificationHandler
implements OperationStepHandler {
    static final OperationContext.AttachmentKey<Boolean> FAILURE_REPORTED_ATTACHMENT = OperationContext.AttachmentKey.create(Boolean.class);
    private final ContainerStateMonitor.ContainerStateChangeReport changeReport;

    ContainerStateVerificationHandler(ContainerStateMonitor.ContainerStateChangeReport changeReport) {
        assert (changeReport != null);
        assert (changeReport.hasNewProblems());
        this.changeReport = changeReport;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!context.hasFailureDescription() && context.getAttachment(FAILURE_REPORTED_ATTACHMENT) == null) {
            throw new OperationFailedException(ContainerStateMonitor.createChangeReportLogMessage(this.changeReport, true));
        }
    }
}

