/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.Assert;

public class RelativePathService
extends AbstractPathService {
    private final String relativePath;
    private final Supplier<String> pathSupplier;

    private RelativePathService(String relativePath, Consumer<String> pathConsumer, Supplier<String> pathSupplier) {
        super(pathConsumer);
        this.relativePath = RelativePathService.convertPath(relativePath);
        this.pathSupplier = pathSupplier;
    }

    public static ServiceController<?> addService(String name, String relativePath, String relativeTo, ServiceTarget serviceTarget) {
        return RelativePathService.addService(RelativePathService.pathNameOf(name), relativePath, false, relativeTo, serviceTarget);
    }

    public static ServiceController<?> addService(ServiceName name, String relativePath, String relativeTo, ServiceTarget serviceTarget) {
        return RelativePathService.addService(name, relativePath, false, relativeTo, serviceTarget);
    }

    public static ServiceController<?> addService(ServiceName name, String path, boolean possiblyAbsolute, String relativeTo, ServiceTarget serviceTarget) {
        if (possiblyAbsolute && RelativePathService.isAbsoluteUnixOrWindowsPath(path)) {
            return AbsolutePathService.addService(name, path, serviceTarget);
        }
        ServiceBuilder builder = serviceTarget.addService(name);
        Consumer pathConsumer = builder.provides(new ServiceName[]{name});
        Supplier injectedPath = builder.requires(RelativePathService.pathNameOf(relativeTo));
        builder.setInstance((Service)new RelativePathService(path, pathConsumer, injectedPath));
        return builder.install();
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String relativePath = element.require("path").asString();
        String relativeTo = element.require("relative-to").asString();
        RelativePathService.addService(name, relativePath, false, relativeTo, serviceTarget);
    }

    static String convertPath(String relativePath) {
        Assert.checkNotNullParam((String)"relativePath", (Object)relativePath);
        Assert.checkNotEmptyParam((String)"relativePath", (String)relativePath);
        if (relativePath.charAt(0) == '/') {
            if (relativePath.length() == 1) {
                throw ControllerLogger.ROOT_LOGGER.invalidRelativePathValue(relativePath);
            }
            return relativePath.substring(1);
        }
        if (relativePath.indexOf(":\\") == 1) {
            throw ControllerLogger.ROOT_LOGGER.pathIsAWindowsAbsolutePath(relativePath);
        }
        if (RelativePathService.isWindows()) {
            return relativePath.replace("/", File.separator);
        }
        return relativePath.replace("\\", File.separator);
    }

    static String doResolve(String base, String relativePath) {
        base = base.endsWith(File.separator) ? base.substring(0, base.length() - 1) : base;
        return base + File.separatorChar + relativePath;
    }

    @Override
    protected String resolvePath() {
        return RelativePathService.doResolve(this.pathSupplier.get(), this.relativePath);
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

