/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.JsonReportAttacher;
import org.jboss.as.controller.operations.global.ReportAttacher;
import org.jboss.as.controller.operations.global.XMLReportAttacher;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalInstallationReportHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    public static final String OPERATION_NAME = "product-info";
    public static final String SUB_OPERATION_NAME = "report";
    public static final String ARCH = "host-cpu-arch";
    public static final String AVAILABLE_PROCESSORS = "host-core-count";
    public static final String CPU = "host-cpu";
    public static final String FORMAT = "format";
    public static final String HOSTNAME = "host-name";
    public static final String INSTANCE_ID = "instance-identifier";
    public static final String JAVA_VERSION = "java-version";
    public static final String JVM = "jvm";
    public static final String JVM_HOME = "java-home";
    public static final String JVM_VENDOR = "jvm-vendor";
    public static final String JVM_VERSION = "jvm-version";
    public static final String NODE_NAME = "node-name";
    public static final String OS = "host-operating-system";
    public static final String PRODUCT_COMMUNITY_IDENTIFIER = "product-community-identifier";
    public static final String PRODUCT_HOME = "product-home";
    public static final String PRODUCT_INSTALLATION_DATE = "installation-date";
    public static final String PRODUCT_LAST_UPDATE = "last-update-date";
    public static final String STANDALONE_DOMAIN_IDENTIFIER = "standalone-or-domain-identifier";
    public static final String SUMMARY = "summary";
    public static final String PRODUCT_TYPE = "Product";
    public static final String PROJECT_TYPE = "Project";
    public static final String XML_FORMAT = "xml";
    public static final String JSON_FORMAT = "json";
    public static final SimpleAttributeDefinition JVM_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of("jvm", SimpleAttributeDefinitionBuilder.create("java-version", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("jvm-version", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("jvm-vendor", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("java-home", ModelType.STRING, true).build()).setRequired(true)).setAttributeMarshaller(AttributeMarshaller.ELEMENT_ONLY_OBJECT)).build();
    public static final SimpleAttributeDefinition CPU_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of("host-cpu", SimpleAttributeDefinitionBuilder.create("host-cpu-arch", ModelType.STRING, true).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("host-core-count", ModelType.INT, true).setDefaultValue(new ModelNode(1))).build()).setRequired(true)).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).build();
    public static final SimpleAttributeDefinition SUMMARY_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("summary", SimpleAttributeDefinitionBuilder.create("node-name", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("host-name", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("instance-identifier", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("product-name", ModelType.STRING, true).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("product-community-identifier", ModelType.STRING).setAllowedValues("Product", "Project")).build(), SimpleAttributeDefinitionBuilder.create("product-version", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("product-home", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("installation-date", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("last-update-date", ModelType.STRING, true).build(), SimpleAttributeDefinitionBuilder.create("host-operating-system", ModelType.STRING, false).build(), JVM_DEFINITION, CPU_DEFINITION).setAttributeMarshaller(AttributeMarshaller.ELEMENT_ONLY_OBJECT)).build();
    public static final SimpleAttributeDefinition CREATE_REPORT_DEFINITION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("file", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).build();
    public static final SimpleAttributeDefinition FILE_FORMAT_DEFINITION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("format", ModelType.STRING, true).setDefaultValue(new ModelNode("xml"))).setAllowedValues("xml", "json")).build();
    public static final GlobalInstallationReportHandler INSTANCE = new GlobalInstallationReportHandler();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("product-info", ControllerResolver.getResolver("global")).setRuntimeOnly().setReadOnly().setReplyType(ModelType.LIST).setReplyParameters(SUMMARY_DEFINITION).build();

    @Override
    void doExecute(OperationContext context, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResource) throws OperationFailedException {
        final HashMap<String, GlobalOperationHandlers.AvailableResponse> servers = new HashMap<String, GlobalOperationHandlers.AvailableResponse>();
        ModelNode rootModel = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).getModel();
        final String defaultOrganization = rootModel.hasDefined("domain-organization") ? rootModel.get("domain-organization").asString() : null;
        final HashMap serverOrganizations = new HashMap();
        final ReportAssemblyHandler assemblyHandler = new ReportAssemblyHandler(servers, serverOrganizations, filteredData, ignoreMissingResource);
        if (null != context.getProcessType()) {
            switch (context.getProcessType()) {
                case HOST_CONTROLLER: 
                case EMBEDDED_HOST_CONTROLLER: {
                    context.addStep(new OperationStepHandler(){

                        @Override
                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            context.addStep(assemblyHandler, OperationContext.Stage.VERIFY, true);
                            String host = Util.getNameFromAddress(context.getCurrentAddress());
                            PathAddress hostAddress = context.getCurrentAddress();
                            ModelNode hostModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                            String hostOrganization = hostModel.hasDefined("organization") ? hostModel.get("organization").asString() : defaultOrganization;
                            GlobalInstallationReportHandler.this.addHostReport(context, hostAddress, host, servers);
                            if (hostOrganization != null) {
                                serverOrganizations.put(hostOrganization, hostOrganization);
                            }
                            Set<String> hostServers = context.readResource(PathAddress.EMPTY_ADDRESS).getChildrenNames("server");
                            for (String server : hostServers) {
                                String nodeName = host + ":" + server;
                                GlobalInstallationReportHandler.this.addServerReport(context, hostAddress.append("server", server), nodeName, servers);
                                if (hostOrganization == null) continue;
                                serverOrganizations.put(nodeName, hostOrganization);
                            }
                        }
                    }, OperationContext.Stage.RUNTIME);
                    break;
                }
                case STANDALONE_SERVER: 
                case DOMAIN_SERVER: 
                case EMBEDDED_SERVER: 
                case SELF_CONTAINED: {
                    context.addStep(assemblyHandler, OperationContext.Stage.VERIFY, true);
                    this.addStandaloneReport(context, servers);
                    break;
                }
            }
        }
    }

    private void addStandaloneReport(OperationContext context, Map<String, GlobalOperationHandlers.AvailableResponse> responseMap) {
        ModelNode reportOperation = Util.getEmptyOperation(SUB_OPERATION_NAME, PathAddress.EMPTY_ADDRESS.toModelNode());
        ModelNode response = new ModelNode();
        GlobalOperationHandlers.AvailableResponse availableResponse = new GlobalOperationHandlers.AvailableResponse(response);
        OperationEntry entry = context.getResourceRegistration().getOperationEntry(PathAddress.EMPTY_ADDRESS, SUB_OPERATION_NAME);
        OperationStepHandler osh = entry.getOperationHandler();
        GlobalOperationHandlers.AvailableResponseWrapper wrapper = new GlobalOperationHandlers.AvailableResponseWrapper(osh, availableResponse);
        context.addStep(response, reportOperation, wrapper, OperationContext.Stage.RUNTIME);
        responseMap.put("", availableResponse);
        ControllerLogger.ROOT_LOGGER.debug("We are asking the standalone server its report");
    }

    private void addServerReport(OperationContext context, PathAddress address, String server, Map<String, GlobalOperationHandlers.AvailableResponse> responseMap) {
        ModelNode reportOperation = Util.getEmptyOperation(SUB_OPERATION_NAME, address.toModelNode());
        ModelNode response = new ModelNode();
        GlobalOperationHandlers.AvailableResponse availableResponse = new GlobalOperationHandlers.AvailableResponse(response);
        responseMap.put(server, availableResponse);
        OperationEntry entry = context.getRootResourceRegistration().getOperationEntry(address, SUB_OPERATION_NAME);
        if (entry != null) {
            OperationStepHandler osh = entry.getOperationHandler();
            GlobalOperationHandlers.AvailableResponseWrapper wrapper = new GlobalOperationHandlers.AvailableResponseWrapper(osh, availableResponse);
            context.addStep(response, reportOperation, wrapper, OperationContext.Stage.RUNTIME);
            ControllerLogger.ROOT_LOGGER.debugf("We are asking the server %s its report", server);
        }
    }

    private void addHostReport(OperationContext context, PathAddress address, String host, Map<String, GlobalOperationHandlers.AvailableResponse> responseMap) {
        ModelNode reportOperation = Util.getEmptyOperation(SUB_OPERATION_NAME, address.toModelNode());
        ModelNode response = new ModelNode();
        GlobalOperationHandlers.AvailableResponse availableResponse = new GlobalOperationHandlers.AvailableResponse(response);
        responseMap.put(host, availableResponse);
        OperationEntry entry = context.getRootResourceRegistration().getOperationEntry(address, SUB_OPERATION_NAME);
        if (entry != null) {
            OperationStepHandler osh = entry.getOperationHandler();
            GlobalOperationHandlers.AvailableResponseWrapper wrapper = new GlobalOperationHandlers.AvailableResponseWrapper(osh, availableResponse);
            context.addStep(response, reportOperation, wrapper, OperationContext.Stage.RUNTIME);
            ControllerLogger.ROOT_LOGGER.debugf("We are asking the host %s its report", host);
        }
    }

    public static OperationStepHandler createDomainOperation() {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource res = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
                Set<String> hosts = res.getChildrenNames("host");
                String hostName = hosts.iterator().next();
                PathAddress address = PathAddress.pathAddress(PathElement.pathElement("host"));
                OperationEntry entry = context.getRootResourceRegistration().getOperationEntry(PathAddress.pathAddress(PathElement.pathElement("host", hostName)), GlobalInstallationReportHandler.OPERATION_NAME);
                ModelNode reportOperation = Util.getEmptyOperation(GlobalInstallationReportHandler.OPERATION_NAME, address.toModelNode());
                if (operation.hasDefined(CREATE_REPORT_DEFINITION.getName())) {
                    reportOperation.get(CREATE_REPORT_DEFINITION.getName()).set(operation.get(CREATE_REPORT_DEFINITION.getName()));
                    if (operation.hasDefined(FILE_FORMAT_DEFINITION.getName())) {
                        reportOperation.get(FILE_FORMAT_DEFINITION.getName()).set(operation.get(FILE_FORMAT_DEFINITION.getName()));
                    }
                }
                if (entry != null) {
                    OperationStepHandler osh = entry.getOperationHandler();
                    context.addStep(reportOperation, osh, OperationContext.Stage.MODEL);
                }
            }
        };
    }

    private static class ReportAssemblyHandler
    implements OperationStepHandler {
        private final Map<String, GlobalOperationHandlers.AvailableResponse> servers;
        private final Map<String, String> serverOrganizations;
        private final FilteredData filteredData;
        private final boolean ignoreMissingResource;

        private ReportAssemblyHandler(Map<String, GlobalOperationHandlers.AvailableResponse> servers, Map<String, String> serverOrganizations, FilteredData filteredData, boolean ignoreMissingResource) {
            this.servers = servers;
            this.serverOrganizations = serverOrganizations;
            this.filteredData = filteredData;
            this.ignoreMissingResource = ignoreMissingResource;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            boolean record = false;
            ModelNode rootModel = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).getModel();
            String defaultOrganization = null;
            if (rootModel.hasDefined("organization")) {
                defaultOrganization = rootModel.get("organization").asString();
            }
            String format = FILE_FORMAT_DEFINITION.resolveModelAttribute(context, operation).asString();
            TreeMap<String, ModelNode> sortedAttributes = new TreeMap<String, ModelNode>();
            boolean failed = false;
            for (Map.Entry<String, GlobalOperationHandlers.AvailableResponse> entry : this.servers.entrySet()) {
                Object ar = entry.getValue();
                if (((GlobalOperationHandlers.AvailableResponse)ar).unavailable) {
                    this.handleMissingResource(context);
                    return;
                }
                ModelNode value = ((GlobalOperationHandlers.AvailableResponse)ar).response;
                if (!value.has("failure-description")) {
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                failed = true;
                break;
            }
            if (!failed) {
                ReportAttacher.AbstractReportAttacher attacher;
                ModelNode result = context.getResult();
                result.setEmptyList();
                switch (format) {
                    case "json": {
                        attacher = new JsonReportAttacher(record);
                        break;
                    }
                    default: {
                        attacher = new XMLReportAttacher(SUMMARY_DEFINITION, record, "urn:jboss:product-report:1.0", GlobalInstallationReportHandler.SUB_OPERATION_NAME);
                    }
                }
                if (sortedAttributes.size() == 1) {
                    Map.Entry entry = sortedAttributes.entrySet().iterator().next();
                    ModelNode report = (ModelNode)entry.getValue();
                    result.add(report);
                    attacher.addReport(report);
                } else {
                    for (Map.Entry entry : sortedAttributes.entrySet()) {
                        ModelNode report = (ModelNode)entry.getValue();
                        ModelNode summary = report.get(SUMMARY_DEFINITION.getName());
                        this.updateSummary(summary, defaultOrganization, (String)entry.getKey());
                        result.add(report);
                        attacher.addReport(report);
                    }
                }
                attacher.attachResult(context);
                if (this.filteredData != null && this.filteredData.hasFilteredData()) {
                    context.getResponseHeaders().get("access-control").set(this.filteredData.toModelNode());
                }
            }
        }

        private void updateSummary(ModelNode summary, String defaultOrganization, String nodeName) {
            summary.get(GlobalInstallationReportHandler.NODE_NAME).set(nodeName);
            if (!summary.hasDefined("organization")) {
                if (this.serverOrganizations.containsKey(nodeName)) {
                    summary.get("organization").set(this.serverOrganizations.get(nodeName));
                } else if (defaultOrganization != null) {
                    summary.get("organization").set(defaultOrganization);
                }
            }
        }

        private void handleMissingResource(OperationContext context) {
            if (context.hasResult()) {
                context.getResult().set(new ModelNode());
            }
            if (!this.ignoreMissingResource) {
                throw ControllerLogger.MGMT_OP_LOGGER.managementResourceNotFound(context.getCurrentAddress());
            }
        }
    }
}

