/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AliasEntry {
    private final ManagementResourceRegistration target;
    private volatile PathAddress aliasAddress;
    private volatile PathAddress targetAddress;

    protected AliasEntry(ManagementResourceRegistration target) {
        this.target = target;
    }

    ManagementResourceRegistration getTarget() {
        return this.target;
    }

    void setAddresses(PathAddress targetAddress, PathAddress aliasAddress) {
        this.targetAddress = targetAddress;
        this.aliasAddress = aliasAddress;
    }

    protected PathAddress getAliasAddress() {
        return this.aliasAddress;
    }

    protected PathAddress getTargetAddress() {
        return this.targetAddress;
    }

    @Deprecated
    public PathAddress convertToTargetAddress(PathAddress aliasAddress) {
        throw new UnsupportedOperationException("convertToTargetAddress");
    }

    public PathAddress convertToTargetAddress(PathAddress aliasAddress, AliasContext aliasContext) {
        return this.convertToTargetAddress(aliasAddress);
    }

    public static class AliasContext {
        public static final String RECURSIVE_GLOBAL_OP = "recursive-global-op";
        final OperationContext delegate;
        final ModelNode operation;

        private AliasContext(ModelNode operation, OperationContext delegate) {
            this.delegate = delegate;
            this.operation = operation.clone();
            this.operation.protect();
        }

        static AliasContext create(ModelNode operation, OperationContext delegate) {
            return new AliasContext(operation, delegate);
        }

        public static AliasContext create(PathAddress address, OperationContext delegate) {
            return new AliasContext(Util.createEmptyOperation(RECURSIVE_GLOBAL_OP, address), delegate);
        }

        public Resource readResourceFromRoot(PathAddress address) {
            return this.delegate.readResourceFromRoot(address);
        }

        public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
            return this.delegate.readResourceFromRoot(address, recursive);
        }

        public ModelNode getOperation() {
            return this.operation;
        }
    }
}

