/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.OperationAttachmentsProxy;
import org.jboss.as.controller.remote.OperationMessageHandlerProxy;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class ModelControllerClientOperationHandler
implements ManagementRequestHandlerFactory {
    private final ModelController controller;
    private final ManagementChannelAssociation channelAssociation;
    private final Executor clientRequestExecutor;
    private final Subject subject;
    private final ResponseAttachmentInputStreamSupport responseAttachmentSupport;

    public ModelControllerClientOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation, ResponseAttachmentInputStreamSupport responseAttachmentSupport, ExecutorService clientRequestExecutor) {
        this(controller, channelAssociation, responseAttachmentSupport, clientRequestExecutor, new Subject());
    }

    public ModelControllerClientOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation, ResponseAttachmentInputStreamSupport responseAttachmentSupport, ExecutorService clientRequestExecutor, Subject subject) {
        this.controller = controller;
        this.channelAssociation = channelAssociation;
        this.responseAttachmentSupport = responseAttachmentSupport;
        this.subject = subject;
        this.clientRequestExecutor = clientRequestExecutor;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        switch (header.getOperationId()) {
            case 69: 
            case 70: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new ExecuteRequestHandler();
            }
            case 77: {
                return new CancelAsyncRequestHandler();
            }
            case 79: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return this.responseAttachmentSupport.getReadHandler();
            }
            case 68: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return this.responseAttachmentSupport.getCloseHandler();
            }
        }
        return handlers.resolveNext();
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        try {
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            String op = operation.get("operation").asString();
            int size = address.size();
            if (size == 0) {
                if ("reload".equals(op)) {
                    return true;
                }
                if ("composite".equals(op)) {
                    return false;
                }
                return false;
            }
            if (size == 1 && "host".equals(address.getLastElement().getKey())) {
                return "reload".equals(op);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static class IOExceptionHolder {
        private IOException exception;

        private IOExceptionHolder() {
        }
    }

    private static class CancelAsyncRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        private CancelAsyncRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Cancellation of %d requested", context.getOperationId());
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            }, false);
            resultHandler.cancel();
        }
    }

    private static class CompletedCallback {
        private volatile boolean completed;
        private final ManagementResponseHeader response;
        private final ManagementRequestContext<Void> responseContext;
        private final ActiveOperation.ResultHandler<ModelNode> resultHandler;

        private CompletedCallback(ManagementResponseHeader response, ManagementRequestContext<Void> responseContext, ActiveOperation.ResultHandler<ModelNode> resultHandler) {
            this.response = response;
            this.responseContext = responseContext;
            this.resultHandler = resultHandler;
        }

        synchronized void sendResponse(final ModelNode result) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            final IOExceptionHolder exceptionHolder = new IOExceptionHolder();
            final CountDownLatch latch = new CountDownLatch(1);
            boolean accepted = this.responseContext.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    FlushableDataOutput output = null;
                    try {
                        ControllerLogger.MGMT_OP_LOGGER.tracef("Transmitting response for %d", context.getOperationId());
                        output = responseContext.writeMessage((ManagementProtocolHeader)response);
                        output.write(100);
                        result.writeExternal((DataOutput)output);
                        output.writeByte(36);
                        output.close();
                        StreamUtils.safeClose((Closeable)output);
                        latch.countDown();
                    }
                    catch (IOException e) {
                        exceptionHolder.exception = e;
                    }
                    finally {
                        StreamUtils.safeClose(output);
                        latch.countDown();
                    }
                }
            }, false);
            if (accepted) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (exceptionHolder.exception != null) {
                    this.resultHandler.failed((Exception)exceptionHolder.exception);
                } else {
                    this.resultHandler.done((Object)result);
                }
            }
        }
    }

    class ExecuteRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        ExecuteRequestHandler() {
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Handling ExecuteRequest for %d", context.getOperationId());
            final ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            final int attachmentsLength = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(final ManagementRequestContext<Void> context) throws Exception {
                    final ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    try {
                        AccessAuditContext.doAs(ModelControllerClientOperationHandler.this.subject, new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                CompletedCallback callback = new CompletedCallback(response, context, resultHandler);
                                ExecuteRequestHandler.this.doExecute(operation, attachmentsLength, (ManagementRequestContext<Void>)context, callback);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                }
            }, ModelControllerClientOperationHandler.this.clientRequestExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<Void> context, final CompletedCallback callback) {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing ExecuteRequest for %d", context.getOperationId());
            ModelNode headers = operation.get("operation-headers");
            headers.get("caller-type").set("user");
            headers.get("access-mechanism").set(AccessMechanism.NATIVE.toString());
            if (headers.hasDefined("domain-uuid")) {
                headers.remove("domain-uuid");
            }
            if (headers.hasDefined("execute-for-coordinator")) {
                headers.remove("execute-for-coordinator");
            }
            if (headers.hasDefined("sync-dropped-for-readd")) {
                headers.remove("sync-dropped-for-readd");
            }
            ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
            int batchId = header.getBatchId();
            ModelNode result = new ModelNode();
            boolean sendPreparedOperation = ModelControllerClientOperationHandler.this.sendPreparedResponse(operation);
            ModelController.OperationTransactionControl transactionControl = sendPreparedOperation ? new ModelController.OperationTransactionControl(){

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode preparedResult) {
                    transaction.commit();
                    preparedResult.get("outcome").set("success");
                    preparedResult.get("result");
                    callback.sendResponse(preparedResult);
                }
            } : ModelController.OperationTransactionControl.COMMIT;
            OperationMessageHandlerProxy messageHandlerProxy = new OperationMessageHandlerProxy(ModelControllerClientOperationHandler.this.channelAssociation, batchId);
            OperationAttachmentsProxy attachmentsProxy = OperationAttachmentsProxy.create(operation, ModelControllerClientOperationHandler.this.channelAssociation, batchId, attachmentsLength);
            try {
                ControllerLogger.ROOT_LOGGER.tracef("Executing client request %d(%d)", batchId, header.getRequestId());
                OperationResponse response = ModelControllerClientOperationHandler.this.controller.execute(attachmentsProxy, messageHandlerProxy, transactionControl);
                ModelControllerClientOperationHandler.this.responseAttachmentSupport.registerStreams(context.getOperationId(), response.getInputStreams());
                result.set(response.getResponseNode());
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                result.set(failure);
                attachmentsProxy.shutdown(e);
            }
            finally {
                ControllerLogger.ROOT_LOGGER.tracef("Executed client request %d", batchId);
            }
            callback.sendResponse(result);
        }
    }
}

