/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.File;
import java.io.IOException;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.PathManagerService;

public class SizeRotatingFileAuditLogHandler
extends AbstractFileAuditLogHandler {
    private long rotateSize = 655360L;
    private int maxBackupIndex = 1;
    private volatile long currentSize = 0L;

    public SizeRotatingFileAuditLogHandler(String name, String formatterName, int maxFailureCount, PathManagerService pathManager, String path, String relativeTo, long rotateSize, int maxBackupIndex) {
        super(name, formatterName, maxFailureCount, pathManager, path, relativeTo);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    @Override
    protected void initializeAtStartup(File file) {
        this.currentSize = file.length();
    }

    @Override
    protected void rotateLogFile(File file) {
        if (this.currentSize > this.rotateSize) {
            if (this.maxBackupIndex > 0) {
                new File(file.getAbsolutePath() + "." + this.maxBackupIndex).delete();
                for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                    File from = new File(file.getAbsolutePath() + "." + i);
                    File to = new File(file.getAbsolutePath() + "." + (i + 1));
                    try {
                        this.rename(from, to);
                        continue;
                    }
                    catch (IOException e) {
                        throw ControllerLogger.ROOT_LOGGER.couldNotBackUp(e, from.getAbsolutePath(), to.getAbsolutePath());
                    }
                }
                File backup = new File(file.getAbsolutePath() + ".1");
                try {
                    this.rename(file, backup);
                }
                catch (IOException e) {
                    throw ControllerLogger.ROOT_LOGGER.couldNotBackUp(e, file.getAbsolutePath(), backup.getAbsolutePath());
                }
            } else {
                file.delete();
            }
            this.createNewFile(file);
            this.currentSize = 0L;
        }
    }

    @Override
    void writeLogItem(String formattedItem) throws IOException {
        super.writeLogItem(formattedItem);
        this.currentSize += (long)formattedItem.getBytes().length;
        this.currentSize += (long)LINE_TERMINATOR.length;
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof SizeRotatingFileAuditLogHandler)) {
            return true;
        }
        SizeRotatingFileAuditLogHandler otherHandler = (SizeRotatingFileAuditLogHandler)other;
        if (this.rotateSize != otherHandler.rotateSize) {
            return true;
        }
        if (this.maxBackupIndex != otherHandler.maxBackupIndex) {
            return true;
        }
        return super.isDifferent(other);
    }
}

