/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import java.security.Permission;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.ControllerPermission;
import org.jboss.as.core.security.api.RealmPrincipal;
import org.wildfly.security.auth.server.SecurityIdentity;

@Deprecated
public final class Caller {
    private static final String UNDEFINED = "UNDEFINED";
    private final SecurityIdentity securityIdentity;
    private volatile String name;
    private volatile String realm = "UNDEFINED";
    private volatile Set<String> groups;
    private volatile Set<String> roles;

    private Caller(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    public static Caller createCaller(SecurityIdentity securityIdentity) {
        Caller.checkPermission(ControllerPermission.CREATE_CALLER);
        return new Caller(securityIdentity);
    }

    public String getName() {
        if (this.name == null && this.securityIdentity != null) {
            this.name = this.securityIdentity.getPrincipal().getName();
        }
        return this.name;
    }

    public String getRealm() {
        if (UNDEFINED.equals(this.realm)) {
            Principal principal = this.securityIdentity.getPrincipal();
            String realm = null;
            if (principal instanceof RealmPrincipal) {
                realm = ((RealmPrincipal)principal).getRealm();
            }
            this.realm = realm;
        }
        return this.realm;
    }

    public Set<String> getAssociatedGroups() {
        if (this.groups == null) {
            this.groups = this.securityIdentity != null ? StreamSupport.stream(this.securityIdentity.getRoles().spliterator(), true).collect(Collectors.toSet()) : Collections.emptySet();
        }
        return this.groups;
    }

    public Set<String> getAssociatedRoles() {
        return this.getAssociatedGroups();
    }

    public boolean hasSubject() {
        return false;
    }

    public Subject getSubject() {
        Caller.checkPermission(ControllerPermission.GET_CALLER_SUBJECT);
        return null;
    }

    public boolean hasSecurityIdentity() {
        return this.securityIdentity != null;
    }

    public SecurityIdentity getSecurityIdentity() {
        Caller.checkPermission(ControllerPermission.GET_CALLER_SECURITY_IDENTITY);
        return this.securityIdentity;
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

