/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.wildfly.common.Assert;

public class SimpleResourceDefinition
implements ResourceDefinition {
    private static final EnumSet<OperationEntry.Flag> RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM);
    private static final RuntimeCapability[] NO_CAPABILITIES = new RuntimeCapability[0];
    private final PathElement pathElement;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DescriptionProvider descriptionProvider;
    private final OperationStepHandler addHandler;
    private final OperationStepHandler removeHandler;
    private final OperationEntry.Flag addRestartLevel;
    private final OperationEntry.Flag removeRestartLevel;
    private final boolean runtime;
    private volatile DeprecationData deprecationData;
    private final boolean orderedChild;
    private final RuntimeCapability[] capabilities;
    private final Set<RuntimeCapability> incorporatingCapabilities;
    private final List<AccessConstraintDefinition> accessConstraints;
    private final int minOccurs;
    private final int maxOccurs;

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, DescriptionProvider descriptionProvider) {
        Assert.checkNotNullParam((String)"descriptionProvider", (Object)descriptionProvider);
        this.pathElement = pathElement;
        this.descriptionResolver = null;
        this.descriptionProvider = descriptionProvider;
        this.addHandler = null;
        this.removeHandler = null;
        this.addRestartLevel = null;
        this.removeRestartLevel = null;
        this.deprecationData = null;
        this.runtime = false;
        this.orderedChild = false;
        this.capabilities = NO_CAPABILITIES;
        this.incorporatingCapabilities = null;
        this.accessConstraints = Collections.emptyList();
        this.minOccurs = 0;
        this.maxOccurs = Integer.MAX_VALUE;
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
        this(pathElement, descriptionResolver, null, null, null, null, null);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, boolean isRuntime) {
        this(pathElement, descriptionResolver, null, null, null, null, null, isRuntime);
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, null, null, null);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, boolean isRuntime) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, null, null, null, isRuntime);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, DeprecationData deprecationData) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, null, null, deprecationData);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, addRestartLevel, removeRestartLevel, null);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel, DeprecationData deprecationData) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, addRestartLevel, removeRestartLevel, deprecationData, false);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel, DeprecationData deprecationData, boolean runtime) {
        this(new Parameters(pathElement, descriptionResolver).setAddHandler(addHandler).setAddRestartLevel(addRestartLevel == null ? SimpleResourceDefinition.restartLevelForAdd(addHandler) : addRestartLevel).setRemoveHandler(removeHandler).setRemoveRestartLevel(removeRestartLevel == null ? SimpleResourceDefinition.restartLevelForRemove(removeHandler) : removeRestartLevel).setDeprecationData(deprecationData).setRuntime(runtime));
    }

    public SimpleResourceDefinition(Parameters parameters) {
        this.pathElement = parameters.pathElement;
        this.descriptionResolver = parameters.descriptionResolver;
        this.addHandler = parameters.addHandler;
        this.removeHandler = parameters.removeHandler;
        this.addRestartLevel = parameters.addRestartLevel;
        this.removeRestartLevel = parameters.removeRestartLevel;
        this.deprecationData = parameters.deprecationData;
        this.runtime = parameters.runtime;
        this.orderedChild = parameters.orderedChildResource;
        this.descriptionProvider = null;
        this.capabilities = parameters.capabilities != null ? parameters.capabilities : NO_CAPABILITIES;
        this.incorporatingCapabilities = parameters.incorporatingCapabilities;
        this.accessConstraints = parameters.accessConstraints != null ? Arrays.asList(parameters.accessConstraints) : Collections.emptyList();
        this.minOccurs = parameters.minOccurs;
        this.maxOccurs = parameters.maxOccurs;
    }

    private static OperationEntry.Flag restartLevelForAdd(OperationStepHandler addHandler) {
        return addHandler instanceof AbstractBoottimeAddStepHandler || addHandler instanceof ReloadRequiredAddStepHandler ? OperationEntry.Flag.RESTART_ALL_SERVICES : OperationEntry.Flag.RESTART_NONE;
    }

    private static OperationEntry.Flag restartLevelForRemove(OperationStepHandler removeHandler) {
        return removeHandler instanceof ReloadRequiredRemoveStepHandler ? OperationEntry.Flag.RESTART_ALL_SERVICES : OperationEntry.Flag.RESTART_RESOURCE_SERVICES;
    }

    @Override
    public PathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        return this.descriptionProvider == null ? new DefaultResourceDescriptionProvider(resourceRegistration, this.descriptionResolver, this.getDeprecationData()) : this.descriptionProvider;
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        if (this.addHandler != null) {
            this.registerAddOperation(resourceRegistration, this.addHandler, this.addRestartLevel);
        }
        if (this.removeHandler != null) {
            this.registerRemoveOperation(resourceRegistration, this.removeHandler, this.removeRestartLevel);
        }
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        if (this.capabilities != null) {
            for (RuntimeCapability c : this.capabilities) {
                resourceRegistration.registerCapability(c);
            }
        }
        if (this.incorporatingCapabilities != null) {
            resourceRegistration.registerIncorporatingCapabilities(this.incorporatingCapabilities);
        }
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return this.descriptionResolver;
    }

    @Deprecated
    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        if (handler instanceof DescriptionProvider) {
            registration.registerOperationHandler(this.getOperationDefinition("add", (DescriptionProvider)((Object)handler), OperationEntry.EntryType.PUBLIC, flags), handler);
        } else {
            registration.registerOperationHandler(this.getOperationDefinition("add", new DefaultResourceAddDescriptionProvider(registration, this.descriptionResolver, this.orderedChild), OperationEntry.EntryType.PUBLIC, flags), handler);
        }
    }

    private OperationDefinition getOperationDefinition(String operationName, DescriptionProvider descriptionProvider, OperationEntry.EntryType entryType, OperationEntry.Flag ... flags) {
        return new SimpleOperationDefinitionBuilder(operationName, this.descriptionResolver).withFlags(flags).setEntryType(entryType).setDescriptionProvider(descriptionProvider).build();
    }

    protected void registerAddOperation(ManagementResourceRegistration registration, AbstractAddStepHandler handler, OperationEntry.Flag ... flags) {
        registration.registerOperationHandler(this.getOperationDefinition("add", new DefaultResourceAddDescriptionProvider(registration, this.descriptionResolver, this.orderedChild), OperationEntry.EntryType.PUBLIC, flags), handler);
    }

    @Deprecated
    protected void registerRemoveOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        if (handler instanceof DescriptionProvider) {
            registration.registerOperationHandler(this.getOperationDefinition("remove", (DescriptionProvider)((Object)handler), OperationEntry.EntryType.PUBLIC, flags), handler);
        } else {
            SimpleOperationDefinition opDef = new SimpleOperationDefinitionBuilder("remove", this.descriptionResolver).withFlags(flags).build();
            registration.registerOperationHandler(opDef, handler);
        }
    }

    protected void registerRemoveOperation(ManagementResourceRegistration registration, AbstractRemoveStepHandler handler, OperationEntry.Flag ... flags) {
        this.registerRemoveOperation(registration, (OperationStepHandler)handler, flags);
    }

    private static OperationEntry.Flag validateRestartLevel(String paramName, OperationEntry.Flag flag) {
        if (flag != null && !RESTART_FLAGS.contains((Object)flag)) {
            throw ControllerLogger.ROOT_LOGGER.invalidParameterValue(flag, paramName, RESTART_FLAGS);
        }
        return flag;
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        return SimpleOperationDefinitionBuilder.getFlagsSet(vararg);
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    protected void setDeprecated(ModelVersion since) {
        this.deprecationData = new DeprecationData(since);
    }

    protected DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    @Override
    public boolean isRuntime() {
        return this.runtime;
    }

    @Override
    public int getMinOccurs() {
        if (this.minOccurs == 0) {
            return ResourceDefinition.super.getMinOccurs();
        }
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        if (this.maxOccurs == Integer.MAX_VALUE) {
            return ResourceDefinition.super.getMaxOccurs();
        }
        return this.maxOccurs;
    }

    @Override
    public boolean isOrderedChild() {
        return this.orderedChild;
    }

    public static class Parameters {
        private final PathElement pathElement;
        private ResourceDescriptionResolver descriptionResolver;
        private OperationStepHandler addHandler;
        private OperationStepHandler removeHandler;
        private OperationEntry.Flag addRestartLevel = OperationEntry.Flag.RESTART_NONE;
        private OperationEntry.Flag removeRestartLevel = OperationEntry.Flag.RESTART_ALL_SERVICES;
        private boolean runtime;
        private DeprecationData deprecationData;
        private boolean orderedChildResource;
        private RuntimeCapability[] capabilities;
        private Set<RuntimeCapability> incorporatingCapabilities;
        private AccessConstraintDefinition[] accessConstraints;
        private int minOccurs = 0;
        private int maxOccurs = Integer.MAX_VALUE;

        public Parameters(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
            Assert.checkNotNullParam((String)"descriptionResolver", (Object)descriptionResolver);
            this.pathElement = pathElement;
            this.descriptionResolver = descriptionResolver;
        }

        public Parameters setDescriptionResolver(ResourceDescriptionResolver descriptionResolver) {
            Assert.checkNotNullParam((String)"descriptionResolver", (Object)descriptionResolver);
            this.descriptionResolver = descriptionResolver;
            return this;
        }

        public Parameters setAddHandler(OperationStepHandler addHandler) {
            this.addHandler = addHandler;
            if (this.addRestartLevel == null) {
                this.addRestartLevel = SimpleResourceDefinition.restartLevelForAdd(addHandler);
            }
            return this;
        }

        public Parameters setRemoveHandler(OperationStepHandler removeHandler) {
            this.removeHandler = removeHandler;
            if (this.removeRestartLevel == null) {
                this.removeRestartLevel = SimpleResourceDefinition.restartLevelForRemove(removeHandler);
            }
            return this;
        }

        public Parameters setAddRestartLevel(OperationEntry.Flag addRestartLevel) {
            Assert.checkNotNullParam((String)"addRestartLevel", (Object)((Object)addRestartLevel));
            this.addRestartLevel = SimpleResourceDefinition.validateRestartLevel("addRestartLevel", addRestartLevel);
            return this;
        }

        public Parameters setRemoveRestartLevel(OperationEntry.Flag removeRestartLevel) {
            Assert.checkNotNullParam((String)"removeRestartLevel", (Object)((Object)removeRestartLevel));
            this.removeRestartLevel = SimpleResourceDefinition.validateRestartLevel("removeRestartLevel", removeRestartLevel);
            return this;
        }

        public Parameters setRuntime() {
            this.runtime = true;
            return this;
        }

        public Parameters setRuntime(boolean isRuntime) {
            this.runtime = isRuntime;
            return this;
        }

        public Parameters setDeprecationData(DeprecationData deprecationData) {
            this.deprecationData = deprecationData;
            return this;
        }

        public Parameters setDeprecatedSince(ModelVersion deprecatedSince) {
            Assert.checkNotNullParam((String)"deprecatedSince", (Object)deprecatedSince);
            this.deprecationData = new DeprecationData(deprecatedSince);
            return this;
        }

        public Parameters setOrderedChild() {
            this.orderedChildResource = true;
            return this;
        }

        public Parameters setCapabilities(RuntimeCapability ... capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Parameters addCapabilities(RuntimeCapability ... capabilities) {
            if (this.capabilities == null) {
                this.setCapabilities(capabilities);
            } else if (capabilities != null && capabilities.length > 0) {
                RuntimeCapability[] combo = Arrays.copyOf(this.capabilities, this.capabilities.length + capabilities.length);
                System.arraycopy(capabilities, 0, combo, this.capabilities.length, capabilities.length);
                this.setCapabilities(combo);
            }
            return this;
        }

        public Parameters setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
            this.accessConstraints = accessConstraints;
            return this;
        }

        public Parameters addAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
            if (this.accessConstraints == null) {
                this.setAccessConstraints(accessConstraints);
            } else if (accessConstraints != null && accessConstraints.length > 0) {
                AccessConstraintDefinition[] combo = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + accessConstraints.length);
                System.arraycopy(accessConstraints, 0, combo, this.accessConstraints.length, accessConstraints.length);
                this.setAccessConstraints(combo);
            }
            return this;
        }

        public Parameters setMaxOccurs(int maxOccurs) {
            this.maxOccurs = maxOccurs;
            return this;
        }

        public Parameters setMinOccurs(int minOccurs) {
            this.minOccurs = minOccurs;
            return this;
        }

        public Parameters setIncorporatingCapabilities(Set<RuntimeCapability> incorporatingCapabilities) {
            this.incorporatingCapabilities = incorporatingCapabilities;
            return this;
        }

        public Parameters addIncorporatingCapabilities(Set<RuntimeCapability> incorporatingCapabilities) {
            if (this.incorporatingCapabilities == null) {
                this.setIncorporatingCapabilities(incorporatingCapabilities);
            } else if (incorporatingCapabilities != null && !incorporatingCapabilities.isEmpty()) {
                HashSet<RuntimeCapability> combo = new HashSet<RuntimeCapability>();
                combo.addAll(this.incorporatingCapabilities);
                combo.addAll(incorporatingCapabilities);
                this.setIncorporatingCapabilities(combo);
            }
            return this;
        }
    }
}

